/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.config.atomtypes;

import java.util.Vector;
import org.openscience.cdk.AtomType;
import org.openscience.cdk.tools.LoggingTool;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class AtomTypeHandler
extends DefaultHandler {
    private final int SCALAR_UNSET = 0;
    private final int SCALAR_MAXBONDORDER = 1;
    private final int SCALAR_BONDORDERSUM = 2;
    private final int SCALAR_HYBRIDIZATION = 3;
    private final int SCALAR_FORMALNEIGHBOURCOUNT = 4;
    private final int SCALAR_VALENCY = 5;
    private LoggingTool logger = new LoggingTool(this);
    private String currentChars;
    private Vector atomTypes;
    private int scalarType;
    private AtomType atomType;

    public Vector getAtomTypes() {
        return this.atomTypes;
    }

    public void startDocument() {
        this.atomTypes = new Vector();
        this.scalarType = 0;
        this.atomType = null;
    }

    public void endElement(String uri, String local, String raw) {
        this.logger.debug((Object)"END Element: ", raw);
        this.logger.debug((Object)"  uri: ", uri);
        this.logger.debug((Object)"  local: ", local);
        this.logger.debug((Object)"  raw: ", raw);
        this.logger.debug((Object)"  chars: ", this.currentChars.trim());
        if ("atomType".equals(local)) {
            this.atomTypes.addElement(this.atomType);
        } else if ("scalar".equals(local)) {
            this.currentChars.trim();
            try {
                if (this.scalarType == 2) {
                    this.atomType.setBondOrderSum(Double.parseDouble(this.currentChars));
                } else if (this.scalarType == 1) {
                    this.atomType.setMaxBondOrder(Double.parseDouble(this.currentChars));
                } else if (this.scalarType == 4) {
                    this.atomType.setFormalNeighbourCount(Integer.parseInt(this.currentChars));
                } else if (this.scalarType == 5) {
                    this.atomType.setValency(Integer.parseInt(this.currentChars));
                } else if (this.scalarType == 3) {
                    if ("sp1".equals(this.currentChars)) {
                        this.atomType.setHybridization(1);
                    } else if ("sp2".equals(this.currentChars)) {
                        this.atomType.setHybridization(2);
                    } else if ("sp3".equals(this.currentChars)) {
                        this.atomType.setHybridization(3);
                    }
                }
            }
            catch (Exception exception) {
                this.logger.error("Value (", this.currentChars, ") is not off the expected type: ", exception.getMessage());
                this.logger.debug(exception);
            }
            this.scalarType = 0;
        }
        this.currentChars = "";
    }

    public void startElement(String uri, String local, String raw, Attributes atts) {
        block11: {
            block12: {
                block10: {
                    this.currentChars = "";
                    this.logger.debug((Object)"START Element: ", raw);
                    this.logger.debug((Object)"  uri: ", uri);
                    this.logger.debug((Object)"  local: ", local);
                    this.logger.debug((Object)"  raw: ", raw);
                    if (!"atomType".equals(local)) break block10;
                    this.atomType = new AtomType("R");
                    for (int i = 0; i < atts.getLength(); ++i) {
                        if (!"id".equals(atts.getQName(i))) continue;
                        this.atomType.setAtomTypeName(atts.getValue(i));
                    }
                    break block11;
                }
                if (!"atom".equals(local)) break block12;
                for (int i = 0; i < atts.getLength(); ++i) {
                    if ("elementType".equals(atts.getQName(i))) {
                        this.atomType.setSymbol(atts.getValue(i));
                        continue;
                    }
                    if (!"formalCharge".equals(atts.getQName(i))) continue;
                    try {
                        this.atomType.setFormalCharge(Integer.parseInt(atts.getValue(i)));
                        continue;
                    }
                    catch (NumberFormatException exception) {
                        this.logger.error("Value of <atom> @", atts.getQName(i), " is not an integer: ", atts.getValue(i));
                        this.logger.debug(exception);
                    }
                }
                break block11;
            }
            if (!"scalar".equals(local)) break block11;
            for (int i = 0; i < atts.getLength(); ++i) {
                if (!"dictRef".equals(atts.getQName(i))) continue;
                if ("cdk:maxBondOrder".equals(atts.getValue(i))) {
                    this.scalarType = 1;
                    continue;
                }
                if ("cdk:bondOrderSum".equals(atts.getValue(i))) {
                    this.scalarType = 2;
                    continue;
                }
                if ("cdk:hybridization".equals(atts.getValue(i))) {
                    this.scalarType = 3;
                    continue;
                }
                if ("cdk:formalNeighbourCount".equals(atts.getValue(i))) {
                    this.scalarType = 4;
                    continue;
                }
                if (!"cdk:valency".equals(atts.getValue(i))) continue;
                this.scalarType = 5;
            }
        }
    }

    public void characters(char[] chars, int start, int length) {
        this.logger.debug("character data");
        this.currentChars = this.currentChars + new String(chars, start, length);
    }
}

