/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.config;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import java.util.Vector;
import org.openscience.cdk.AtomType;
import org.openscience.cdk.config.AtomTypeConfigurator;

public class TXTBasedAtomTypeConfigurator
implements AtomTypeConfigurator {
    private String configFile = "org/openscience/cdk/config/data/jmol_atomtypes.txt";
    private InputStream ins = null;

    public void setInputStream(InputStream ins) {
        this.ins = ins;
    }

    public Vector readAtomTypes() throws IOException {
        Vector<AtomType> atomTypes = new Vector<AtomType>();
        if (this.ins == null) {
            this.ins = this.getClass().getClassLoader().getResourceAsStream(this.configFile);
        }
        if (this.ins == null) {
            throw new IOException("There was a problem getting the default stream: " + this.configFile);
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.ins), 1024);
        try {
            String string;
            while ((string = reader.readLine()) != null) {
                if (string.startsWith("#")) continue;
                String name = "";
                String rootType = "";
                int atomicNumber = 0;
                int colorR = 0;
                int colorG = 0;
                int colorB = 0;
                double mass = 0.0;
                double vdwaals = 0.0;
                double covalent = 0.0;
                StringTokenizer tokenizer = new StringTokenizer(string, "\t ,;");
                int tokenCount = tokenizer.countTokens();
                if (tokenCount == 9) {
                    name = tokenizer.nextToken();
                    rootType = tokenizer.nextToken();
                    String san = tokenizer.nextToken();
                    String sam = tokenizer.nextToken();
                    String svdwaals = tokenizer.nextToken();
                    String scovalent = tokenizer.nextToken();
                    String sColorR = tokenizer.nextToken();
                    String sColorG = tokenizer.nextToken();
                    String sColorB = tokenizer.nextToken();
                    try {
                        mass = new Double(sam);
                        vdwaals = new Double(svdwaals);
                        covalent = new Double(scovalent);
                        atomicNumber = Integer.parseInt(san);
                        colorR = Integer.parseInt(sColorR);
                        colorG = Integer.parseInt(sColorG);
                        colorB = Integer.parseInt(sColorB);
                    }
                    catch (NumberFormatException nfe) {
                        throw new IOException("AtomTypeTable.ReadAtypes: Malformed Number");
                    }
                    AtomType atomType = new AtomType(name, rootType);
                    atomType.setAtomicNumber(atomicNumber);
                    atomType.setExactMass(mass);
                    atomType.setVanderwaalsRadius(vdwaals);
                    atomType.setCovalentRadius(covalent);
                    Color color = new Color(colorR, colorG, colorB);
                    atomType.setProperty("org.openscience.cdk.renderer.color", color);
                    atomTypes.addElement(atomType);
                    continue;
                }
                throw new IOException("AtomTypeTable.ReadAtypes: Wrong Number of fields");
            }
            this.ins.close();
        }
        catch (IOException exception) {
            System.err.println(exception.toString());
            exception.printStackTrace();
            throw exception;
        }
        return atomTypes;
    }
}

