/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.config;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OptionalDataException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import org.openscience.cdk.Atom;
import org.openscience.cdk.AtomContainer;
import org.openscience.cdk.Element;
import org.openscience.cdk.Isotope;
import org.openscience.cdk.config.isotopes.IsotopeReader;
import org.openscience.cdk.tools.LoggingTool;

public class IsotopeFactory {
    private static IsotopeFactory ifac = null;
    private Vector isotopes = null;
    private Hashtable majorIsotopes = null;
    private boolean debug = false;
    private LoggingTool logger = new LoggingTool(this);

    private IsotopeFactory() throws IOException, OptionalDataException, ClassNotFoundException {
        this.logger.info("Creating new IsotopeFactory");
        InputStream ins = null;
        String errorMessage = "There was a problem getting org.openscience.cdk.config.isotopes.xml as a stream";
        try {
            String configFile = "org/openscience/cdk/config/data/isotopes.xml";
            if (this.debug) {
                this.logger.debug((Object)"Getting stream for ", configFile);
            }
            ins = this.getClass().getClassLoader().getResourceAsStream(configFile);
        }
        catch (Exception exception) {
            this.logger.error(errorMessage);
            this.logger.debug(exception);
            throw new IOException(errorMessage);
        }
        if (ins == null) {
            this.logger.error(errorMessage);
            throw new IOException(errorMessage);
        }
        IsotopeReader reader = new IsotopeReader(new InputStreamReader(ins));
        this.isotopes = reader.readIsotopes();
        if (this.debug) {
            this.logger.debug((Object)"Found #isotopes in file: ", this.isotopes.size());
        }
        this.majorIsotopes = new Hashtable();
    }

    public static IsotopeFactory getInstance() throws IOException, OptionalDataException, ClassNotFoundException {
        if (ifac == null) {
            ifac = new IsotopeFactory();
        }
        return ifac;
    }

    public int getSize() {
        return this.isotopes.size();
    }

    public Isotope[] getIsotopes(String symbol) {
        ArrayList<Isotope> list = new ArrayList<Isotope>();
        for (int f = 0; f < this.isotopes.size(); ++f) {
            if (!((Isotope)this.isotopes.elementAt(f)).getSymbol().equals(symbol)) continue;
            list.add((Isotope)((Isotope)this.isotopes.elementAt(f)).clone());
        }
        return list.toArray(new Isotope[list.size()]);
    }

    public Isotope getMajorIsotope(int atomicNumber) {
        Isotope major = null;
        for (int f = 0; f < this.isotopes.size(); ++f) {
            Isotope current = (Isotope)this.isotopes.elementAt(f);
            if (current.getAtomicNumber() != atomicNumber) continue;
            if (major == null) {
                major = (Isotope)current.clone();
                continue;
            }
            if (!(current.getNaturalAbundance() > major.getNaturalAbundance())) continue;
            major = (Isotope)current.clone();
        }
        if (major == null) {
            this.logger.error((Object)"Could not find major isotope for: ", atomicNumber);
        }
        return major;
    }

    public boolean isElement(String elementName) {
        return this.getElement(elementName) != null;
    }

    public Isotope getMajorIsotope(String symbol) {
        Isotope major = null;
        if (this.majorIsotopes.contains(symbol)) {
            major = (Isotope)this.majorIsotopes.get(symbol);
        } else {
            for (int f = 0; f < this.isotopes.size(); ++f) {
                Isotope current = (Isotope)this.isotopes.elementAt(f);
                if (!current.getSymbol().equals(symbol)) continue;
                if (major == null) {
                    major = (Isotope)current.clone();
                    continue;
                }
                if (!(current.getNaturalAbundance() > major.getNaturalAbundance())) continue;
                major = (Isotope)current.clone();
            }
            if (major == null) {
                this.logger.error((Object)"Could not find major isotope for: ", symbol);
            } else {
                this.majorIsotopes.put(symbol, major);
            }
        }
        return major;
    }

    public Element getElement(String symbol) {
        Isotope isotope = this.getMajorIsotope(symbol);
        return isotope;
    }

    public Element getElement(int atomicNumber) {
        Isotope isotope = this.getMajorIsotope(atomicNumber);
        return isotope;
    }

    public String getElementSymbol(int atomicNumber) {
        Isotope isotope = this.getMajorIsotope(atomicNumber);
        return isotope.getSymbol();
    }

    public Atom configure(Atom atom) {
        Isotope isotope = this.getMajorIsotope(atom.getSymbol());
        return this.configure(atom, isotope);
    }

    public Atom configure(Atom atom, Isotope isotope) {
        atom.setMassNumber(isotope.getMassNumber());
        atom.setSymbol(isotope.getSymbol());
        atom.setExactMass(isotope.getExactMass());
        atom.setAtomicNumber(isotope.getAtomicNumber());
        atom.setNaturalAbundance(isotope.getNaturalAbundance());
        return atom;
    }

    public void configureAtoms(AtomContainer container) {
        for (int f = 0; f < container.getAtomCount(); ++f) {
            this.configure((Atom)container.getAtomAt(f));
        }
    }
}

