/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.config;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Vector;
import org.openscience.cdk.AtomType;
import org.openscience.cdk.config.AtomTypeConfigurator;
import org.openscience.cdk.config.atomtypes.AtomTypeReader;
import org.openscience.cdk.tools.LoggingTool;

public class CDKBasedAtomTypeConfigurator
implements AtomTypeConfigurator {
    private String configFile = "org.openscience.cdk.config.data.structgen_atomtypes.xml";
    private InputStream ins = null;
    private LoggingTool logger = new LoggingTool(this);

    public void setInputStream(InputStream ins) {
        this.ins = ins;
    }

    public Vector readAtomTypes() throws IOException {
        Vector atomTypes = new Vector(0);
        if (this.ins == null) {
            try {
                this.ins = this.getClass().getClassLoader().getResourceAsStream(this.configFile);
            }
            catch (Exception exc) {
                this.logger.error(exc.getMessage());
                this.logger.debug(exc);
                throw new IOException("There was a problem getting a stream for " + this.configFile + " with getClass.getClassLoader.getResourceAsStream");
            }
            if (this.ins == null) {
                try {
                    this.ins = this.getClass().getResourceAsStream(this.configFile);
                }
                catch (Exception exc) {
                    this.logger.error(exc.getMessage());
                    this.logger.debug(exc);
                    throw new IOException("There was a problem getting a stream for " + this.configFile + " with getClass.getResourceAsStream");
                }
            }
        }
        if (this.ins == null) {
            throw new IOException("There was a problem getting an input stream");
        }
        AtomTypeReader reader = new AtomTypeReader(new InputStreamReader(this.ins));
        atomTypes = reader.readAtomTypes();
        for (int f = 0; f < atomTypes.size(); ++f) {
            Object object = atomTypes.elementAt(f);
            if (object != null) continue;
            System.out.println("Expecting an object but found null!");
            if (object instanceof AtomType) continue;
            System.out.println("Expecting cdk.AtomType class, but got: " + object.getClass().getName());
        }
        return atomTypes;
    }
}

