/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OptionalDataException;
import java.util.Hashtable;
import java.util.Vector;
import org.openscience.cdk.Atom;
import org.openscience.cdk.AtomType;
import org.openscience.cdk.PseudoAtom;
import org.openscience.cdk.config.AtomTypeConfigurator;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.exception.NoSuchAtomTypeException;
import org.openscience.cdk.tools.LoggingTool;

public class AtomTypeFactory {
    public static final String ATOMTYPE_ID_STRUCTGEN = "structgen";
    public static final String ATOMTYPE_ID_MODELING = "modeling";
    public static final String ATOMTYPE_ID_JMOL = "jmol";
    private static final String TXT_EXTENSION = "txt";
    private static final String XML_EXTENSION = "xml";
    private static LoggingTool logger;
    private static Hashtable tables;
    private Vector atomTypes = null;

    private AtomTypeFactory(String configFile) throws IOException, OptionalDataException, ClassNotFoundException {
        if (logger == null) {
            logger = new LoggingTool(this);
        }
        this.atomTypes = new Vector(30);
        this.readConfiguration(configFile);
    }

    private AtomTypeFactory(InputStream ins, String format) throws IOException, OptionalDataException, ClassNotFoundException {
        if (logger == null) {
            logger = new LoggingTool(this);
        }
        this.atomTypes = new Vector(30);
        this.readConfiguration(ins, format);
    }

    public static AtomTypeFactory getInstance(InputStream ins, String format) throws IOException, OptionalDataException, ClassNotFoundException {
        return new AtomTypeFactory(ins, format);
    }

    public static AtomTypeFactory getInstance() throws IOException, OptionalDataException, ClassNotFoundException {
        return AtomTypeFactory.getInstance("org/openscience/cdk/config/data/structgen_atomtypes.xml");
    }

    public static AtomTypeFactory getInstance(String configFile) throws IOException, OptionalDataException, ClassNotFoundException {
        if (tables == null) {
            tables = new Hashtable();
        }
        if (!tables.containsKey(configFile)) {
            tables.put(configFile, new AtomTypeFactory(configFile));
        }
        return (AtomTypeFactory)tables.get(configFile);
    }

    private void readConfiguration(String fileName) {
        logger.info((Object)"Reading config file from ", fileName);
        InputStream ins = null;
        File file = new File(fileName);
        if (file.exists()) {
            logger.debug("configFile is a File");
            try {
                ins = new FileInputStream(file);
            }
            catch (Exception exception) {
                logger.error(exception.getMessage());
                logger.debug(exception);
            }
        } else {
            logger.debug("configFile must be a stream");
            ins = this.getClass().getClassLoader().getResourceAsStream(fileName);
        }
        if (ins == null) {
            logger.error((Object)"There was a problem getting a stream for ", fileName);
        }
        String format = XML_EXTENSION;
        if (fileName.endsWith(TXT_EXTENSION)) {
            format = TXT_EXTENSION;
        } else if (fileName.endsWith(XML_EXTENSION)) {
            format = XML_EXTENSION;
        }
        this.readConfiguration(ins, format);
    }

    private AtomTypeConfigurator constructConfigurator(String format) {
        try {
            if (format.equals(TXT_EXTENSION)) {
                return (AtomTypeConfigurator)this.getClass().getClassLoader().loadClass("org.openscience.cdk.config.TXTBasedAtomTypeConfigurator").newInstance();
            }
            if (format.equals(XML_EXTENSION)) {
                return (AtomTypeConfigurator)this.getClass().getClassLoader().loadClass("org.openscience.cdk.config.CDKBasedAtomTypeConfigurator").newInstance();
            }
        }
        catch (Exception exc) {
            logger.error((Object)"Could not get instance of AtomTypeConfigurator for format ", format);
            logger.debug(exc);
        }
        return null;
    }

    private void readConfiguration(InputStream ins, String format) {
        AtomTypeConfigurator atc = this.constructConfigurator(format);
        if (atc != null) {
            atc.setInputStream(ins);
            try {
                this.atomTypes = atc.readAtomTypes();
            }
            catch (Exception exc) {
                logger.error((Object)"Could not read AtomType's from file due to: ", exc.getMessage());
                logger.debug(exc);
            }
        } else {
            logger.debug("AtomTypeConfigurator was null!");
            this.atomTypes = new Vector();
        }
    }

    public int getSize() {
        return this.atomTypes.size();
    }

    public AtomType getAtomType(String identifier) throws NoSuchAtomTypeException {
        AtomType atomType = null;
        for (int f = 0; f < this.atomTypes.size(); ++f) {
            atomType = (AtomType)this.atomTypes.elementAt(f);
            if (!atomType.getAtomTypeName().equals(identifier)) continue;
            return atomType;
        }
        throw new NoSuchAtomTypeException("The AtomType " + identifier + " could not be found");
    }

    public AtomType[] getAtomTypes(String symbol) {
        logger.debug((Object)"Request for atomtype for symbol ", symbol);
        Vector<AtomType> atomList = new Vector<AtomType>();
        AtomType atomType = null;
        for (int f = 0; f < this.atomTypes.size(); ++f) {
            atomType = (AtomType)this.atomTypes.elementAt(f);
            if (!atomType.getSymbol().equals(symbol)) continue;
            atomList.addElement((AtomType)atomType.clone());
        }
        Object[] atomTypes = new AtomType[atomList.size()];
        atomList.copyInto(atomTypes);
        if (atomTypes.length > 0) {
            logger.debug("Atomtype for symbol ", symbol, " has this number of types: " + atomTypes.length);
        } else {
            logger.debug((Object)"No atomtype for symbol ", symbol);
        }
        return atomTypes;
    }

    public AtomType[] getAllAtomTypes() {
        logger.debug((Object)"Returning list of size: ", this.getSize());
        Vector<AtomType> atomtypeList = new Vector<AtomType>();
        AtomType atomType = null;
        for (int f = 0; f < this.atomTypes.size(); ++f) {
            atomType = (AtomType)this.atomTypes.elementAt(f);
            atomtypeList.addElement((AtomType)atomType.clone());
        }
        Object[] atomTypes = new AtomType[atomtypeList.size()];
        atomtypeList.copyInto(atomTypes);
        return atomTypes;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Atom configure(Atom atom) throws CDKException {
        if (atom instanceof PseudoAtom) {
            return atom;
        }
        try {
            AtomType atomType = null;
            String atomTypeName = atom.getAtomTypeName();
            if (atomTypeName == null || atomTypeName.length() == 0) {
                logger.debug("Using atom symbol because atom type name is empty...");
                AtomType[] types = this.getAtomTypes(atom.getSymbol());
                if (types.length <= 0) {
                    String message = "Could not configure atom with unknown ID: " + atom.toString() + " + (id=" + atom.getAtomTypeName() + ")";
                    logger.warn(message);
                    throw new CDKException(message);
                }
                logger.warn("Taking first atom type, but other may exist");
                atomType = types[0];
            } else {
                atomType = this.getAtomType(atom.getAtomTypeName());
            }
            logger.debug((Object)"Configuring with atomtype: ", atomType);
            atom.setSymbol(atomType.getSymbol());
            atom.setMaxBondOrder(atomType.getMaxBondOrder());
            atom.setBondOrderSum(atomType.getBondOrderSum());
            atom.setVanderwaalsRadius(atomType.getVanderwaalsRadius());
            atom.setCovalentRadius(atomType.getCovalentRadius());
            atom.setHybridization(atomType.getHybridization());
            Object color = atomType.getProperty("org.openscience.cdk.renderer.color");
            if (color != null) {
                atom.setProperty("org.openscience.cdk.renderer.color", color);
            }
            if (atomType.getAtomicNumber() != 0) {
                atom.setAtomicNumber(atomType.getAtomicNumber());
            } else {
                logger.debug((Object)"Did not configure atomic number: AT.an=", atomType.getAtomicNumber());
            }
            if (atomType.getExactMass() > 0.0) {
                atom.setExactMass(atomType.getExactMass());
            } else {
                logger.debug((Object)"Did not configure mass: AT.mass=", atomType.getAtomicNumber());
            }
        }
        catch (Exception exception) {
            logger.warn("Could not configure atom with unknown ID: ", atom, " + (id=", atom.getAtomTypeName(), ")");
            logger.debug(exception);
            throw new CDKException(exception.toString());
        }
        logger.debug((Object)"Configured: ", atom);
        return atom;
    }

    static {
        tables = null;
    }
}

