/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk;

import java.io.Serializable;
import org.openscience.cdk.ChemObject;
import org.openscience.cdk.interfaces.Reaction;

public class SetOfReactions
extends ChemObject
implements Serializable,
org.openscience.cdk.interfaces.SetOfReactions {
    private static final long serialVersionUID = 1528749911904585204L;
    private Reaction[] reactions = new org.openscience.cdk.Reaction[this.growArraySize];
    private int reactionCount = 0;
    private int growArraySize = 5;

    public void addReaction(Reaction reaction) {
        if (this.reactionCount + 1 >= this.reactions.length) {
            this.growReactionArray();
        }
        this.reactions[this.reactionCount] = reaction;
        ++this.reactionCount;
        this.notifyChanged();
    }

    public Reaction getReaction(int number) {
        return (org.openscience.cdk.Reaction)this.reactions[number];
    }

    public Reaction[] getReactions() {
        Reaction[] result = new org.openscience.cdk.Reaction[this.reactionCount];
        for (int i = 0; i < this.reactionCount; ++i) {
            result[i] = (org.openscience.cdk.Reaction)this.reactions[i];
        }
        return result;
    }

    private void growReactionArray() {
        this.growArraySize = this.reactions.length;
        org.openscience.cdk.Reaction[] newreactions = new org.openscience.cdk.Reaction[this.reactions.length + this.growArraySize];
        System.arraycopy(this.reactions, 0, newreactions, 0, this.reactions.length);
        this.reactions = newreactions;
    }

    public int getReactionCount() {
        return this.reactionCount;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("SetOfReactions(");
        buffer.append(this.hashCode()).append(", ");
        buffer.append("R=").append(this.getReactionCount()).append(", ");
        Reaction[] reactions = this.getReactions();
        for (int i = 0; i < reactions.length; ++i) {
            buffer.append(reactions[i].toString());
        }
        buffer.append(")");
        return buffer.toString();
    }

    public Object clone() {
        SetOfReactions clone = (SetOfReactions)super.clone();
        clone.reactionCount = this.reactionCount;
        clone.reactions = new org.openscience.cdk.Reaction[clone.reactionCount];
        for (int f = 0; f < clone.reactionCount; ++f) {
            clone.reactions[f] = (org.openscience.cdk.Reaction)((org.openscience.cdk.Reaction)this.reactions[f]).clone();
        }
        return clone;
    }
}

