/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk;

import java.io.Serializable;
import org.openscience.cdk.ChemObject;
import org.openscience.cdk.interfaces.AtomContainer;
import org.openscience.cdk.interfaces.ChemObjectChangeEvent;
import org.openscience.cdk.interfaces.ChemObjectListener;

public class SetOfAtomContainers
extends ChemObject
implements Serializable,
org.openscience.cdk.interfaces.SetOfAtomContainers,
ChemObjectListener {
    private static final long serialVersionUID = -521290297592768395L;
    protected AtomContainer[] atomContainers = new org.openscience.cdk.AtomContainer[this.growArraySize];
    protected int atomContainerCount = 0;
    protected double[] multipliers = new double[this.growArraySize];
    protected int growArraySize = 5;

    public void addAtomContainer(AtomContainer atomContainer) {
        atomContainer.addListener(this);
        this.addAtomContainer(atomContainer, 1.0);
    }

    public void removeAtomContainer(AtomContainer atomContainer) {
        for (int i = 0; i < this.atomContainerCount; ++i) {
            if (this.atomContainers[i] != atomContainer) continue;
            this.removeAtomContainer(i);
        }
    }

    public void removeAllAtomContainers() {
        for (int pos = this.atomContainerCount - 1; pos >= 0; --pos) {
            this.atomContainers[pos].removeListener(this);
            this.multipliers[pos] = 0.0;
            this.atomContainers[pos] = null;
        }
        this.atomContainerCount = 0;
        this.notifyChanged();
    }

    public void removeAtomContainer(int pos) {
        this.atomContainers[pos].removeListener(this);
        for (int i = pos; i < this.atomContainerCount - 1; ++i) {
            this.atomContainers[i] = this.atomContainers[i + 1];
            this.multipliers[i] = this.multipliers[i + 1];
        }
        this.atomContainers[this.atomContainerCount - 1] = null;
        --this.atomContainerCount;
        this.notifyChanged();
    }

    public boolean setMultiplier(AtomContainer container, double multiplier) {
        for (int i = 0; i < this.atomContainers.length; ++i) {
            if (this.atomContainers[i] != container) continue;
            this.multipliers[i] = multiplier;
            this.notifyChanged();
            return true;
        }
        return false;
    }

    public void setMultiplier(int position, double multiplier) {
        this.multipliers[position] = multiplier;
        this.notifyChanged();
    }

    public double[] getMultipliers() {
        double[] returnArray = new double[this.atomContainerCount];
        System.arraycopy(this.multipliers, 0, returnArray, 0, this.atomContainerCount);
        return returnArray;
    }

    public boolean setMultipliers(double[] newMultipliers) {
        if (newMultipliers.length == this.atomContainerCount) {
            System.arraycopy(newMultipliers, 0, this.multipliers, 0, this.atomContainerCount);
            this.notifyChanged();
            return true;
        }
        return false;
    }

    public void addAtomContainer(AtomContainer atomContainer, double multiplier) {
        if (this.atomContainerCount + 1 >= this.atomContainers.length) {
            this.growAtomContainerArray();
        }
        atomContainer.addListener(this);
        this.atomContainers[this.atomContainerCount] = atomContainer;
        this.multipliers[this.atomContainerCount] = multiplier;
        ++this.atomContainerCount;
        this.notifyChanged();
    }

    public void add(org.openscience.cdk.interfaces.SetOfAtomContainers atomContainerSet) {
        AtomContainer[] mols = atomContainerSet.getAtomContainers();
        for (int i = 0; i < mols.length; ++i) {
            this.addAtomContainer(mols[i]);
        }
    }

    public AtomContainer[] getAtomContainers() {
        AtomContainer[] result = new org.openscience.cdk.AtomContainer[this.atomContainerCount];
        System.arraycopy(this.atomContainers, 0, result, 0, result.length);
        return result;
    }

    public AtomContainer getAtomContainer(int number) {
        return (org.openscience.cdk.AtomContainer)this.atomContainers[number];
    }

    public double getMultiplier(int number) {
        return this.multipliers[number];
    }

    public double getMultiplier(AtomContainer container) {
        for (int i = 0; i < this.atomContainerCount; ++i) {
            if (!this.atomContainers[i].equals(container)) continue;
            return this.multipliers[i];
        }
        return -1.0;
    }

    protected void growAtomContainerArray() {
        this.growArraySize = this.atomContainers.length;
        org.openscience.cdk.AtomContainer[] newatomContainers = new org.openscience.cdk.AtomContainer[this.atomContainers.length + this.growArraySize];
        System.arraycopy(this.atomContainers, 0, newatomContainers, 0, this.atomContainers.length);
        this.atomContainers = newatomContainers;
        double[] newMultipliers = new double[this.multipliers.length + this.growArraySize];
        System.arraycopy(this.multipliers, 0, newMultipliers, 0, this.multipliers.length);
        this.multipliers = newMultipliers;
    }

    public int getAtomContainerCount() {
        return this.atomContainerCount;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("SetOfAtomContainers(");
        buffer.append(this.hashCode()).append(", ");
        buffer.append("M=").append(this.getAtomContainerCount()).append(", ");
        AtomContainer[] atomContainers = this.getAtomContainers();
        for (int i = 0; i < atomContainers.length; ++i) {
            buffer.append(atomContainers[i].toString());
            if (i >= atomContainers.length - 1) continue;
            buffer.append(", ");
        }
        buffer.append(")");
        return buffer.toString();
    }

    public Object clone() {
        SetOfAtomContainers clone = new SetOfAtomContainers();
        AtomContainer[] result = this.getAtomContainers();
        for (int i = 0; i < result.length; ++i) {
            clone.addAtomContainer((org.openscience.cdk.AtomContainer)((org.openscience.cdk.AtomContainer)result[i]).clone(), 1.0);
        }
        return clone;
    }

    public void stateChanged(ChemObjectChangeEvent event) {
        this.notifyChanged(event);
    }
}

