/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import org.openscience.cdk.ChemObject;
import org.openscience.cdk.interfaces.Atom;
import org.openscience.cdk.interfaces.Bond;
import org.openscience.cdk.interfaces.Ring;

public class RingSet
extends Vector
implements Serializable,
org.openscience.cdk.interfaces.RingSet {
    private static final long serialVersionUID = -1859706720484903351L;
    public static final int LARGE_FIRST = 1;
    public static final int SMALL_FIRST = 2;

    public boolean ringAlreadyInSet(Ring newRing) {
        for (int f = 0; f < this.size(); ++f) {
            Bond[] newBonds;
            boolean equals = false;
            int equalCount = 0;
            org.openscience.cdk.Ring ring = (org.openscience.cdk.Ring)this.elementAt(f);
            Bond[] bonds = ring.getBonds();
            if (bonds.length == (newBonds = newRing.getBonds()).length) {
                for (int i = 0; i < bonds.length; ++i) {
                    Bond bond = newBonds[i];
                    for (int n = 0; n < bonds.length; ++n) {
                        if (bond != bonds[n]) continue;
                        equals = true;
                        ++equalCount;
                        break;
                    }
                    if (!equals) break;
                }
            }
            if (equalCount != bonds.length) continue;
            return true;
        }
        return false;
    }

    public Vector getRings(Bond bond) {
        Vector<org.openscience.cdk.Ring> rings = new Vector<org.openscience.cdk.Ring>();
        for (int i = 0; i < this.size(); ++i) {
            org.openscience.cdk.Ring ring = (org.openscience.cdk.Ring)this.elementAt(i);
            if (!ring.contains(bond)) continue;
            rings.addElement(ring);
        }
        return rings;
    }

    public org.openscience.cdk.interfaces.RingSet getRings(Atom atom) {
        RingSet rings = new RingSet();
        for (int i = 0; i < this.size(); ++i) {
            org.openscience.cdk.Ring ring = (org.openscience.cdk.Ring)this.elementAt(i);
            if (!ring.contains(atom)) continue;
            rings.addElement(ring);
        }
        return rings;
    }

    public Vector getConnectedRings(Ring ring) {
        Vector<org.openscience.cdk.Ring> connectedRings = new Vector<org.openscience.cdk.Ring>();
        for (int i = 0; i < ring.getAtomCount(); ++i) {
            Atom atom = ring.getAtomAt(i);
            for (int j = 0; j < this.size(); ++j) {
                org.openscience.cdk.Ring tempRing = (org.openscience.cdk.Ring)this.elementAt(j);
                if (tempRing == ring || !tempRing.contains(atom)) continue;
                connectedRings.addElement(tempRing);
            }
        }
        return connectedRings;
    }

    public void add(org.openscience.cdk.interfaces.RingSet ringSet) {
        for (int f = 0; f < ringSet.size(); ++f) {
            if (this.contains(ringSet.get(f))) continue;
            this.addElement(ringSet.get(f));
        }
    }

    public boolean contains(Atom atom) {
        for (int i = 0; i < this.size(); ++i) {
            if (!((org.openscience.cdk.Ring)this.elementAt(i)).contains(atom)) continue;
            return true;
        }
        return false;
    }

    public Object clone() {
        RingSet clone = (RingSet)super.clone();
        clone.removeAllElements();
        Enumeration rings = this.elements();
        while (rings.hasMoreElements()) {
            Object possibleRing = rings.nextElement();
            if (possibleRing instanceof ChemObject) {
                clone.addElement(((ChemObject)possibleRing).clone());
                continue;
            }
            clone.addElement(possibleRing);
        }
        return clone;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("RingSet(");
        buffer.append(this.hashCode()).append(", ");
        buffer.append("R=").append(this.size()).append(", ");
        Enumeration rings = this.elements();
        while (rings.hasMoreElements()) {
            org.openscience.cdk.Ring possibleRing = (org.openscience.cdk.Ring)rings.nextElement();
            buffer.append(possibleRing.toString());
            if (!rings.hasMoreElements()) continue;
            buffer.append(", ");
        }
        buffer.append(")");
        return buffer.toString();
    }

    public boolean isSameRing(org.openscience.cdk.Atom atom1, org.openscience.cdk.Atom atom2) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            org.openscience.cdk.Ring ring = (org.openscience.cdk.Ring)iterator.next();
            if (!ring.contains(atom1) || !ring.contains(atom2)) continue;
            return true;
        }
        return false;
    }
}

