/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk;

import java.io.Serializable;
import org.openscience.cdk.Bond;
import org.openscience.cdk.interfaces.Atom;
import org.openscience.cdk.interfaces.AtomContainer;
import org.openscience.cdk.interfaces.ElectronContainer;

public class Ring
extends org.openscience.cdk.AtomContainer
implements Serializable,
org.openscience.cdk.interfaces.Ring {
    private static final long serialVersionUID = 6604894792331865990L;

    public Ring() {
    }

    public Ring(AtomContainer ac) {
        super(ac);
    }

    public Ring(int ringSize, String elementSymbol) {
        this(ringSize);
        Atom[] atoms = new org.openscience.cdk.Atom[ringSize];
        atoms[0] = new org.openscience.cdk.Atom(elementSymbol);
        for (int i = 1; i < ringSize; ++i) {
            atoms[i] = new org.openscience.cdk.Atom(elementSymbol);
            this.addElectronContainer(new Bond(atoms[i - 1], atoms[i], 1.0));
        }
        this.addElectronContainer(new Bond(atoms[ringSize - 1], atoms[0], 1.0));
        this.setAtoms(atoms);
    }

    public Ring(int ringSize) {
        super(ringSize, ringSize);
    }

    public int getRingSize() {
        return this.atomCount;
    }

    public org.openscience.cdk.interfaces.Bond getNextBond(org.openscience.cdk.interfaces.Bond bond, Atom atom) {
        for (int f = 0; f < this.getElectronContainerCount(); ++f) {
            Bond tempBond;
            ElectronContainer electronContainer = this.getElectronContainerAt(f);
            if (!(electronContainer instanceof org.openscience.cdk.interfaces.Bond) || !(tempBond = (Bond)electronContainer).contains(atom) || bond == tempBond) continue;
            return tempBond;
        }
        return null;
    }

    public int getOrderSum() {
        int orderSum = 0;
        for (int i = 0; i < this.getElectronContainerCount(); ++i) {
            ElectronContainer electronContainer = this.getElectronContainerAt(i);
            if (!(electronContainer instanceof org.openscience.cdk.interfaces.Bond)) continue;
            Bond tempBond = (Bond)electronContainer;
            orderSum = (int)((double)orderSum + tempBond.getOrder());
        }
        return orderSum;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Ring(");
        buffer.append(super.toString());
        buffer.append(")");
        return buffer.toString();
    }
}

