/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk;

import java.io.Serializable;
import org.openscience.cdk.ChemObject;
import org.openscience.cdk.Mapping;
import org.openscience.cdk.SetOfMolecules;
import org.openscience.cdk.interfaces.Molecule;

public class Reaction
extends ChemObject
implements Serializable,
org.openscience.cdk.interfaces.Reaction {
    private static final long serialVersionUID = -554752528363533678L;
    public static final int UNKNOWN_DIRECTION = 0;
    public static final int FORWARD = 1;
    public static final int BACKWARD = 2;
    public static final int BIDIRECTIONAL = 3;
    protected int growArraySize = 3;
    protected org.openscience.cdk.interfaces.SetOfMolecules reactants = new SetOfMolecules();
    protected org.openscience.cdk.interfaces.SetOfMolecules products = new SetOfMolecules();
    protected org.openscience.cdk.interfaces.SetOfMolecules agents = new SetOfMolecules();
    protected Mapping[] map = new Mapping[this.growArraySize];
    protected int mappingCount = 0;
    private int reactionDirection = 1;

    public int getReactantCount() {
        return this.reactants.getAtomContainerCount();
    }

    public int getProductCount() {
        return this.products.getAtomContainerCount();
    }

    public org.openscience.cdk.interfaces.SetOfMolecules getReactants() {
        return (SetOfMolecules)this.reactants;
    }

    public void setReactants(org.openscience.cdk.interfaces.SetOfMolecules setOfMolecules) {
        this.reactants = setOfMolecules;
        this.notifyChanged();
    }

    public org.openscience.cdk.interfaces.SetOfMolecules getProducts() {
        return (SetOfMolecules)this.products;
    }

    public void setProducts(org.openscience.cdk.interfaces.SetOfMolecules setOfMolecules) {
        this.products = setOfMolecules;
        this.notifyChanged();
    }

    public org.openscience.cdk.interfaces.SetOfMolecules getAgents() {
        return (SetOfMolecules)this.agents;
    }

    public Mapping[] getMappings() {
        Mapping[] returnMappings = new Mapping[this.mappingCount];
        System.arraycopy(this.map, 0, returnMappings, 0, returnMappings.length);
        return returnMappings;
    }

    public void addReactant(Molecule reactant) {
        this.addReactant(reactant, 1.0);
    }

    public void addAgent(Molecule agent) {
        this.agents.addAtomContainer(agent);
        this.notifyChanged();
    }

    public void addReactant(Molecule reactant, double coefficient) {
        this.reactants.addAtomContainer(reactant, coefficient);
        this.notifyChanged();
    }

    public void addProduct(Molecule product) {
        this.addProduct(product, 1.0);
    }

    public void addProduct(Molecule product, double coefficient) {
        this.products.addAtomContainer(product, coefficient);
    }

    public double getReactantCoefficient(Molecule reactant) {
        return this.reactants.getMultiplier(reactant);
    }

    public double getProductCoefficient(Molecule product) {
        return this.products.getMultiplier(product);
    }

    public boolean setReactantCoefficient(Molecule reactant, double coefficient) {
        this.notifyChanged();
        return this.reactants.setMultiplier(reactant, coefficient);
    }

    public boolean setProductCoefficient(Molecule product, double coefficient) {
        this.notifyChanged();
        return this.products.setMultiplier(product, coefficient);
    }

    public double[] getReactantCoefficients() {
        return this.reactants.getMultipliers();
    }

    public double[] getProductCoefficients() {
        return this.products.getMultipliers();
    }

    public boolean setReactantCoefficients(double[] coefficients) {
        this.notifyChanged();
        return this.reactants.setMultipliers(coefficients);
    }

    public boolean setProductCoefficients(double[] coefficients) {
        this.notifyChanged();
        return this.products.setMultipliers(coefficients);
    }

    public void setDirection(int direction) {
        this.reactionDirection = direction;
        this.notifyChanged();
    }

    public int getDirection() {
        return this.reactionDirection;
    }

    public void addMapping(Mapping mapping) {
        if (this.mappingCount + 1 >= this.map.length) {
            this.growMappingArray();
        }
        this.map[this.mappingCount] = mapping;
        ++this.mappingCount;
        this.notifyChanged();
    }

    protected void growMappingArray() {
        Mapping[] newMap = new Mapping[this.map.length + this.growArraySize];
        System.arraycopy(this.map, 0, newMap, 0, this.map.length);
        this.map = newMap;
    }

    public String toString() {
        StringBuffer description = new StringBuffer();
        description.append("Reaction(");
        description.append(this.getID()).append(", ");
        description.append("#M:").append(this.mappingCount).append(", ");
        description.append("reactants=").append(this.reactants.toString()).append(", ");
        description.append("products=").append(this.products.toString()).append(", ");
        description.append("agents=").append(this.agents.toString());
        description.append(")");
        return description.toString();
    }

    public Object clone() {
        Reaction clone = (Reaction)super.clone();
        clone.reactants = (SetOfMolecules)((SetOfMolecules)this.reactants).clone();
        clone.agents = (SetOfMolecules)((SetOfMolecules)this.agents).clone();
        clone.products = (SetOfMolecules)((SetOfMolecules)this.products).clone();
        clone.map = new Mapping[this.map.length];
        for (int f = 0; f < this.map.length; ++f) {
            clone.map[f] = this.map[f];
        }
        return clone;
    }
}

