/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk;

import java.io.Serializable;
import org.openscience.cdk.Element;

public class Isotope
extends Element
implements Serializable,
org.openscience.cdk.interfaces.Isotope {
    private static final long serialVersionUID = 6389365978927575858L;
    public double exactMass = -1.0;
    public double naturalAbundance = -1.0;
    private int massNumber = 0;

    public Isotope(String elementSymbol) {
        super(elementSymbol);
    }

    public Isotope(int atomicNumber, String elementSymbol, int massNumber, double exactMass, double abundance) {
        this(atomicNumber, elementSymbol, exactMass, abundance);
        this.massNumber = massNumber;
    }

    public Isotope(int atomicNumber, String elementSymbol, double exactMass, double abundance) {
        super(elementSymbol, atomicNumber);
        this.exactMass = exactMass;
        this.naturalAbundance = abundance;
    }

    public Isotope(String elementSymbol, int massNumber) {
        super(elementSymbol);
        this.massNumber = massNumber;
    }

    public void setNaturalAbundance(double naturalAbundance) {
        this.naturalAbundance = naturalAbundance;
        this.notifyChanged();
    }

    public void setExactMass(double exactMass) {
        this.exactMass = exactMass;
        this.notifyChanged();
    }

    public double getNaturalAbundance() {
        return this.naturalAbundance;
    }

    public double getExactMass() {
        return this.exactMass;
    }

    public int getMassNumber() {
        return this.massNumber;
    }

    public void setMassNumber(int massNumber) {
        this.massNumber = massNumber;
        this.notifyChanged();
    }

    public Object clone() {
        Object clone = null;
        try {
            clone = super.clone();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return clone;
    }

    public String toString() {
        StringBuffer resultString = new StringBuffer();
        resultString.append("Isotope(");
        resultString.append(this.massNumber);
        resultString.append(", EM:");
        resultString.append(this.exactMass);
        resultString.append(", AB:");
        resultString.append(this.naturalAbundance);
        resultString.append(", ");
        resultString.append(super.toString());
        resultString.append(")");
        return resultString.toString();
    }

    public boolean compare(Object object) {
        if (!(object instanceof Isotope)) {
            return false;
        }
        if (!super.compare(object)) {
            return false;
        }
        Isotope isotope = (Isotope)object;
        return this.massNumber == isotope.massNumber && this.exactMass == isotope.exactMass && this.naturalAbundance == isotope.naturalAbundance;
    }
}

