/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk;

import java.io.Serializable;
import org.openscience.cdk.ChemObject;

public class Element
extends ChemObject
implements Serializable,
org.openscience.cdk.interfaces.Element {
    private static final long serialVersionUID = 3062529834691231436L;
    protected String symbol = null;
    protected int atomicNumber = 0;

    public Element() {
    }

    public Element(String symbol) {
        this();
        this.symbol = symbol;
    }

    public Element(String symbol, int atomicNumber) {
        this(symbol);
        this.atomicNumber = atomicNumber;
    }

    public int getAtomicNumber() {
        return this.atomicNumber;
    }

    public void setAtomicNumber(int atomicNumber) {
        this.atomicNumber = atomicNumber;
        this.notifyChanged();
    }

    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
        this.notifyChanged();
    }

    public Object clone() {
        Object clone = null;
        try {
            clone = super.clone();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return clone;
    }

    public String toString() {
        StringBuffer resultString = new StringBuffer();
        resultString.append("Element(");
        resultString.append(this.getSymbol());
        resultString.append(", ID:");
        resultString.append(this.getID());
        resultString.append(", AN:");
        resultString.append(this.getAtomicNumber());
        resultString.append(")");
        return resultString.toString();
    }

    public boolean compare(Object object) {
        if (!(object instanceof Element)) {
            return false;
        }
        if (!super.compare(object)) {
            return false;
        }
        Element elem = (Element)object;
        return this.atomicNumber == elem.atomicNumber && this.symbol == elem.symbol;
    }
}

