/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk;

import java.io.Serializable;
import javax.vecmath.Vector3d;
import org.openscience.cdk.Atom;
import org.openscience.cdk.interfaces.AtomContainer;

public class Crystal
extends org.openscience.cdk.AtomContainer
implements Serializable,
org.openscience.cdk.interfaces.Crystal {
    private static final long serialVersionUID = 5919649450390509278L;
    private Vector3d aAxis;
    private Vector3d bAxis;
    private Vector3d cAxis;
    private int zValue = 1;
    private String spaceGroup = "P1";

    public Crystal() {
        this.setZeroAxes();
    }

    public Crystal(AtomContainer container) {
        this();
        this.add(container);
    }

    public void add(AtomContainer container) {
        super.add(container);
    }

    public void addAtom(Atom atom) {
        super.addAtom(atom);
    }

    public void setA(Vector3d newAxis) {
        this.aAxis = newAxis;
        this.notifyChanged();
    }

    public Vector3d getA() {
        return this.aAxis;
    }

    public void setB(Vector3d newAxis) {
        this.bAxis = newAxis;
        this.notifyChanged();
    }

    public Vector3d getB() {
        return this.bAxis;
    }

    public void setC(Vector3d newAxis) {
        this.cAxis = newAxis;
        this.notifyChanged();
    }

    public Vector3d getC() {
        return this.cAxis;
    }

    public String getSpaceGroup() {
        return this.spaceGroup;
    }

    public void setSpaceGroup(String group) {
        this.spaceGroup = group;
        this.notifyChanged();
    }

    public int getZ() {
        return this.zValue;
    }

    public void setZ(int value) {
        this.zValue = value;
        this.notifyChanged();
    }

    public Object clone() {
        Crystal clone = null;
        try {
            clone = (Crystal)super.clone();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        clone.setA(new Vector3d(this.aAxis));
        clone.setB(new Vector3d(this.bAxis));
        clone.setC(new Vector3d(this.cAxis));
        return clone;
    }

    public String toString() {
        StringBuffer resultString = new StringBuffer();
        resultString.append("Crystal{");
        resultString.append("SG=").append(this.getSpaceGroup()).append(", ");
        resultString.append("Z=").append(this.getZ()).append(", ");
        resultString.append("a=(").append(this.aAxis.x).append(", ").append(this.aAxis.y).append(", ").append(this.aAxis.z).append("), ");
        resultString.append("b=(").append(this.bAxis.x).append(", ").append(this.bAxis.y).append(", ").append(this.bAxis.z).append("), ");
        resultString.append("c=(").append(this.cAxis.x).append(", ").append(this.cAxis.y).append(", ").append(this.cAxis.z).append("), ");
        resultString.append("#A=").append(this.getAtomCount()).append("}");
        return resultString.toString();
    }

    private void setZeroAxes() {
        this.aAxis = new Vector3d(0.0, 0.0, 0.0);
        this.bAxis = new Vector3d(0.0, 0.0, 0.0);
        this.cAxis = new Vector3d(0.0, 0.0, 0.0);
        this.notifyChanged();
    }
}

