/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk;

import java.io.Serializable;
import org.openscience.cdk.ChemObject;
import org.openscience.cdk.interfaces.ChemModel;
import org.openscience.cdk.interfaces.ChemObjectChangeEvent;
import org.openscience.cdk.interfaces.ChemObjectListener;

public class ChemSequence
extends ChemObject
implements Serializable,
org.openscience.cdk.interfaces.ChemSequence,
ChemObjectListener {
    private static final long serialVersionUID = 2199218627455492000L;
    protected ChemModel[] chemModels = new org.openscience.cdk.ChemModel[this.growArraySize];
    protected int chemModelCount = 0;
    protected int growArraySize = 4;

    public void addChemModel(ChemModel chemModel) {
        if (this.chemModelCount + 1 >= this.chemModels.length) {
            this.growChemModelArray();
        }
        this.chemModels[this.chemModelCount] = chemModel;
        ++this.chemModelCount;
        chemModel.addListener(this);
        this.notifyChanged();
    }

    public ChemModel[] getChemModels() {
        ChemModel[] returnModels = new org.openscience.cdk.ChemModel[this.getChemModelCount()];
        System.arraycopy(this.chemModels, 0, returnModels, 0, returnModels.length);
        return returnModels;
    }

    public ChemModel getChemModel(int number) {
        return this.chemModels[number];
    }

    protected void growChemModelArray() {
        org.openscience.cdk.ChemModel[] newchemModels = new org.openscience.cdk.ChemModel[this.chemModels.length + this.growArraySize];
        System.arraycopy(this.chemModels, 0, newchemModels, 0, this.chemModels.length);
        this.chemModels = newchemModels;
    }

    public int getChemModelCount() {
        return this.chemModelCount;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("ChemSequence(#M=");
        ChemModel[] models = this.getChemModels();
        buffer.append(models.length);
        buffer.append(", ");
        for (int i = 0; i < models.length; ++i) {
            ChemModel model = models[i];
            buffer.append(model.toString());
        }
        buffer.append(")");
        return buffer.toString();
    }

    public Object clone() {
        ChemSequence clone = (ChemSequence)super.clone();
        clone.chemModelCount = this.getChemModelCount();
        clone.chemModels = new org.openscience.cdk.ChemModel[clone.chemModelCount];
        for (int f = 0; f < clone.chemModelCount; ++f) {
            clone.chemModels[f] = (org.openscience.cdk.ChemModel)((org.openscience.cdk.ChemModel)this.chemModels[f]).clone();
        }
        return clone;
    }

    public void stateChanged(ChemObjectChangeEvent event) {
        this.notifyChanged(event);
    }
}

