/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.openscience.cdk.DefaultChemObjectBuilder;
import org.openscience.cdk.interfaces.ChemObjectBuilder;
import org.openscience.cdk.interfaces.ChemObjectChangeEvent;
import org.openscience.cdk.interfaces.ChemObjectListener;

public class ChemObject
implements Serializable,
org.openscience.cdk.interfaces.ChemObject {
    private static final long serialVersionUID = 2798134548764323328L;
    private Vector chemObjectListeners = null;
    private Hashtable properties = null;
    private boolean[] flags = new boolean[6];
    private String identifier = null;

    private Vector lazyChemObjectListeners() {
        if (this.chemObjectListeners == null) {
            this.chemObjectListeners = new Vector();
        }
        return this.chemObjectListeners;
    }

    public void addListener(ChemObjectListener col) {
        Vector listeners = this.lazyChemObjectListeners();
        if (!listeners.contains(col)) {
            listeners.addElement(col);
        }
    }

    public int getListenerCount() {
        if (this.chemObjectListeners == null) {
            return 0;
        }
        return this.lazyChemObjectListeners().size();
    }

    public void removeListener(ChemObjectListener col) {
        if (this.chemObjectListeners == null) {
            return;
        }
        Vector listeners = this.lazyChemObjectListeners();
        if (listeners.contains(col)) {
            listeners.removeElement(col);
        }
    }

    public void notifyChanged() {
        if (this.getListenerCount() > 0) {
            Vector listeners = this.lazyChemObjectListeners();
            for (int f = 0; f < listeners.size(); ++f) {
                ((ChemObjectListener)listeners.elementAt(f)).stateChanged(new org.openscience.cdk.event.ChemObjectChangeEvent(this));
            }
        }
    }

    public void notifyChanged(ChemObjectChangeEvent evt) {
        if (this.getListenerCount() > 0) {
            Vector listeners = this.lazyChemObjectListeners();
            for (int f = 0; f < listeners.size(); ++f) {
                ((ChemObjectListener)listeners.elementAt(f)).stateChanged(evt);
            }
        }
    }

    private Hashtable lazyProperties() {
        if (this.properties == null) {
            this.properties = new Hashtable();
        }
        return this.properties;
    }

    public void setProperty(Object description, Object property) {
        this.lazyProperties().put(description, property);
        this.notifyChanged();
    }

    public void removeProperty(Object description) {
        if (this.properties == null) {
            return;
        }
        this.lazyProperties().remove(description);
    }

    public Object getProperty(Object description) {
        if (this.properties != null) {
            return this.lazyProperties().get(description);
        }
        return null;
    }

    public Hashtable getProperties() {
        return this.lazyProperties();
    }

    public Object clone() {
        Object clone = null;
        try {
            clone = super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace(System.err);
        }
        ((ChemObject)clone).flags = new boolean[6];
        for (int f = 0; f < this.flags.length; ++f) {
            ((ChemObject)clone).flags[f] = this.flags[f];
        }
        if (this.properties != null) {
            Hashtable clonedHashtable = new Hashtable();
            Enumeration keys = this.properties.keys();
            while (keys.hasMoreElements()) {
                Object value;
                Object key = keys.nextElement();
                if (key instanceof ChemObject) {
                    key = ((ChemObject)key).clone();
                }
                if ((value = this.properties.get(key)) instanceof ChemObject) {
                    value = ((ChemObject)value).clone();
                }
                clonedHashtable.put(key, value);
            }
            ((ChemObject)clone).properties = clonedHashtable;
        }
        ((ChemObject)clone).chemObjectListeners = null;
        return clone;
    }

    public boolean compare(Object object) {
        if (!(object instanceof ChemObject)) {
            return false;
        }
        ChemObject chemObj = (ChemObject)object;
        return this.identifier == chemObj.identifier;
    }

    public String getID() {
        return this.identifier;
    }

    public void setID(String identifier) {
        this.identifier = identifier;
        this.notifyChanged();
    }

    public void setFlag(int flag_type, boolean flag_value) {
        this.flags[flag_type] = flag_value;
        this.notifyChanged();
    }

    public boolean getFlag(int flag_type) {
        return this.flags[flag_type];
    }

    public void setProperties(Hashtable properties) {
        Enumeration keys = properties.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            this.lazyProperties().put(key, properties.get(key));
        }
        this.notifyChanged();
    }

    public void setFlags(boolean[] flagsNew) {
        this.flags = flagsNew;
    }

    public boolean[] getFlags() {
        return this.flags;
    }

    public Object shallowCopy() {
        Object copy = null;
        try {
            copy = super.clone();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return copy;
    }

    public ChemObjectBuilder getBuilder() {
        return DefaultChemObjectBuilder.getInstance();
    }
}

