/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk;

import java.io.Serializable;
import java.util.Vector;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import org.openscience.cdk.ElectronContainer;
import org.openscience.cdk.interfaces.Atom;

public class Bond
extends ElectronContainer
implements Serializable,
org.openscience.cdk.interfaces.Bond {
    private static final long serialVersionUID = 7057060562283387384L;
    protected double order;
    protected int atomCount = 2;
    protected Atom[] atoms = new org.openscience.cdk.Atom[2];
    protected int stereo;

    public Bond() {
        this(null, null, 0.0, 0);
    }

    public Bond(Atom atom1, Atom atom2) {
        this(atom1, atom2, 1.0, 0);
    }

    public Bond(Atom atom1, Atom atom2, double order) {
        this(atom1, atom2, order, 0);
    }

    public Bond(Atom atom1, Atom atom2, double order, int stereo) {
        this.setAtomAt(atom1, 0);
        this.setAtomAt(atom2, 1);
        this.setOrder(order);
        this.setStereo(stereo);
    }

    public Atom[] getAtoms() {
        Atom[] returnAtoms = new org.openscience.cdk.Atom[this.getAtomCount()];
        System.arraycopy(this.atoms, 0, returnAtoms, 0, returnAtoms.length);
        return returnAtoms;
    }

    public Vector getAtomsVector() {
        Vector<Atom> atomsVector = new Vector<Atom>();
        for (int f = 0; f < this.getAtomCount(); ++f) {
            atomsVector.addElement(this.getAtomAt(f));
        }
        return atomsVector;
    }

    public void setAtoms(Atom[] atoms) {
        this.atoms = atoms;
        this.notifyChanged();
    }

    public int getAtomCount() {
        return this.atomCount;
    }

    public Atom getAtomAt(int position) {
        return (org.openscience.cdk.Atom)this.atoms[position];
    }

    public Atom getConnectedAtom(Atom atom) {
        if (this.atoms[0] == atom) {
            return (org.openscience.cdk.Atom)this.atoms[1];
        }
        if (this.atoms[1] == atom) {
            return (org.openscience.cdk.Atom)this.atoms[0];
        }
        return null;
    }

    public boolean contains(Atom atom) {
        if (this.atoms[0] == atom) {
            return true;
        }
        return this.atoms[1] == atom;
    }

    public void setAtomAt(Atom atom, int position) {
        this.atoms[position] = atom;
        this.notifyChanged();
    }

    public double getOrder() {
        return this.order;
    }

    public void setOrder(double order) {
        this.order = order;
        this.notifyChanged();
    }

    public int getStereo() {
        return this.stereo;
    }

    public void setStereo(int stereo) {
        this.stereo = stereo;
        this.notifyChanged();
    }

    public Point2d get2DCenter() {
        double xOfCenter = 0.0;
        double yOfCenter = 0.0;
        for (int f = 0; f < this.getAtomCount(); ++f) {
            xOfCenter += this.getAtomAt(f).getX2d();
            yOfCenter += this.getAtomAt(f).getY2d();
        }
        return new Point2d(xOfCenter / (double)this.getAtomCount(), yOfCenter / (double)this.getAtomCount());
    }

    public Point3d get3DCenter() {
        double xOfCenter = 0.0;
        double yOfCenter = 0.0;
        double zOfCenter = 0.0;
        for (int f = 0; f < this.getAtomCount(); ++f) {
            xOfCenter += this.getAtomAt(f).getX3d();
            yOfCenter += this.getAtomAt(f).getY3d();
            zOfCenter += this.getAtomAt(f).getZ3d();
        }
        return new Point3d(xOfCenter / (double)this.getAtomCount(), yOfCenter / (double)this.getAtomCount(), zOfCenter / (double)this.getAtomCount());
    }

    public boolean compare(Object object) {
        if (object instanceof org.openscience.cdk.interfaces.Bond) {
            Bond bond = (Bond)object;
            for (int i = 0; i < this.atoms.length; ++i) {
                if (bond.contains(this.atoms[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isConnectedTo(org.openscience.cdk.interfaces.Bond bond) {
        for (int f = 0; f < this.getAtomCount(); ++f) {
            if (!bond.contains(this.getAtomAt(f))) continue;
            return true;
        }
        return false;
    }

    public Object clone() {
        Bond clone = null;
        try {
            clone = (Bond)super.clone();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        if (this.atoms != null) {
            clone.atoms = new org.openscience.cdk.Atom[this.atoms.length];
            for (int f = 0; f < this.atoms.length; ++f) {
                if (this.atoms[f] == null) continue;
                clone.atoms[f] = (org.openscience.cdk.Atom)((org.openscience.cdk.Atom)this.atoms[f]).clone();
            }
        }
        return clone;
    }

    public String toString() {
        StringBuffer resultString = new StringBuffer();
        resultString.append("Bond(");
        resultString.append(this.hashCode());
        resultString.append(", #O:").append(this.getOrder());
        resultString.append(", #S:").append(this.getStereo());
        Atom[] atoms = this.getAtoms();
        resultString.append(", #A:").append(atoms.length);
        for (int i = 0; i < atoms.length; ++i) {
            if (atoms[i] == null) {
                resultString.append(", null");
                continue;
            }
            resultString.append(", ").append(atoms[i].toString());
        }
        resultString.append(")");
        return resultString.toString();
    }
}

