/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk;

import java.io.Serializable;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import org.openscience.cdk.Monomer;
import org.openscience.cdk.Polymer;
import org.openscience.cdk.interfaces.Atom;
import org.openscience.cdk.interfaces.AtomContainer;
import org.openscience.cdk.interfaces.Strand;

public class BioPolymer
extends Polymer
implements Serializable,
org.openscience.cdk.interfaces.BioPolymer {
    private static final long serialVersionUID = -5001873073769634393L;
    private Hashtable strands = new Hashtable();

    public void addAtom(org.openscience.cdk.Atom oAtom) {
        super.addAtom(oAtom);
    }

    public void addAtom(Atom oAtom, Strand oStrand) {
        if (!this.contains(oAtom)) {
            super.addAtom(oAtom);
            if (oStrand != null) {
                oStrand.addAtom(oAtom);
                if (!this.strands.contains(oStrand.getStrandName())) {
                    this.strands.put(oStrand.getStrandName(), oStrand);
                }
            }
        }
    }

    public void addAtom(Atom oAtom, org.openscience.cdk.interfaces.Monomer oMonomer, Strand oStrand) {
        if (!this.contains(oAtom)) {
            super.addAtom(oAtom);
            if (oStrand != null) {
                oStrand.addAtom(oAtom, oMonomer);
                if (!this.strands.containsKey(oStrand.getStrandName())) {
                    this.strands.put(oStrand.getStrandName(), oStrand);
                }
            }
        }
    }

    public int getMonomerCount() {
        Enumeration keys = this.strands.keys();
        int number = 0;
        while (keys.hasMoreElements()) {
            org.openscience.cdk.Strand tmp = (org.openscience.cdk.Strand)this.strands.get(keys.nextElement());
            number += tmp.getMonomers().size() - 1;
        }
        return number;
    }

    public org.openscience.cdk.interfaces.Monomer getMonomer(String monName, String strandName) {
        org.openscience.cdk.Strand strand = (org.openscience.cdk.Strand)this.strands.get(strandName);
        if (strand != null) {
            return (Monomer)strand.getMonomer(monName);
        }
        return null;
    }

    public Collection getMonomerNames() {
        Enumeration keys = this.strands.keys();
        Hashtable monomers = new Hashtable();
        while (keys.hasMoreElements()) {
            org.openscience.cdk.Strand oStrand = (org.openscience.cdk.Strand)this.strands.get(keys.nextElement());
            monomers.putAll(oStrand.getMonomers());
        }
        return monomers.keySet();
    }

    public int getStrandCount() {
        return this.strands.size();
    }

    public Strand getStrand(String cName) {
        return (org.openscience.cdk.Strand)this.strands.get(cName);
    }

    public Collection getStrandNames() {
        return this.strands.keySet();
    }

    public void removeStrand(String name) {
        if (this.strands.containsKey(name)) {
            org.openscience.cdk.Strand strand = (org.openscience.cdk.Strand)this.strands.get(name);
            this.remove((AtomContainer)strand);
            this.strands.remove(name);
        }
    }

    public Hashtable getStrands() {
        return this.strands;
    }

    public String toString() {
        StringBuffer stringContent = new StringBuffer();
        stringContent.append("BioPolymer(");
        stringContent.append(this.hashCode()).append(", ");
        stringContent.append(super.toString());
        stringContent.append(")");
        return stringContent.toString();
    }
}

