/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk;

import java.io.Serializable;
import org.openscience.cdk.Isotope;

public class AtomType
extends Isotope
implements Serializable,
org.openscience.cdk.interfaces.AtomType {
    private static final long serialVersionUID = -7950397716808229972L;
    double maxBondOrder;
    double bondOrderSum;
    double vanderwaalsRadius;
    double covalentRadius;
    protected int formalCharge;
    protected int hybridization;
    protected int electronValency;
    protected int formalNeighbourCount;
    protected boolean acceptor = false;
    protected boolean donor = false;
    protected int chemicalGroupConstant = 0;
    protected int ringSize = 0;
    protected boolean isAromatic = false;
    protected String sphericalMatcher = null;

    public AtomType(String elementSymbol) {
        super(elementSymbol);
    }

    public AtomType(String identifier, String elementSymbol) {
        this(elementSymbol);
        this.setAtomTypeName(identifier);
    }

    public void setAtomTypeName(String identifier) {
        this.setID(identifier);
        this.notifyChanged();
    }

    public void setMaxBondOrder(double maxBondOrder) {
        this.maxBondOrder = maxBondOrder;
        this.notifyChanged();
    }

    public void setBondOrderSum(double bondOrderSum) {
        this.bondOrderSum = bondOrderSum;
        this.notifyChanged();
    }

    public String getAtomTypeName() {
        return this.getID();
    }

    public double getMaxBondOrder() {
        return this.maxBondOrder;
    }

    public double getBondOrderSum() {
        return this.bondOrderSum;
    }

    public void setFormalCharge(int charge) {
        this.formalCharge = charge;
        this.notifyChanged();
    }

    public int getFormalCharge() {
        return this.formalCharge;
    }

    public void setFormalNeighbourCount(int count) {
        this.formalNeighbourCount = count;
        this.notifyChanged();
    }

    public int getFormalNeighbourCount() {
        return this.formalNeighbourCount;
    }

    public void setHybridization(int hybridization) {
        this.hybridization = hybridization;
        this.notifyChanged();
    }

    public int getHybridization() {
        return this.hybridization;
    }

    public boolean compare(Object object) {
        if (!(object instanceof AtomType)) {
            return false;
        }
        if (!super.compare(object)) {
            return false;
        }
        AtomType type = (AtomType)object;
        return this.getAtomTypeName() == type.getAtomTypeName() && this.maxBondOrder == type.maxBondOrder && this.bondOrderSum == type.bondOrderSum;
    }

    public void setVanderwaalsRadius(double radius) {
        this.vanderwaalsRadius = radius;
        this.notifyChanged();
    }

    public double getVanderwaalsRadius() {
        return this.vanderwaalsRadius;
    }

    public void setCovalentRadius(double radius) {
        this.covalentRadius = radius;
        this.notifyChanged();
    }

    public double getCovalentRadius() {
        return this.covalentRadius;
    }

    public void setValency(int valency) {
        this.electronValency = valency;
        this.notifyChanged();
    }

    public int getValency() {
        return this.electronValency;
    }

    public void setAcceptor(boolean isAcceptor) {
        this.acceptor = isAcceptor;
        this.notifyChanged();
    }

    public boolean getAcceptor() {
        return this.acceptor;
    }

    public void setDonor(boolean isDonor) {
        this.donor = isDonor;
        this.notifyChanged();
    }

    public boolean getDonor() {
        return this.donor;
    }

    public void setChemicalGroupConstant(int chemicalGroupCDKConstant) {
        this.chemicalGroupConstant = chemicalGroupCDKConstant;
        this.notifyChanged();
    }

    public int getChemicalGroupConstant() {
        return this.chemicalGroupConstant;
    }

    public void setRingSize(int sizeOfRingSystem) {
        this.ringSize = sizeOfRingSystem;
        this.notifyChanged();
    }

    public int getRingSize() {
        return this.ringSize;
    }

    public void setIsAromatic(boolean ISAROMATIC) {
        this.isAromatic = ISAROMATIC;
        this.notifyChanged();
    }

    public boolean getIsAromatic() {
        return this.isAromatic;
    }

    public void setSphericalMatcher(String description) {
        this.sphericalMatcher = description;
        this.notifyChanged();
    }

    public String getSphericalMatcher() {
        return this.sphericalMatcher;
    }

    public String toString() {
        StringBuffer resultString = new StringBuffer();
        resultString.append("AtomType(");
        resultString.append(this.getAtomTypeName()).append(", ");
        resultString.append("MBO:").append(this.getMaxBondOrder()).append(", ");
        resultString.append("BOS:").append(this.getBondOrderSum()).append(", ");
        resultString.append("FC:").append(this.getFormalCharge()).append(", ");
        resultString.append("H:").append(this.getHybridization()).append(", ");
        resultString.append("NC:").append(this.getFormalNeighbourCount()).append(", ");
        resultString.append("CR:").append(this.getCovalentRadius()).append(", ");
        resultString.append("VDWR:").append(this.getVanderwaalsRadius()).append(", ");
        resultString.append("EV:").append(this.getValency()).append(", ");
        resultString.append("A:").append(this.getAcceptor()).append(", ");
        resultString.append("D:").append(this.getDonor()).append(", ");
        resultString.append("ChemicalGroupCode:").append(this.getChemicalGroupConstant()).append(", ");
        resultString.append("RingSize:").append(this.getRingSize()).append(", ");
        resultString.append("Aromatic:").append(this.getIsAromatic()).append(", ");
        resultString.append("SphericalDescriptor:").append(this.getSphericalMatcher()).append(", ");
        resultString.append(super.toString());
        resultString.append(")");
        return resultString.toString();
    }
}

