/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.openscience.cdk.Atom;
import org.openscience.cdk.AtomEnumeration;
import org.openscience.cdk.Bond;
import org.openscience.cdk.ChemObject;
import org.openscience.cdk.ElectronContainer;
import org.openscience.cdk.interfaces.AtomParity;
import org.openscience.cdk.interfaces.ChemObjectChangeEvent;
import org.openscience.cdk.interfaces.ChemObjectListener;
import org.openscience.cdk.interfaces.LonePair;
import org.openscience.cdk.interfaces.SingleElectron;

public class AtomContainer
extends ChemObject
implements Serializable,
org.openscience.cdk.interfaces.AtomContainer,
ChemObjectListener {
    private static final long serialVersionUID = 5678100348445919254L;
    protected int atomCount = 0;
    protected int electronContainerCount = 0;
    protected int growArraySize = 10;
    protected org.openscience.cdk.interfaces.Atom[] atoms;
    protected org.openscience.cdk.interfaces.ElectronContainer[] electronContainers;
    protected Hashtable atomParities;

    public AtomContainer() {
        this(10, 10);
    }

    public AtomContainer(org.openscience.cdk.interfaces.AtomContainer container) {
        this();
        this.add(container);
    }

    public AtomContainer(int atomCount, int electronContainerCount) {
        this.atoms = new Atom[atomCount];
        this.electronContainers = new ElectronContainer[electronContainerCount];
        this.atomParities = new Hashtable(atomCount / 2);
    }

    public void addAtomParity(AtomParity parity) {
        this.atomParities.put(parity.getAtom(), parity);
    }

    public AtomParity getAtomParity(org.openscience.cdk.interfaces.Atom atom) {
        return (org.openscience.cdk.AtomParity)this.atomParities.get(atom);
    }

    public void setAtoms(org.openscience.cdk.interfaces.Atom[] atoms) {
        this.atoms = atoms;
        for (int f = 0; f < atoms.length; ++f) {
            atoms[f].addListener(this);
        }
        this.setAtomCount(atoms.length);
        this.notifyChanged();
    }

    public void setElectronContainers(org.openscience.cdk.interfaces.ElectronContainer[] electronContainers) {
        this.electronContainers = electronContainers;
        for (int f = 0; f < electronContainers.length; ++f) {
            electronContainers[f].addListener(this);
        }
        this.setElectronContainerCount(electronContainers.length);
        this.notifyChanged();
    }

    public void setAtomAt(int number, org.openscience.cdk.interfaces.Atom atom) {
        atom.addListener(this);
        this.atoms[number] = atom;
        this.notifyChanged();
    }

    public org.openscience.cdk.interfaces.Atom getAtomAt(int number) {
        return this.atoms[number];
    }

    public org.openscience.cdk.interfaces.Bond getBondAt(int number) {
        return this.getBonds()[number];
    }

    public void setElectronContainerAt(int number, org.openscience.cdk.interfaces.ElectronContainer electronContainer) {
        electronContainer.addListener(this);
        this.electronContainers[number] = electronContainer;
        this.notifyChanged();
    }

    public void setElectronContainerCount(int electronContainerCount) {
        this.electronContainerCount = electronContainerCount;
        this.notifyChanged();
    }

    public void setAtomCount(int atomCount) {
        this.atomCount = atomCount;
        this.notifyChanged();
    }

    public org.openscience.cdk.interfaces.Atom[] getAtoms() {
        org.openscience.cdk.interfaces.Atom[] returnAtoms = new Atom[this.getAtomCount()];
        System.arraycopy(this.atoms, 0, returnAtoms, 0, returnAtoms.length);
        return returnAtoms;
    }

    public Enumeration atoms() {
        return new AtomEnumeration(this);
    }

    public org.openscience.cdk.interfaces.ElectronContainer[] getElectronContainers() {
        org.openscience.cdk.interfaces.ElectronContainer[] returnElectronContainers = new ElectronContainer[this.getElectronContainerCount()];
        System.arraycopy(this.electronContainers, 0, returnElectronContainers, 0, returnElectronContainers.length);
        return returnElectronContainers;
    }

    public org.openscience.cdk.interfaces.Bond[] getBonds() {
        int bondCount = this.getBondCount();
        org.openscience.cdk.interfaces.Bond[] result = new Bond[bondCount];
        int bondCounter = 0;
        for (int i = 0; i < this.getElectronContainerCount(); ++i) {
            org.openscience.cdk.interfaces.ElectronContainer electronContainer = this.getElectronContainerAt(i);
            if (!(electronContainer instanceof org.openscience.cdk.interfaces.Bond)) continue;
            result[bondCounter] = (Bond)electronContainer;
            ++bondCounter;
        }
        return result;
    }

    public LonePair[] getLonePairs() {
        int count = this.getLonePairCount();
        LonePair[] result = new org.openscience.cdk.LonePair[count];
        int counter = 0;
        for (int i = 0; i < this.getElectronContainerCount(); ++i) {
            org.openscience.cdk.interfaces.ElectronContainer electronContainer = this.getElectronContainerAt(i);
            if (!(electronContainer instanceof org.openscience.cdk.LonePair)) continue;
            result[counter] = (org.openscience.cdk.LonePair)electronContainer;
            ++counter;
        }
        return result;
    }

    public LonePair[] getLonePairs(org.openscience.cdk.interfaces.Atom atom) {
        Vector<org.openscience.cdk.interfaces.ElectronContainer> lps = new Vector<org.openscience.cdk.interfaces.ElectronContainer>();
        for (int i = 0; i < this.getElectronContainerCount(); ++i) {
            org.openscience.cdk.interfaces.ElectronContainer electronContainer = this.getElectronContainerAt(i);
            if (!(electronContainer instanceof org.openscience.cdk.LonePair) || !((org.openscience.cdk.LonePair)electronContainer).contains((Atom)atom)) continue;
            lps.add(electronContainer);
        }
        Object[] result = new org.openscience.cdk.LonePair[lps.size()];
        lps.copyInto(result);
        return result;
    }

    public org.openscience.cdk.interfaces.Atom getFirstAtom() {
        return (Atom)this.atoms[0];
    }

    public org.openscience.cdk.interfaces.Atom getLastAtom() {
        return (Atom)this.atoms[this.getAtomCount() - 1];
    }

    public int getAtomNumber(org.openscience.cdk.interfaces.Atom atom) {
        for (int f = 0; f < this.getAtomCount(); ++f) {
            if (this.getAtomAt(f) != atom) continue;
            return f;
        }
        return -1;
    }

    public int getBondNumber(org.openscience.cdk.interfaces.Atom atom1, org.openscience.cdk.interfaces.Atom atom2) {
        return this.getBondNumber(this.getBond(atom1, atom2));
    }

    public int getBondNumber(org.openscience.cdk.interfaces.Bond bond) {
        for (int f = 0; f < this.getElectronContainerCount(); ++f) {
            if (this.getElectronContainerAt(f) != bond) continue;
            return f;
        }
        return -1;
    }

    public org.openscience.cdk.interfaces.ElectronContainer getElectronContainerAt(int number) {
        return (ElectronContainer)this.electronContainers[number];
    }

    public org.openscience.cdk.interfaces.Bond getBond(org.openscience.cdk.interfaces.Atom atom1, org.openscience.cdk.interfaces.Atom atom2) {
        for (int i = 0; i < this.getElectronContainerCount(); ++i) {
            if (!(this.electronContainers[i] instanceof org.openscience.cdk.interfaces.Bond) || !((Bond)this.electronContainers[i]).contains(atom1) || !(this.electronContainers[i] instanceof org.openscience.cdk.interfaces.Bond) || ((Bond)this.electronContainers[i]).getConnectedAtom(atom1) != atom2) continue;
            return (Bond)this.electronContainers[i];
        }
        return null;
    }

    public org.openscience.cdk.interfaces.Atom[] getConnectedAtoms(org.openscience.cdk.interfaces.Atom atom) {
        Vector atomsVec = this.getConnectedAtomsVector(atom);
        Object[] conAtoms = new Atom[atomsVec.size()];
        atomsVec.copyInto(conAtoms);
        return conAtoms;
    }

    public Vector getConnectedAtomsVector(org.openscience.cdk.interfaces.Atom atom) {
        Vector<org.openscience.cdk.interfaces.Atom> atomsVec = new Vector<org.openscience.cdk.interfaces.Atom>();
        for (int i = 0; i < this.electronContainerCount; ++i) {
            ElectronContainer electronContainer = (ElectronContainer)this.electronContainers[i];
            if (!(electronContainer instanceof org.openscience.cdk.interfaces.Bond) || !((Bond)electronContainer).contains(atom)) continue;
            atomsVec.addElement(((Bond)electronContainer).getConnectedAtom(atom));
        }
        return atomsVec;
    }

    public org.openscience.cdk.interfaces.Bond[] getConnectedBonds(org.openscience.cdk.interfaces.Atom atom) {
        Vector bondsVec = this.getConnectedBondsVector(atom);
        Object[] conBonds = new Bond[bondsVec.size()];
        bondsVec.copyInto(conBonds);
        return conBonds;
    }

    public Vector getConnectedBondsVector(org.openscience.cdk.interfaces.Atom atom) {
        Vector<org.openscience.cdk.interfaces.ElectronContainer> bondsVec = new Vector<org.openscience.cdk.interfaces.ElectronContainer>();
        for (int i = 0; i < this.electronContainerCount; ++i) {
            if (!(this.electronContainers[i] instanceof org.openscience.cdk.interfaces.Bond) || !((Bond)this.electronContainers[i]).contains(atom)) continue;
            bondsVec.addElement(this.electronContainers[i]);
        }
        return bondsVec;
    }

    public org.openscience.cdk.interfaces.ElectronContainer[] getConnectedElectronContainers(org.openscience.cdk.interfaces.Atom atom) {
        Vector<org.openscience.cdk.interfaces.ElectronContainer> bondsVec = new Vector<org.openscience.cdk.interfaces.ElectronContainer>();
        for (int i = 0; i < this.electronContainerCount; ++i) {
            if (this.electronContainers[i] instanceof org.openscience.cdk.interfaces.Bond && ((Bond)this.electronContainers[i]).contains(atom)) {
                bondsVec.addElement(this.electronContainers[i]);
                continue;
            }
            if (this.electronContainers[i] instanceof org.openscience.cdk.LonePair && ((org.openscience.cdk.LonePair)this.electronContainers[i]).contains((Atom)atom)) {
                bondsVec.addElement(this.electronContainers[i]);
                continue;
            }
            if (!(this.electronContainers[i] instanceof org.openscience.cdk.SingleElectron) || !((org.openscience.cdk.SingleElectron)this.electronContainers[i]).contains((Atom)atom)) continue;
            bondsVec.addElement(this.electronContainers[i]);
        }
        Object[] cons = new ElectronContainer[bondsVec.size()];
        bondsVec.copyInto(cons);
        return cons;
    }

    public int getBondCount(int atomnumber) {
        return this.getBondCount(this.getAtomAt(atomnumber));
    }

    public int getAtomCount() {
        return this.atomCount;
    }

    public int getElectronContainerCount() {
        return this.electronContainerCount;
    }

    public int getLonePairCount() {
        int count = 0;
        for (int i = 0; i < this.electronContainerCount; ++i) {
            if (!(this.electronContainers[i] instanceof org.openscience.cdk.LonePair)) continue;
            ++count;
        }
        return count;
    }

    public int getBondCount() {
        int bondCount = 0;
        for (int i = 0; i < this.electronContainerCount; ++i) {
            if (!(this.electronContainers[i] instanceof org.openscience.cdk.interfaces.Bond)) continue;
            ++bondCount;
        }
        return bondCount;
    }

    public int getBondCount(org.openscience.cdk.interfaces.Atom atom) {
        int count = 0;
        for (int i = 0; i < this.getElectronContainerCount(); ++i) {
            if (!(this.electronContainers[i] instanceof org.openscience.cdk.interfaces.Bond) || !((Bond)this.electronContainers[i]).contains(atom)) continue;
            ++count;
        }
        return count;
    }

    public int getLonePairCount(org.openscience.cdk.interfaces.Atom atom) {
        int count = 0;
        for (int i = 0; i < this.getElectronContainerCount(); ++i) {
            if (!(this.electronContainers[i] instanceof org.openscience.cdk.LonePair) || !((org.openscience.cdk.LonePair)this.electronContainers[i]).contains((Atom)atom)) continue;
            ++count;
        }
        return count;
    }

    public SingleElectron[] getSingleElectron(org.openscience.cdk.interfaces.Atom atom) {
        Vector<org.openscience.cdk.interfaces.ElectronContainer> lps = new Vector<org.openscience.cdk.interfaces.ElectronContainer>();
        for (int i = 0; i < this.getElectronContainerCount(); ++i) {
            if (!(this.electronContainers[i] instanceof org.openscience.cdk.SingleElectron) || !((org.openscience.cdk.SingleElectron)this.electronContainers[i]).contains((Atom)atom)) continue;
            lps.add(this.electronContainers[i]);
        }
        Object[] result = new org.openscience.cdk.SingleElectron[lps.size()];
        lps.copyInto(result);
        return result;
    }

    public int getSingleElectronSum(org.openscience.cdk.interfaces.Atom atom) {
        int count = 0;
        for (int i = 0; i < this.getElectronContainerCount(); ++i) {
            if (!(this.electronContainers[i] instanceof org.openscience.cdk.SingleElectron) || !((org.openscience.cdk.SingleElectron)this.electronContainers[i]).contains((Atom)atom)) continue;
            ++count;
        }
        return count;
    }

    public double getBondOrderSum(org.openscience.cdk.interfaces.Atom atom) {
        double count = 0.0;
        for (int i = 0; i < this.getElectronContainerCount(); ++i) {
            if (!(this.electronContainers[i] instanceof org.openscience.cdk.interfaces.Bond) || !((Bond)this.electronContainers[i]).contains(atom)) continue;
            count += ((Bond)this.electronContainers[i]).getOrder();
        }
        return count;
    }

    public double getMaximumBondOrder(org.openscience.cdk.interfaces.Atom atom) {
        double max = 0.0;
        for (int i = 0; i < this.getElectronContainerCount(); ++i) {
            if (!(this.electronContainers[i] instanceof org.openscience.cdk.interfaces.Bond) || !((Bond)this.electronContainers[i]).contains(atom) || !(((Bond)this.electronContainers[i]).getOrder() > max)) continue;
            max = ((Bond)this.electronContainers[i]).getOrder();
        }
        return max;
    }

    public double getMinimumBondOrder(org.openscience.cdk.interfaces.Atom atom) {
        double min = 6.0;
        for (int i = 0; i < this.getElectronContainerCount(); ++i) {
            if (!(this.electronContainers[i] instanceof org.openscience.cdk.interfaces.Bond) || !((Bond)this.electronContainers[i]).contains(atom) || !(((Bond)this.electronContainers[i]).getOrder() < min)) continue;
            min = ((Bond)this.electronContainers[i]).getOrder();
        }
        return min;
    }

    public org.openscience.cdk.interfaces.AtomContainer getIntersection(org.openscience.cdk.interfaces.AtomContainer container) {
        int i;
        AtomContainer intersection = new AtomContainer();
        for (i = 0; i < this.getAtomCount(); ++i) {
            if (!container.contains(this.getAtomAt(i))) continue;
            intersection.addAtom(this.getAtomAt(i));
        }
        for (i = 0; i < this.getElectronContainerCount(); ++i) {
            if (!container.contains(this.getElectronContainerAt(i))) continue;
            intersection.addElectronContainer(this.getElectronContainerAt(i));
        }
        return intersection;
    }

    public void addElectronContainers(org.openscience.cdk.interfaces.AtomContainer atomContainer) {
        for (int f = 0; f < atomContainer.getElectronContainerCount(); ++f) {
            if (this.contains(atomContainer.getElectronContainerAt(f))) continue;
            this.addElectronContainer(atomContainer.getElectronContainerAt(f));
        }
        this.notifyChanged();
    }

    public void add(org.openscience.cdk.interfaces.AtomContainer atomContainer) {
        int f;
        for (f = 0; f < atomContainer.getAtomCount(); ++f) {
            if (this.contains(atomContainer.getAtomAt(f))) continue;
            this.addAtom(atomContainer.getAtomAt(f));
        }
        for (f = 0; f < atomContainer.getElectronContainerCount(); ++f) {
            if (this.contains(atomContainer.getElectronContainerAt(f))) continue;
            this.addElectronContainer(atomContainer.getElectronContainerAt(f));
        }
        this.notifyChanged();
    }

    public void addAtom(org.openscience.cdk.interfaces.Atom atom) {
        if (this.contains(atom)) {
            return;
        }
        if (this.atomCount + 1 >= this.atoms.length) {
            this.growAtomArray();
        }
        atom.addListener(this);
        this.atoms[this.atomCount] = atom;
        ++this.atomCount;
        this.notifyChanged();
    }

    public void addBond(org.openscience.cdk.interfaces.Bond bond) {
        this.addElectronContainer(bond);
        this.notifyChanged();
    }

    public void addElectronContainer(org.openscience.cdk.interfaces.ElectronContainer electronContainer) {
        if (this.electronContainerCount + 1 >= this.electronContainers.length) {
            this.growElectronContainerArray();
        }
        electronContainer.addListener(this);
        this.electronContainers[this.electronContainerCount] = electronContainer;
        ++this.electronContainerCount;
        this.notifyChanged();
    }

    public void remove(org.openscience.cdk.interfaces.AtomContainer atomContainer) {
        int f;
        for (f = 0; f < atomContainer.getAtomCount(); ++f) {
            this.removeAtom(atomContainer.getAtomAt(f));
        }
        for (f = 0; f < atomContainer.getElectronContainerCount(); ++f) {
            this.removeElectronContainer(atomContainer.getElectronContainerAt(f));
        }
        this.notifyChanged();
    }

    public org.openscience.cdk.interfaces.ElectronContainer removeElectronContainer(int position) {
        org.openscience.cdk.interfaces.ElectronContainer electronContainer = this.getElectronContainerAt(position);
        electronContainer.removeListener(this);
        for (int i = position; i < this.electronContainerCount - 1; ++i) {
            this.electronContainers[i] = this.electronContainers[i + 1];
        }
        this.electronContainers[this.electronContainerCount - 1] = null;
        --this.electronContainerCount;
        this.notifyChanged();
        return electronContainer;
    }

    public org.openscience.cdk.interfaces.ElectronContainer removeElectronContainer(org.openscience.cdk.interfaces.ElectronContainer electronContainer) {
        for (int i = this.getElectronContainerCount() - 1; i >= 0; --i) {
            if (!this.electronContainers[i].equals(electronContainer)) continue;
            return this.removeElectronContainer(i);
        }
        return null;
    }

    public org.openscience.cdk.interfaces.Bond removeBond(org.openscience.cdk.interfaces.Atom atom1, org.openscience.cdk.interfaces.Atom atom2) {
        for (int i = 0; i < this.getElectronContainerCount(); ++i) {
            if (!(this.electronContainers[i] instanceof org.openscience.cdk.interfaces.Bond) || !((Bond)this.electronContainers[i]).contains(atom1) || ((Bond)this.electronContainers[i]).getConnectedAtom(atom1) != atom2) continue;
            return (Bond)this.removeElectronContainer(this.electronContainers[i]);
        }
        return null;
    }

    public void removeAtom(int position) {
        this.atoms[position].removeListener(this);
        for (int i = position; i < this.atomCount - 1; ++i) {
            this.atoms[i] = this.atoms[i + 1];
        }
        this.atoms[this.atomCount - 1] = null;
        --this.atomCount;
        this.notifyChanged();
    }

    public void removeAtomAndConnectedElectronContainers(org.openscience.cdk.interfaces.Atom atom) {
        int position = this.getAtomNumber(atom);
        if (position != -1) {
            org.openscience.cdk.interfaces.ElectronContainer[] electronContainers = this.getConnectedElectronContainers(atom);
            for (int f = 0; f < electronContainers.length; ++f) {
                this.removeElectronContainer(electronContainers[f]);
            }
            this.removeAtom(position);
        }
        this.notifyChanged();
    }

    public void removeAtom(org.openscience.cdk.interfaces.Atom atom) {
        int position = this.getAtomNumber(atom);
        if (position != -1) {
            this.removeAtom(position);
        }
        this.notifyChanged();
    }

    public void removeAllElements() {
        int f;
        for (f = 0; f < this.getAtomCount(); ++f) {
            this.getAtomAt(f).removeListener(this);
        }
        for (f = 0; f < this.getElectronContainerCount(); ++f) {
            this.getElectronContainerAt(f).removeListener(this);
        }
        this.atoms = new Atom[this.growArraySize];
        this.electronContainers = new ElectronContainer[this.growArraySize];
        this.atomCount = 0;
        this.electronContainerCount = 0;
        this.notifyChanged();
    }

    public void removeAllElectronContainers() {
        for (int f = 0; f < this.getElectronContainerCount(); ++f) {
            this.getElectronContainerAt(f).removeListener(this);
        }
        this.electronContainers = new ElectronContainer[this.growArraySize];
        this.electronContainerCount = 0;
        this.notifyChanged();
    }

    public void removeAllBonds() {
        org.openscience.cdk.interfaces.Bond[] bonds = this.getBonds();
        for (int i = 0; i < bonds.length; ++i) {
            this.removeElectronContainer(bonds[i]);
        }
        this.notifyChanged();
    }

    public void addBond(int atom1, int atom2, double order, int stereo) {
        Bond bond = new Bond(this.getAtomAt(atom1), this.getAtomAt(atom2), order, stereo);
        if (this.contains(bond)) {
            return;
        }
        if (this.electronContainerCount >= this.electronContainers.length) {
            this.growElectronContainerArray();
        }
        this.addBond(bond);
    }

    public void addBond(int atom1, int atom2, double order) {
        Bond bond = new Bond(this.getAtomAt(atom1), this.getAtomAt(atom2), order);
        if (this.electronContainerCount >= this.electronContainers.length) {
            this.growElectronContainerArray();
        }
        this.addBond(bond);
    }

    public void addLonePair(int atomID) {
        org.openscience.cdk.LonePair lonePair = new org.openscience.cdk.LonePair((Atom)this.atoms[atomID]);
        lonePair.addListener(this);
        this.addElectronContainer(lonePair);
    }

    public boolean contains(org.openscience.cdk.interfaces.ElectronContainer electronContainer) {
        for (int i = 0; i < this.getElectronContainerCount(); ++i) {
            if (electronContainer != this.electronContainers[i]) continue;
            return true;
        }
        return false;
    }

    public boolean contains(org.openscience.cdk.interfaces.Atom atom) {
        for (int i = 0; i < this.getAtomCount(); ++i) {
            if (atom != this.atoms[i]) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        int i;
        StringBuffer stringContent = new StringBuffer();
        stringContent.append("AtomContainer(");
        stringContent.append(this.hashCode()).append(", ");
        stringContent.append("#A:").append(this.getAtomCount()).append(", ");
        stringContent.append("#EC:").append(this.getElectronContainerCount()).append(", ");
        for (i = 0; i < this.getAtomCount(); ++i) {
            stringContent.append(this.getAtomAt(i).toString()).append(", ");
        }
        for (i = 0; i < this.getElectronContainerCount(); ++i) {
            org.openscience.cdk.interfaces.ElectronContainer electronContainer = this.getElectronContainerAt(i);
            if (electronContainer == null) continue;
            stringContent.append(electronContainer.toString()).append(", ");
        }
        stringContent.append(", AP:[#").append(this.atomParities.size()).append(", ");
        Enumeration parities = this.atomParities.elements();
        while (parities.hasMoreElements()) {
            stringContent.append(((org.openscience.cdk.AtomParity)parities.nextElement()).toString());
            if (!parities.hasMoreElements()) continue;
            stringContent.append(", ");
        }
        stringContent.append("])");
        return stringContent.toString();
    }

    public Object clone() {
        int f;
        AtomContainer clone = null;
        org.openscience.cdk.interfaces.ElectronContainer electronContainer = null;
        ElectronContainer newEC = null;
        try {
            clone = (AtomContainer)super.clone();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        clone.removeAllElements();
        for (f = 0; f < this.getAtomCount(); ++f) {
            clone.addAtom((Atom)this.getAtomAt(f).clone());
        }
        for (f = 0; f < this.getElectronContainerCount(); ++f) {
            org.openscience.cdk.interfaces.Atom atom;
            electronContainer = this.getElectronContainerAt(f);
            newEC = new ElectronContainer();
            if (electronContainer instanceof org.openscience.cdk.interfaces.Bond) {
                Bond bond = (Bond)electronContainer;
                newEC = (ElectronContainer)bond.clone();
                org.openscience.cdk.interfaces.Atom[] natoms = bond.getAtoms();
                org.openscience.cdk.interfaces.Atom[] newAtoms = new Atom[natoms.length];
                for (int g = 0; g < natoms.length; ++g) {
                    try {
                        newAtoms[g] = clone.getAtomAt(this.getAtomNumber(natoms[g]));
                        continue;
                    }
                    catch (Exception exc) {
                        System.out.println("natoms[g]: " + natoms[g]);
                        exc.printStackTrace();
                    }
                }
                ((Bond)newEC).setAtoms(newAtoms);
            } else if (electronContainer instanceof org.openscience.cdk.LonePair) {
                atom = ((org.openscience.cdk.LonePair)electronContainer).getAtom();
                newEC = (org.openscience.cdk.LonePair)electronContainer.clone();
                ((org.openscience.cdk.LonePair)newEC).setAtom(clone.getAtomAt(this.getAtomNumber(atom)));
            } else if (electronContainer instanceof org.openscience.cdk.SingleElectron) {
                atom = ((org.openscience.cdk.SingleElectron)electronContainer).getAtom();
                newEC = (org.openscience.cdk.SingleElectron)electronContainer.clone();
                ((org.openscience.cdk.SingleElectron)newEC).setAtom(clone.getAtomAt(this.getAtomNumber(atom)));
            } else {
                newEC = (ElectronContainer)electronContainer.clone();
            }
            clone.addElectronContainer(newEC);
        }
        return clone;
    }

    protected void growElectronContainerArray() {
        this.growArraySize = this.electronContainers.length;
        ElectronContainer[] newelectronContainers = new ElectronContainer[this.electronContainers.length + this.growArraySize];
        System.arraycopy(this.electronContainers, 0, newelectronContainers, 0, this.electronContainers.length);
        this.electronContainers = newelectronContainers;
    }

    protected void growAtomArray() {
        this.growArraySize = this.atoms.length;
        Atom[] newatoms = new Atom[this.atoms.length + this.growArraySize];
        System.arraycopy(this.atoms, 0, newatoms, 0, this.atoms.length);
        this.atoms = newatoms;
    }

    public void stateChanged(ChemObjectChangeEvent event) {
        this.notifyChanged(event);
    }
}

