/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk;

import java.io.Serializable;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import org.openscience.cdk.AtomType;

public class Atom
extends AtomType
implements Serializable,
org.openscience.cdk.interfaces.Atom {
    private static final long serialVersionUID = -3137373012494608794L;
    protected Point2d point2d = null;
    protected Point3d point3d = null;
    protected Point3d fractionalPoint3d = null;
    protected int hydrogenCount;
    protected int stereoParity;
    protected double charge;

    public Atom() {
        this(null);
    }

    public Atom(String elementSymbol) {
        super(elementSymbol);
    }

    public Atom(String elementSymbol, Point3d point3d) {
        this(elementSymbol);
        this.point3d = point3d;
    }

    public Atom(String elementSymbol, Point2d point2d) {
        this(elementSymbol);
        this.point2d = point2d;
    }

    public void setCharge(double charge) {
        this.charge = charge;
        this.notifyChanged();
    }

    public double getCharge() {
        return this.charge;
    }

    public void setHydrogenCount(int hydrogenCount) {
        this.hydrogenCount = hydrogenCount;
        this.notifyChanged();
    }

    public int getHydrogenCount() {
        return this.hydrogenCount;
    }

    public void setPoint2d(Point2d point2d) {
        this.point2d = point2d;
        this.notifyChanged();
    }

    public void setPoint3d(Point3d point3d) {
        this.point3d = point3d;
        this.notifyChanged();
    }

    public void setFractionalPoint3d(Point3d point3d) {
        this.fractionalPoint3d = point3d;
        this.notifyChanged();
    }

    public void setStereoParity(int stereoParity) {
        this.stereoParity = stereoParity;
        this.notifyChanged();
    }

    public Point2d getPoint2d() {
        return this.point2d;
    }

    public Point3d getPoint3d() {
        return this.point3d;
    }

    public Point3d getFractionalPoint3d() {
        return this.fractionalPoint3d;
    }

    public double getX2d() {
        if (this.point2d == null) {
            return 0.0;
        }
        return this.point2d.x;
    }

    public double getY2d() {
        if (this.point2d == null) {
            return 0.0;
        }
        return this.point2d.y;
    }

    public double getX3d() {
        if (this.point3d == null) {
            return 0.0;
        }
        return this.point3d.x;
    }

    public double getY3d() {
        if (this.point3d == null) {
            return 0.0;
        }
        return this.point3d.y;
    }

    public double getZ3d() {
        if (this.point3d == null) {
            return 0.0;
        }
        return this.point3d.z;
    }

    public void setFractX3d(double xFract) {
        if (this.fractionalPoint3d == null) {
            this.fractionalPoint3d = new Point3d();
        }
        this.fractionalPoint3d.x = xFract;
        this.notifyChanged();
    }

    public void setFractY3d(double yFract) {
        if (this.fractionalPoint3d == null) {
            this.fractionalPoint3d = new Point3d();
        }
        this.fractionalPoint3d.y = yFract;
        this.notifyChanged();
    }

    public void setFractZ3d(double zFract) {
        if (this.fractionalPoint3d == null) {
            this.fractionalPoint3d = new Point3d();
        }
        this.fractionalPoint3d.z = zFract;
        this.notifyChanged();
    }

    public double getFractX3d() {
        if (this.fractionalPoint3d == null) {
            return 0.0;
        }
        return this.fractionalPoint3d.x;
    }

    public double getFractY3d() {
        if (this.fractionalPoint3d == null) {
            return 0.0;
        }
        return this.fractionalPoint3d.y;
    }

    public double getFractZ3d() {
        if (this.fractionalPoint3d == null) {
            return 0.0;
        }
        return this.fractionalPoint3d.z;
    }

    public void setX2d(double xCoord) {
        if (this.point2d == null) {
            this.point2d = new Point2d();
        }
        this.point2d.x = xCoord;
        this.notifyChanged();
    }

    public void setY2d(double yCoord) {
        if (this.point2d == null) {
            this.point2d = new Point2d();
        }
        this.point2d.y = yCoord;
        this.notifyChanged();
    }

    public void setX3d(double xCoord) {
        if (this.point3d == null) {
            this.point3d = new Point3d();
        }
        this.point3d.x = xCoord;
        this.notifyChanged();
    }

    public void setY3d(double yCoord) {
        if (this.point3d == null) {
            this.point3d = new Point3d();
        }
        this.point3d.y = yCoord;
        this.notifyChanged();
    }

    public void setZ3d(double zCoord) {
        if (this.point3d == null) {
            this.point3d = new Point3d();
        }
        this.point3d.z = zCoord;
        this.notifyChanged();
    }

    public int getStereoParity() {
        return this.stereoParity;
    }

    public boolean compare(Object object) {
        if (!(object instanceof org.openscience.cdk.interfaces.Atom)) {
            return false;
        }
        if (!super.compare(object)) {
            return false;
        }
        Atom atom = (Atom)object;
        return (this.point2d == atom.point2d || this.point2d != null && this.point2d.equals(atom.point2d)) && (this.point3d == atom.point3d || this.point3d != null && this.point3d.equals(atom.point3d)) && this.hydrogenCount == atom.hydrogenCount && this.stereoParity == atom.stereoParity && this.charge == atom.charge;
    }

    public String toString() {
        StringBuffer stringContent = new StringBuffer();
        stringContent.append("Atom(");
        stringContent.append(this.hashCode()).append(", ");
        stringContent.append(this.getSymbol()).append(", ");
        stringContent.append("H:").append(this.getHydrogenCount()).append(", ");
        stringContent.append("SP:").append(this.getStereoParity()).append(", ");
        stringContent.append("2D:[").append(this.getPoint2d()).append("], ");
        stringContent.append("3D:[").append(this.getPoint3d()).append("], ");
        stringContent.append("Fract3D:[").append(this.getFractionalPoint3d()).append("], ");
        stringContent.append("C:").append(this.getCharge()).append(", ");
        stringContent.append("FC:").append(this.getFormalCharge());
        stringContent.append(", ").append(super.toString());
        stringContent.append(")");
        return stringContent.toString();
    }

    public Object clone() {
        Object clone = null;
        try {
            clone = super.clone();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        if (this.point2d != null) {
            ((Atom)clone).setPoint2d(new Point2d(this.point2d.x, this.point2d.y));
        }
        if (this.point3d != null) {
            ((Atom)clone).setPoint3d(new Point3d(this.point3d.x, this.point3d.y, this.point3d.z));
        }
        if (this.fractionalPoint3d != null) {
            ((Atom)clone).setFractionalPoint3d(new Point3d(this.fractionalPoint3d.x, this.fractionalPoint3d.y, this.fractionalPoint3d.z));
        }
        return clone;
    }
}

