/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.util.Bmp;
import org.jmol.viewer.Util;

class SasFlattenedPointList {
    Graphics3D g3d;
    int geodesicLevel;
    int count;
    short[] vertexes = new short[32];
    float[] angles = new float[32];
    float[] distances = new float[32];
    private static final float PI = (float)Math.PI;
    final Point3f vertexPointT = new Point3f();
    final Vector3f vertexVectorT = new Vector3f();
    final Point3f projectedPointT = new Point3f();
    final Vector3f projectedVectorT = new Vector3f();

    SasFlattenedPointList(Graphics3D g3d, int geodesicLevel) {
        this.g3d = g3d;
        this.geodesicLevel = geodesicLevel;
    }

    void reset() {
        this.count = 0;
    }

    void generateTorusSegment(short startingVertex, short vertexIncrement, float startingAngle, float angleIncrement, int segmentCount) {
        if (this.vertexes.length < segmentCount) {
            this.vertexes = Util.ensureLength(this.vertexes, segmentCount);
            this.angles = Util.ensureLength(this.angles, segmentCount);
            this.distances = Util.ensureLength(this.distances, segmentCount);
        }
        this.count = segmentCount;
        short vertex = startingVertex;
        float angle = startingAngle;
        for (int i = 0; i < segmentCount; ++i) {
            this.vertexes[i] = vertex;
            vertex = (short)(vertex + vertexIncrement);
            this.angles[i] = angle;
            angle += angleIncrement;
            this.distances[i] = 0.0f;
        }
    }

    void add(short vertex, float angle, float distance) {
        if (this.count == this.vertexes.length) {
            this.vertexes = Util.doubleLength(this.vertexes);
            this.angles = Util.doubleLength(this.angles);
            this.distances = Util.doubleLength(this.distances);
        }
        this.vertexes[this.count] = vertex;
        this.angles[this.count] = angle;
        this.distances[this.count] = distance;
        ++this.count;
    }

    void duplicateFirstPointPlus2Pi() {
        this.add(this.vertexes[0], this.angles[0] + (float)Math.PI * 2, this.distances[0]);
    }

    void sort() {
        int i = this.count;
        while (--i > 0) {
            int j = i;
            while (--j >= 0) {
                if (!(this.angles[j] > this.angles[i])) continue;
                Util.swap(this.angles, i, j);
                Util.swap(this.distances, i, j);
                Util.swap(this.vertexes, i, j);
            }
        }
    }

    int find(float angle) {
        for (int i = 0; i < this.count; ++i) {
            if (!(this.angles[i] >= angle)) continue;
            return i;
        }
        return -1;
    }

    int findGE(float angle) {
        int min = 0;
        int max = this.count;
        while (min != max) {
            int mid = (min + max) / 2;
            float midAngle = this.angles[mid];
            if (midAngle < angle) {
                min = mid + 1;
                continue;
            }
            max = mid;
        }
        return min;
    }

    int findGT(float angle) {
        int min = 0;
        int max = this.count;
        while (min != max) {
            int mid = (min + max) / 2;
            float midAngle = this.angles[mid];
            if (midAngle <= angle) {
                min = mid + 1;
                continue;
            }
            max = mid;
        }
        return min;
    }

    void setGeodesicEdge(Point3f geodesicCenter, float geodesicRadius, Point3f planeCenter, Vector3f axisUnitVector, Point3f planeZeroPoint, boolean fullTorus, Vector3f vector0, Vector3f vector90, Vector3f[] geodesicVertexVectors, int[] edgeMap) {
        float radiansPerAngstrom = (float)Math.PI / geodesicRadius;
        this.count = 0;
        int v = -1;
        while ((v = Bmp.nextSetBit(edgeMap, v + 1)) >= 0) {
            this.vertexPointT.scaleAdd(geodesicRadius, geodesicVertexVectors[v], geodesicCenter);
            this.vertexVectorT.sub(this.vertexPointT, planeCenter);
            float distance = axisUnitVector.dot(this.vertexVectorT);
            this.projectedPointT.scaleAdd(-distance, axisUnitVector, this.vertexPointT);
            this.projectedVectorT.sub(this.projectedPointT, planeCenter);
            float angle = SasFlattenedPointList.calcAngleInThePlane(vector0, vector90, this.projectedVectorT);
            this.add((short)v, angle, distance * radiansPerAngstrom);
        }
        this.sort();
        if (fullTorus) {
            this.duplicateFirstPointPlus2Pi();
        }
    }

    static float calcAngleInThePlane(Vector3f radialVector0, Vector3f radialVector90, Vector3f vectorInQuestion) {
        float angle = radialVector0.angle(vectorInQuestion);
        float angle90 = radialVector90.angle(vectorInQuestion);
        if (angle90 > 1.5707964f) {
            angle = (float)Math.PI * 2 - angle;
        }
        return angle;
    }

    void buildForStitching(float startingAngle, float endingAngle, SasFlattenedPointList fplIdeal, SasFlattenedPointList fplActual, SasFlattenedPointList fplVisibleIdeal, boolean dump) {
        int minVisibleIdeal = fplVisibleIdeal.findGE(startingAngle);
        int maxVisibleIdeal = fplVisibleIdeal.findGT(endingAngle);
        if (dump) {
            System.out.println("buildForStitching(" + startingAngle + "," + endingAngle + ",...)");
            System.out.println("fplVisibleIdeal=");
            fplVisibleIdeal.dump();
            System.out.println("minVisibleIdeal=" + minVisibleIdeal);
            System.out.println("maxVisibleIdeal=" + maxVisibleIdeal);
        }
        this.count = 0;
        if (minVisibleIdeal == maxVisibleIdeal) {
            return;
        }
        short minVisibleIdealVertex = fplVisibleIdeal.vertexes[minVisibleIdeal];
        float minVisibleIdealAngle = fplVisibleIdeal.angles[minVisibleIdeal];
        for (int i = minVisibleIdeal; i < maxVisibleIdeal; ++i) {
            this.add(fplVisibleIdeal.vertexes[i], fplVisibleIdeal.angles[i], fplVisibleIdeal.distances[i]);
        }
    }

    void dump() {
        System.out.println(" SasFlattenedPointList.dump() count=" + this.count);
        for (int i = 0; i < this.count; ++i) {
            System.out.println(" " + i + ":" + this.angles[i] + "," + this.vertexes[i] + "," + this.distances[i]);
        }
    }
}

