/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.awt.Rectangle;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.Properties;
import javax.vecmath.Matrix3f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.jmol.api.JmolAdapter;
import org.jmol.bspt.Bspf;
import org.jmol.bspt.SphereIterator;
import org.jmol.bspt.Tuple;
import org.jmol.g3d.Graphics3D;
import org.jmol.viewer.AlphaMonomer;
import org.jmol.viewer.AminoMonomer;
import org.jmol.viewer.Atom;
import org.jmol.viewer.AtomIterator;
import org.jmol.viewer.Bond;
import org.jmol.viewer.BondIterator;
import org.jmol.viewer.Chain;
import org.jmol.viewer.Closest;
import org.jmol.viewer.FrameExportJmolAdapter;
import org.jmol.viewer.FrameRenderer;
import org.jmol.viewer.Group;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.Measurement;
import org.jmol.viewer.Mmset;
import org.jmol.viewer.Model;
import org.jmol.viewer.Monomer;
import org.jmol.viewer.NucleicMonomer;
import org.jmol.viewer.PhosphorusMonomer;
import org.jmol.viewer.Polymer;
import org.jmol.viewer.Shape;
import org.jmol.viewer.ShapeRenderer;
import org.jmol.viewer.Util;
import org.jmol.viewer.Viewer;

final class Frame {
    final Viewer viewer;
    final JmolAdapter adapter;
    final FrameRenderer frameRenderer;
    final String modelSetTypeName;
    final Mmset mmset;
    final Graphics3D g3d;
    float maxBondingRadius = -2.1474836E9f;
    float maxVanderwaalsRadius = -2.1474836E9f;
    int atomCount;
    Atom[] atoms;
    Object[] clientAtomReferences;
    Vector3f[] vibrationVectors;
    byte[] occupancies;
    short[] bfactor100s;
    float[] partialCharges;
    String[] atomNames;
    int[] atomSerials;
    byte[] specialAtomIDs;
    int bondCount;
    Bond[] bonds;
    private static final int growthIncrement = 250;
    boolean fileCoordinatesAreFractional;
    float[] notionalUnitcell;
    Matrix3f matrixNotional;
    Matrix3f pdbScaleMatrix;
    Matrix3f pdbScaleMatrixTranspose;
    Vector3f pdbTranslateVector;
    Matrix3f matrixEuclideanToFractional;
    Matrix3f matrixFractionalToEuclidean;
    boolean hasVibrationVectors;
    boolean fileHasHbonds;
    boolean structuresDefined;
    BitSet elementsPresent;
    int groupCount;
    Group[] groups;
    BitSet groupsPresent;
    boolean hasBfactorRange;
    int bfactor100Lo;
    int bfactor100Hi;
    private static final int ATOM_GROWTH_INCREMENT = 2000;
    int currentModelIndex;
    Model currentModel;
    char currentChainID;
    Chain currentChain;
    int currentGroupSequenceNumber;
    char currentGroupInsertionCode;
    private final Hashtable htAtomMap = new Hashtable();
    static final int defaultGroupCount = 32;
    Chain[] chains = new Chain[32];
    String[] group3s = new String[32];
    int[] seqcodes = new int[32];
    int[] firstAtomIndexes = new int[32];
    final int[] specialAtomIndexes = new int[JmolConstants.ATOMID_MAX];
    FrameExportJmolAdapter exportJmolAdapter;
    final Shape[] shapes = new Shape[27];
    final Point3f averageAtomPoint = new Point3f();
    final Point3f centerBoundBox = new Point3f();
    final Vector3f boundBoxCornerVector = new Vector3f();
    final Point3f minBoundBox = new Point3f();
    final Point3f maxBoundBox = new Point3f();
    final Point3f centerUnitcell = new Point3f();
    Point3f rotationCenter;
    float rotationRadius;
    Point3f rotationCenterDefault;
    float rotationRadiusDefault;
    static final Point3f[] unitBboxPoints = new Point3f[]{new Point3f(1.0f, 1.0f, 1.0f), new Point3f(1.0f, 1.0f, -1.0f), new Point3f(1.0f, -1.0f, 1.0f), new Point3f(1.0f, -1.0f, -1.0f), new Point3f(-1.0f, 1.0f, 1.0f), new Point3f(-1.0f, 1.0f, -1.0f), new Point3f(-1.0f, -1.0f, 1.0f), new Point3f(-1.0f, -1.0f, -1.0f)};
    final Point3f[] bboxVertices = new Point3f[8];
    static final Point3f[] unitCubePoints = new Point3f[]{new Point3f(0.0f, 0.0f, 0.0f), new Point3f(0.0f, 0.0f, 1.0f), new Point3f(0.0f, 1.0f, 0.0f), new Point3f(0.0f, 1.0f, 1.0f), new Point3f(1.0f, 0.0f, 0.0f), new Point3f(1.0f, 0.0f, 1.0f), new Point3f(1.0f, 1.0f, 0.0f), new Point3f(1.0f, 1.0f, 1.0f)};
    Point3f[] unitcellVertices;
    static final int measurementGrowthIncrement = 16;
    int measurementCount = 0;
    Measurement[] measurements = null;
    static final int minimumPixelSelectionRadius = 4;
    final Closest closest = new Closest();
    final BitSet bsEmpty = new BitSet();
    final BitSet bsFoundRectangle = new BitSet();
    Bspf bspf;
    private static final boolean MIX_BSPT_ORDER = false;
    private final WithinModelIterator withinModelIterator = new WithinModelIterator();
    private final WithinAnyModelIterator withinAnyModelIterator = new WithinAnyModelIterator();
    static final boolean showRebondTimes = true;
    private float bondTolerance;
    private float minBondDistance;
    private float minBondDistance2;
    float hbondMax = 3.25f;
    float hbondMin = 2.5f;
    float hbondMin2 = this.hbondMin * this.hbondMin;
    boolean hbondsCalculated;
    boolean useRasMolHbondsCalculation = true;
    static final float toRadians = (float)Math.PI / 180;
    Vector3f vectorBA;
    Vector3f vectorBC;
    static final int MAX_BONDS_LENGTH_TO_CACHE = 5;
    static final int MAX_NUM_TO_CACHE = 200;
    int[] numCached = new int[5];
    Bond[][][] freeBonds = new Bond[5][][];

    Frame(Viewer viewer, JmolAdapter adapter, Object clientFile) {
        JmolAdapter.StructureIterator iterStructure;
        int i = 5;
        while (--i > 0) {
            this.freeBonds[i] = new Bond[200][];
        }
        this.viewer = viewer;
        this.adapter = adapter;
        String fileTypeName = adapter.getFileTypeName(clientFile);
        this.modelSetTypeName = fileTypeName.toLowerCase().intern();
        this.mmset = new Mmset(this);
        this.frameRenderer = viewer.getFrameRenderer();
        this.g3d = viewer.getGraphics3D();
        this.initializeBuild(adapter.getEstimatedAtomCount(clientFile));
        this.fileCoordinatesAreFractional = adapter.coordinatesAreFractional(clientFile);
        this.setNotionalUnitcell(adapter.getNotionalUnitcell(clientFile));
        this.setPdbScaleMatrix(adapter.getPdbScaleMatrix(clientFile));
        this.setPdbScaleTranslate(adapter.getPdbScaleTranslate(clientFile));
        this.setModelSetProperties(adapter.getAtomSetCollectionProperties(clientFile));
        this.currentModelIndex = -1;
        int modelCount = adapter.getAtomSetCount(clientFile);
        this.setModelCount(modelCount);
        for (int i2 = 0; i2 < modelCount; ++i2) {
            int modelNumber = adapter.getAtomSetNumber(clientFile, i2);
            String modelName = adapter.getAtomSetName(clientFile, i2);
            if (modelName == null) {
                modelName = "" + modelNumber;
            }
            Properties modelProperties = adapter.getAtomSetProperties(clientFile, i2);
            this.setModelNameNumberProperties(i2, modelName, modelNumber, modelProperties);
        }
        JmolAdapter.AtomIterator iterAtom = adapter.getAtomIterator(clientFile);
        while (iterAtom.hasNext()) {
            char alternateLocation;
            byte elementNumber = (byte)iterAtom.getElementNumber();
            if (elementNumber <= 0) {
                elementNumber = JmolConstants.elementNumberFromSymbol(iterAtom.getElementSymbol());
            }
            if ((alternateLocation = iterAtom.getAlternateLocationID()) != '\u0000' && alternateLocation != 'A') continue;
            this.addAtom(iterAtom.getAtomSetIndex(), iterAtom.getUniqueID(), elementNumber, iterAtom.getAtomName(), iterAtom.getFormalCharge(), iterAtom.getPartialCharge(), iterAtom.getOccupancy(), iterAtom.getBfactor(), iterAtom.getX(), iterAtom.getY(), iterAtom.getZ(), iterAtom.getIsHetero(), iterAtom.getAtomSerial(), iterAtom.getChainID(), iterAtom.getGroup3(), iterAtom.getSequenceNumber(), iterAtom.getInsertionCode(), iterAtom.getVectorX(), iterAtom.getVectorY(), iterAtom.getVectorZ(), alternateLocation, iterAtom.getClientAtomReference());
        }
        this.fileHasHbonds = false;
        JmolAdapter.BondIterator iterBond = adapter.getBondIterator(clientFile);
        if (iterBond != null) {
            while (iterBond.hasNext()) {
                this.bondAtoms(iterBond.getAtomUniqueID1(), iterBond.getAtomUniqueID2(), iterBond.getEncodedOrder());
            }
        }
        if ((iterStructure = adapter.getStructureIterator(clientFile)) != null) {
            while (iterStructure.hasNext()) {
                this.defineStructure(iterStructure.getStructureType(), iterStructure.getStartChainID(), iterStructure.getStartSequenceNumber(), iterStructure.getStartInsertionCode(), iterStructure.getEndChainID(), iterStructure.getEndSequenceNumber(), iterStructure.getEndInsertionCode());
            }
        }
        this.doUnitcellStuff();
        this.doAutobond();
        this.finalizeGroupBuild();
        this.buildPolymers();
        this.freeze();
        adapter.finish(clientFile);
        this.finalizeBuild();
        this.dumpAtomSetNameDiagnostics(clientFile);
    }

    void dumpAtomSetNameDiagnostics(Object clientFile) {
    }

    void initializeBuild(int atomCountEstimate) {
        this.currentModel = null;
        this.currentChainID = (char)65535;
        this.currentChain = null;
        this.currentGroupInsertionCode = (char)65535;
        if (atomCountEstimate <= 0) {
            atomCountEstimate = 2000;
        }
        this.atoms = new Atom[atomCountEstimate];
        this.bonds = new Bond[2 * atomCountEstimate];
        this.htAtomMap.clear();
        this.initializeGroupBuild();
    }

    void finalizeBuild() {
        this.currentModel = null;
        this.currentChain = null;
        this.htAtomMap.clear();
    }

    void addAtom(int modelIndex, Object atomUid, byte atomicNumber, String atomName, int formalCharge, float partialCharge, int occupancy, float bfactor, float x, float y, float z, boolean isHetero, int atomSerial, char chainID, String group3, int groupSequenceNumber, char groupInsertionCode, float vectorX, float vectorY, float vectorZ, char alternateLocationID, Object clientAtomReference) {
        Atom atom;
        if (modelIndex != this.currentModelIndex) {
            this.currentModel = this.mmset.getModel(modelIndex);
            this.currentModelIndex = modelIndex;
            this.currentChainID = (char)65535;
        }
        if (chainID != this.currentChainID) {
            this.currentChainID = chainID;
            this.currentChain = this.currentModel.getOrAllocateChain(chainID);
            this.currentGroupInsertionCode = (char)65535;
        }
        if (groupSequenceNumber != this.currentGroupSequenceNumber || groupInsertionCode != this.currentGroupInsertionCode) {
            this.currentGroupSequenceNumber = groupSequenceNumber;
            this.currentGroupInsertionCode = groupInsertionCode;
            this.startGroup(this.currentChain, group3, groupSequenceNumber, groupInsertionCode, this.atomCount);
        }
        if (this.atomCount == this.atoms.length) {
            this.growAtomArrays();
        }
        this.atoms[this.atomCount] = atom = new Atom(this.viewer, this, this.currentModelIndex, this.atomCount, atomicNumber, atomName, formalCharge, partialCharge, occupancy, bfactor, x, y, z, isHetero, atomSerial, chainID, vectorX, vectorY, vectorZ, alternateLocationID, clientAtomReference);
        ++this.atomCount;
        this.htAtomMap.put(atomUid, atom);
    }

    void bondAtoms(Object atomUid1, Object atomUid2, int order) {
        Bond bond;
        Atom atom1 = (Atom)this.htAtomMap.get(atomUid1);
        if (atom1 == null) {
            System.out.println("bondAtoms cannot find atomUid1?");
            return;
        }
        Atom atom2 = (Atom)this.htAtomMap.get(atomUid2);
        if (atom2 == null) {
            System.out.println("bondAtoms cannot find atomUid2?");
            return;
        }
        if (this.bondCount == this.bonds.length) {
            this.bonds = (Bond[])Util.setLength(this.bonds, this.bondCount + 4000);
        }
        if ((bond = atom1.bondMutually(atom2, order, this)) != null) {
            this.bonds[this.bondCount++] = bond;
            if ((order & 0x3C0) != 0) {
                this.fileHasHbonds = true;
            }
        }
    }

    void growAtomArrays() {
        int newLength = this.atomCount + 2000;
        this.atoms = (Atom[])Util.setLength(this.atoms, newLength);
        if (this.clientAtomReferences != null) {
            this.clientAtomReferences = (Object[])Util.setLength(this.clientAtomReferences, newLength);
        }
        if (this.vibrationVectors != null) {
            this.vibrationVectors = (Vector3f[])Util.setLength(this.vibrationVectors, newLength);
        }
        if (this.occupancies != null) {
            this.occupancies = Util.setLength(this.occupancies, newLength);
        }
        if (this.bfactor100s != null) {
            this.bfactor100s = Util.setLength(this.bfactor100s, newLength);
        }
        if (this.partialCharges != null) {
            this.partialCharges = Util.setLength(this.partialCharges, newLength);
        }
        if (this.atomNames != null) {
            this.atomNames = Util.setLength(this.atomNames, newLength);
        }
        if (this.atomSerials != null) {
            this.atomSerials = Util.setLength(this.atomSerials, newLength);
        }
        if (this.specialAtomIDs != null) {
            this.specialAtomIDs = Util.setLength(this.specialAtomIDs, newLength);
        }
    }

    void initializeGroupBuild() {
        this.groupCount = 0;
    }

    void finalizeGroupBuild() {
        this.groups = new Group[this.groupCount];
        for (int i = 0; i < this.groupCount; ++i) {
            this.distinguishAndPropogateGroup(i, this.chains[i], this.group3s[i], this.seqcodes[i], this.firstAtomIndexes[i], i == this.groupCount - 1 ? this.atomCount : this.firstAtomIndexes[i + 1]);
            this.chains[i] = null;
            this.group3s[i] = null;
        }
    }

    void startGroup(Chain chain, String group3, int groupSequenceNumber, char groupInsertionCode, int firstAtomIndex) {
        if (this.groupCount == this.group3s.length) {
            this.chains = (Chain[])Util.doubleLength(this.chains);
            this.group3s = Util.doubleLength(this.group3s);
            this.seqcodes = Util.doubleLength(this.seqcodes);
            this.firstAtomIndexes = Util.doubleLength(this.firstAtomIndexes);
        }
        this.firstAtomIndexes[this.groupCount] = firstAtomIndex;
        this.chains[this.groupCount] = chain;
        this.group3s[this.groupCount] = group3;
        this.seqcodes[this.groupCount] = Group.getSeqcode(groupSequenceNumber, groupInsertionCode);
        ++this.groupCount;
    }

    void distinguishAndPropogateGroup(int groupIndex, Chain chain, String group3, int seqcode, int firstAtomIndex, int maxAtomIndex) {
        int lastAtomIndex;
        int distinguishingBits = 0;
        int i = JmolConstants.ATOMID_MAX;
        while (--i >= 0) {
            this.specialAtomIndexes[i] = Integer.MIN_VALUE;
        }
        if (this.specialAtomIDs != null) {
            i = maxAtomIndex;
            while (--i >= firstAtomIndex) {
                byte specialAtomID = this.specialAtomIDs[i];
                if (specialAtomID <= 0) continue;
                if (specialAtomID < 32) {
                    distinguishingBits |= 1 << specialAtomID;
                }
                this.specialAtomIndexes[specialAtomID] = i;
            }
        }
        if ((lastAtomIndex = maxAtomIndex - 1) < firstAtomIndex) {
            throw new NullPointerException();
        }
        Group group = null;
        if ((distinguishingBits & 0xE) == 14) {
            group = AminoMonomer.validateAndAllocate(chain, group3, seqcode, firstAtomIndex, lastAtomIndex, this.specialAtomIndexes, this.atoms);
        } else if (distinguishingBits == 4) {
            group = AlphaMonomer.validateAndAllocate(chain, group3, seqcode, firstAtomIndex, lastAtomIndex, this.specialAtomIndexes, this.atoms);
        } else if ((distinguishingBits & 0xFE0) == 4064) {
            group = NucleicMonomer.validateAndAllocate(chain, group3, seqcode, firstAtomIndex, lastAtomIndex, this.specialAtomIndexes, this.atoms);
        } else if (distinguishingBits == 4096) {
            group = PhosphorusMonomer.validateAndAllocate(chain, group3, seqcode, firstAtomIndex, lastAtomIndex, this.specialAtomIndexes, this.atoms);
        }
        if (group == null) {
            group = new Group(chain, group3, seqcode, firstAtomIndex, lastAtomIndex);
        }
        chain.addGroup(group);
        this.groups[groupIndex] = group;
        int i2 = maxAtomIndex;
        while (--i2 >= firstAtomIndex) {
            this.atoms[i2].setGroup(group);
        }
    }

    void buildPolymers() {
        for (int i = 0; i < this.groupCount; ++i) {
            Group group = this.groups[i];
            if (!(group instanceof Monomer)) continue;
            Monomer monomer = (Monomer)group;
            if (monomer.polymer != null) continue;
            Polymer.allocatePolymer(this.groups, i);
        }
    }

    JmolAdapter getExportJmolAdapter() {
        if (this.exportJmolAdapter == null) {
            this.exportJmolAdapter = new FrameExportJmolAdapter(this.viewer, this);
        }
        return this.exportJmolAdapter;
    }

    void freeze() {
        if (this.atomCount < this.atoms.length) {
            this.atoms = (Atom[])Util.setLength(this.atoms, this.atomCount);
            if (this.clientAtomReferences != null) {
                this.clientAtomReferences = (Object[])Util.setLength(this.clientAtomReferences, this.atomCount);
            }
            if (this.vibrationVectors != null) {
                this.vibrationVectors = (Vector3f[])Util.setLength(this.vibrationVectors, this.atomCount);
            }
            if (this.occupancies != null) {
                this.occupancies = Util.setLength(this.occupancies, this.atomCount);
            }
            if (this.bfactor100s != null) {
                this.bfactor100s = Util.setLength(this.bfactor100s, this.atomCount);
            }
            if (this.partialCharges != null) {
                this.partialCharges = Util.setLength(this.partialCharges, this.atomCount);
            }
            if (this.atomNames != null) {
                this.atomNames = Util.setLength(this.atomNames, this.atomCount);
            }
            if (this.atomSerials != null) {
                this.atomSerials = Util.setLength(this.atomSerials, this.atomCount);
            }
            if (this.specialAtomIDs != null) {
                this.specialAtomIDs = Util.setLength(this.specialAtomIDs, this.atomCount);
            }
        }
        if (this.bondCount < this.bonds.length) {
            this.bonds = (Bond[])Util.setLength(this.bonds, this.bondCount);
        }
        this.freeBondsCache();
        this.hasVibrationVectors = this.vibrationVectors != null;
        this.hackAtomSerialNumbersForAnimations();
        if (!this.structuresDefined) {
            this.mmset.calculateStructures();
        }
        this.findElementsPresent();
        this.findGroupsPresent();
        this.mmset.freeze();
        this.loadShape(0);
        this.loadShape(1);
        if (this.fileHasHbonds) {
            this.loadShape(2);
        }
        this.loadShape(6);
    }

    void hackAtomSerialNumbersForAnimations() {
        if (this.atomSerials != null) {
            return;
        }
        int n = Integer.MAX_VALUE;
        int modelAtomIndex = 0;
        this.atomSerials = new int[this.atomCount];
        for (int i = 0; i < this.atomCount; ++i) {
            short s;
            Atom atom = this.atoms[i];
            if (atom.modelIndex != s) {
                s = atom.modelIndex;
                modelAtomIndex = 1;
            }
            this.atomSerials[i] = modelAtomIndex++;
        }
    }

    void defineStructure(String structureType, char startChainID, int startSequenceNumber, char startInsertionCode, char endChainID, int endSequenceNumber, char endInsertionCode) {
        this.structuresDefined = true;
        this.mmset.defineStructure(structureType, startChainID, startSequenceNumber, startInsertionCode, endChainID, endSequenceNumber, endInsertionCode);
    }

    int getAtomIndexFromAtomNumber(int atomNumber) {
        int i = this.atomCount;
        while (--i >= 0) {
            if (this.atoms[i].getAtomNumber() != atomNumber) continue;
            return i;
        }
        return -1;
    }

    Properties getModelSetProperties() {
        return this.mmset.getModelSetProperties();
    }

    String getModelSetProperty(String propertyName) {
        return this.mmset.getModelSetProperty(propertyName);
    }

    boolean modelSetHasVibrationVectors() {
        return this.hasVibrationVectors;
    }

    boolean hasVibrationVectors() {
        return this.hasVibrationVectors;
    }

    boolean modelHasVibrationVectors(int modelIndex) {
        if (this.vibrationVectors != null) {
            int i = this.atomCount;
            while (--i >= 0) {
                if (this.atoms[i].modelIndex != modelIndex || this.vibrationVectors[i] == null) continue;
                return true;
            }
        }
        return false;
    }

    int getModelCount() {
        return this.mmset.getModelCount();
    }

    int getModelNumber(int modelIndex) {
        return this.mmset.getModelNumber(modelIndex);
    }

    String getModelName(int modelIndex) {
        return this.mmset.getModelName(modelIndex);
    }

    String getModelSetTypeName() {
        return this.modelSetTypeName;
    }

    Properties getModelProperties(int modelIndex) {
        return this.mmset.getModelProperties(modelIndex);
    }

    String getModelProperty(int modelIndex, String propertyName) {
        return this.mmset.getModelProperty(modelIndex, propertyName);
    }

    Model getModel(int modelIndex) {
        return this.mmset.getModel(modelIndex);
    }

    int getModelNumberIndex(int modelNumber) {
        return this.mmset.getModelNumberIndex(modelNumber);
    }

    void setModelCount(int modelCount) {
        this.mmset.setModelCount(modelCount);
    }

    void setModelSetProperties(Properties modelSetProperties) {
        this.mmset.setModelSetProperties(modelSetProperties);
    }

    void setModelNameNumberProperties(int modelIndex, String modelName, int modelNumber, Properties modelProperties) {
        this.mmset.setModelNameNumberProperties(modelIndex, modelName, modelNumber, modelProperties);
    }

    int getChainCount() {
        return this.mmset.getChainCount();
    }

    int getPolymerCount() {
        return this.mmset.getPolymerCount();
    }

    int getPolymerCountInModel(int modelIndex) {
        return this.mmset.getPolymerCountInModel(modelIndex);
    }

    Polymer getPolymerAt(int modelIndex, int polymerIndex) {
        return this.mmset.getPolymerAt(modelIndex, polymerIndex);
    }

    int getGroupCount() {
        return this.mmset.getGroupCount();
    }

    int getAtomCount() {
        return this.atomCount;
    }

    Atom[] getAtoms() {
        return this.atoms;
    }

    Atom getAtomAt(int atomIndex) {
        return this.atoms[atomIndex];
    }

    Point3f getAtomPoint3f(int atomIndex) {
        return this.atoms[atomIndex].point3f;
    }

    int getBondCount() {
        return this.bondCount;
    }

    Bond getBondAt(int bondIndex) {
        return this.bonds[bondIndex];
    }

    private void addBond(Bond bond) {
        if (bond == null) {
            return;
        }
        if (this.bondCount == this.bonds.length) {
            this.bonds = (Bond[])Util.setLength(this.bonds, this.bondCount + 250);
        }
        this.bonds[this.bondCount++] = bond;
    }

    void bondAtoms(Atom atom1, Atom atom2, int order) {
        this.addBond(atom1.bondMutually(atom2, order, this));
    }

    Shape allocateShape(int shapeID) {
        String classBase = JmolConstants.shapeClassBases[shapeID];
        String className = "org.jmol.viewer." + classBase;
        try {
            Class<?> shapeClass = Class.forName(className);
            Shape shape = (Shape)shapeClass.newInstance();
            shape.setViewerG3dFrame(this.viewer, this.g3d, this);
            return shape;
        }
        catch (Exception e) {
            System.out.println("Could not instantiate shape:" + classBase + "\n" + e);
            e.printStackTrace();
            return null;
        }
    }

    void loadShape(int shapeID) {
        if (this.shapes[shapeID] == null) {
            this.shapes[shapeID] = this.allocateShape(shapeID);
        }
    }

    void setShapeSize(int shapeID, int size, BitSet bsSelected) {
        if (size != 0) {
            this.loadShape(shapeID);
        }
        if (this.shapes[shapeID] != null) {
            this.shapes[shapeID].setSize(size, bsSelected);
        }
    }

    void setShapeProperty(int shapeID, String propertyName, Object value, BitSet bsSelected) {
        if (this.shapes[shapeID] != null) {
            this.shapes[shapeID].setProperty(propertyName, value, bsSelected);
        }
    }

    Object getShapeProperty(int shapeID, String propertyName, int index) {
        return this.shapes[shapeID] == null ? null : this.shapes[shapeID].getProperty(propertyName, index);
    }

    Point3f getBoundBoxCenter() {
        this.findBounds();
        return this.centerBoundBox;
    }

    Point3f getAverageAtomPoint() {
        this.findBounds();
        return this.averageAtomPoint;
    }

    Vector3f getBoundBoxCornerVector() {
        this.findBounds();
        return this.boundBoxCornerVector;
    }

    Point3f getRotationCenter() {
        this.findBounds();
        return this.rotationCenter;
    }

    Point3f getRotationCenterDefault() {
        this.findBounds();
        return this.rotationCenterDefault;
    }

    void increaseRotationRadius(float increaseInAngstroms) {
        this.rotationRadius += increaseInAngstroms;
    }

    float getRotationRadius() {
        this.findBounds();
        return this.rotationRadius;
    }

    void setRotationCenter(Point3f newCenterOfRotation) {
        if (newCenterOfRotation != null) {
            this.rotationCenter = newCenterOfRotation;
            if (!this.viewer.getFriedaSwitch()) {
                this.rotationRadius = this.calcRotationRadius(this.rotationCenter);
            }
        } else {
            this.rotationCenter = this.rotationCenterDefault;
            this.rotationRadius = this.rotationRadiusDefault;
        }
    }

    void clearBounds() {
        this.rotationCenter = null;
        this.rotationRadius = 0.0f;
    }

    private void findBounds() {
        if (this.rotationCenter != null || this.atomCount <= 0) {
            return;
        }
        this.calcRotationSphere();
    }

    private void calcRotationSphere() {
        this.calcAverageAtomPoint();
        this.calcBoundBoxDimensions();
        if (this.notionalUnitcell != null) {
            this.calcUnitcellDimensions();
        }
        this.rotationCenter = this.rotationCenterDefault = this.centerBoundBox;
        this.rotationRadius = this.rotationRadiusDefault = this.calcRotationRadius(this.rotationCenterDefault);
    }

    private void calcAverageAtomPoint() {
        Point3f average = this.averageAtomPoint;
        average.set(0.0f, 0.0f, 0.0f);
        int i = this.atomCount;
        while (--i >= 0) {
            average.add(this.atoms[i].point3f);
        }
        average.scale(1.0f / (float)this.atomCount);
    }

    private void calcBoundBoxDimensions() {
        this.calcAtomsMinMax(this.minBoundBox, this.maxBoundBox);
        this.centerBoundBox.add(this.minBoundBox, this.maxBoundBox);
        this.centerBoundBox.scale(0.5f);
        this.boundBoxCornerVector.sub(this.maxBoundBox, this.centerBoundBox);
        int i = 8;
        while (--i >= 0) {
            Point3f bbcagePoint = this.bboxVertices[i] = new Point3f(unitBboxPoints[i]);
            bbcagePoint.x *= this.boundBoxCornerVector.x;
            bbcagePoint.y *= this.boundBoxCornerVector.y;
            bbcagePoint.z *= this.boundBoxCornerVector.z;
            bbcagePoint.add(this.centerBoundBox);
        }
    }

    private void calcUnitcellDimensions() {
        this.unitcellVertices = new Point3f[8];
        int i = 8;
        while (--i >= 0) {
            Point3f vertex = this.unitcellVertices[i] = new Point3f();
            this.matrixFractionalToEuclidean.transform(unitCubePoints[i], vertex);
        }
        this.centerUnitcell.set(this.unitcellVertices[7]);
        this.centerUnitcell.scale(0.5f);
    }

    private float calcRotationRadius(Point3f center) {
        float maxRadius = 0.0f;
        int i = this.atomCount;
        while (--i >= 0) {
            float radiusVdw;
            Atom atom = this.atoms[i];
            float distAtom = center.distance(atom.point3f);
            float outerVdw = distAtom + (radiusVdw = atom.getVanderwaalsRadiusFloat());
            if (!(outerVdw > maxRadius)) continue;
            maxRadius = outerVdw;
        }
        return maxRadius;
    }

    boolean frankClicked(int x, int y) {
        Shape frankShape = this.shapes[19];
        if (frankShape == null) {
            return false;
        }
        return frankShape.wasClicked(x, y);
    }

    int findNearestAtomIndex(int x, int y) {
        this.closest.atom = null;
        for (int i = 0; i < this.shapes.length; ++i) {
            Shape shape = this.shapes[i];
            if (shape == null) continue;
            this.shapes[i].findNearestAtomIndex(x, y, this.closest);
            if (this.closest.atom != null) break;
        }
        int closestIndex = this.closest.atom == null ? -1 : this.closest.atom.atomIndex;
        this.closest.atom = null;
        return closestIndex;
    }

    BitSet findAtomsInRectangle(Rectangle rect) {
        this.bsFoundRectangle.and(this.bsEmpty);
        int i = this.atomCount;
        while (--i >= 0) {
            Atom atom = this.atoms[i];
            if (!rect.contains(atom.getScreenX(), atom.getScreenY())) continue;
            this.bsFoundRectangle.set(i);
        }
        return this.bsFoundRectangle;
    }

    BondIterator getBondIterator(short bondType, BitSet bsSelected) {
        return new SelectedBondIterator(bondType, bsSelected);
    }

    void initializeBspf() {
        if (this.bspf == null) {
            long timeBegin = 0L;
            timeBegin = System.currentTimeMillis();
            this.bspf = new Bspf(3);
            System.out.println("sequential bspt order");
            int i = this.atomCount;
            while (--i >= 0) {
                Atom atom = this.atoms[i];
                if (atom.isDeleted()) continue;
                this.bspf.addTuple(atom.modelIndex, atom);
            }
            long timeEnd = System.currentTimeMillis();
            System.out.println("time to build bspf=" + (timeEnd - timeBegin) + " ms");
            this.bspf.stats();
        }
    }

    private void clearBspf() {
        this.bspf = null;
    }

    int getBsptCount() {
        if (this.bspf == null) {
            this.initializeBspf();
        }
        return this.bspf.getBsptCount();
    }

    AtomIterator getWithinModelIterator(Atom atomCenter, float radius) {
        this.withinModelIterator.initialize(atomCenter.modelIndex, atomCenter, radius);
        return this.withinModelIterator;
    }

    AtomIterator getWithinAnyModelIterator(Atom atomCenter, float radius) {
        this.withinAnyModelIterator.initialize(atomCenter, radius);
        return this.withinAnyModelIterator;
    }

    void doAutobond() {
        if (this.viewer.getAutoBond() && this.getModelSetProperty("noautobond") == null && (this.bondCount == 0 || this.modelSetTypeName == "pdb" && this.bondCount < this.atomCount / 2)) {
            this.rebond(false);
        }
    }

    void rebond() {
        this.rebond(true);
    }

    void rebond(boolean deleteFirst) {
        if (deleteFirst) {
            this.deleteAllBonds();
        }
        if (this.maxBondingRadius == -2.1474836E9f) {
            this.findMaxRadii();
        }
        this.bondTolerance = this.viewer.getBondTolerance();
        this.minBondDistance = this.viewer.getMinBondDistance();
        this.minBondDistance2 = this.minBondDistance * this.minBondDistance;
        this.initializeBspf();
        long timeBegin = 0L;
        timeBegin = System.currentTimeMillis();
        int i = this.atomCount;
        while (--i >= 0) {
            Atom atom = this.atoms[i];
            float myBondingRadius = atom.getBondingRadiusFloat();
            if (myBondingRadius == 0.0f) continue;
            float searchRadius = myBondingRadius + this.maxBondingRadius + this.bondTolerance;
            SphereIterator iter = this.bspf.getSphereIterator(atom.modelIndex);
            iter.initializeHemisphere(atom, searchRadius);
            while (iter.hasMoreElements()) {
                int order;
                Atom atomNear = (Atom)iter.nextElement();
                if (atomNear == atom || (order = this.getBondOrder(atom, myBondingRadius, atomNear, atomNear.getBondingRadiusFloat(), iter.foundDistance2())) <= 0) continue;
                this.checkValencesAndBond(atom, atomNear, order);
            }
            iter.release();
        }
        long timeEnd = System.currentTimeMillis();
        System.out.println("Time to autoBond=" + (timeEnd - timeBegin));
    }

    private int getBondOrder(Atom atomA, float bondingRadiusA, Atom atomB, float bondingRadiusB, float distance2) {
        if (bondingRadiusA == 0.0f || bondingRadiusB == 0.0f) {
            return 0;
        }
        float maxAcceptable = bondingRadiusA + bondingRadiusB + this.bondTolerance;
        float maxAcceptable2 = maxAcceptable * maxAcceptable;
        if (distance2 < this.minBondDistance2) {
            return 0;
        }
        if (distance2 <= maxAcceptable2) {
            return 1;
        }
        return 0;
    }

    void checkValencesAndBond(Atom atomA, Atom atomB, int order) {
        if (atomA.getCurrentBondCount() > 20 || atomB.getCurrentBondCount() > 20) {
            System.out.println("maximum auto bond count reached");
            return;
        }
        int formalChargeA = atomA.getFormalCharge();
        if (formalChargeA != 0) {
            int formalChargeB = atomB.getFormalCharge();
            if (formalChargeA < 0 && formalChargeB < 0 || formalChargeA > 0 && formalChargeB > 0) {
                return;
            }
        }
        this.addBond(atomA.bondMutually(atomB, order, this));
    }

    void calcHbonds() {
        if (this.hbondsCalculated) {
            return;
        }
        this.hbondsCalculated = true;
        if (this.useRasMolHbondsCalculation) {
            if (this.mmset != null) {
                this.mmset.calcHydrogenBonds();
            }
            return;
        }
        this.initializeBspf();
        long timeBegin = 0L;
        timeBegin = System.currentTimeMillis();
        int i = this.atomCount;
        while (--i >= 0) {
            Atom atom = this.atoms[i];
            byte elementNumber = atom.elementNumber;
            if (elementNumber != 7 && elementNumber != 8) continue;
            SphereIterator iter = this.bspf.getSphereIterator(atom.modelIndex);
            iter.initializeHemisphere(atom, this.hbondMax);
            while (iter.hasMoreElements()) {
                Atom atomNear = (Atom)iter.nextElement();
                byte elementNumberNear = atomNear.elementNumber;
                if (elementNumberNear != 7 && elementNumberNear != 8 || atomNear == atom || iter.foundDistance2() < this.hbondMin2 || atom.isBonded(atomNear)) continue;
                this.addBond(atom.bondMutually(atomNear, 64, this));
                System.out.println("adding an hbond between " + atom.atomIndex + " & " + atomNear.atomIndex);
            }
            iter.release();
        }
        long timeEnd = System.currentTimeMillis();
        System.out.println("Time to hbond=" + (timeEnd - timeBegin));
    }

    void deleteAllBonds() {
        int i = this.bondCount;
        while (--i >= 0) {
            this.bonds[i].deleteAtomReferences();
            this.bonds[i] = null;
        }
        this.bondCount = 0;
    }

    void deleteBond(Bond bond) {
        int i = this.bondCount;
        while (--i >= 0) {
            if (this.bonds[i] != bond) continue;
            this.bonds[i].deleteAtomReferences();
            System.arraycopy(this.bonds, i + 1, this.bonds, i, this.bondCount - i - 1);
            --this.bondCount;
            this.bonds[this.bondCount] = null;
            return;
        }
    }

    void deleteCovalentBonds() {
        int indexNoncovalent = 0;
        for (int i = 0; i < this.bondCount; ++i) {
            Bond bond = this.bonds[i];
            if (!bond.isCovalent()) {
                if (i == indexNoncovalent) continue;
                this.bonds[indexNoncovalent++] = bond;
                this.bonds[i] = null;
                continue;
            }
            bond.deleteAtomReferences();
            this.bonds[i] = null;
        }
        this.bondCount = indexNoncovalent;
    }

    void deleteAtom(int atomIndex) {
        this.clearBspf();
        this.atoms[atomIndex].markDeleted();
    }

    float getMaxVanderwaalsRadius() {
        if (this.maxVanderwaalsRadius == -2.1474836E9f) {
            this.findMaxRadii();
        }
        return this.maxVanderwaalsRadius;
    }

    void setNotionalUnitcell(float[] notionalUnitcell) {
        if (notionalUnitcell != null && notionalUnitcell.length != 6) {
            System.out.println("notionalUnitcell length incorrect:" + notionalUnitcell);
        } else {
            this.notionalUnitcell = notionalUnitcell;
        }
    }

    void setPdbScaleMatrix(float[] pdbScaleMatrixArray) {
        if (pdbScaleMatrixArray == null) {
            return;
        }
        if (pdbScaleMatrixArray.length != 9) {
            System.out.println("pdbScaleMatrix.length != 9 :" + this.pdbScaleMatrix);
            return;
        }
        this.pdbScaleMatrix = new Matrix3f(pdbScaleMatrixArray);
        this.pdbScaleMatrixTranspose = new Matrix3f();
        this.pdbScaleMatrixTranspose.transpose(this.pdbScaleMatrix);
    }

    void setPdbScaleTranslate(float[] pdbScaleTranslate) {
        if (pdbScaleTranslate == null) {
            return;
        }
        if (pdbScaleTranslate.length != 3) {
            System.out.println("pdbScaleTranslate.length != 3 :" + pdbScaleTranslate);
            return;
        }
        this.pdbTranslateVector = new Vector3f(pdbScaleTranslate);
    }

    ShapeRenderer getRenderer(int shapeID) {
        return this.frameRenderer.getRenderer(shapeID, this.g3d);
    }

    void doUnitcellStuff() {
        if (this.notionalUnitcell != null) {
            this.constructFractionalMatrices();
            if (this.fileCoordinatesAreFractional) {
                this.convertFractionalToEuclidean();
            }
        }
    }

    void constructFractionalMatrices() {
        this.matrixNotional = new Matrix3f();
        this.calcNotionalMatrix(this.notionalUnitcell, this.matrixNotional);
        if (this.pdbScaleMatrix != null) {
            this.matrixEuclideanToFractional = new Matrix3f();
            this.matrixEuclideanToFractional.transpose(this.pdbScaleMatrix);
            this.matrixFractionalToEuclidean = new Matrix3f();
            this.matrixFractionalToEuclidean.invert(this.matrixEuclideanToFractional);
        } else {
            this.matrixFractionalToEuclidean = this.matrixNotional;
            this.matrixEuclideanToFractional = new Matrix3f();
            this.matrixEuclideanToFractional.invert(this.matrixFractionalToEuclidean);
        }
    }

    void calcNotionalMatrix(float[] notionalUnitcell, Matrix3f matrixNotional) {
        float gamma = notionalUnitcell[5];
        float beta = notionalUnitcell[4];
        float alpha = notionalUnitcell[3];
        float c = notionalUnitcell[2];
        float b = notionalUnitcell[1];
        float a = notionalUnitcell[0];
        float cosAlpha = (float)Math.cos((float)Math.PI / 180 * alpha);
        float cosBeta = (float)Math.cos((float)Math.PI / 180 * beta);
        float cosGamma = (float)Math.cos((float)Math.PI / 180 * gamma);
        float sinGamma = (float)Math.sin((float)Math.PI / 180 * gamma);
        matrixNotional.setColumn(0, a, 0.0f, 0.0f);
        matrixNotional.setColumn(1, b * cosGamma, b * sinGamma, 0.0f);
        float V = a * b * c * (float)Math.sqrt(1.0 - (double)(cosAlpha * cosAlpha) - (double)(cosBeta * cosBeta) - (double)(cosGamma * cosGamma) + 2.0 * (double)cosAlpha * (double)cosBeta * (double)cosGamma);
        matrixNotional.setColumn(2, c * cosBeta, c * (cosAlpha - cosBeta * cosGamma) / sinGamma, V / (a * b * sinGamma));
    }

    void putAtomsInsideUnitcell() {
        this.convertEuclideanToFractional();
        Point3f adjustment = this.findFractionalAdjustment();
        if (adjustment.x != 0.0f || adjustment.y != 0.0f || adjustment.z != 0.0f) {
            this.applyFractionalAdjustment(adjustment);
        }
        this.convertFractionalToEuclidean();
    }

    void convertEuclideanToFractional() {
        int i = this.atomCount;
        while (--i >= 0) {
            this.matrixEuclideanToFractional.transform(this.atoms[i].point3f);
        }
    }

    void convertFractionalToEuclidean() {
        int i = this.atomCount;
        while (--i >= 0) {
            this.matrixFractionalToEuclidean.transform(this.atoms[i].point3f);
        }
    }

    Point3f findFractionalAdjustment() {
        Point3f pointMin = new Point3f();
        Point3f pointMax = new Point3f();
        this.calcAtomsMinMax(pointMin, pointMax);
        pointMin.add(pointMax);
        pointMin.scale(0.5f);
        Point3f fractionalCenter = pointMin;
        System.out.println("fractionalCenter=" + fractionalCenter);
        Point3f adjustment = pointMax;
        adjustment.set((float)Math.floor(fractionalCenter.x), (float)Math.floor(fractionalCenter.y), (float)Math.floor(fractionalCenter.z));
        return adjustment;
    }

    void applyFractionalAdjustment(Point3f adjustment) {
        System.out.println("applyFractionalAdjustment(" + adjustment + ")");
        int i = this.atomCount;
        while (--i >= 0) {
            this.atoms[i].point3f.sub(adjustment);
        }
    }

    void calcAtomsMinMax(Point3f pointMin, Point3f pointMax) {
        float maxZ;
        float maxY;
        float maxX;
        Point3f pointT = this.atoms[0].point3f;
        float minX = maxX = pointT.x;
        float minY = maxY = pointT.y;
        float minZ = maxZ = pointT.z;
        int i = this.atomCount;
        while (--i > 0) {
            pointT = this.atoms[i].point3f;
            float t = pointT.x;
            if (t < minX) {
                minX = t;
            } else if (t > maxX) {
                maxX = t;
            }
            t = pointT.y;
            if (t < minY) {
                minY = t;
            } else if (t > maxY) {
                maxY = t;
            }
            t = pointT.z;
            if (t < minZ) {
                minZ = t;
                continue;
            }
            if (!(t > maxZ)) continue;
            maxZ = t;
        }
        pointMin.set(minX, minY, minZ);
        pointMax.set(maxX, maxY, maxZ);
    }

    void setLabel(String label, int atomIndex) {
    }

    void findElementsPresent() {
        this.elementsPresent = new BitSet();
        int i = this.atomCount;
        while (--i >= 0) {
            this.elementsPresent.set(this.atoms[i].elementNumber);
        }
    }

    BitSet getElementsPresentBitSet() {
        return this.elementsPresent;
    }

    void findGroupsPresent() {
        Group groupLast = null;
        this.groupsPresent = new BitSet();
        int i = this.atomCount;
        while (--i >= 0) {
            if (groupLast == this.atoms[i].group) continue;
            groupLast = this.atoms[i].group;
            this.groupsPresent.set(groupLast.getGroupID());
        }
    }

    void calcSelectedGroupsCount(BitSet bsSelected) {
        this.mmset.calcSelectedGroupsCount(bsSelected);
    }

    void calcSelectedMonomersCount(BitSet bsSelected) {
        this.mmset.calcSelectedMonomersCount(bsSelected);
    }

    void findMaxRadii() {
        int i = this.atomCount;
        while (--i >= 0) {
            float vdwRadius;
            Atom atom = this.atoms[i];
            float bondingRadius = atom.getBondingRadiusFloat();
            if (bondingRadius > this.maxBondingRadius) {
                this.maxBondingRadius = bondingRadius;
            }
            if (!((vdwRadius = atom.getVanderwaalsRadiusFloat()) > this.maxVanderwaalsRadius)) continue;
            this.maxVanderwaalsRadius = vdwRadius;
        }
    }

    BitSet getGroupsPresentBitSet() {
        return this.groupsPresent;
    }

    void calcBfactorRange() {
        if (!this.hasBfactorRange) {
            this.bfactor100Lo = this.bfactor100Hi = this.atoms[0].getBfactor100();
            int i = this.atomCount;
            while (--i > 0) {
                int bf = this.atoms[i].getBfactor100();
                if (bf < this.bfactor100Lo) {
                    this.bfactor100Lo = bf;
                    continue;
                }
                if (bf <= this.bfactor100Hi) continue;
                this.bfactor100Hi = bf;
            }
            this.hasBfactorRange = true;
        }
    }

    int getBfactor100Lo() {
        if (!this.hasBfactorRange) {
            this.calcBfactorRange();
        }
        return this.bfactor100Lo;
    }

    int getBfactor100Hi() {
        if (!this.hasBfactorRange) {
            this.calcBfactorRange();
        }
        return this.bfactor100Hi;
    }

    float getDistance(int atomIndexA, int atomIndexB) {
        return this.atoms[atomIndexA].point3f.distance(this.atoms[atomIndexB].point3f);
    }

    float getAngle(int atomIndexA, int atomIndexB, int atomIndexC) {
        if (this.vectorBA == null) {
            this.vectorBA = new Vector3f();
            this.vectorBC = new Vector3f();
        }
        Point3f pointA = this.atoms[atomIndexA].point3f;
        Point3f pointB = this.atoms[atomIndexB].point3f;
        Point3f pointC = this.atoms[atomIndexC].point3f;
        this.vectorBA.sub(pointA, pointB);
        this.vectorBC.sub(pointC, pointB);
        float angle = this.vectorBA.angle(this.vectorBC);
        float degrees = Frame.toDegrees(angle);
        return degrees;
    }

    float getTorsion(int atomIndexA, int atomIndexB, int atomIndexC, int atomIndexD) {
        return Frame.computeTorsion(this.atoms[atomIndexA].point3f, this.atoms[atomIndexB].point3f, this.atoms[atomIndexC].point3f, this.atoms[atomIndexD].point3f);
    }

    static float toDegrees(float angleRadians) {
        return angleRadians * 180.0f / (float)Math.PI;
    }

    static float computeTorsion(Point3f p1, Point3f p2, Point3f p3, Point3f p4) {
        float ci;
        float ijx = p1.x - p2.x;
        float ijy = p1.y - p2.y;
        float ijz = p1.z - p2.z;
        float kjx = p3.x - p2.x;
        float kjy = p3.y - p2.y;
        float kjz = p3.z - p2.z;
        float klx = p3.x - p4.x;
        float kly = p3.y - p4.y;
        float klz = p3.z - p4.z;
        float ax = ijy * kjz - ijz * kjy;
        float ay = ijz * kjx - ijx * kjz;
        float az = ijx * kjy - ijy * kjx;
        float cx = kjy * klz - kjz * kly;
        float cy = kjz * klx - kjx * klz;
        float cz = kjx * kly - kjy * klx;
        float ai2 = 1.0f / (ax * ax + ay * ay + az * az);
        float ci2 = 1.0f / (cx * cx + cy * cy + cz * cz);
        float cross = ax * cx + ay * cy + az * cz;
        float ai = (float)Math.sqrt(ai2);
        float denom = ai * (ci = (float)Math.sqrt(ci2));
        float cosang = cross * denom;
        if (cosang > 1.0f) {
            cosang = 1.0f;
        }
        if (cosang < -1.0f) {
            cosang = -1.0f;
        }
        float torsion = Frame.toDegrees((float)Math.acos(cosang));
        float dot = ijx * cx + ijy * cy + ijz * cz;
        float absDot = Math.abs(dot);
        torsion = dot / absDot > 0.0f ? torsion : -torsion;
        return torsion;
    }

    BitSet getGroupBitSet(int atomIndex) {
        BitSet bsGroup = new BitSet();
        this.atoms[atomIndex].group.selectAtoms(bsGroup);
        return bsGroup;
    }

    BitSet getChainBitSet(int atomIndex) {
        BitSet bsChain = new BitSet();
        this.atoms[atomIndex].group.chain.selectAtoms(bsChain);
        return bsChain;
    }

    void selectSeqcodeRange(int seqcodeA, int seqcodeB, BitSet bs) {
        this.mmset.selectSeqcodeRange(seqcodeA, seqcodeB, bs);
    }

    Bond[] addToBonds(Bond newBond, Bond[] oldBonds) {
        Bond[] newBonds;
        if (oldBonds == null) {
            if (this.numCached[1] > 0) {
                this.numCached[1] = this.numCached[1] - 1;
                newBonds = this.freeBonds[1][this.numCached[1]];
            } else {
                newBonds = new Bond[]{newBond};
            }
        } else {
            int oldLength = oldBonds.length;
            int newLength = oldLength + 1;
            if (newLength < 5 && this.numCached[newLength] > 0) {
                int n = newLength;
                int n2 = this.numCached[n] - 1;
                this.numCached[n] = n2;
                newBonds = this.freeBonds[newLength][n2];
            } else {
                newBonds = new Bond[newLength];
            }
            newBonds[oldLength] = newBond;
            int i = oldLength;
            while (--i >= 0) {
                newBonds[i] = oldBonds[i];
            }
            if (oldLength < 5 && this.numCached[oldLength] < 200) {
                int n = oldLength;
                int n3 = this.numCached[n];
                this.numCached[n] = n3 + 1;
                this.freeBonds[oldLength][n3] = oldBonds;
            }
        }
        return newBonds;
    }

    void freeBondsCache() {
        int i = 5;
        while (--i > 0) {
            this.numCached[i] = 0;
            Bond[][] bondsCache = this.freeBonds[i];
            int j = bondsCache.length;
            while (--j >= 0) {
                bondsCache[j] = null;
            }
        }
    }

    class WithinAnyModelIterator
    implements AtomIterator {
        int bsptIndex;
        Tuple center;
        float radius;
        SphereIterator bsptIter;

        WithinAnyModelIterator() {
        }

        void initialize(Tuple center, float radius) {
            Frame.this.initializeBspf();
            this.bsptIndex = Frame.this.bspf.getBsptCount();
            this.bsptIter = null;
            this.center = center;
            this.radius = radius;
        }

        public boolean hasNext() {
            while (this.bsptIter == null || !this.bsptIter.hasMoreElements()) {
                if (--this.bsptIndex < 0) {
                    this.bsptIter = null;
                    return false;
                }
                this.bsptIter = Frame.this.bspf.getSphereIterator(this.bsptIndex);
                this.bsptIter.initialize(this.center, this.radius);
            }
            return true;
        }

        public Atom next() {
            return (Atom)this.bsptIter.nextElement();
        }

        public void release() {
            this.bsptIter.release();
            this.bsptIter = null;
        }
    }

    class WithinModelIterator
    implements AtomIterator {
        int bsptIndex;
        Tuple center;
        float radius;
        SphereIterator bsptIter;

        WithinModelIterator() {
        }

        void initialize(int bsptIndex, Tuple center, float radius) {
            Frame.this.initializeBspf();
            this.bsptIndex = bsptIndex;
            this.bsptIter = Frame.this.bspf.getSphereIterator(bsptIndex);
            this.center = center;
            this.radius = radius;
            this.bsptIter.initialize(center, radius);
        }

        public boolean hasNext() {
            return this.bsptIter.hasMoreElements();
        }

        public Atom next() {
            return (Atom)this.bsptIter.nextElement();
        }

        public void release() {
            this.bsptIter.release();
            this.bsptIter = null;
        }
    }

    class SelectedBondIterator
    implements BondIterator {
        short bondType;
        int iBond;
        BitSet bsSelected;
        boolean bondSelectionModeOr;

        SelectedBondIterator(short bondType, BitSet bsSelected) {
            this.bondType = bondType;
            this.bsSelected = bsSelected;
            this.iBond = 0;
            this.bondSelectionModeOr = Frame.this.viewer.getBondSelectionModeOr();
        }

        public boolean hasNext() {
            while (this.iBond < Frame.this.bondCount) {
                Bond bond = Frame.this.bonds[this.iBond];
                if (this.bondType == -1 || (bond.order & this.bondType) != 0) {
                    boolean isSelected2;
                    boolean isSelected1;
                    if (!this.bondSelectionModeOr & (isSelected1 = this.bsSelected.get(bond.atom1.atomIndex)) & (isSelected2 = this.bsSelected.get(bond.atom2.atomIndex)) || this.bondSelectionModeOr & (isSelected1 | isSelected2)) {
                        return true;
                    }
                }
                ++this.iBond;
            }
            return false;
        }

        public Bond next() {
            return Frame.this.bonds[this.iBond++];
        }
    }
}

