/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import org.jmol.g3d.Graphics3D;
import org.jmol.viewer.Atom;
import org.jmol.viewer.Closest;
import org.jmol.viewer.Shape;

class Balls
extends Shape {
    static final int minimumPixelSelectionRadius = 6;

    Balls() {
    }

    void setSize(int size, BitSet bsSelected) {
        short mad = (short)size;
        Atom[] atoms = this.frame.atoms;
        int i = this.frame.atomCount;
        while (--i >= 0) {
            if (!bsSelected.get(i)) continue;
            atoms[i].setMadAtom(mad);
        }
    }

    void setProperty(String propertyName, Object value, BitSet bs) {
        int atomCount = this.frame.atomCount;
        Atom[] atoms = this.frame.atoms;
        if ("color" == propertyName) {
            short colix = Graphics3D.getColix(value);
            int i = atomCount;
            while (--i >= 0) {
                if (!bs.get(i)) continue;
                Atom atom = atoms[i];
                atom.setColixAtom(colix != 3 ? colix : this.viewer.getColixAtomPalette(atom, (String)value));
            }
            return;
        }
        if ("translucency" == propertyName) {
            int i = atomCount;
            while (--i >= 0) {
                if (!bs.get(i)) continue;
                atoms[i].setTranslucent(value == "translucent");
            }
            return;
        }
    }

    void findNearestAtomIndex(int x, int y, Closest closest) {
        if (this.frame.atomCount == 0) {
            return;
        }
        Atom champion = null;
        int i = this.frame.atomCount;
        while (--i >= 0) {
            Atom contender = this.frame.atoms[i];
            if (!contender.isCursorOnTopOfVisibleAtom(x, y, 6, champion)) continue;
            champion = contender;
        }
        closest.atom = champion;
    }
}

