/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.g3d;

import org.jmol.g3d.Graphics3D;
import org.jmol.g3d.Shade3D;

class Cylinder3D {
    Graphics3D g3d;
    private short colixA;
    private short colixB;
    private int[] shadesA;
    private boolean isScreenedA;
    private int[] shadesB;
    private boolean isScreenedB;
    private int xA;
    private int yA;
    private int zA;
    private int dxB;
    private int dyB;
    private int dzB;
    private boolean tEvenDiameter;
    private int diameter;
    private byte endcaps;
    private boolean tEndcapOpen;
    private int xEndcap;
    private int yEndcap;
    private int zEndcap;
    private int argbEndcap;
    private short colixEndcap;
    private int intensityEndcap;
    private float radius;
    private float radius2;
    private float cosTheta;
    private float cosPhi;
    private float sinPhi;
    int sampleCount;
    int rasterCount;
    float[] tRaster = new float[32];
    int[] xRaster = new int[32];
    int[] yRaster = new int[32];
    int[] zRaster = new int[32];
    int[] fp8IntensityUp = new int[32];
    int yMin;
    int yMax;
    int xMin;
    int xMax;
    int zXMin;
    int zXMax;
    int xTip;
    int yTip;
    int zTip;

    Cylinder3D(Graphics3D g3d) {
        this.g3d = g3d;
    }

    void render(short colixA, short colixB, byte endcaps, int diameter, int xA, int yA, int zA, int dxB, int dyB, int dzB) {
        this.diameter = diameter;
        if (diameter <= 1) {
            this.g3d.plotLineDelta(colixA, colixB, xA, yA, zA, dxB, dyB, dzB);
            return;
        }
        this.xA = xA;
        this.yA = yA;
        this.zA = zA;
        this.dxB = dxB;
        this.dyB = dyB;
        this.dzB = dzB;
        this.colixA = colixA;
        this.shadesA = this.g3d.getShades(this.colixA);
        this.colixB = colixB;
        this.shadesB = this.g3d.getShades(this.colixB);
        this.isScreenedA = (colixA & 0x4000) != 0;
        this.isScreenedB = (colixB & 0x4000) != 0;
        this.endcaps = endcaps;
        this.calcArgbEndcap(true);
        this.generateBaseEllipse();
        if (endcaps == 2) {
            this.renderFlatEndcap(true);
        }
        int i = this.rasterCount;
        while (--i >= 0) {
            this.plotRaster(i);
        }
        if (endcaps == 3) {
            this.renderSphericalEndcaps();
        }
    }

    void generateBaseEllipse() {
        this.tEvenDiameter = (this.diameter & 1) == 0;
        this.radius = (float)this.diameter / 2.0f;
        this.radius2 = this.radius * this.radius;
        int mag2d2 = this.dxB * this.dxB + this.dyB * this.dyB;
        if (mag2d2 == 0) {
            this.cosTheta = 1.0f;
            this.cosPhi = 1.0f;
            this.sinPhi = 0.0f;
        } else {
            float mag2d = (float)Math.sqrt(mag2d2);
            float mag3d = (float)Math.sqrt(mag2d2 + this.dzB * this.dzB);
            this.cosTheta = (float)this.dzB / mag3d;
            this.cosPhi = (float)this.dxB / mag2d;
            this.sinPhi = (float)this.dyB / mag2d;
        }
        this.calcRotatedPoint(0.0f, 0);
        this.calcRotatedPoint(0.5f, 1);
        this.calcRotatedPoint(1.0f, 2);
        this.rasterCount = 3;
        this.interpolate(0, 1);
        this.interpolate(1, 2);
    }

    void interpolate(int iLower, int iUpper) {
        int dy;
        int dx = this.xRaster[iUpper] - this.xRaster[iLower];
        if (dx < 0) {
            dx = -dx;
        }
        if ((dy = this.yRaster[iUpper] - this.yRaster[iLower]) < 0) {
            dy = -dy;
        }
        if (dx + dy <= 1) {
            return;
        }
        float tLower = this.tRaster[iLower];
        float tUpper = this.tRaster[iUpper];
        int iMid = this.allocRaster();
        int j = 4;
        while (--j >= 0) {
            float tMid = (tLower + tUpper) / 2.0f;
            this.calcRotatedPoint(tMid, iMid);
            if (this.xRaster[iMid] == this.xRaster[iLower] && this.yRaster[iMid] == this.yRaster[iLower]) {
                this.fp8IntensityUp[iLower] = (this.fp8IntensityUp[iLower] + this.fp8IntensityUp[iMid]) / 2;
                tLower = tMid;
                continue;
            }
            if (this.xRaster[iMid] == this.xRaster[iUpper] && this.yRaster[iMid] == this.yRaster[iUpper]) {
                this.fp8IntensityUp[iUpper] = (this.fp8IntensityUp[iUpper] + this.fp8IntensityUp[iMid]) / 2;
                tUpper = tMid;
                continue;
            }
            this.interpolate(iLower, iMid);
            this.interpolate(iMid, iUpper);
            return;
        }
        this.xRaster[iMid] = this.xRaster[iLower];
        this.yRaster[iMid] = this.yRaster[iUpper];
    }

    void plotRaster(int i) {
        int fp8Up = this.fp8IntensityUp[i];
        int x = this.xRaster[i];
        int y = this.yRaster[i];
        int z = this.zRaster[i];
        if (this.tEndcapOpen) {
            this.g3d.plotPixelClipped(this.argbEndcap, this.xEndcap + x, this.yEndcap + y, this.zEndcap - z - 1);
            this.g3d.plotPixelClipped(this.argbEndcap, this.xEndcap - x, this.yEndcap - y, this.zEndcap + z - 1);
        }
        this.g3d.plotLineDelta(this.shadesA, this.isScreenedA, this.shadesB, this.isScreenedB, fp8Up, this.xA + x, this.yA + y, this.zA - z, this.dxB, this.dyB, this.dzB);
        if (this.endcaps == 1) {
            this.g3d.plotLineDelta(this.shadesA[0], this.isScreenedA, this.shadesB[0], this.isScreenedB, this.xA - x, this.yA - y, this.zA + z, this.dxB, this.dyB, this.dzB);
        }
    }

    int[] realloc(int[] a) {
        int[] t = new int[a.length * 2];
        System.arraycopy(a, 0, t, 0, a.length);
        return t;
    }

    float[] realloc(float[] a) {
        float[] t = new float[a.length * 2];
        System.arraycopy(a, 0, t, 0, a.length);
        return t;
    }

    int allocRaster() {
        if (this.rasterCount == this.xRaster.length) {
            this.xRaster = this.realloc(this.xRaster);
            this.yRaster = this.realloc(this.yRaster);
            this.zRaster = this.realloc(this.zRaster);
            this.tRaster = this.realloc(this.tRaster);
            this.fp8IntensityUp = this.realloc(this.fp8IntensityUp);
        }
        return this.rasterCount++;
    }

    void calcRotatedPoint(float t, int i) {
        double zR;
        double yR;
        double yT;
        this.tRaster[i] = t;
        double tPI = (double)t * Math.PI;
        double xT = Math.sin(tPI) * (double)this.cosTheta;
        double xR = (double)this.radius * (xT * (double)this.cosPhi - (yT = Math.cos(tPI)) * (double)this.sinPhi);
        double z2 = (double)this.radius2 - (xR * xR + (yR = (double)this.radius * (xT * (double)this.sinPhi + yT * (double)this.cosPhi)) * yR);
        double d = zR = z2 > 0.0 ? Math.sqrt(z2) : 0.0;
        if (this.tEvenDiameter) {
            this.xRaster[i] = (int)(xR - 0.5);
            this.yRaster[i] = (int)(yR - 0.5);
        } else {
            this.xRaster[i] = (int)xR;
            this.yRaster[i] = (int)yR;
        }
        this.zRaster[i] = (int)(zR + 0.5);
        this.fp8IntensityUp[i] = Shade3D.calcFp8Intensity((float)xR, (float)yR, (float)zR);
    }

    void findMinMaxY() {
        this.yMin = this.yMax = this.yRaster[0];
        int i = this.rasterCount;
        while (--i > 0) {
            int y = this.yRaster[i];
            if (y < this.yMin) {
                this.yMin = y;
                continue;
            }
            if (y > this.yMax) {
                this.yMax = y;
                continue;
            }
            if ((y = -y) < this.yMin) {
                this.yMin = y;
                continue;
            }
            if (y <= this.yMax) continue;
            this.yMax = y;
        }
    }

    void findMinMaxX(int y) {
        this.xMin = Integer.MAX_VALUE;
        this.xMax = Integer.MIN_VALUE;
        int i = this.rasterCount;
        while (--i >= 0) {
            int x;
            if (this.yRaster[i] == y) {
                x = this.xRaster[i];
                if (x < this.xMin) {
                    this.xMin = x;
                    this.zXMin = this.zRaster[i];
                }
                if (x > this.xMax) {
                    this.xMax = x;
                    this.zXMax = this.zRaster[i];
                }
            }
            if (this.yRaster[i] != -y) continue;
            x = -this.xRaster[i];
            if (x < this.xMin) {
                this.xMin = x;
                this.zXMin = -this.zRaster[i];
            }
            if (x <= this.xMax) continue;
            this.xMax = x;
            this.zXMax = -this.zRaster[i];
        }
    }

    void renderFlatEndcap(boolean tCylinder) {
        if (this.dzB == 0 || !tCylinder && this.dzB < 0) {
            return;
        }
        int xT = this.xA;
        int yT = this.yA;
        int zT = this.zA;
        if (this.dzB < 0) {
            xT += this.dxB;
            yT += this.dyB;
            zT += this.dzB;
        }
        this.findMinMaxY();
        for (int y = this.yMin; y <= this.yMax; ++y) {
            this.findMinMaxX(y);
            int count = this.xMax - this.xMin + 1;
            this.g3d.setColorNoisy(this.colixEndcap, this.intensityEndcap);
            this.g3d.plotPixelsClipped(count, xT + this.xMin, yT + y, zT - this.zXMin - 1, zT - this.zXMax - 1, null, null);
        }
    }

    void renderSphericalEndcaps() {
        this.g3d.fillSphereCentered(this.colixA, this.diameter, this.xA, this.yA, this.zA + 1);
        this.g3d.fillSphereCentered(this.colixB, this.diameter, this.xA + this.dxB, this.yA + this.dyB, this.zA + this.dzB + 1);
    }

    void renderCone(short colix, byte endcap, int diameter, int xA, int yA, int zA, int xTip, int yTip, int zTip) {
        this.xTip = xTip;
        this.xA = xA;
        this.dxB = this.xTip - this.xA;
        this.yTip = yTip;
        this.yA = yA;
        this.dyB = this.yTip - this.yA;
        this.zTip = zTip;
        this.zA = zA;
        this.dzB = this.zTip - this.zA;
        this.colixA = colix;
        this.shadesA = this.g3d.getShades(colix);
        this.isScreenedA = (this.colixA & 0x4000) != 0;
        byte intensityTip = Shade3D.calcIntensity(this.dxB, this.dyB, -this.dzB);
        this.g3d.plotPixelClipped(this.shadesA[intensityTip], this.isScreenedA, xTip, yTip, zTip);
        this.diameter = diameter;
        if (diameter <= 1) {
            if (diameter == 1) {
                this.g3d.plotLineDelta(this.colixA, this.isScreenedA, this.colixA, this.isScreenedA, xA, yA, zA, this.dxB, this.dyB, this.dzB);
            }
            return;
        }
        this.endcaps = endcap;
        this.calcArgbEndcap(false);
        this.generateBaseEllipse();
        if (this.endcaps == 2) {
            this.renderFlatEndcap(false);
        }
        int i = this.rasterCount;
        while (--i >= 0) {
            this.plotRasterCone(i);
        }
    }

    void plotRasterCone(int i) {
        int x = this.xRaster[i];
        int y = this.yRaster[i];
        int z = this.zRaster[i];
        int xUp = this.xA + x;
        int yUp = this.yA + y;
        int zUp = this.zA - z;
        int xDn = this.xA - x;
        int yDn = this.yA - y;
        int zDn = this.zA + z;
        if (this.tEndcapOpen) {
            this.g3d.plotPixelClipped(this.argbEndcap, this.isScreenedA, xUp, yUp, zUp);
            this.g3d.plotPixelClipped(this.argbEndcap, this.isScreenedA, xDn, yDn, zDn);
        }
        int fp8Up = this.fp8IntensityUp[i];
        this.g3d.plotLineDelta(this.shadesA, this.isScreenedA, this.shadesA, this.isScreenedA, fp8Up, xUp, yUp, zUp, this.xTip - xUp, this.yTip - yUp, this.zTip - zUp);
        if (this.endcaps != 2 || this.dzB <= 0) {
            int argb = this.shadesA[0];
            this.g3d.plotLineDelta(argb, this.isScreenedA, argb, this.isScreenedA, xDn, yDn, zDn, this.xTip - xDn, this.yTip - yDn, this.zTip - zDn);
        }
    }

    void calcArgbEndcap(boolean tCylinder) {
        int[] shadesEndcap;
        this.tEndcapOpen = false;
        if (this.endcaps == 3 || this.dzB == 0 || !tCylinder && this.dzB < 0) {
            return;
        }
        this.xEndcap = this.xA;
        this.yEndcap = this.yA;
        this.zEndcap = this.zA;
        if (this.dzB >= 0) {
            this.intensityEndcap = Shade3D.calcIntensity(-this.dxB, -this.dyB, this.dzB);
            this.colixEndcap = this.colixA;
            shadesEndcap = this.shadesA;
        } else {
            this.intensityEndcap = Shade3D.calcIntensity(this.dxB, this.dyB, -this.dzB);
            this.colixEndcap = this.colixB;
            shadesEndcap = this.shadesB;
            this.xEndcap += this.dxB;
            this.yEndcap += this.dyB;
            this.zEndcap += this.dzB;
        }
        if (this.intensityEndcap > Graphics3D.intensitySpecularSurfaceLimit) {
            this.intensityEndcap = Graphics3D.intensitySpecularSurfaceLimit;
        }
        this.argbEndcap = shadesEndcap[this.intensityEndcap];
        this.tEndcapOpen = this.endcaps == 1;
    }
}

