/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.io.BufferedReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;

class QchemReader
extends AtomSetCollectionReader {
    int coordinateBase = 16;
    int frequencyLineSkipCount = 4;
    int atomCount;

    QchemReader() {
    }

    AtomSetCollection readAtomSetCollection(BufferedReader reader) throws Exception {
        this.atomSetCollection = new AtomSetCollection("qchem");
        try {
            String line;
            int lineNum = 0;
            while ((line = reader.readLine()) != null) {
                if (line.indexOf("Standard Nuclear Orientation") >= 0) {
                    this.readAtoms(reader);
                } else {
                    if (line.indexOf("VIBRATIONAL FREQUENCIES") >= 0) {
                        this.readFrequencies(reader);
                        break;
                    }
                    if (line.indexOf("Mulliken Net Atomic Charges") >= 0) {
                        this.readPartialCharges(reader);
                    }
                }
                ++lineNum;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.atomSetCollection.errorMessage = "Could not read file:" + ex;
            return this.atomSetCollection;
        }
        if (this.atomSetCollection.atomCount == 0) {
            this.atomSetCollection.errorMessage = "No atoms in file";
        }
        return this.atomSetCollection;
    }

    void readAtoms(BufferedReader reader) throws Exception {
        String line;
        this.atomSetCollection.discardPreviousAtoms();
        this.atomCount = 0;
        this.discardLines(reader, 2);
        while ((line = reader.readLine()) != null && !line.startsWith(" --")) {
            this.parseToken(line, 0, 5);
            String aname = this.parseToken(line, 6, 12);
            if (aname.indexOf("X") == 1) continue;
            float x = this.parseFloat(line, this.coordinateBase, this.coordinateBase + 13);
            float y = this.parseFloat(line, this.coordinateBase + 13, this.coordinateBase + 26);
            float z = this.parseFloat(line, this.coordinateBase + 26, this.coordinateBase + 39);
            if (Float.isNaN(x) || Float.isNaN(y) || Float.isNaN(z)) continue;
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.elementSymbol = aname;
            atom.x = x;
            atom.y = y;
            atom.z = z;
            ++this.atomCount;
        }
    }

    void readFrequencies(BufferedReader reader) throws Exception {
        String line;
        int modelNumber = 1;
        while ((line = reader.readLine()) != null && !line.startsWith(" Frequency:")) {
        }
        if (line == null) {
            return;
        }
        do {
            this.discardLines(reader, this.frequencyLineSkipCount);
            for (int i = 0; i < this.atomCount; ++i) {
                line = reader.readLine();
                int j = 0;
                int col = 12;
                while (j < 3) {
                    float x = this.parseFloat(line, col, col + 5);
                    float y = this.parseFloat(line, col + 7, col + 12);
                    float z = this.parseFloat(line, col + 14, col + 19);
                    this.recordAtomVector(modelNumber + j, i + 1, x, y, z);
                    ++j;
                    col += 23;
                }
            }
            this.discardLines(reader, 1);
            modelNumber += 3;
        } while ((line = reader.readLine()) != null && line.startsWith(" Frequency:"));
    }

    void recordAtomVector(int modelNumber, int atomCenterNumber, float x, float y, float z) {
        if (Float.isNaN(x) || Float.isNaN(y) || Float.isNaN(z)) {
            return;
        }
        if (atomCenterNumber <= 0 || atomCenterNumber > this.atomCount) {
            return;
        }
        if (atomCenterNumber == 1 && modelNumber > 1) {
            this.atomSetCollection.cloneFirstAtomSet();
        }
        Atom atom = this.atomSetCollection.atoms[(modelNumber - 1) * this.atomCount + atomCenterNumber - 1];
        atom.vectorX = x;
        atom.vectorY = y;
        atom.vectorZ = z;
    }

    void readPartialCharges(BufferedReader reader) throws Exception {
        String line;
        this.discardLines(reader, 3);
        for (int i = 0; i < this.atomCount && (line = reader.readLine()) != null; ++i) {
            this.atomSetCollection.atoms[i].partialCharge = this.parseFloat(line, 29, 38);
        }
    }
}

