/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.util.Hashtable;
import java.util.Properties;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.Bond;
import org.jmol.adapter.smarter.SmarterJmolAdapter;
import org.jmol.adapter.smarter.Structure;

class AtomSetCollection {
    String fileTypeName;
    String collectionName;
    Properties atomSetCollectionProperties = new Properties();
    static final String[] notionalUnitcellTags = new String[]{"a", "b", "c", "alpha", "beta", "gamma"};
    static final String[] dictRefUnitcellTags = new String[]{"cif:_cell_length_a", "cif:_cell_length_b", "cif:cell_length_c", "cif:_cell_length_alpha", "cif:_cell_length_beta", "cif:_cell_length_gamma"};
    int atomCount;
    Atom[] atoms = new Atom[256];
    int bondCount;
    Bond[] bonds = new Bond[256];
    int structureCount;
    Structure[] structures = new Structure[16];
    int atomSetCount;
    int currentAtomSetIndex = -1;
    int[] atomSetNumbers = new int[16];
    String[] atomSetNames = new String[16];
    int[] atomSetAtomCounts = new int[16];
    Properties[] atomSetProperties = new Properties[16];
    String errorMessage;
    String spaceGroup;
    float wavelength = Float.NaN;
    boolean coordinatesAreFractional;
    float[] notionalUnitcell;
    float[] pdbScaleMatrix;
    float[] pdbScaleTranslate;
    String[] pdbStructureRecords;
    Hashtable atomNameMap = new Hashtable();

    AtomSetCollection(String fileTypeName) {
        this.fileTypeName = fileTypeName;
        this.atomSetCollectionProperties.put("PATH_KEY", ".PATH");
        this.atomSetCollectionProperties.put("PATH_SEPARATOR", SmarterJmolAdapter.PATH_SEPARATOR);
    }

    protected void finalize() {
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void finish() {
        this.atoms = null;
        this.bonds = null;
        this.pdbScaleTranslate = null;
        this.pdbScaleMatrix = null;
        this.notionalUnitcell = null;
        this.pdbStructureRecords = null;
    }

    void freeze() {
        System.out.println("AtomSetCollection.freeze called");
        if (this.hasAlternateLocations()) {
            this.hackAlternateLocationDamage();
        }
    }

    void discardPreviousAtoms() {
        int i = this.atomCount;
        while (--i >= 0) {
            this.atoms[i] = null;
        }
        this.atomCount = 0;
        this.atomNameMap.clear();
        this.atomSetCount = 0;
        this.currentAtomSetIndex = -1;
        i = this.atomSetNumbers.length;
        while (--i >= 0) {
            this.atomSetAtomCounts[i] = 0;
            this.atomSetNumbers[i] = 0;
            this.atomSetNames[i] = null;
        }
    }

    Atom newCloneAtom(Atom atom) {
        Atom clone = atom.cloneAtom();
        this.addAtom(clone);
        return clone;
    }

    void cloneFirstAtomSet() {
        this.newAtomSet();
        int firstCount = this.atomSetAtomCounts[0];
        for (int i = 0; i < firstCount; ++i) {
            this.newCloneAtom(this.atoms[i]);
        }
    }

    void cloneLastAtomSet() {
        int count = this.getLastAtomSetAtomCount();
        int atomIndex = this.getLastAtomSetAtomIndex();
        this.newAtomSet();
        while (--count >= 0) {
            this.newCloneAtom(this.atoms[atomIndex]);
            ++atomIndex;
        }
    }

    int getFirstAtomSetAtomCount() {
        return this.atomSetAtomCounts[0];
    }

    int getLastAtomSetAtomCount() {
        return this.atomSetAtomCounts[this.currentAtomSetIndex];
    }

    int getLastAtomSetAtomIndex() {
        return this.atomCount - this.atomSetAtomCounts[this.currentAtomSetIndex];
    }

    Atom addNewAtom() {
        Atom atom = new Atom();
        this.addAtom(atom);
        return atom;
    }

    void addAtom(Atom atom) {
        if (this.atomCount == this.atoms.length) {
            this.atoms = (Atom[])AtomSetCollectionReader.doubleLength(this.atoms);
        }
        this.atoms[this.atomCount++] = atom;
        if (this.atomSetCount == 0) {
            this.atomSetCount = 1;
            this.currentAtomSetIndex = 0;
            this.atomSetNumbers[0] = 1;
        }
        atom.atomSetIndex = this.currentAtomSetIndex;
        int n = this.currentAtomSetIndex;
        this.atomSetAtomCounts[n] = this.atomSetAtomCounts[n] + 1;
    }

    void addAtomWithMappedName(Atom atom) {
        this.addAtom(atom);
        this.mapMostRecentAtomName();
    }

    Bond addNewBond(int atomIndex1, int atomIndex2) {
        return this.addNewBond(atomIndex1, atomIndex2, 1);
    }

    Bond addNewBond(String atomName1, String atomName2) {
        return this.addNewBond(atomName1, atomName2, 1);
    }

    Bond addNewBond(int atomIndex1, int atomIndex2, int order) {
        Bond bond = new Bond(atomIndex1, atomIndex2, order);
        this.addBond(bond);
        return bond;
    }

    Bond addNewBond(String atomName1, String atomName2, int order) {
        return this.addNewBond(this.getAtomNameIndex(atomName1), this.getAtomNameIndex(atomName2), order);
    }

    void addBond(Bond bond) {
        if (bond.atomIndex1 < 0 || bond.atomIndex2 < 0 || bond.order <= 0) {
            return;
        }
        if (this.bondCount == this.bonds.length) {
            this.bonds = (Bond[])AtomSetCollectionReader.setLength(this.bonds, this.bondCount + 1024);
        }
        this.bonds[this.bondCount++] = bond;
    }

    void addStructure(Structure structure) {
        if (this.structureCount == this.structures.length) {
            this.structures = (Structure[])AtomSetCollectionReader.setLength(this.structures, this.structureCount + 32);
        }
        this.structures[this.structureCount++] = structure;
    }

    void setCollectionName(String collectionName) {
        if (collectionName != null && (collectionName = collectionName.trim()).length() > 0) {
            this.collectionName = collectionName;
        }
    }

    void mapMostRecentAtomName() {
        if (this.atomCount > 0) {
            int index = this.atomCount - 1;
            String atomName = this.atoms[index].atomName;
            if (atomName != null) {
                this.atomNameMap.put(atomName, new Integer(this.atomCount - 1));
            }
        }
    }

    void mapAtomName(String atomName, int atomIndex) {
        this.atomNameMap.put(atomName, new Integer(atomIndex));
    }

    int getAtomNameIndex(String atomName) {
        int index = -1;
        Object value = this.atomNameMap.get(atomName);
        if (value != null) {
            index = (Integer)value;
        }
        return index;
    }

    void setAtomSetCollectionProperty(String key, String value) {
        this.atomSetCollectionProperties.put(key, value);
    }

    void newAtomSet() {
        this.currentAtomSetIndex = this.atomSetCount++;
        if (this.atomSetCount > this.atomSetNumbers.length) {
            this.atomSetNumbers = AtomSetCollectionReader.doubleLength(this.atomSetNumbers);
            this.atomSetNames = AtomSetCollectionReader.doubleLength(this.atomSetNames);
            this.atomSetAtomCounts = AtomSetCollectionReader.doubleLength(this.atomSetAtomCounts);
            this.atomSetProperties = (Properties[])AtomSetCollectionReader.doubleLength(this.atomSetProperties);
        }
        this.atomSetNumbers[this.currentAtomSetIndex] = this.atomSetCount;
    }

    void setAtomSetName(String atomSetName) {
        this.atomSetNames[this.currentAtomSetIndex] = atomSetName;
    }

    void setAtomSetName(String atomSetName, int atomSetIndex) {
        this.atomSetNames[atomSetIndex] = atomSetName;
    }

    void setAtomSetNames(String atomSetName, int n) {
        int idx = this.currentAtomSetIndex;
        while (--n >= 0) {
            this.setAtomSetName(atomSetName, idx);
            --idx;
        }
    }

    void setAtomSetNumber(int atomSetNumber) {
        this.atomSetNumbers[this.currentAtomSetIndex] = atomSetNumber;
    }

    void setAtomSetProperty(String key, String value) {
        this.setAtomSetProperty(key, value, this.currentAtomSetIndex);
    }

    void setAtomSetProperty(String key, String value, int atomSetIndex) {
        if (this.atomSetProperties[atomSetIndex] == null) {
            this.atomSetProperties[atomSetIndex] = new Properties();
        }
        this.atomSetProperties[atomSetIndex].put(key, value);
    }

    void setAtomSetProperties(String key, String value, int n) {
        int idx = this.currentAtomSetIndex;
        while (--n >= 0) {
            this.setAtomSetProperty(key, value, idx);
            --idx;
        }
    }

    void cloneLastAtomSetProperties() {
        this.cloneAtomSetProperties(this.currentAtomSetIndex - 1);
    }

    void cloneAtomSetProperties(int index) {
        this.atomSetProperties[this.currentAtomSetIndex] = (Properties)this.atomSetProperties[index].clone();
    }

    int getAtomSetNumber(int atomSetIndex) {
        return this.atomSetNumbers[atomSetIndex];
    }

    String getAtomSetName(int atomSetIndex) {
        return this.atomSetNames[atomSetIndex];
    }

    Properties getAtomSetProperties(int atomSetIndex) {
        return this.atomSetProperties[atomSetIndex];
    }

    boolean hasAlternateLocations() {
        int i = this.atomCount;
        while (--i >= 0) {
            if (this.atoms[i].alternateLocationID == '\u0000') continue;
            return true;
        }
        return false;
    }

    void hackAlternateLocationDamage() {
        System.out.println("hacking alternate location damage");
    }
}

