/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.cdk;

import java.io.BufferedReader;
import java.io.IOException;
import org.jmol.api.JmolAdapter;
import org.openscience.cdk.config.AtomTypeFactory;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.geometry.CrystalGeometryTools;
import org.openscience.cdk.interfaces.Atom;
import org.openscience.cdk.interfaces.AtomContainer;
import org.openscience.cdk.interfaces.Bond;
import org.openscience.cdk.interfaces.ChemFile;
import org.openscience.cdk.interfaces.ChemModel;
import org.openscience.cdk.interfaces.ChemObject;
import org.openscience.cdk.interfaces.ChemSequence;
import org.openscience.cdk.interfaces.Crystal;
import org.openscience.cdk.interfaces.SetOfMolecules;
import org.openscience.cdk.io.ChemObjectReader;
import org.openscience.cdk.io.ReaderFactory;
import org.openscience.cdk.tools.manipulator.ChemFileManipulator;
import org.openscience.cdk.tools.manipulator.ChemModelManipulator;
import org.openscience.cdk.tools.manipulator.SetOfMoleculesManipulator;

public class CdkJmolAdapter
extends JmolAdapter {
    public static final String ATOM_SET_INDEX = "org.jmol.adapter.cdk.ATOM_SET_INDEX";

    public CdkJmolAdapter(JmolAdapter.Logger logger) {
        super("CdkJmolAdapter", logger);
    }

    public Object openBufferedReader(String name, BufferedReader bufferedReader) {
        ChemFile chemFile = null;
        try {
            ChemObjectReader chemObjectReader = null;
            try {
                chemObjectReader = new ReaderFactory().createReader(bufferedReader);
            }
            catch (IOException ex) {
                return "Error determining input format: " + ex;
            }
            if (chemObjectReader == null) {
                return "unrecognized input format";
            }
            chemFile = (ChemFile)chemObjectReader.read(new org.openscience.cdk.ChemFile());
        }
        catch (CDKException ex) {
            return "Error reading input:" + ex;
        }
        if (chemFile == null) {
            return "unknown error reading file";
        }
        try {
            AtomTypeFactory factory = AtomTypeFactory.getInstance("jmol_atomtypes.txt");
            AtomContainer atomContainer = ChemFileManipulator.getAllInOneContainer((ChemFile)chemFile);
            Atom[] atoms = atomContainer.getAtoms();
            for (int i = 0; i < atoms.length; ++i) {
                try {
                    factory.configure(atoms[i]);
                    continue;
                }
                catch (CDKException exception) {
                    System.out.println("Could not configure atom: " + atoms[i]);
                }
            }
        }
        catch (ClassNotFoundException exception) {
            System.err.println(exception.toString());
            exception.printStackTrace();
        }
        catch (IOException exception) {
            System.err.println(exception.toString());
            exception.printStackTrace();
        }
        return chemFile;
    }

    public String getFileTypeName(Object clientFile) {
        AtomContainer atomContainer = this.getAtomContainer(clientFile);
        if (atomContainer != null && atomContainer.getAtomCount() > 0 && atomContainer.getAtomAt(0).getProperty("pdb.record") != null) {
            return "pdb";
        }
        return "other";
    }

    public String getAtomSetCollectionName(Object clientFile) {
        Object title;
        if (clientFile instanceof ChemObject && (title = ((ChemObject)clientFile).getProperty("Title")) != null) {
            System.out.println("Setting model name to title");
            return title.toString();
        }
        return null;
    }

    public int getAtomSetCount(Object clientFile) {
        if (clientFile instanceof AtomContainer) {
            return 1;
        }
        if (clientFile instanceof ChemFile) {
            ChemFile chemFile = (ChemFile)clientFile;
            ChemSequence chemSequence = chemFile.getChemSequence(0);
            if (chemSequence != null) {
                return chemSequence.getChemModelCount();
            }
            return super.getAtomSetCount(clientFile);
        }
        return 0;
    }

    private AtomContainer getAtomContainer(Object clientFile) {
        if (clientFile instanceof AtomContainer) {
            return (AtomContainer)clientFile;
        }
        if (clientFile instanceof ChemFile) {
            ChemFile chemFile = (ChemFile)clientFile;
            ChemSequence chemSequence = chemFile.getChemSequence(0);
            ChemModel[] chemModels = chemSequence.getChemModels();
            org.openscience.cdk.AtomContainer superMolecule = new org.openscience.cdk.AtomContainer();
            for (int i = 0; i < chemModels.length; ++i) {
                ChemModel chemModel = chemModels[i];
                ChemModelManipulator.setAtomProperties((ChemModel)chemModel, (Object)ATOM_SET_INDEX, (Object)new Integer(i));
                SetOfMolecules setOfMolecules = chemModel.getSetOfMolecules();
                Crystal crystal = chemModel.getCrystal();
                if (setOfMolecules != null) {
                    superMolecule.add(SetOfMoleculesManipulator.getAllInOneContainer((SetOfMolecules)setOfMolecules));
                    continue;
                }
                if (crystal != null) {
                    CrystalGeometryTools.fractionalToCartesian(crystal);
                    superMolecule.add(crystal);
                    continue;
                }
                System.out.println("Cannot display data in model");
                return null;
            }
            return superMolecule;
        }
        System.out.println("Cannot display data in model: clientFile must be instance of AtomContainer or ChemFile");
        return null;
    }

    public int getEstimatedAtomCount(Object clientFile) {
        return this.getAtomContainer(clientFile).getAtomCount();
    }

    public float[] getNotionalUnitcell(Object clientFile) {
        if (clientFile instanceof Crystal) {
            Crystal crystal = (Crystal)clientFile;
            double[] notional = CrystalGeometryTools.cartesianToNotional(crystal.getA(), crystal.getB(), crystal.getC());
            float[] fNotional = new float[6];
            for (int i = 0; i < 6; ++i) {
                fNotional[i] = (float)notional[i];
            }
            return fNotional;
        }
        return null;
    }

    public String getClientAtomStringProperty(Object clientAtom, String propertyName) {
        Object value = ((Atom)clientAtom).getProperty(propertyName);
        return value == null ? null : "" + value;
    }

    public JmolAdapter.AtomIterator getAtomIterator(Object clientFile) {
        return new AtomIterator(this.getAtomContainer(clientFile));
    }

    public JmolAdapter.BondIterator getBondIterator(Object clientFile) {
        return new BondIterator(this.getAtomContainer(clientFile));
    }

    class BondIterator
    extends JmolAdapter.BondIterator {
        AtomContainer atomContainer;
        Bond[] bonds;
        int ibond;
        Bond bond;
        Atom[] bondedAtoms;

        BondIterator(AtomContainer atomContainer) {
            super(CdkJmolAdapter.this);
            this.atomContainer = atomContainer;
            this.bonds = atomContainer.getBonds();
            this.ibond = 0;
        }

        public boolean hasNext() {
            if (this.ibond == this.bonds.length) {
                return false;
            }
            this.bond = this.bonds[this.ibond++];
            this.bondedAtoms = this.bond.getAtoms();
            return true;
        }

        public Object getAtomUniqueID1() {
            return this.bondedAtoms.length == 2 ? this.bondedAtoms[0] : null;
        }

        public Object getAtomUniqueID2() {
            return this.bondedAtoms.length == 2 ? this.bondedAtoms[1] : null;
        }

        public int getEncodedOrder() {
            return (int)this.bond.getOrder();
        }
    }

    class AtomIterator
    extends JmolAdapter.AtomIterator {
        AtomContainer atomContainer;
        int atomCount;
        int iatom;
        Atom atom;

        AtomIterator(AtomContainer atomContainer) {
            super(CdkJmolAdapter.this);
            this.atomContainer = atomContainer;
            this.atomCount = atomContainer.getAtomCount();
            this.iatom = 0;
        }

        public boolean hasNext() {
            if (this.iatom == this.atomCount) {
                return false;
            }
            this.atom = this.atomContainer.getAtomAt(this.iatom++);
            return true;
        }

        public Object getUniqueID() {
            return this.atom;
        }

        public int getElementNumber() {
            return this.atom.getAtomicNumber();
        }

        public String getElementSymbol() {
            return this.atom.getSymbol();
        }

        public float getX() {
            return (float)this.atom.getX3d();
        }

        public float getY() {
            return (float)this.atom.getY3d();
        }

        public float getZ() {
            return (float)this.atom.getZ3d();
        }

        public String getPdbAtomRecord() {
            return (String)this.atom.getProperty("pdb.record");
        }

        public String getAtomName() {
            return this.atom.getAtomTypeName();
        }

        public int getAtomSetIndex() {
            Integer indexInt = (Integer)this.atom.getProperty(CdkJmolAdapter.ATOM_SET_INDEX);
            System.out.println("indexInt: " + indexInt);
            if (indexInt != null) {
                return indexInt;
            }
            return super.getAtomSetIndex();
        }

        public char getChainID() {
            String chainID = (String)this.atom.getProperty("pdb.chainID");
            if (chainID != null && chainID.length() > 0) {
                return chainID.charAt(0);
            }
            return super.getChainID();
        }

        public String getGroup3() {
            String resName = (String)this.atom.getProperty("pdb.resName");
            if (resName != null && resName.length() > 0) {
                return resName.trim();
            }
            return super.getGroup3();
        }

        public int getSequenceNumber() {
            String sequenceNumber = (String)this.atom.getProperty("pdb.resSeq");
            if (sequenceNumber != null && sequenceNumber.length() > 0) {
                try {
                    int sequenceInt = Integer.parseInt(sequenceNumber);
                    return sequenceInt;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            return super.getSequenceNumber();
        }

        public char getInsertionCode() {
            String iCode = (String)this.atom.getProperty("pdb.iCode");
            if (iCode != null && iCode.length() > 0) {
                return iCode.charAt(0);
            }
            return super.getInsertionCode();
        }

        public Object getClientAtomReference() {
            return this.atom;
        }
    }
}

