/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.io.Reader;
import java.net.URL;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.Properties;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Vector3f;
import org.jmol.api.JmolAdapter;
import org.jmol.api.JmolSelectionListener;
import org.jmol.api.JmolStatusListener;
import org.jmol.api.JmolViewer;
import org.jmol.g3d.Font3D;
import org.jmol.g3d.Graphics3D;
import org.jmol.viewer.Atom;
import org.jmol.viewer.AtomIterator;
import org.jmol.viewer.Bond;
import org.jmol.viewer.BondIterator;
import org.jmol.viewer.ColorManager;
import org.jmol.viewer.Eval;
import org.jmol.viewer.FileManager;
import org.jmol.viewer.Frame;
import org.jmol.viewer.FrameRenderer;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.ModelManager;
import org.jmol.viewer.MouseManager;
import org.jmol.viewer.MouseManager10;
import org.jmol.viewer.MouseWrapper11;
import org.jmol.viewer.MouseWrapper14;
import org.jmol.viewer.PickingManager;
import org.jmol.viewer.RepaintManager;
import org.jmol.viewer.SelectionManager;
import org.jmol.viewer.StyleManager;
import org.jmol.viewer.TempManager;
import org.jmol.viewer.TransformManager;

public final class Viewer
extends JmolViewer {
    Component awtComponent;
    ColorManager colorManager;
    TransformManager transformManager;
    SelectionManager selectionManager;
    MouseManager mouseManager;
    FileManager fileManager;
    ModelManager modelManager;
    RepaintManager repaintManager;
    StyleManager styleManager;
    TempManager tempManager;
    PickingManager pickingManager;
    Eval eval;
    Graphics3D g3d;
    JmolAdapter modelAdapter;
    String strJavaVendor;
    String strJavaVersion;
    String strOSName;
    boolean jvm11orGreater = false;
    boolean jvm12orGreater = false;
    boolean jvm14orGreater = false;
    JmolStatusListener jmolStatusListener;
    final Hashtable imageCache = new Hashtable();
    static final float radiansPerDegree = (float)Math.PI / 180;
    static final float degreesPerRadian = 57.29578f;
    public static int MAXIMUM_ZOOM_PERCENTAGE = 5000;
    final Dimension dimScreen = new Dimension();
    final Rectangle rectClip = new Rectangle();
    boolean enableFullSceneAntialiasing = false;
    boolean selectionHaloEnabled = false;
    private boolean bondSelectionModeOr;
    boolean friedaSwitch = false;
    int motionEventNumber;
    boolean wasInMotion = false;
    boolean chainCaseSensitive = false;
    boolean ribbonBorder = false;
    boolean hideNameInPopup = false;
    int hoverAtomIndex = -1;
    int strandsCount = 5;
    boolean rasmolHydrogenSetting = true;
    boolean rasmolHeteroSetting = true;
    boolean debugScript = false;
    boolean testFlag1;
    boolean testFlag2;
    boolean testFlag3;
    boolean testFlag4;
    boolean tOversampleStopped;
    boolean tOversampleAlways;
    boolean greyscaleRendering;
    boolean disablePopupMenu;
    final AtomIterator nullAtomIterator = new NullAtomIterator();
    final BondIterator nullBondIterator = new NullBondIterator();

    Viewer(Component awtComponent, JmolAdapter modelAdapter) {
        this.awtComponent = awtComponent;
        this.modelAdapter = modelAdapter;
        this.strJavaVendor = System.getProperty("java.vendor");
        this.strOSName = System.getProperty("os.name");
        this.strJavaVersion = System.getProperty("java.version");
        this.jvm11orGreater = this.strJavaVersion.compareTo("1.1") >= 0 && (!this.strJavaVendor.startsWith("Netscape") || this.strJavaVersion.compareTo("1.1.5") > 0 || !"Mac OS".equals(this.strOSName));
        this.jvm12orGreater = this.strJavaVersion.compareTo("1.2") >= 0;
        this.jvm14orGreater = this.strJavaVersion.compareTo("1.4") >= 0;
        System.out.println("(C) 2005 The Jmol Development Team\nJmol Version 10.00.43  " + JmolConstants.date + "\njava.vendor:" + this.strJavaVendor + "\njava.version:" + this.strJavaVersion + "\nos.name:" + this.strOSName);
        this.g3d = new Graphics3D(awtComponent);
        this.colorManager = new ColorManager(this, this.g3d);
        this.transformManager = new TransformManager(this);
        this.selectionManager = new SelectionManager(this);
        this.mouseManager = this.jvm14orGreater ? MouseWrapper14.alloc(awtComponent, this) : (this.jvm11orGreater ? MouseWrapper11.alloc(awtComponent, this) : new MouseManager10(awtComponent, this));
        this.fileManager = new FileManager(this, modelAdapter);
        this.repaintManager = new RepaintManager(this);
        this.modelManager = new ModelManager(this, modelAdapter);
        this.styleManager = new StyleManager(this);
        this.tempManager = new TempManager(this);
        this.pickingManager = new PickingManager(this);
    }

    public static JmolViewer allocateViewer(Component awtComponent, JmolAdapter modelAdapter) {
        return new Viewer(awtComponent, modelAdapter);
    }

    public Component getAwtComponent() {
        return this.awtComponent;
    }

    public boolean handleOldJvm10Event(Event e) {
        return this.mouseManager.handleOldJvm10Event(e);
    }

    public void homePosition() {
        this.setCenter(null);
        this.transformManager.homePosition();
        this.refresh();
    }

    void flushCachedImages() {
        this.imageCache.clear();
        this.colorManager.flushCachedColors();
    }

    void logError(String strMsg) {
        System.out.println(strMsg);
    }

    void rotateXYBy(int xDelta, int yDelta) {
        this.transformManager.rotateXYBy(xDelta, yDelta);
        this.refresh();
    }

    void rotateZBy(int zDelta) {
        this.transformManager.rotateZBy(zDelta);
        this.refresh();
    }

    public void rotateFront() {
        this.transformManager.rotateFront();
        this.refresh();
    }

    public void rotateToX(float angleRadians) {
        this.transformManager.rotateToX(angleRadians);
        this.refresh();
    }

    public void rotateToY(float angleRadians) {
        this.transformManager.rotateToY(angleRadians);
        this.refresh();
    }

    public void rotateToZ(float angleRadians) {
        this.transformManager.rotateToZ(angleRadians);
        this.refresh();
    }

    public void rotateToX(int angleDegrees) {
        this.rotateToX((float)angleDegrees * ((float)Math.PI / 180));
    }

    public void rotateToY(int angleDegrees) {
        this.rotateToY((float)angleDegrees * ((float)Math.PI / 180));
    }

    void rotateToZ(int angleDegrees) {
        this.rotateToZ((float)angleDegrees * ((float)Math.PI / 180));
    }

    void rotateXRadians(float angleRadians) {
        this.transformManager.rotateXRadians(angleRadians);
        this.refresh();
    }

    void rotateYRadians(float angleRadians) {
        this.transformManager.rotateYRadians(angleRadians);
        this.refresh();
    }

    void rotateZRadians(float angleRadians) {
        this.transformManager.rotateZRadians(angleRadians);
        this.refresh();
    }

    void rotateXDegrees(float angleDegrees) {
        this.rotateXRadians(angleDegrees * ((float)Math.PI / 180));
    }

    void rotateYDegrees(float angleDegrees) {
        this.rotateYRadians(angleDegrees * ((float)Math.PI / 180));
    }

    void rotateZDegrees(float angleDegrees) {
        this.rotateZRadians(angleDegrees * ((float)Math.PI / 180));
    }

    void rotateZDegreesScript(float angleDegrees) {
        this.transformManager.rotateZRadiansScript(angleDegrees * ((float)Math.PI / 180));
        this.refresh();
    }

    void rotate(AxisAngle4f axisAngle) {
        this.transformManager.rotate(axisAngle);
        this.refresh();
    }

    void rotateAxisAngle(float x, float y, float z, float degrees) {
        this.transformManager.rotateAxisAngle(x, y, z, degrees);
    }

    void rotateTo(float xAxis, float yAxis, float zAxis, float degrees) {
        this.transformManager.rotateTo(xAxis, yAxis, zAxis, degrees);
    }

    void rotateTo(AxisAngle4f axisAngle) {
        this.transformManager.rotateTo(axisAngle);
    }

    void translateXYBy(int xDelta, int yDelta) {
        this.transformManager.translateXYBy(xDelta, yDelta);
        this.refresh();
    }

    void translateToXPercent(float percent) {
        this.transformManager.translateToXPercent(percent);
        this.refresh();
    }

    void translateToYPercent(float percent) {
        this.transformManager.translateToYPercent(percent);
        this.refresh();
    }

    void translateToZPercent(float percent) {
        this.transformManager.translateToZPercent(percent);
        this.refresh();
    }

    float getTranslationXPercent() {
        return this.transformManager.getTranslationXPercent();
    }

    float getTranslationYPercent() {
        return this.transformManager.getTranslationYPercent();
    }

    float getTranslationZPercent() {
        return this.transformManager.getTranslationZPercent();
    }

    void translateByXPercent(float percent) {
        this.translateToXPercent(this.getTranslationXPercent() + percent);
    }

    void translateByYPercent(float percent) {
        this.translateToYPercent(this.getTranslationYPercent() + percent);
    }

    void translateByZPercent(float percent) {
        this.translateToZPercent(this.getTranslationZPercent() + percent);
    }

    void translateCenterTo(int x, int y) {
        this.transformManager.translateCenterTo(x, y);
    }

    void zoomBy(int pixels) {
        this.transformManager.zoomBy(pixels);
        this.refresh();
    }

    public int getZoomPercent() {
        return this.transformManager.zoomPercent;
    }

    int getZoomPercentSetting() {
        return this.transformManager.zoomPercentSetting;
    }

    void zoomToPercent(int percent) {
        this.transformManager.zoomToPercent(percent);
        this.refresh();
    }

    void zoomByPercent(int percent) {
        this.transformManager.zoomByPercent(percent);
        this.refresh();
    }

    void setZoomEnabled(boolean zoomEnabled) {
        this.transformManager.setZoomEnabled(zoomEnabled);
        this.refresh();
    }

    boolean getZoomEnabled() {
        return this.transformManager.zoomEnabled;
    }

    boolean getSlabEnabled() {
        return this.transformManager.slabEnabled;
    }

    int getSlabPercentSetting() {
        return this.transformManager.slabPercentSetting;
    }

    void slabByPixels(int pixels) {
        this.transformManager.slabByPercentagePoints(pixels);
        this.refresh();
    }

    void depthByPixels(int pixels) {
        this.transformManager.depthByPercentagePoints(pixels);
        this.refresh();
    }

    void slabDepthByPixels(int pixels) {
        this.transformManager.slabDepthByPercentagePoints(pixels);
        this.refresh();
    }

    void slabToPercent(int percentSlab) {
        this.transformManager.slabToPercent(percentSlab);
        this.refresh();
    }

    void depthToPercent(int percentDepth) {
        this.transformManager.depthToPercent(percentDepth);
        this.refresh();
    }

    void setSlabEnabled(boolean slabEnabled) {
        this.transformManager.setSlabEnabled(slabEnabled);
        this.refresh();
    }

    void setModeSlab(int modeSlab) {
        this.transformManager.setModeSlab(modeSlab);
        this.refresh();
    }

    int getModeSlab() {
        return this.transformManager.modeSlab;
    }

    public Matrix4f getUnscaledTransformMatrix() {
        return this.transformManager.getUnscaledTransformMatrix();
    }

    void calcTransformMatrices() {
        this.transformManager.calcTransformMatrices();
    }

    Point3i transformPoint(Point3f pointAngstroms) {
        return this.transformManager.transformPoint(pointAngstroms);
    }

    Point3i transformPoint(Point3f pointAngstroms, Vector3f vibrationVector) {
        return this.transformManager.transformPoint(pointAngstroms, vibrationVector);
    }

    void transformPoint(Point3f pointAngstroms, Vector3f vibrationVector, Point3i pointScreen) {
        this.transformManager.transformPoint(pointAngstroms, vibrationVector, pointScreen);
    }

    void transformPoint(Point3f pointAngstroms, Point3i pointScreen) {
        this.transformManager.transformPoint(pointAngstroms, pointScreen);
    }

    void transformPoint(Point3f pointAngstroms, Point3f pointScreen) {
        this.transformManager.transformPoint(pointAngstroms, pointScreen);
    }

    void transformPoints(Point3f[] pointsAngstroms, Point3i[] pointsScreens) {
        this.transformManager.transformPoints(pointsAngstroms.length, pointsAngstroms, pointsScreens);
    }

    void transformVector(Vector3f vectorAngstroms, Vector3f vectorTransformed) {
        this.transformManager.transformVector(vectorAngstroms, vectorTransformed);
    }

    float getScalePixelsPerAngstrom() {
        return this.transformManager.scalePixelsPerAngstrom;
    }

    float scaleToScreen(int z, float sizeAngstroms) {
        return this.transformManager.scaleToScreen(z, sizeAngstroms);
    }

    short scaleToScreen(int z, int milliAngstroms) {
        return this.transformManager.scaleToScreen(z, milliAngstroms);
    }

    float scaleToPerspective(int z, float sizeAngstroms) {
        return this.transformManager.scaleToPerspective(z, sizeAngstroms);
    }

    void scaleFitToScreen() {
        this.transformManager.scaleFitToScreen();
    }

    public void setPerspectiveDepth(boolean perspectiveDepth) {
        this.transformManager.setPerspectiveDepth(perspectiveDepth);
        this.refresh();
    }

    public void setAxesOrientationRasmol(boolean axesOrientationRasmol) {
        this.transformManager.setAxesOrientationRasmol(axesOrientationRasmol);
        this.refresh();
    }

    public boolean getAxesOrientationRasmol() {
        return this.transformManager.axesOrientationRasmol;
    }

    public boolean getPerspectiveDepth() {
        return this.transformManager.perspectiveDepth;
    }

    void setCameraDepth(float depth) {
        this.transformManager.setCameraDepth(depth);
    }

    float getCameraDepth() {
        return this.transformManager.cameraDepth;
    }

    void checkCameraDistance() {
        if (this.transformManager.increaseRotationRadius) {
            this.modelManager.increaseRotationRadius(this.transformManager.getRotationRadiusIncrease());
        }
    }

    public void setScreenDimension(Dimension dim) {
        int height = dim.height;
        int width = dim.width;
        if (this.getStereoMode() == 1) {
            width = (width + 1) / 2;
        }
        if (this.dimScreen.width == width && this.dimScreen.height == height) {
            return;
        }
        this.dimScreen.width = width;
        this.dimScreen.height = height;
        this.transformManager.setScreenDimension(width, height);
        this.transformManager.scaleFitToScreen();
        this.g3d.setSize(this.dimScreen, this.enableFullSceneAntialiasing);
    }

    public int getScreenWidth() {
        return this.dimScreen.width;
    }

    public int getScreenHeight() {
        return this.dimScreen.height;
    }

    void setRectClip(Rectangle clip) {
        if (clip == null) {
            this.rectClip.y = 0;
            this.rectClip.x = 0;
            this.rectClip.setSize(this.dimScreen);
        } else {
            this.rectClip.setBounds(clip);
            if (this.rectClip.x < 0) {
                this.rectClip.x = 0;
            }
            if (this.rectClip.y < 0) {
                this.rectClip.y = 0;
            }
            if (this.rectClip.x + this.rectClip.width > this.dimScreen.width) {
                this.rectClip.width = this.dimScreen.width - this.rectClip.x;
            }
            if (this.rectClip.y + this.rectClip.height > this.dimScreen.height) {
                this.rectClip.height = this.dimScreen.height - this.rectClip.y;
            }
        }
    }

    void setScaleAngstromsPerInch(float angstromsPerInch) {
        this.transformManager.setScaleAngstromsPerInch(angstromsPerInch);
    }

    void setSlabAndDepthValues(int slabValue, int depthValue) {
        this.g3d.setSlabAndDepthValues(slabValue, depthValue);
    }

    public void setVibrationPeriod(float period) {
        this.transformManager.setVibrationPeriod(period);
    }

    void setVibrationT(float t) {
        this.transformManager.setVibrationT(t);
    }

    float getVibrationRadians() {
        return this.transformManager.vibrationRadians;
    }

    void setSpinX(int value) {
        this.transformManager.setSpinX(value);
    }

    int getSpinX() {
        return this.transformManager.spinX;
    }

    void setSpinY(int value) {
        this.transformManager.setSpinY(value);
    }

    int getSpinY() {
        return this.transformManager.spinY;
    }

    void setSpinZ(int value) {
        this.transformManager.setSpinZ(value);
    }

    int getSpinZ() {
        return this.transformManager.spinZ;
    }

    void setSpinFps(int value) {
        this.transformManager.setSpinFps(value);
    }

    int getSpinFps() {
        return this.transformManager.spinFps;
    }

    void setSpinOn(boolean spinOn) {
        this.transformManager.setSpinOn(spinOn);
    }

    boolean getSpinOn() {
        return this.transformManager.spinOn;
    }

    String getOrientationText() {
        return this.transformManager.getOrientationText();
    }

    void getAxisAngle(AxisAngle4f axisAngle) {
        this.transformManager.getAxisAngle(axisAngle);
    }

    String getTransformText() {
        return this.transformManager.getTransformText();
    }

    void setRotation(Matrix3f matrixRotation) {
        this.transformManager.setRotation(matrixRotation);
    }

    void getRotation(Matrix3f matrixRotation) {
        this.transformManager.getRotation(matrixRotation);
    }

    public void setModeAtomColorProfile(String palette) {
        this.colorManager.setPaletteDefault(palette);
        this.refresh();
    }

    String getModeAtomColorProfile() {
        return this.colorManager.paletteDefault;
    }

    void setDefaultColors(String colorScheme) {
        this.colorManager.setDefaultColors(colorScheme);
    }

    public void setColorSelection(Color c) {
        this.colorManager.setColorSelection(c);
        this.refresh();
    }

    Color getColorSelection() {
        return this.colorManager.getColorSelection();
    }

    short getColixSelection() {
        return this.colorManager.getColixSelection();
    }

    void setColorRubberband(Color color) {
        this.colorManager.setColorRubberband(color);
    }

    short getColixRubberband() {
        return this.colorManager.colixRubberband;
    }

    public void setColorLabel(Color color) {
        this.colorManager.setColorLabel(color);
        this.setShapeColorProperty(4, color);
        this.refresh();
    }

    void setElementColor(int elementNumber, Color color) {
        this.colorManager.setElementColor(elementNumber, color);
    }

    void setColorDotsSaddle(Color color) {
        this.colorManager.setColorDotsSaddle(color);
        this.setShapeProperty(7, "dotssaddle", color);
    }

    short getColixDotsSaddle() {
        return this.colorManager.colixDotsSaddle;
    }

    void setColorDotsConvex(Color color) {
        this.colorManager.setColorDotsConvex(color);
        this.setShapeProperty(7, "dotsconvex", color);
    }

    short getColixDotsConvex() {
        return this.colorManager.colixDotsConvex;
    }

    void setColorDotsConcave(Color color) {
        this.colorManager.setColorDotsConcave(color);
        this.setShapeProperty(7, "dotsconcave", color);
    }

    short getColixDotsConcave() {
        return this.colorManager.colixDotsConcave;
    }

    public Color getColorLabel() {
        return this.colorManager.colorLabel;
    }

    short getColixLabel() {
        return this.colorManager.colixLabel;
    }

    public void setColorMeasurement(Color c) {
        this.colorManager.setColorMeasurement(c);
        this.refresh();
    }

    public Color getColorMeasurement() {
        return this.colorManager.colorDistance;
    }

    void setColorDistance(Color c) {
        this.colorManager.setColorDistance(c);
        this.refresh();
    }

    Color getColorDistance() {
        return this.colorManager.colorDistance;
    }

    short getColixDistance() {
        return this.colorManager.colixDistance;
    }

    void setColorAngle(Color c) {
        this.colorManager.setColorAngle(c);
        this.refresh();
    }

    Color getColorAngle() {
        return this.colorManager.colorAngle;
    }

    short getColixAngle() {
        return this.colorManager.colixAngle;
    }

    void setColorTorsion(Color c) {
        this.colorManager.setColorTorsion(c);
        this.refresh();
    }

    Color getColorTorsion() {
        return this.colorManager.colorTorsion;
    }

    short getColixTorsion() {
        return this.colorManager.colixTorsion;
    }

    public void setColorVector(Color c) {
        this.colorManager.setColorVector(c);
        this.refresh();
    }

    public Color getColorVector() {
        return this.colorManager.colorVector;
    }

    short getColixVector() {
        return this.colorManager.colixVector;
    }

    float getVectorScale() {
        return this.transformManager.vectorScale;
    }

    public void setVectorScale(float scale) {
        this.transformManager.setVectorScale(scale);
    }

    public void setVibrationScale(float scale) {
        this.transformManager.setVibrationScale(scale);
    }

    float getVibrationScale() {
        return this.transformManager.vibrationScale;
    }

    public void setColorBackground(Color bg) {
        this.colorManager.setColorBackground(bg);
        this.refresh();
    }

    public Color getColorBackground() {
        return this.colorManager.colorBackground;
    }

    public void setColorBackground(String colorName) {
        this.colorManager.setColorBackground(colorName);
        this.refresh();
    }

    Color getColorFromString(String colorName) {
        return Graphics3D.getColorFromString(colorName);
    }

    void setSpecular(boolean specular) {
        this.colorManager.setSpecular(specular);
    }

    boolean getSpecular() {
        return this.colorManager.getSpecular();
    }

    void setSpecularPower(int specularPower) {
        this.colorManager.setSpecularPower(specularPower);
    }

    void setAmbientPercent(int ambientPercent) {
        this.colorManager.setAmbientPercent(ambientPercent);
    }

    void setDiffusePercent(int diffusePercent) {
        this.colorManager.setDiffusePercent(diffusePercent);
    }

    void setSpecularPercent(int specularPercent) {
        this.colorManager.setSpecularPercent(specularPercent);
    }

    void setLightsourceZ(float z) {
        this.colorManager.setLightsourceZ(z);
    }

    short getColixAtom(Atom atom) {
        return this.colorManager.getColixAtom(atom);
    }

    short getColixAtomPalette(Atom atom, String palette) {
        return this.colorManager.getColixAtomPalette(atom, palette);
    }

    short getColixHbondType(short order) {
        return this.colorManager.getColixHbondType(order);
    }

    short getColixAxes() {
        return this.colorManager.colixAxes;
    }

    short getColixAxesText() {
        return this.colorManager.colixAxesText;
    }

    short getColixFromPalette(float val, float rangeMin, float rangeMax, String palette) {
        return this.colorManager.getColixFromPalette(val, rangeMin, rangeMax, palette);
    }

    void addSelection(int atomIndex) {
        this.selectionManager.addSelection(atomIndex);
        this.refresh();
    }

    void addSelection(BitSet set) {
        this.selectionManager.addSelection(set);
        this.refresh();
    }

    void toggleSelection(int atomIndex) {
        this.selectionManager.toggleSelection(atomIndex);
        this.refresh();
    }

    void setSelection(int atomIndex) {
        this.selectionManager.setSelection(atomIndex);
        this.refresh();
    }

    boolean isSelected(int atomIndex) {
        return this.selectionManager.isSelected(atomIndex);
    }

    boolean hasSelectionHalo(int atomIndex) {
        return this.selectionHaloEnabled && !this.repaintManager.wireframeRotating && this.selectionManager.isSelected(atomIndex);
    }

    public void setSelectionHaloEnabled(boolean selectionHaloEnabled) {
        if (this.selectionHaloEnabled != selectionHaloEnabled) {
            this.selectionHaloEnabled = selectionHaloEnabled;
            this.refresh();
        }
    }

    boolean getSelectionHaloEnabled() {
        return this.selectionHaloEnabled;
    }

    void setBondSelectionModeOr(boolean bondSelectionModeOr) {
        this.bondSelectionModeOr = bondSelectionModeOr;
        this.refresh();
    }

    boolean getBondSelectionModeOr() {
        return this.bondSelectionModeOr;
    }

    public void selectAll() {
        this.selectionManager.selectAll();
        this.refresh();
    }

    public void clearSelection() {
        this.selectionManager.clearSelection();
        this.refresh();
    }

    public void setSelectionSet(BitSet set) {
        this.selectionManager.setSelectionSet(set);
        this.refresh();
    }

    void toggleSelectionSet(BitSet set) {
        this.selectionManager.toggleSelectionSet(set);
        this.refresh();
    }

    void invertSelection() {
        this.selectionManager.invertSelection();
    }

    void excludeSelectionSet(BitSet set) {
        this.selectionManager.excludeSelectionSet(set);
    }

    public BitSet getSelectionSet() {
        return this.selectionManager.bsSelection;
    }

    int getSelectionCount() {
        return this.selectionManager.getSelectionCount();
    }

    public void addSelectionListener(JmolSelectionListener listener) {
        this.selectionManager.addListener(listener);
    }

    public void removeSelectionListener(JmolSelectionListener listener) {
        this.selectionManager.addListener(listener);
    }

    public void setModeMouse(int modeMouse) {
    }

    Rectangle getRubberBandSelection() {
        return this.mouseManager.getRubberBand();
    }

    void popupMenu(int x, int y) {
        if (!this.disablePopupMenu && this.jmolStatusListener != null) {
            this.jmolStatusListener.handlePopupMenu(x, y);
        }
    }

    int getCursorX() {
        return this.mouseManager.xCurrent;
    }

    int getCursorY() {
        return this.mouseManager.yCurrent;
    }

    public void setAppletContext(URL documentBase, URL codeBase, String appletProxy) {
        this.fileManager.setAppletContext(documentBase, codeBase, appletProxy);
    }

    Object getInputStreamOrErrorMessageFromName(String name) {
        return this.fileManager.getInputStreamOrErrorMessageFromName(name);
    }

    Object getUnzippedBufferedReaderOrErrorMessageFromName(String name) {
        return this.fileManager.getUnzippedBufferedReaderOrErrorMessageFromName(name);
    }

    public void openFile(String name) {
        this.clear();
        long timeBegin = System.currentTimeMillis();
        this.fileManager.openFile(name);
        long ms = System.currentTimeMillis() - timeBegin;
        System.out.println("openFile(" + name + ") " + ms + " ms");
    }

    public void openStringInline(String strModel) {
        this.clear();
        this.fileManager.openStringInline(strModel);
        this.getOpenFileError();
    }

    public void openReader(String fullPathName, String name, Reader reader) {
        this.clear();
        this.fileManager.openReader(fullPathName, name, reader);
        this.getOpenFileError();
    }

    public String getOpenFileError() {
        String errorMsg = this.getOpenFileError1();
        return errorMsg;
    }

    String getOpenFileError1() {
        String fullPathName = this.fileManager.getFullPathName();
        String fileName = this.fileManager.getFileName();
        Object clientFile = this.fileManager.waitForClientFileOrErrorMessage();
        if (clientFile instanceof String || clientFile == null) {
            String errorMsg = (String)clientFile;
            this.notifyFileNotLoaded(fullPathName, errorMsg);
            return errorMsg;
        }
        this.openClientFile(fullPathName, fileName, clientFile);
        this.notifyFileLoaded(fullPathName, fileName, this.modelManager.getModelSetName(), clientFile);
        return null;
    }

    String getCurrentFileAsString() {
        String pathName = this.modelManager.getModelSetPathName();
        if (pathName == null) {
            return null;
        }
        return this.fileManager.getFileAsString(pathName);
    }

    String getFileAsString(String pathName) {
        return this.fileManager.getFileAsString(pathName);
    }

    public void openClientFile(String fullPathName, String fileName, Object clientFile) {
        this.pushHoldRepaint();
        this.modelManager.setClientFile(fullPathName, fileName, clientFile);
        this.homePosition();
        this.selectAll();
        if (this.eval != null) {
            this.eval.clearDefinitionsAndLoadPredefined();
        }
        if (this.modelManager.hasVibrationVectors()) {
            this.setShapeSize(5, 1);
        }
        this.setFrankOn(this.styleManager.frankOn);
        this.popHoldRepaint();
    }

    void clear() {
        this.repaintManager.clearAnimation();
        this.transformManager.clearVibration();
        this.modelManager.setClientFile(null, null, null);
        this.selectionManager.clearSelection();
        this.clearMeasurements();
        this.notifyFileLoaded(null, null, null, null);
        this.refresh();
    }

    public String getModelSetName() {
        return this.modelManager.getModelSetName();
    }

    public String getModelSetFileName() {
        return this.modelManager.getModelSetFileName();
    }

    public String getModelSetPathName() {
        return this.modelManager.getModelSetPathName();
    }

    String getModelSetTypeName() {
        return this.modelManager.getModelSetTypeName();
    }

    public boolean haveFrame() {
        return this.modelManager.frame != null;
    }

    Object getClientFile() {
        return null;
    }

    String getClientAtomStringProperty(Object clientAtomReference, String propertyName) {
        return this.modelManager.getClientAtomStringProperty(clientAtomReference, propertyName);
    }

    JmolAdapter getExportJmolAdapter() {
        return this.modelManager.getExportJmolAdapter();
    }

    Frame getFrame() {
        return this.modelManager.getFrame();
    }

    public float getRotationRadius() {
        return this.modelManager.getRotationRadius();
    }

    Point3f getRotationCenter() {
        return this.modelManager.getRotationCenter();
    }

    Point3f getBoundBoxCenter() {
        return this.modelManager.getBoundBoxCenter();
    }

    Vector3f getBoundBoxCornerVector() {
        return this.modelManager.getBoundBoxCornerVector();
    }

    int getBoundBoxCenterX() {
        return this.dimScreen.width / 2;
    }

    int getBoundBoxCenterY() {
        return this.dimScreen.height / 2;
    }

    public int getModelCount() {
        return this.modelManager.getModelCount();
    }

    public Properties getModelSetProperties() {
        return this.modelManager.getModelSetProperties();
    }

    public int getModelNumber(int modelIndex) {
        return this.modelManager.getModelNumber(modelIndex);
    }

    public String getModelName(int modelIndex) {
        return this.modelManager.getModelName(modelIndex);
    }

    public Properties getModelProperties(int modelIndex) {
        return this.modelManager.getModelProperties(modelIndex);
    }

    public String getModelProperty(int modelIndex, String propertyName) {
        return this.modelManager.getModelProperty(modelIndex, propertyName);
    }

    int getModelNumberIndex(int modelNumber) {
        return this.modelManager.getModelNumberIndex(modelNumber);
    }

    boolean modelSetHasVibrationVectors() {
        return this.modelManager.modelSetHasVibrationVectors();
    }

    public boolean modelHasVibrationVectors(int modelIndex) {
        return this.modelManager.modelHasVibrationVectors(modelIndex);
    }

    public int getChainCount() {
        return this.modelManager.getChainCount();
    }

    public int getGroupCount() {
        return this.modelManager.getGroupCount();
    }

    public int getPolymerCount() {
        return this.modelManager.getPolymerCount();
    }

    public int getPolymerCountInModel(int modelIndex) {
        return this.modelManager.getPolymerCountInModel(modelIndex);
    }

    public int getAtomCount() {
        return this.modelManager.getAtomCount();
    }

    public int getBondCount() {
        return this.modelManager.getBondCount();
    }

    boolean frankClicked(int x, int y) {
        return this.modelManager.frankClicked(x, y);
    }

    int findNearestAtomIndex(int x, int y) {
        return this.modelManager.findNearestAtomIndex(x, y);
    }

    BitSet findAtomsInRectangle(Rectangle rectRubberBand) {
        return this.modelManager.findAtomsInRectangle(rectRubberBand);
    }

    void setCenter(Point3f center) {
        this.modelManager.setRotationCenter(center);
        this.refresh();
    }

    Point3f getCenter() {
        return this.modelManager.getRotationCenter();
    }

    void setCenter(String relativeTo, float x, float y, float z) {
        this.modelManager.setRotationCenter(relativeTo, x, y, z);
        this.scaleFitToScreen();
    }

    void setCenterBitSet(BitSet bsCenter) {
        this.modelManager.setCenterBitSet(bsCenter);
        if (!this.friedaSwitch) {
            this.scaleFitToScreen();
        }
        this.refresh();
    }

    boolean getFriedaSwitch() {
        return this.friedaSwitch;
    }

    void setFriedaSwitch(boolean friedaSwitch) {
        this.friedaSwitch = friedaSwitch;
    }

    public void setCenterSelected() {
        this.setCenterBitSet(this.selectionManager.bsSelection);
    }

    public void rebond() {
        this.modelManager.rebond();
        this.refresh();
    }

    public void setBondTolerance(float bondTolerance) {
        this.modelManager.setBondTolerance(bondTolerance);
        this.refresh();
    }

    public float getBondTolerance() {
        return this.modelManager.bondTolerance;
    }

    public void setMinBondDistance(float minBondDistance) {
        this.modelManager.setMinBondDistance(minBondDistance);
        this.refresh();
    }

    public float getMinBondDistance() {
        return this.modelManager.minBondDistance;
    }

    public void setAutoBond(boolean ab) {
        this.modelManager.setAutoBond(ab);
        this.refresh();
    }

    public boolean getAutoBond() {
        return this.modelManager.autoBond;
    }

    void setSolventProbeRadius(float radius) {
        this.modelManager.setSolventProbeRadius(radius);
    }

    float getSolventProbeRadius() {
        return this.modelManager.solventProbeRadius;
    }

    float getCurrentSolventProbeRadius() {
        return this.modelManager.solventOn ? this.modelManager.solventProbeRadius : 0.0f;
    }

    void setSolventOn(boolean solventOn) {
        this.modelManager.setSolventOn(solventOn);
    }

    boolean getSolventOn() {
        return this.modelManager.solventOn;
    }

    int getAtomIndexFromAtomNumber(int atomNumber) {
        return this.modelManager.getAtomIndexFromAtomNumber(atomNumber);
    }

    public BitSet getElementsPresentBitSet() {
        return this.modelManager.getElementsPresentBitSet();
    }

    public BitSet getGroupsPresentBitSet() {
        return this.modelManager.getGroupsPresentBitSet();
    }

    void calcSelectedGroupsCount() {
        this.modelManager.calcSelectedGroupsCount(this.selectionManager.bsSelection);
    }

    void calcSelectedMonomersCount() {
        this.modelManager.calcSelectedMonomersCount(this.selectionManager.bsSelection);
    }

    public void clearMeasurements() {
        this.setShapeProperty(6, "clear", null);
        this.refresh();
    }

    public int getMeasurementCount() {
        int count = this.getShapePropertyAsInt(6, "count");
        return count <= 0 ? 0 : count;
    }

    public String getMeasurementStringValue(int i) {
        return "" + this.getShapeProperty(6, "stringValue", i);
    }

    public int[] getMeasurementCountPlusIndices(int i) {
        return (int[])this.getShapeProperty(6, "countPlusIndices", i);
    }

    void setPendingMeasurement(int[] atomCountPlusIndices) {
        this.setShapeProperty(6, "pending", atomCountPlusIndices);
    }

    void defineMeasurement(int[] atomCountPlusIndices) {
        this.setShapeProperty(6, "define", atomCountPlusIndices);
    }

    public void deleteMeasurement(int i) {
        this.setShapeProperty(6, "delete", new Integer(i));
    }

    void deleteMeasurement(int[] atomCountPlusIndices) {
        this.setShapeProperty(6, "delete", atomCountPlusIndices);
    }

    void toggleMeasurement(int[] atomCountPlusIndices) {
        this.setShapeProperty(6, "toggle", atomCountPlusIndices);
    }

    void clearAllMeasurements() {
        this.setShapeProperty(6, "clear", null);
    }

    void setAnimationDirection(int direction) {
        this.repaintManager.setAnimationDirection(direction);
    }

    int getAnimationDirection() {
        return this.repaintManager.animationDirection;
    }

    public void setAnimationFps(int fps) {
        this.repaintManager.setAnimationFps(fps);
    }

    public int getAnimationFps() {
        return this.repaintManager.animationFps;
    }

    void setAnimationReplayMode(int replay, float firstFrameDelay, float lastFrameDelay) {
        this.repaintManager.setAnimationReplayMode(replay, firstFrameDelay, lastFrameDelay);
    }

    int getAnimationReplayMode() {
        return this.repaintManager.animationReplayMode;
    }

    void setAnimationOn(boolean animationOn) {
        boolean wasAnimating = this.repaintManager.animationOn;
        this.repaintManager.setAnimationOn(animationOn);
        if (animationOn != wasAnimating) {
            this.refresh();
        }
    }

    boolean isAnimationOn() {
        return this.repaintManager.animationOn;
    }

    void setAnimationNext() {
        if (this.repaintManager.setAnimationNext()) {
            this.refresh();
        }
    }

    void setAnimationPrevious() {
        if (this.repaintManager.setAnimationPrevious()) {
            this.refresh();
        }
    }

    boolean setDisplayModelIndex(int modelIndex) {
        return this.repaintManager.setDisplayModelIndex(modelIndex);
    }

    public int getDisplayModelIndex() {
        return this.repaintManager.displayModelIndex;
    }

    FrameRenderer getFrameRenderer() {
        return this.repaintManager.frameRenderer;
    }

    void setWireframeRotating(boolean wireframeRotating) {
        this.repaintManager.setWireframeRotating(wireframeRotating);
    }

    boolean getWireframeRotating() {
        return this.repaintManager.wireframeRotating;
    }

    public int getMotionEventNumber() {
        return this.motionEventNumber;
    }

    void setInMotion(boolean inMotion) {
        if (this.wasInMotion ^ inMotion) {
            if (inMotion) {
                ++this.motionEventNumber;
            }
            this.repaintManager.setInMotion(inMotion);
            this.checkOversample();
            this.wasInMotion = inMotion;
        }
    }

    boolean getInMotion() {
        return this.repaintManager.inMotion;
    }

    Image takeSnapshot() {
        return this.repaintManager.takeSnapshot();
    }

    public void pushHoldRepaint() {
        this.repaintManager.pushHoldRepaint();
    }

    public void popHoldRepaint() {
        this.repaintManager.popHoldRepaint();
    }

    void forceRefresh() {
        this.repaintManager.forceRefresh();
    }

    public void refresh() {
        this.repaintManager.refresh();
    }

    void requestRepaintAndWait() {
        this.repaintManager.requestRepaintAndWait();
    }

    public void notifyRepainted() {
        this.repaintManager.notifyRepainted();
    }

    public void renderScreenImage(Graphics g, Dimension size, Rectangle clip) {
        this.manageScriptTermination();
        if (size != null) {
            this.setScreenDimension(size);
        }
        int stereoMode = this.getStereoMode();
        switch (stereoMode) {
            case 0: {
                this.setRectClip(clip);
                this.render1(g, this.transformManager.getStereoRotationMatrix(false), false, 0, 0);
                break;
            }
            case 1: {
                this.setRectClip(null);
                this.render1(g, this.transformManager.getStereoRotationMatrix(false), false, 0, 0);
                this.render1(g, this.transformManager.getStereoRotationMatrix(true), false, this.dimScreen.width, 0);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                this.setRectClip(null);
                this.g3d.beginRendering(this.rectClip, this.transformManager.getStereoRotationMatrix(true), false);
                this.repaintManager.render(this.g3d, this.rectClip, this.modelManager.getFrame(), this.repaintManager.displayModelIndex);
                this.g3d.endRendering();
                this.g3d.snapshotAnaglyphChannelBytes();
                this.g3d.beginRendering(this.rectClip, this.transformManager.getStereoRotationMatrix(false), false);
                this.repaintManager.render(this.g3d, this.rectClip, this.modelManager.getFrame(), this.repaintManager.displayModelIndex);
                this.g3d.endRendering();
                if (stereoMode == 2) {
                    this.g3d.applyCyanAnaglyph();
                } else {
                    this.g3d.applyBlueOrGreenAnaglyph(stereoMode == 3);
                }
                Image img = this.g3d.getScreenImage();
                try {
                    g.drawImage(img, 0, 0, null);
                }
                catch (NullPointerException npe) {
                    System.out.println("Sun!! ... fix graphics your bugs!");
                }
                this.g3d.releaseScreenImage();
            }
        }
        this.notifyRepainted();
    }

    void render1(Graphics g, Matrix3f matrixRotate, boolean antialias, int x, int y) {
        this.g3d.beginRendering(this.rectClip, matrixRotate, antialias);
        this.repaintManager.render(this.g3d, this.rectClip, this.modelManager.getFrame(), this.repaintManager.displayModelIndex);
        this.g3d.endRendering();
        Image img = this.g3d.getScreenImage();
        try {
            g.drawImage(img, x, y, null);
        }
        catch (NullPointerException npe) {
            System.out.println("Sun!! ... fix graphics your bugs!");
        }
        this.g3d.releaseScreenImage();
    }

    public Image getScreenImage() {
        boolean antialiasThisFrame = true;
        this.setRectClip(null);
        this.g3d.beginRendering(this.rectClip, this.transformManager.getStereoRotationMatrix(false), antialiasThisFrame);
        this.repaintManager.render(this.g3d, this.rectClip, this.modelManager.getFrame(), this.repaintManager.displayModelIndex);
        this.g3d.endRendering();
        return this.g3d.getScreenImage();
    }

    public void releaseScreenImage() {
        this.g3d.releaseScreenImage();
    }

    void checkOversample() {
        boolean tOversample = this.tOversampleAlways | !this.repaintManager.inMotion & this.tOversampleStopped;
        this.repaintManager.setOversample(tOversample);
        this.transformManager.setOversample(tOversample);
    }

    void setOversample(boolean tOversample) {
        this.transformManager.setOversample(tOversample);
        this.repaintManager.setOversample(tOversample);
    }

    Eval getEval() {
        if (this.eval == null) {
            this.eval = new Eval(this);
        }
        return this.eval;
    }

    public String evalFile(String strFilename) {
        if (strFilename != null) {
            if (!this.getEval().loadScriptFile(strFilename, false)) {
                return this.eval.getErrorMessage();
            }
            this.eval.start();
        }
        return null;
    }

    public String evalString(String strScript) {
        if (strScript != null) {
            if (!this.getEval().loadScriptString(strScript, false)) {
                return this.eval.getErrorMessage();
            }
            this.eval.start();
        }
        return null;
    }

    public String evalStringQuiet(String strScript) {
        if (strScript != null) {
            if (!this.getEval().loadScriptString(strScript, true)) {
                return this.eval.getErrorMessage();
            }
            this.eval.start();
        }
        return null;
    }

    public void haltScriptExecution() {
        if (this.eval != null) {
            this.eval.haltExecution();
        }
    }

    boolean getChainCaseSensitive() {
        return this.chainCaseSensitive;
    }

    void setChainCaseSensitive(boolean chainCaseSensitive) {
        this.chainCaseSensitive = chainCaseSensitive;
    }

    boolean getRibbonBorder() {
        return this.ribbonBorder;
    }

    void setRibbonBorder(boolean borderOn) {
        this.ribbonBorder = borderOn;
    }

    boolean getHideNameInPopup() {
        return this.hideNameInPopup;
    }

    void setHideNameInPopup(boolean hideNameInPopup) {
        this.hideNameInPopup = hideNameInPopup;
    }

    public void setColorBond(Color color) {
        this.colorManager.setColorBond(color);
        this.setShapeColorProperty(1, color);
    }

    public Color getColorBond() {
        return this.colorManager.colorBond;
    }

    short getColixBond(int order) {
        if ((order & 0x3C0) != 0) {
            return this.colorManager.colixHbond;
        }
        if ((order & 0x20) != 0) {
            return this.colorManager.colixSsbond;
        }
        return this.colorManager.colixBond;
    }

    void setSsbondsBackbone(boolean ssbondsBackbone) {
        this.styleManager.setSsbondsBackbone(ssbondsBackbone);
    }

    boolean getSsbondsBackbone() {
        return this.styleManager.ssbondsBackbone;
    }

    void setHbondsBackbone(boolean hbondsBackbone) {
        this.styleManager.setHbondsBackbone(hbondsBackbone);
    }

    boolean getHbondsBackbone() {
        return this.styleManager.hbondsBackbone;
    }

    void setHbondsSolid(boolean hbondsSolid) {
        this.styleManager.setHbondsSolid(hbondsSolid);
    }

    boolean getHbondsSolid() {
        return this.styleManager.hbondsSolid;
    }

    public void setMarBond(short marBond) {
        this.styleManager.setMarBond(marBond);
        this.setShapeSize(1, marBond * 2);
    }

    void hoverOn(int atomIndex) {
        if (!(this.eval != null && this.eval.isActive() || atomIndex == this.hoverAtomIndex)) {
            this.loadShape(21);
            this.setShapeProperty(21, "target", new Integer(atomIndex));
            this.hoverAtomIndex = atomIndex;
        }
    }

    void hoverOff() {
        if (this.hoverAtomIndex >= 0) {
            this.setShapeProperty(21, "target", null);
            this.hoverAtomIndex = -1;
        }
    }

    void setLabel(String strLabel) {
        if (strLabel != null) {
            this.setShapeSize(4, this.styleManager.pointsLabelFontSize);
        }
        this.setShapeProperty(4, "label", strLabel);
    }

    void togglePickingLabel(int atomIndex) {
        if (atomIndex != -1) {
            this.setShapeSize(4, this.styleManager.pointsLabelFontSize);
            this.modelManager.setShapeProperty(4, "pickingLabel", new Integer(atomIndex), null);
            this.refresh();
        }
    }

    BitSet getBitSetSelection() {
        return this.selectionManager.bsSelection;
    }

    void setShapeShow(int shapeID, boolean show) {
        this.setShapeSize(shapeID, show ? -1 : 0);
    }

    boolean getShapeShow(int shapeID) {
        return this.getShapeSize(shapeID) != 0;
    }

    void loadShape(int shapeID) {
        this.modelManager.loadShape(shapeID);
    }

    void setShapeSize(int shapeID, int size) {
        this.modelManager.setShapeSize(shapeID, size, this.selectionManager.bsSelection);
        this.refresh();
    }

    int getShapeSize(int shapeID) {
        return this.modelManager.getShapeSize(shapeID);
    }

    void setShapeProperty(int shapeID, String propertyName, Object value) {
        this.modelManager.setShapeProperty(shapeID, propertyName, value, this.selectionManager.bsSelection);
        this.refresh();
    }

    void setShapeColorProperty(int shapeType, Color color) {
        this.setShapeProperty(shapeType, "color", color);
    }

    Object getShapeProperty(int shapeType, String propertyName) {
        return this.modelManager.getShapeProperty(shapeType, propertyName, Integer.MIN_VALUE);
    }

    Object getShapeProperty(int shapeType, String propertyName, int index) {
        return this.modelManager.getShapeProperty(shapeType, propertyName, index);
    }

    Color getShapePropertyAsColor(int shapeID, String propertyName) {
        return (Color)this.getShapeProperty(shapeID, propertyName);
    }

    int getShapePropertyAsInt(int shapeID, String propertyName) {
        Object value = this.getShapeProperty(shapeID, propertyName);
        return value == null || !(value instanceof Integer) ? Integer.MIN_VALUE : (Integer)value;
    }

    Color getColorShape(int shapeID) {
        return (Color)this.getShapeProperty(shapeID, "color");
    }

    short getColixShape(int shapeID) {
        return Graphics3D.getColix(this.getColorShape(shapeID));
    }

    int getShapeID(String shapeName) {
        int i = 27;
        while (--i >= 0) {
            if (!JmolConstants.shapeClassBases[i].equals(shapeName)) continue;
            return i;
        }
        String msg = "Unrecognized shape name:" + shapeName;
        System.out.println(msg);
        throw new NullPointerException(msg);
    }

    short getColix(Color color) {
        return Graphics3D.getColix(color);
    }

    short getColix(Object object) {
        return Graphics3D.getColix(object);
    }

    void setStrandsCount(int strandsCount) {
        if (strandsCount < 0) {
            strandsCount = 0;
        }
        if (strandsCount > 20) {
            strandsCount = 20;
        }
        this.strandsCount = strandsCount;
    }

    int getStrandsCount() {
        return this.strandsCount;
    }

    void setRasmolHydrogenSetting(boolean b) {
        this.rasmolHydrogenSetting = b;
    }

    boolean getRasmolHydrogenSetting() {
        return this.rasmolHydrogenSetting;
    }

    void setRasmolHeteroSetting(boolean b) {
        this.rasmolHeteroSetting = b;
    }

    boolean getRasmolHeteroSetting() {
        return this.rasmolHeteroSetting;
    }

    public void setJmolStatusListener(JmolStatusListener jmolStatusListener) {
        this.jmolStatusListener = jmolStatusListener;
    }

    void notifyFrameChanged(int frameNo) {
        if (this.jmolStatusListener != null) {
            this.jmolStatusListener.notifyFrameChanged(frameNo);
        }
    }

    void notifyFileLoaded(String fullPathName, String fileName, String modelName, Object clientFile) {
        if (this.jmolStatusListener != null) {
            this.jmolStatusListener.notifyFileLoaded(fullPathName, fileName, modelName, clientFile, null);
        }
    }

    void notifyFileNotLoaded(String fullPathName, String errorMsg) {
        if (this.jmolStatusListener != null) {
            this.jmolStatusListener.notifyFileLoaded(fullPathName, null, null, null, errorMsg);
        }
    }

    private void manageScriptTermination() {
        if (this.eval != null && this.eval.hasTerminationNotification()) {
            String strErrorMessage = this.eval.getErrorMessage();
            int msWalltime = this.eval.getExecutionWalltime();
            this.eval.resetTerminationNotification();
            if (this.jmolStatusListener != null) {
                this.jmolStatusListener.notifyScriptTermination(strErrorMessage, msWalltime);
            }
        }
    }

    void scriptEcho(String strEcho) {
        if (this.jmolStatusListener != null) {
            this.jmolStatusListener.scriptEcho(strEcho);
        }
    }

    boolean getDebugScript() {
        return this.debugScript;
    }

    public void setDebugScript(boolean debugScript) {
        this.debugScript = debugScript;
    }

    void scriptStatus(String strStatus) {
        if (this.jmolStatusListener != null) {
            this.jmolStatusListener.scriptStatus(strStatus);
        }
    }

    void notifyMeasurementsChanged() {
        if (this.jmolStatusListener != null) {
            this.jmolStatusListener.notifyMeasurementsChanged();
        }
    }

    void atomPicked(int atomIndex, boolean shiftKey) {
        this.pickingManager.atomPicked(atomIndex, shiftKey);
    }

    void clearClickCount() {
        this.mouseManager.clearClickCount();
    }

    void notifyAtomPicked(int atomIndex) {
        if (atomIndex != -1 && this.jmolStatusListener != null) {
            this.jmolStatusListener.notifyAtomPicked(atomIndex, this.modelManager.getAtomInfo(atomIndex));
        }
    }

    public void showUrl(String urlString) {
        if (this.jmolStatusListener != null) {
            this.jmolStatusListener.showUrl(urlString);
        }
    }

    public void showConsole(boolean showConsole) {
        if (this.jmolStatusListener != null) {
            this.jmolStatusListener.showConsole(showConsole);
        }
    }

    void setPickingMode(int pickingMode) {
        this.pickingManager.setPickingMode(pickingMode);
    }

    String getAtomInfo(int atomIndex) {
        return this.modelManager.getAtomInfo(atomIndex);
    }

    public boolean getBooleanProperty(String key) {
        if (key.equalsIgnoreCase("wireframeRotation")) {
            return this.getWireframeRotation();
        }
        if (key.equalsIgnoreCase("perspectiveDepth")) {
            return this.getPerspectiveDepth();
        }
        if (key.equalsIgnoreCase("showAxes")) {
            return this.getShapeShow(16);
        }
        if (key.equalsIgnoreCase("showBoundBox")) {
            return this.getShapeShow(17);
        }
        if (key.equalsIgnoreCase("showUnitcell")) {
            return this.getShapeShow(18);
        }
        if (key.equalsIgnoreCase("showHydrogens")) {
            return this.getShowHydrogens();
        }
        if (key.equalsIgnoreCase("showMeasurements")) {
            return this.getShowMeasurements();
        }
        if (key.equalsIgnoreCase("showSelections")) {
            return this.getSelectionHaloEnabled();
        }
        if (key.equalsIgnoreCase("oversampleAlways")) {
            return this.getOversampleAlwaysEnabled();
        }
        if (key.equalsIgnoreCase("oversampleStopped")) {
            return this.getOversampleStoppedEnabled();
        }
        if (key.equalsIgnoreCase("axesOrientationRasmol")) {
            return this.getAxesOrientationRasmol();
        }
        if (key.equalsIgnoreCase("zeroBasedXyzRasmol")) {
            return this.getZeroBasedXyzRasmol();
        }
        if (key.equalsIgnoreCase("testFlag1")) {
            return this.getTestFlag1();
        }
        if (key.equalsIgnoreCase("testFlag2")) {
            return this.getTestFlag2();
        }
        if (key.equalsIgnoreCase("testFlag3")) {
            return this.getTestFlag3();
        }
        if (key.equalsIgnoreCase("testFlag4")) {
            return this.getTestFlag4();
        }
        if (key.equalsIgnoreCase("chainCaseSensitive")) {
            return this.getChainCaseSensitive();
        }
        if (key.equalsIgnoreCase("hideNameInPopup")) {
            return this.getHideNameInPopup();
        }
        if (key.equalsIgnoreCase("autobond")) {
            return this.getAutoBond();
        }
        if (key.equalsIgnoreCase("greyscaleRendering")) {
            return this.getGreyscaleRendering();
        }
        if (key.equalsIgnoreCase("disablePopupMenu")) {
            return this.getDisablePopupMenu();
        }
        System.out.println("viewer.getBooleanProperty(" + key + ") - unrecognized");
        return false;
    }

    public void setBooleanProperty(String key, boolean value) {
        this.refresh();
        if (key.equalsIgnoreCase("wireframeRotation")) {
            this.setWireframeRotation(value);
            return;
        }
        if (key.equalsIgnoreCase("perspectiveDepth")) {
            this.setPerspectiveDepth(value);
            return;
        }
        if (key.equalsIgnoreCase("showAxes")) {
            this.setShapeShow(16, value);
            return;
        }
        if (key.equalsIgnoreCase("showBoundBox")) {
            this.setShapeShow(17, value);
            return;
        }
        if (key.equalsIgnoreCase("showUnitcell")) {
            this.setShapeShow(18, value);
            return;
        }
        if (key.equalsIgnoreCase("showHydrogens")) {
            this.setShowHydrogens(value);
            return;
        }
        if (key.equalsIgnoreCase("showHydrogens")) {
            this.setShowHydrogens(value);
            return;
        }
        if (key.equalsIgnoreCase("showMeasurements")) {
            this.setShowMeasurements(value);
            return;
        }
        if (key.equalsIgnoreCase("showSelections")) {
            this.setSelectionHaloEnabled(value);
            return;
        }
        if (key.equalsIgnoreCase("oversampleAlways")) {
            this.setOversampleAlwaysEnabled(value);
            return;
        }
        if (key.equalsIgnoreCase("oversampleStopped")) {
            this.setOversampleStoppedEnabled(value);
            return;
        }
        if (key.equalsIgnoreCase("axesOrientationRasmol")) {
            this.setAxesOrientationRasmol(value);
            return;
        }
        if (key.equalsIgnoreCase("zeroBasedXyzRasmol")) {
            this.setZeroBasedXyzRasmol(value);
            return;
        }
        if (key.equalsIgnoreCase("frieda")) {
            this.setFriedaSwitch(value);
            return;
        }
        if (key.equalsIgnoreCase("testFlag1")) {
            this.setTestFlag1(value);
            return;
        }
        if (key.equalsIgnoreCase("testFlag2")) {
            this.setTestFlag2(value);
            return;
        }
        if (key.equalsIgnoreCase("testFlag3")) {
            this.setTestFlag3(value);
            return;
        }
        if (key.equalsIgnoreCase("testFlag4")) {
            this.setTestFlag4(value);
            return;
        }
        if (key.equalsIgnoreCase("chainCaseSensitive")) {
            this.setChainCaseSensitive(value);
            return;
        }
        if (key.equalsIgnoreCase("ribbonBorder")) {
            this.setRibbonBorder(value);
            return;
        }
        if (key.equalsIgnoreCase("hideNameInPopup")) {
            this.setHideNameInPopup(value);
            return;
        }
        if (key.equalsIgnoreCase("autobond")) {
            this.setAutoBond(value);
            return;
        }
        if (key.equalsIgnoreCase("greyscaleRendering")) {
            this.setGreyscaleRendering(value);
            return;
        }
        if (key.equalsIgnoreCase("disablePopupMenu")) {
            this.setDisablePopupMenu(value);
            return;
        }
        System.out.println("viewer.setBooleanProperty(" + key + "," + value + ") - unrecognized");
    }

    void setTestFlag1(boolean value) {
        this.testFlag1 = value;
    }

    boolean getTestFlag1() {
        return this.testFlag1;
    }

    void setTestFlag2(boolean value) {
        this.testFlag2 = value;
    }

    boolean getTestFlag2() {
        return this.testFlag2;
    }

    void setTestFlag3(boolean value) {
        this.testFlag3 = value;
    }

    boolean getTestFlag3() {
        return this.testFlag3;
    }

    void setTestFlag4(boolean value) {
        this.testFlag4 = value;
    }

    boolean getTestFlag4() {
        return this.testFlag4;
    }

    boolean getOversampleStoppedEnabled() {
        return this.tOversampleStopped;
    }

    boolean getOversampleAlwaysEnabled() {
        return this.tOversampleAlways;
    }

    void setOversampleAlwaysEnabled(boolean value) {
        this.tOversampleAlways = value;
        this.checkOversample();
        this.refresh();
    }

    void setOversampleStoppedEnabled(boolean value) {
        this.tOversampleStopped = value;
        this.checkOversample();
        this.refresh();
    }

    void setGreyscaleRendering(boolean greyscaleRendering) {
        this.greyscaleRendering = greyscaleRendering;
        this.g3d.setGreyscaleMode(greyscaleRendering);
        this.refresh();
    }

    boolean getGreyscaleRendering() {
        return this.greyscaleRendering;
    }

    void setDisablePopupMenu(boolean disablePopupMenu) {
        this.disablePopupMenu = disablePopupMenu;
    }

    boolean getDisablePopupMenu() {
        return this.disablePopupMenu;
    }

    public void setPercentVdwAtom(int percentVdwAtom) {
        this.styleManager.setPercentVdwAtom(percentVdwAtom);
        this.setShapeSize(0, -percentVdwAtom);
    }

    public void setFrankOn(boolean frankOn) {
        this.styleManager.setFrankOn(frankOn);
        this.setShapeSize(19, frankOn ? -1 : 0);
    }

    boolean getFrankOn() {
        return this.styleManager.frankOn;
    }

    public int getPercentVdwAtom() {
        return this.styleManager.percentVdwAtom;
    }

    short getMadAtom() {
        return (short)(-this.styleManager.percentVdwAtom);
    }

    public short getMadBond() {
        return (short)(this.styleManager.marBond * 2);
    }

    void setModeMultipleBond(byte modeMultipleBond) {
        this.styleManager.setModeMultipleBond(modeMultipleBond);
        this.refresh();
    }

    byte getModeMultipleBond() {
        return this.styleManager.modeMultipleBond;
    }

    void setShowMultipleBonds(boolean showMultipleBonds) {
        this.styleManager.setShowMultipleBonds(showMultipleBonds);
        this.refresh();
    }

    boolean getShowMultipleBonds() {
        return this.styleManager.showMultipleBonds;
    }

    public void setShowHydrogens(boolean showHydrogens) {
        this.styleManager.setShowHydrogens(showHydrogens);
        this.refresh();
    }

    public boolean getShowHydrogens() {
        return this.styleManager.showHydrogens;
    }

    public void setShowBbcage(boolean showBbcage) {
        this.setShapeShow(17, showBbcage);
    }

    public boolean getShowBbcage() {
        return this.getShapeShow(17);
    }

    public void setShowAxes(boolean showAxes) {
        this.setShapeShow(16, showAxes);
    }

    public boolean getShowAxes() {
        return this.getShapeShow(16);
    }

    public void setShowMeasurements(boolean showMeasurements) {
        this.styleManager.setShowMeasurements(showMeasurements);
        this.refresh();
    }

    public boolean getShowMeasurements() {
        return this.styleManager.showMeasurements;
    }

    void setShowMeasurementLabels(boolean showMeasurementLabels) {
        this.styleManager.setShowMeasurementLabels(showMeasurementLabels);
        this.refresh();
    }

    boolean getShowMeasurementLabels() {
        return this.styleManager.showMeasurementLabels;
    }

    boolean setMeasureDistanceUnits(String units) {
        if (!this.styleManager.setMeasureDistanceUnits(units)) {
            return false;
        }
        this.setShapeProperty(6, "reformatDistances", null);
        return true;
    }

    String getMeasureDistanceUnits() {
        return this.styleManager.measureDistanceUnits;
    }

    public void setWireframeRotation(boolean wireframeRotation) {
        this.styleManager.setWireframeRotation(wireframeRotation);
    }

    public boolean getWireframeRotation() {
        return this.styleManager.wireframeRotation;
    }

    public void setJmolDefaults() {
        this.styleManager.setJmolDefaults();
    }

    public void setRasmolDefaults() {
        this.styleManager.setRasmolDefaults();
    }

    void setZeroBasedXyzRasmol(boolean zeroBasedXyzRasmol) {
        this.styleManager.setZeroBasedXyzRasmol(zeroBasedXyzRasmol);
    }

    boolean getZeroBasedXyzRasmol() {
        return this.styleManager.zeroBasedXyzRasmol;
    }

    void setLabelFontSize(int points) {
        this.styleManager.setLabelFontSize(points);
        this.refresh();
    }

    void setLabelOffset(int xOffset, int yOffset) {
        this.styleManager.setLabelOffset(xOffset, yOffset);
        this.refresh();
    }

    int getLabelOffsetX() {
        return this.styleManager.labelOffsetX;
    }

    int getLabelOffsetY() {
        return this.styleManager.labelOffsetY;
    }

    Point3f[] allocTempPoints(int size) {
        return this.tempManager.allocTempPoints(size);
    }

    void freeTempPoints(Point3f[] tempPoints) {
        this.tempManager.freeTempPoints(tempPoints);
    }

    Point3i[] allocTempScreens(int size) {
        return this.tempManager.allocTempScreens(size);
    }

    void freeTempScreens(Point3i[] tempScreens) {
        this.tempManager.freeTempScreens(tempScreens);
    }

    boolean[] allocTempBooleans(int size) {
        return this.tempManager.allocTempBooleans(size);
    }

    void freeTempBooleans(boolean[] tempBooleans) {
        this.tempManager.freeTempBooleans(tempBooleans);
    }

    Font3D getFont3D(int fontSize) {
        return this.g3d.getFont3D("SansSerif", "Plain", fontSize);
    }

    Font3D getFont3D(String fontFace, String fontStyle, int fontSize) {
        return this.g3d.getFont3D(fontFace, fontStyle, fontSize);
    }

    String getElementSymbol(int i) {
        return this.modelManager.getElementSymbol(i);
    }

    int getElementNumber(int i) {
        return this.modelManager.getElementNumber(i);
    }

    public String getAtomName(int i) {
        return this.modelManager.getAtomName(i);
    }

    public int getAtomNumber(int i) {
        return this.modelManager.getAtomNumber(i);
    }

    float getAtomX(int i) {
        return this.modelManager.getAtomX(i);
    }

    float getAtomY(int i) {
        return this.modelManager.getAtomY(i);
    }

    float getAtomZ(int i) {
        return this.modelManager.getAtomZ(i);
    }

    public Point3f getAtomPoint3f(int i) {
        return this.modelManager.getAtomPoint3f(i);
    }

    public float getAtomRadius(int i) {
        return this.modelManager.getAtomRadius(i);
    }

    public Color getAtomColor(int i) {
        return this.g3d.getColor(this.modelManager.getAtomColix(i));
    }

    String getAtomChain(int i) {
        return this.modelManager.getAtomChain(i);
    }

    public int getAtomModelIndex(int i) {
        return this.modelManager.getAtomModelIndex(i);
    }

    String getAtomSequenceCode(int i) {
        return this.modelManager.getAtomSequenceCode(i);
    }

    public Point3f getBondPoint3f1(int i) {
        return this.modelManager.getBondPoint3f1(i);
    }

    public Point3f getBondPoint3f2(int i) {
        return this.modelManager.getBondPoint3f2(i);
    }

    public float getBondRadius(int i) {
        return this.modelManager.getBondRadius(i);
    }

    public short getBondOrder(int i) {
        return this.modelManager.getBondOrder(i);
    }

    public Color getBondColor1(int i) {
        return this.g3d.getColor(this.modelManager.getBondColix1(i));
    }

    public int getBondModelIndex(int i) {
        return this.modelManager.getBondModelIndex(i);
    }

    public Color getBondColor2(int i) {
        return this.g3d.getColor(this.modelManager.getBondColix2(i));
    }

    public Point3f[] getPolymerLeadMidPoints(int modelIndex, int polymerIndex) {
        return this.modelManager.getPolymerLeadMidPoints(modelIndex, polymerIndex);
    }

    void setStereoMode(int stereoMode) {
        this.transformManager.setStereoMode(stereoMode);
    }

    int getStereoMode() {
        return this.transformManager.stereoMode;
    }

    float getStereoDegrees() {
        return this.transformManager.stereoDegrees;
    }

    void setStereoDegrees(float degrees) {
        this.transformManager.setStereoDegrees(degrees);
    }

    public boolean isJvm12orGreater() {
        return this.jvm12orGreater;
    }

    public String getOperatingSystemName() {
        return this.strOSName;
    }

    public String getJavaVersion() {
        return this.strJavaVersion;
    }

    Graphics3D getGraphics3D() {
        return this.g3d;
    }

    public boolean showModelSetDownload() {
        return true;
    }

    String formatDecimal(float value, int decimalDigits) {
        return this.styleManager.formatDecimal(value, decimalDigits);
    }

    static class NullBondIterator
    implements BondIterator {
        NullBondIterator() {
        }

        public boolean hasNext() {
            return false;
        }

        public Bond next() {
            return null;
        }
    }

    static class NullAtomIterator
    implements AtomIterator {
        NullAtomIterator() {
        }

        public boolean hasNext() {
            return false;
        }

        public Atom next() {
            return null;
        }

        public void release() {
        }
    }
}

