/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.g3d;

import java.awt.Color;
import org.jmol.g3d.Graphics3D;
import org.jmol.g3d.Shade3D;
import org.jmol.util.Int2IntHash;

final class Colix {
    private static int colixMax = 4;
    private static int[] argbs = new int[128];
    private static int[] argbsGreyscale;
    private static Color[] colors;
    private static int[][] ashades;
    private static int[][] ashadesGreyscale;
    private static final Int2IntHash colixHash;
    static final Int2IntHash hashMix2;

    Colix() {
    }

    static final short getColix(int argb) {
        return Colix.getColix(argb, null);
    }

    static final short getColix(Color color) {
        return color == null ? (short)0 : Colix.getColix(color.getRGB(), color);
    }

    private static final short getColix(int argb, Color opaqueColor) {
        int c;
        if (argb == 0) {
            return 0;
        }
        int translucentMask = 0;
        if ((argb & 0xFF000000) != -16777216) {
            if ((argb & 0xFF000000) == 0) {
                System.out.println("zero alpha channel + non-zero rgb not supported");
                throw new IndexOutOfBoundsException();
            }
            argb |= 0xFF000000;
            translucentMask = 16384;
        }
        if ((c = colixHash.get(argb)) > 0) {
            return (short)(c | translucentMask);
        }
        if (opaqueColor != null && (opaqueColor.getRGB() & 0xFF000000) != -16777216) {
            opaqueColor = null;
        }
        return (short)(Colix.allocateColix(argb, opaqueColor) | translucentMask);
    }

    private static synchronized int allocateColix(int argb, Color opaqueColor) {
        if ((argb & 0xFF000000) != -16777216) {
            throw new IndexOutOfBoundsException();
        }
        int i = colixMax;
        while (--i >= 4) {
            if (argb != argbs[i]) continue;
            return (short)i;
        }
        if (colixMax == argbs.length) {
            int oldSize = argbs.length;
            int newSize = oldSize * 2;
            int[] t0 = new int[newSize];
            System.arraycopy(argbs, 0, t0, 0, oldSize);
            argbs = t0;
            if (argbsGreyscale != null) {
                t0 = new int[newSize];
                System.arraycopy(argbsGreyscale, 0, t0, 0, oldSize);
                argbsGreyscale = t0;
            }
            Color[] t1 = new Color[newSize];
            System.arraycopy(colors, 0, t1, 0, oldSize);
            colors = t1;
            int[][] t2 = new int[newSize][];
            System.arraycopy(ashades, 0, t2, 0, oldSize);
            ashades = t2;
            if (ashadesGreyscale != null) {
                t2 = new int[newSize][];
                System.arraycopy(ashadesGreyscale, 0, t2, 0, oldSize);
                ashadesGreyscale = t2;
            }
        }
        Colix.argbs[Colix.colixMax] = argb;
        if (argbsGreyscale != null) {
            Colix.argbsGreyscale[Colix.colixMax] = Graphics3D.calcGreyscaleRgbFromRgb(argb);
        }
        Colix.colors[Colix.colixMax] = opaqueColor != null ? opaqueColor : new Color(argb);
        colixHash.put(argb, colixMax);
        return colixMax++;
    }

    private static synchronized void calcArgbsGreyscale() {
        if (argbsGreyscale == null) {
            argbsGreyscale = new int[argbs.length];
            int i = argbsGreyscale.length;
            while (--i >= 0) {
                Colix.argbsGreyscale[i] = Graphics3D.calcGreyscaleRgbFromRgb(argbs[i]);
            }
        }
    }

    static final Color getColor(short colix) {
        if (colix == 0) {
            return null;
        }
        return colors[colix & 0xFFFFBFFF];
    }

    static final int getRgb(short colix) {
        return argbs[colix & 0xFFFFBFFF];
    }

    static final int getRgbGreyscale(short colix) {
        if (argbsGreyscale == null) {
            Colix.calcArgbsGreyscale();
        }
        return argbsGreyscale[colix & 0xFFFFBFFF];
    }

    static final boolean isTranslucent(short colix) {
        return (colix & 0x4000) != 0;
    }

    static final int[] getShades(short colix) {
        int[] shades = ashades[colix = (short)(colix & 0xFFFFBFFF)];
        if (shades == null) {
            Colix.ashades[colix] = Shade3D.getShades(argbs[colix], false);
            shades = Colix.ashades[colix];
        }
        return shades;
    }

    static final int[] getShadesGreyscale(short colix) {
        int[] shadesGreyscale;
        colix = (short)(colix & 0xFFFFBFFF);
        if (ashadesGreyscale == null) {
            ashadesGreyscale = new int[ashades.length][];
        }
        if ((shadesGreyscale = ashadesGreyscale[colix]) == null) {
            Colix.ashadesGreyscale[colix] = Shade3D.getShades(argbs[colix], true);
            shadesGreyscale = Colix.ashadesGreyscale[colix];
        }
        return shadesGreyscale;
    }

    static final void flushShades() {
        int i = colixMax;
        while (--i >= 0) {
            Colix.ashades[i] = null;
        }
    }

    static final short getColixMix(short colixA, short colixB) {
        if (colixA == colixB) {
            return colixA;
        }
        if (colixA <= 0) {
            return colixB;
        }
        if (colixB <= 0) {
            return colixA;
        }
        int translucentMask = colixA & colixB & 0x4000;
        int mixId = (colixA = (short)(colixA & 0xFFFFBFFF)) < (colixB = (short)(colixB & 0xFFFFBFFF)) ? colixA << 16 | colixB : colixB << 16 | colixA;
        int mixed = hashMix2.get(mixId);
        if (mixed == Integer.MIN_VALUE) {
            int argbA = argbs[colixA];
            int argbB = argbs[colixB];
            int r = (argbA & 0xFF0000) + (argbB & 0xFF0000) >> 1 & 0xFF0000;
            int g = (argbA & 0xFF00) + (argbB & 0xFF00) >> 1 & 0xFF00;
            int b = (argbA & 0xFF) + (argbB & 0xFF) >> 1;
            int argbMixed = 0xFF000000 | r | g | b;
            mixed = Colix.getColix(argbMixed);
            hashMix2.put(mixId, mixed);
        }
        return (short)(mixed | translucentMask);
    }

    static {
        colors = new Color[128];
        ashades = new int[128][];
        colixHash = new Int2IntHash();
        hashMix2 = new Int2IntHash(32);
    }
}

