/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.api;

import java.io.BufferedReader;
import java.util.Properties;

public abstract class JmolAdapter {
    public static final short ORDER_COVALENT_SINGLE = 1;
    public static final short ORDER_COVALENT_DOUBLE = 2;
    public static final short ORDER_COVALENT_TRIPLE = 3;
    public static final short ORDER_AROMATIC = 4;
    public static final short ORDER_HBOND = 64;
    public static final short ORDER_STEREO_NEAR = 9;
    public static final short ORDER_STEREO_FAR = 18;
    public static final short ORDER_PARTIAL01 = 1024;
    public static final short ORDER_PARTIAL12 = 2048;
    String adapterName;
    public Logger logger;

    public JmolAdapter(String adapterName, Logger logger) {
        this.adapterName = adapterName;
        this.logger = logger == null ? new Logger() : logger;
    }

    public Object openBufferedReader(String name, BufferedReader bufferedReader) {
        return this.openBufferedReader(name, bufferedReader, null);
    }

    public Object openBufferedReader(String name, BufferedReader bufferedReader, Logger logger) {
        return null;
    }

    public void finish(Object clientFile) {
    }

    public String getFileTypeName(Object clientFile) {
        return "unknown";
    }

    public String getAtomSetCollectionName(Object clientFile) {
        return null;
    }

    public Properties getAtomSetCollectionProperties(Object clientFile) {
        return null;
    }

    public int getAtomSetCount(Object clientFile) {
        return 1;
    }

    public int getAtomSetNumber(Object clientFile, int atomSetIndex) {
        return atomSetIndex + 1;
    }

    public String getAtomSetName(Object clientFile, int atomSetIndex) {
        return "" + this.getAtomSetNumber(clientFile, atomSetIndex);
    }

    public Properties getAtomSetProperties(Object clientFile, int atomSetIndex) {
        return null;
    }

    public abstract int getEstimatedAtomCount(Object var1);

    public boolean coordinatesAreFractional(Object clientFile) {
        return false;
    }

    public float[] getNotionalUnitcell(Object clientFile) {
        return null;
    }

    public float[] getPdbScaleMatrix(Object clientFile) {
        return null;
    }

    public float[] getPdbScaleTranslate(Object clientFile) {
        return null;
    }

    public String getClientAtomStringProperty(Object clientAtom, String propertyName) {
        return null;
    }

    public abstract AtomIterator getAtomIterator(Object var1);

    public BondIterator getBondIterator(Object clientFile) {
        return null;
    }

    public StructureIterator getStructureIterator(Object clientFile) {
        return null;
    }

    public static final char canonizeAlphaDigit(char ch) {
        if (ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ch >= '0' && ch <= '9') {
            return ch;
        }
        return '\u0000';
    }

    public static final char canonizeChainID(char chainID) {
        return JmolAdapter.canonizeAlphaDigit(chainID);
    }

    public static final char canonizeInsertionCode(char insertionCode) {
        return JmolAdapter.canonizeAlphaDigit(insertionCode);
    }

    public static final char canonizeAlternateLocationID(char altLoc) {
        return JmolAdapter.canonizeAlphaDigit(altLoc);
    }

    public class Logger {
        public boolean isLogging() {
            return true;
        }

        public void log(String str1) {
            System.out.println(JmolAdapter.this.adapterName + ":" + str1);
        }

        public void log(String str1, Object obj1) {
            System.out.println(JmolAdapter.this.adapterName + ":" + str1 + ":" + obj1);
        }

        public void log(String str1, Object obj1, Object obj2) {
            System.out.println(JmolAdapter.this.adapterName + ":" + str1 + ":" + obj1 + ":" + obj2);
        }
    }

    public abstract class StructureIterator {
        public abstract boolean hasNext();

        public abstract String getStructureType();

        public abstract char getStartChainID();

        public abstract int getStartSequenceNumber();

        public abstract char getStartInsertionCode();

        public abstract char getEndChainID();

        public abstract int getEndSequenceNumber();

        public abstract char getEndInsertionCode();
    }

    public abstract class BondIterator {
        public abstract boolean hasNext();

        public abstract Object getAtomUniqueID1();

        public abstract Object getAtomUniqueID2();

        public abstract int getEncodedOrder();
    }

    public abstract class AtomIterator {
        public abstract boolean hasNext();

        public int getAtomSetIndex() {
            return 0;
        }

        public abstract Object getUniqueID();

        public int getElementNumber() {
            return -1;
        }

        public String getElementSymbol() {
            return null;
        }

        public String getAtomName() {
            return null;
        }

        public int getFormalCharge() {
            return 0;
        }

        public float getPartialCharge() {
            return Float.NaN;
        }

        public abstract float getX();

        public abstract float getY();

        public abstract float getZ();

        public float getVectorX() {
            return Float.NaN;
        }

        public float getVectorY() {
            return Float.NaN;
        }

        public float getVectorZ() {
            return Float.NaN;
        }

        public float getBfactor() {
            return Float.NaN;
        }

        public int getOccupancy() {
            return 100;
        }

        public boolean getIsHetero() {
            return false;
        }

        public int getAtomSerial() {
            return Integer.MIN_VALUE;
        }

        public char getChainID() {
            return '\u0000';
        }

        public char getAlternateLocationID() {
            return '\u0000';
        }

        public String getGroup3() {
            return null;
        }

        public int getSequenceNumber() {
            return Integer.MIN_VALUE;
        }

        public char getInsertionCode() {
            return '\u0000';
        }

        public Object getClientAtomReference() {
            return null;
        }
    }
}

