/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Tuple3f;
import javax.vecmath.Tuple3i;
import javax.vecmath.Vector3f;
import org.jmol.viewer.Viewer;

class TransformManager {
    Viewer viewer;
    private final Matrix3f matrixRotate = new Matrix3f();
    private final Matrix3f matrixTemp3 = new Matrix3f();
    static final float radiansPerDegree = (float)Math.PI / 180;
    static final float degreesPerRadian = 57.29578f;
    float xTranslation;
    float yTranslation;
    final AxisAngle4f axisangleT = new AxisAngle4f();
    final Vector3f vectorT = new Vector3f();
    boolean zoomEnabled = true;
    int zoomPercent = 100;
    int zoomPercentSetting = 100;
    boolean slabEnabled = false;
    int modeSlab;
    int slabPercentSetting = 100;
    int depthPercentSetting = 0;
    private int slabValue;
    private int depthValue;
    boolean perspectiveDepth = true;
    float cameraDepth = 3.0f;
    int cameraDistance = 1000;
    float cameraDistanceFloat = 1000.0f;
    boolean tOversample;
    int width;
    int height;
    int width1;
    int height1;
    int width4;
    int height4;
    int screenPixelCount;
    float scalePixelsPerAngstrom;
    float scaleDefaultPixelsPerAngstrom;
    final Matrix4f matrixTransform = new Matrix4f();
    private final Point3f point3fVibrationTemp = new Point3f();
    private final Point3f point3fScreenTemp = new Point3f();
    private final Point3i point3iScreenTemp = new Point3i();
    private final Matrix4f matrixTemp = new Matrix4f();
    private final Vector3f vectorTemp = new Vector3f();
    boolean axesOrientationRasmol = false;
    boolean increaseRotationRadius;
    int minimumZ;
    boolean vibrationOn;
    float vibrationPeriod;
    int vibrationPeriodMs;
    float vibrationAmplitude;
    float vibrationRadians;
    float vectorScale = 1.0f;
    float vibrationScale = 1.0f;
    int spinX;
    int spinY = 30;
    int spinZ;
    int spinFps = 30;
    static final float twoPI = (float)Math.PI * 2;
    boolean spinOn;
    SpinThread spinThread;
    VibrationThread vibrationThread;
    int stereoMode;
    float stereoDegrees = 5.0f;
    float stereoRadians = 0.08726646f;
    boolean stereoFrame;
    private final Matrix3f matrixStereo = new Matrix3f();

    TransformManager(Viewer viewer) {
        this.viewer = viewer;
    }

    void homePosition() {
        this.matrixRotate.setIdentity();
        this.setZoomEnabled(true);
        this.zoomToPercent(100);
        this.scaleFitToScreen();
    }

    void rotateXYBy(int xDelta, int yDelta) {
        this.rotateXRadians((float)yDelta * ((float)Math.PI / 180));
        this.rotateYRadians((float)xDelta * ((float)Math.PI / 180));
    }

    void rotateZBy(int zDelta) {
        this.rotateZRadians((float)Math.PI * (float)zDelta / 180.0f);
    }

    void rotateFront() {
        this.matrixRotate.setIdentity();
    }

    void rotateToX(float angleRadians) {
        this.matrixRotate.rotX(angleRadians);
    }

    void rotateToY(float angleRadians) {
        this.matrixRotate.rotY(angleRadians);
    }

    void rotateToZ(float angleRadians) {
        this.matrixRotate.rotZ(angleRadians);
    }

    synchronized void rotateXRadians(float angleRadians) {
        this.matrixTemp3.rotX(angleRadians);
        this.matrixRotate.mul(this.matrixTemp3, this.matrixRotate);
    }

    synchronized void rotateYRadians(float angleRadians) {
        if (this.axesOrientationRasmol) {
            angleRadians = -angleRadians;
        }
        this.matrixTemp3.rotY(angleRadians);
        this.matrixRotate.mul(this.matrixTemp3, this.matrixRotate);
    }

    synchronized void rotateZRadians(float angleRadians) {
        if (this.axesOrientationRasmol) {
            angleRadians = -angleRadians;
        }
        this.matrixTemp3.rotZ(angleRadians);
        this.matrixRotate.mul(this.matrixTemp3, this.matrixRotate);
    }

    void rotateZRadiansScript(float angleRadians) {
        this.matrixTemp3.rotZ(angleRadians);
        this.matrixRotate.mul(this.matrixTemp3, this.matrixRotate);
    }

    void rotate(AxisAngle4f axisAngle) {
        this.matrixTemp3.setIdentity();
        this.matrixTemp3.set(axisAngle);
        this.matrixRotate.mul(this.matrixTemp3, this.matrixRotate);
    }

    void rotateAxisAngle(float x, float y, float z, float degrees) {
        this.axisangleT.set(x, y, z, degrees * ((float)Math.PI / 180));
        this.rotate(this.axisangleT);
    }

    void rotateTo(float x, float y, float z, float degrees) {
        if ((double)degrees < 0.01 && (double)degrees > -0.01) {
            this.matrixRotate.setIdentity();
        } else {
            this.axisangleT.set(x, y, z, degrees * ((float)Math.PI / 180));
            this.matrixRotate.set(this.axisangleT);
        }
    }

    void rotateTo(AxisAngle4f axisAngle) {
        if ((double)axisAngle.angle < 0.01 && (double)axisAngle.angle > -0.01) {
            this.matrixRotate.setIdentity();
        } else {
            this.matrixRotate.set(axisAngle);
        }
    }

    void translateXYBy(int xDelta, int yDelta) {
        this.xTranslation += (float)xDelta;
        this.yTranslation += (float)yDelta;
    }

    void translateToXPercent(float percent) {
        this.xTranslation = (float)(this.width / 2) + (float)this.width * percent / 100.0f;
    }

    void translateToYPercent(float percent) {
        this.yTranslation = (float)(this.height / 2) + (float)this.height * percent / 100.0f;
    }

    void translateToZPercent(float percent) {
    }

    float getTranslationXPercent() {
        return (this.xTranslation - (float)(this.width / 2)) * 100.0f / (float)this.width;
    }

    float getTranslationYPercent() {
        return (this.yTranslation - (float)(this.height / 2)) * 100.0f / (float)this.height;
    }

    float getTranslationZPercent() {
        return 0.0f;
    }

    void translateCenterTo(int x, int y) {
        this.xTranslation = x;
        this.yTranslation = y;
    }

    String getOrientationText() {
        return this.getMoveToText() + "\nOR\n" + this.getRotateZyzText();
    }

    String getMoveToText() {
        this.axisangleT.set(this.matrixRotate);
        float degrees = this.axisangleT.angle * 57.29578f;
        StringBuffer sb = new StringBuffer();
        sb.append("moveto 1");
        if (degrees < 0.01f) {
            sb.append(" 0 0 0 0");
        } else {
            this.vectorT.set(this.axisangleT.x, this.axisangleT.y, this.axisangleT.z);
            this.vectorT.normalize();
            this.vectorT.scale(1000.0f);
            TransformManager.truncate0(sb, this.vectorT.x);
            TransformManager.truncate0(sb, this.vectorT.y);
            TransformManager.truncate0(sb, this.vectorT.z);
            TransformManager.truncate1(sb, degrees);
        }
        int zoom = this.getZoomPercent();
        int tX = (int)this.getTranslationXPercent();
        int tY = (int)this.getTranslationYPercent();
        if (zoom != 100 || tX != 0 || tY != 0) {
            sb.append(" ");
            sb.append(zoom);
            if (tX != 0 || tY != 0) {
                sb.append(" ");
                sb.append(tX);
                sb.append(" ");
                sb.append(tY);
            }
        }
        return "" + sb + ";";
    }

    String getRotateZyzText() {
        int tY;
        int tX;
        int zoom;
        float rZ2;
        float rZ1;
        StringBuffer sb = new StringBuffer();
        float m22 = this.matrixRotate.m22;
        float rY = (float)Math.acos(m22) * 57.29578f;
        if (m22 > 0.999f || m22 < -0.999f) {
            rZ1 = (float)Math.atan2(this.matrixRotate.m10, this.matrixRotate.m11) * 57.29578f;
            rZ2 = 0.0f;
        } else {
            rZ1 = (float)Math.atan2(this.matrixRotate.m21, -this.matrixRotate.m20) * 57.29578f;
            rZ2 = (float)Math.atan2(this.matrixRotate.m12, this.matrixRotate.m02) * 57.29578f;
        }
        if (rZ1 != 0.0f && rY != 0.0f && rZ2 != 0.0f) {
            sb.append("#Follows Z-Y-Z convention for Euler angles\n");
        }
        sb.append("reset");
        if (rZ1 != 0.0f) {
            sb.append("; rotate z");
            TransformManager.truncate1(sb, rZ1);
        }
        if (rY != 0.0f) {
            sb.append("; rotate y");
            TransformManager.truncate1(sb, rY);
        }
        if (rZ2 != 0.0f) {
            sb.append("; rotate z");
            TransformManager.truncate1(sb, rZ2);
        }
        if ((zoom = this.getZoomPercent()) != 100) {
            sb.append("; zoom ");
            sb.append(zoom);
        }
        if ((tX = (int)this.getTranslationXPercent()) != 0) {
            sb.append("; translate x ");
            sb.append(tX);
        }
        if ((tY = (int)this.getTranslationYPercent()) != 0) {
            sb.append("; translate y ");
            sb.append(tY);
        }
        sb.append(';');
        return "" + sb;
    }

    static void truncate0(StringBuffer sb, float val) {
        sb.append(' ');
        sb.append(Math.round(val));
    }

    static void truncate1(StringBuffer sb, float val) {
        sb.append(' ');
        sb.append((float)Math.round(val * 10.0f) / 10.0f);
    }

    void getAxisAngle(AxisAngle4f axisAngle) {
        axisAngle.set(this.matrixRotate);
    }

    String getTransformText() {
        return "matrixRotate=\n" + this.matrixRotate;
    }

    void setRotation(Matrix3f matrixRotation) {
        this.matrixRotate.set(matrixRotation);
    }

    void getRotation(Matrix3f matrixRotation) {
        matrixRotation.set(this.matrixRotate);
    }

    void zoomBy(int pixels) {
        if (pixels > 20) {
            pixels = 20;
        } else if (pixels < -20) {
            pixels = -20;
        }
        int deltaPercent = pixels * this.zoomPercentSetting / 50;
        if (deltaPercent == 0) {
            deltaPercent = pixels > 0 ? 1 : (deltaPercent < 0 ? -1 : 0);
        }
        int percent = deltaPercent + this.zoomPercentSetting;
        this.zoomToPercent(percent);
    }

    int getZoomPercent() {
        return this.zoomPercent;
    }

    int getZoomPercentSetting() {
        return this.zoomPercentSetting;
    }

    void zoomToPercent(int percentZoom) {
        this.zoomPercentSetting = percentZoom;
        this.calcZoom();
    }

    void zoomByPercent(int percentZoom) {
        int delta = percentZoom * this.zoomPercentSetting / 100;
        if (delta == 0) {
            delta = percentZoom < 0 ? -1 : 1;
        }
        this.zoomPercentSetting += delta;
        this.calcZoom();
    }

    private void calcZoom() {
        if (this.zoomPercentSetting < 5) {
            this.zoomPercentSetting = 5;
        }
        if (this.zoomPercentSetting > Viewer.MAXIMUM_ZOOM_PERCENTAGE) {
            this.zoomPercentSetting = Viewer.MAXIMUM_ZOOM_PERCENTAGE;
        }
        this.zoomPercent = this.zoomEnabled ? this.zoomPercentSetting : 100;
        this.scalePixelsPerAngstrom = this.scaleDefaultPixelsPerAngstrom * (float)this.zoomPercent / 100.0f;
    }

    void setZoomEnabled(boolean zoomEnabled) {
        if (this.zoomEnabled != zoomEnabled) {
            this.zoomEnabled = zoomEnabled;
            this.calcZoom();
        }
    }

    void setScaleAngstromsPerInch(float angstromsPerInch) {
        this.scalePixelsPerAngstrom = this.scaleDefaultPixelsPerAngstrom = 72.0f / angstromsPerInch;
    }

    boolean getSlabEnabled() {
        return this.slabEnabled;
    }

    int getSlabPercentSetting() {
        return this.slabPercentSetting;
    }

    void slabByPercentagePoints(int percentage) {
        this.slabPercentSetting += percentage;
        if (this.slabPercentSetting < 1) {
            this.slabPercentSetting = 1;
        } else if (this.slabPercentSetting > 100) {
            this.slabPercentSetting = 100;
        }
        if (this.depthPercentSetting >= this.slabPercentSetting) {
            this.depthPercentSetting = this.slabPercentSetting - 1;
        }
    }

    void depthByPercentagePoints(int percentage) {
        this.depthPercentSetting += percentage;
        if (this.depthPercentSetting < 0) {
            this.depthPercentSetting = 0;
        } else if (this.depthPercentSetting > 99) {
            this.depthPercentSetting = 99;
        }
        if (this.slabPercentSetting <= this.depthPercentSetting) {
            this.slabPercentSetting = this.depthPercentSetting + 1;
        }
    }

    void slabDepthByPercentagePoints(int percentage) {
        if (percentage > 0) {
            if (this.slabPercentSetting + percentage > 100) {
                percentage = 100 - this.slabPercentSetting;
            }
        } else if (this.depthPercentSetting + percentage < 0) {
            percentage = 0 - this.depthPercentSetting;
        }
        this.slabPercentSetting += percentage;
        this.depthPercentSetting += percentage;
    }

    void slabToPercent(int percentSlab) {
        int n = percentSlab < 1 ? 1 : (this.slabPercentSetting = percentSlab > 100 ? 100 : percentSlab);
        if (this.depthPercentSetting >= this.slabPercentSetting) {
            this.depthPercentSetting = this.slabPercentSetting - 1;
        }
    }

    void setSlabEnabled(boolean slabEnabled) {
        this.slabEnabled = slabEnabled;
    }

    void depthToPercent(int percentDepth) {
        int n = percentDepth < 0 ? 0 : (this.depthPercentSetting = percentDepth > 99 ? 99 : percentDepth);
        if (this.slabPercentSetting <= this.depthPercentSetting) {
            this.slabPercentSetting = this.depthPercentSetting + 1;
        }
    }

    void setModeSlab(int modeSlab) {
        this.modeSlab = modeSlab;
    }

    int getModeSlab() {
        return this.modeSlab;
    }

    void calcSlabAndDepthValues() {
        this.slabValue = 0;
        this.depthValue = Integer.MAX_VALUE;
        if (this.slabEnabled) {
            int radius = (int)(this.viewer.getRotationRadius() * this.scalePixelsPerAngstrom);
            this.slabValue = (100 - this.slabPercentSetting) * 2 * radius / 100 + this.cameraDistance;
            this.depthValue = (100 - this.depthPercentSetting) * 2 * radius / 100 + this.cameraDistance;
        }
    }

    void setPerspectiveDepth(boolean perspectiveDepth) {
        this.perspectiveDepth = perspectiveDepth;
        this.scaleFitToScreen();
    }

    boolean getPerspectiveDepth() {
        return this.perspectiveDepth;
    }

    void setCameraDepth(float depth) {
        this.cameraDepth = depth;
    }

    float getCameraDepth() {
        return this.cameraDepth;
    }

    void setScreenDimension(int width, int height) {
        this.width1 = this.width = width;
        this.width4 = width + width;
        this.height1 = this.height = height;
        this.height4 = height + height;
    }

    void setOversample(boolean tOversample) {
        if (this.tOversample == tOversample) {
            return;
        }
        this.tOversample = tOversample;
        if (tOversample) {
            this.width = this.width4;
            this.height = this.height4;
        } else {
            this.width = this.width1;
            this.height = this.height1;
        }
        this.scaleFitToScreen();
    }

    void scaleFitToScreen() {
        if (this.width == 0 || this.height == 0 || !this.viewer.haveFrame()) {
            return;
        }
        this.xTranslation = this.width / 2;
        this.yTranslation = this.height / 2;
        this.screenPixelCount = this.width;
        if (this.height > this.screenPixelCount) {
            this.screenPixelCount = this.height;
        }
        if (this.screenPixelCount > 2) {
            this.screenPixelCount -= 2;
        }
        this.scaleDefaultPixelsPerAngstrom = (float)(this.screenPixelCount / 2) / this.viewer.getRotationRadius();
        if (this.perspectiveDepth) {
            this.cameraDistance = (int)(this.cameraDepth * (float)this.screenPixelCount);
            this.cameraDistanceFloat = this.cameraDistance;
            float scaleFactor = (float)(this.cameraDistance + this.screenPixelCount / 2) / this.cameraDistanceFloat;
            scaleFactor = (float)((double)scaleFactor + 0.02);
            this.scaleDefaultPixelsPerAngstrom *= scaleFactor;
        }
        this.calcZoom();
    }

    float scaleToScreen(int z, float sizeAngstroms) {
        float pixelSize = sizeAngstroms * this.scalePixelsPerAngstrom;
        if (this.perspectiveDepth) {
            pixelSize = pixelSize * (float)this.cameraDistance / (float)z;
        }
        return pixelSize;
    }

    float scaleToPerspective(int z, float sizeAngstroms) {
        return this.perspectiveDepth ? sizeAngstroms * (float)this.cameraDistance / (float)z : sizeAngstroms;
    }

    short scaleToScreen(int z, int milliAngstroms) {
        if (milliAngstroms == 0) {
            return 0;
        }
        int pixelSize = (int)((float)milliAngstroms * this.scalePixelsPerAngstrom / 1000.0f);
        if (this.perspectiveDepth) {
            pixelSize = pixelSize * this.cameraDistance / z;
        }
        if (pixelSize == 0) {
            return 1;
        }
        return (short)pixelSize;
    }

    void setAxesOrientationRasmol(boolean axesOrientationRasmol) {
        this.axesOrientationRasmol = axesOrientationRasmol;
    }

    void calcTransformMatrices() {
        this.calcTransformMatrix();
        this.calcSlabAndDepthValues();
        this.viewer.setSlabAndDepthValues(this.slabValue, this.depthValue);
        this.increaseRotationRadius = false;
        this.minimumZ = Integer.MAX_VALUE;
    }

    float getRotationRadiusIncrease() {
        int backupDistance = this.cameraDistance - this.minimumZ + 1;
        float angstromsIncrease = (float)backupDistance / this.scalePixelsPerAngstrom;
        return angstromsIncrease;
    }

    private void calcTransformMatrix() {
        this.matrixTransform.setIdentity();
        this.vectorTemp.set((Tuple3f)this.viewer.getRotationCenter());
        this.matrixTemp.setZero();
        this.matrixTemp.setTranslation(this.vectorTemp);
        this.matrixTransform.sub(this.matrixTemp);
        this.matrixTemp.set(this.stereoFrame ? this.matrixStereo : this.matrixRotate);
        this.matrixTransform.mul(this.matrixTemp, this.matrixTransform);
        this.vectorTemp.x = 0.0f;
        this.vectorTemp.y = 0.0f;
        this.vectorTemp.z = this.viewer.getRotationRadius() + this.cameraDistanceFloat / this.scalePixelsPerAngstrom;
        this.matrixTemp.setZero();
        this.matrixTemp.setTranslation(this.vectorTemp);
        if (this.axesOrientationRasmol) {
            this.matrixTransform.add(this.matrixTemp);
        } else {
            this.matrixTransform.sub(this.matrixTemp);
        }
        this.matrixTemp.setZero();
        this.matrixTemp.set(this.scalePixelsPerAngstrom);
        if (!this.axesOrientationRasmol) {
            this.matrixTemp.m11 = this.matrixTemp.m22 = -this.scalePixelsPerAngstrom;
        }
        this.matrixTransform.mul(this.matrixTemp, this.matrixTransform);
    }

    Matrix4f getUnscaledTransformMatrix() {
        Matrix4f unscaled = new Matrix4f();
        unscaled.setIdentity();
        this.vectorTemp.set((Tuple3f)this.viewer.getRotationCenter());
        this.matrixTemp.setZero();
        this.matrixTemp.setTranslation(this.vectorTemp);
        unscaled.sub(this.matrixTemp);
        this.matrixTemp.set(this.matrixRotate);
        unscaled.mul(this.matrixTemp, unscaled);
        return unscaled;
    }

    void transformPoints(int count, Point3f[] angstroms, Point3i[] screens) {
        int i = count;
        while (--i >= 0) {
            screens[i].set((Tuple3i)this.transformPoint(angstroms[i]));
        }
    }

    void transformPoint(Point3f pointAngstroms, Point3i pointScreen) {
        pointScreen.set((Tuple3i)this.transformPoint(pointAngstroms));
    }

    Point3i transformPoint(Point3f pointAngstroms) {
        this.matrixTransform.transform(pointAngstroms, this.point3fScreenTemp);
        int z = (int)this.point3fScreenTemp.z;
        if (z < this.cameraDistance) {
            if (Float.isNaN(this.point3fScreenTemp.z)) {
                System.out.println("NaN seen in TransformPoint");
                z = 1;
            } else {
                System.out.println("need to back up the camera");
                System.out.println("point3fScreenTemp.z=" + this.point3fScreenTemp.z + " -> z=" + z);
                this.increaseRotationRadius = true;
                if (z < this.minimumZ) {
                    this.minimumZ = z;
                }
                if (z <= 0) {
                    System.out.println("WARNING! DANGER! z <= 0! transformPoint() point=" + pointAngstroms + "  ->  " + this.point3fScreenTemp);
                    z = 1;
                }
            }
        }
        this.point3iScreenTemp.z = z;
        if (this.perspectiveDepth) {
            float perspectiveFactor = this.cameraDistanceFloat / (float)z;
            this.point3fScreenTemp.x *= perspectiveFactor;
            this.point3fScreenTemp.y *= perspectiveFactor;
        }
        this.point3iScreenTemp.x = (int)(this.point3fScreenTemp.x + this.xTranslation);
        this.point3iScreenTemp.y = (int)(this.point3fScreenTemp.y + this.yTranslation);
        return this.point3iScreenTemp;
    }

    void transformPoint(Point3f pointAngstroms, Point3f screen) {
        this.matrixTransform.transform(pointAngstroms, screen);
        float z = screen.z;
        if (z < (float)this.cameraDistance) {
            System.out.println("need to back up the camera");
            this.increaseRotationRadius = true;
            if (z < (float)this.minimumZ) {
                this.minimumZ = (int)z;
            }
            if (z <= 0.0f) {
                System.out.println("WARNING! DANGER! z <= 0! transformPoint()");
                z = 1.0f;
            }
        }
        screen.z = z;
        if (this.perspectiveDepth) {
            float perspectiveFactor = this.cameraDistanceFloat / z;
            screen.x = screen.x * perspectiveFactor + this.xTranslation;
            screen.y = screen.y * perspectiveFactor + this.yTranslation;
        } else {
            screen.x += this.xTranslation;
            screen.y += this.yTranslation;
        }
    }

    Point3i transformPoint(Point3f pointAngstroms, Vector3f vibrationVector) {
        if (!this.vibrationOn || vibrationVector == null) {
            this.matrixTransform.transform(pointAngstroms, this.point3fScreenTemp);
        } else {
            this.point3fVibrationTemp.scaleAdd(this.vibrationAmplitude, (Tuple3f)vibrationVector, (Tuple3f)pointAngstroms);
            this.matrixTransform.transform(this.point3fVibrationTemp, this.point3fScreenTemp);
        }
        int z = (int)this.point3fScreenTemp.z;
        if (z < this.cameraDistance) {
            System.out.println("need to back up the camera");
            this.increaseRotationRadius = true;
            if (z < this.minimumZ) {
                this.minimumZ = z;
            }
            if (z <= 0) {
                System.out.println("WARNING! DANGER! z <= 0! transformPoint()");
                z = 1;
            }
        }
        this.point3iScreenTemp.z = z;
        if (this.perspectiveDepth) {
            float perspectiveFactor = this.cameraDistanceFloat / (float)z;
            this.point3fScreenTemp.x *= perspectiveFactor;
            this.point3fScreenTemp.y *= perspectiveFactor;
        }
        this.point3iScreenTemp.x = (int)(this.point3fScreenTemp.x + this.xTranslation);
        this.point3iScreenTemp.y = (int)(this.point3fScreenTemp.y + this.yTranslation);
        return this.point3iScreenTemp;
    }

    void transformPoint(Point3f pointAngstroms, Vector3f vibrationVector, Point3i pointScreen) {
        pointScreen.set((Tuple3i)this.transformPoint(pointAngstroms, vibrationVector));
    }

    void transformVector(Vector3f vectorAngstroms, Vector3f vectorTransformed) {
        this.matrixTransform.transform(vectorAngstroms, vectorTransformed);
    }

    void setVibrationPeriod(float period) {
        if (period <= 0.0f) {
            this.vibrationPeriod = 0.0f;
            this.vibrationPeriodMs = 0;
            this.clearVibration();
        } else {
            this.vibrationPeriod = period;
            this.vibrationPeriodMs = (int)(period * 1000.0f);
            this.setVibrationOn(true);
        }
    }

    void setVibrationT(float t) {
        this.vibrationRadians = t * ((float)Math.PI * 2);
        this.vibrationAmplitude = (float)Math.cos(this.vibrationRadians) * this.vibrationScale;
    }

    void setVectorScale(float scale) {
        if (scale >= -10.0f && scale <= 10.0f) {
            this.vectorScale = scale;
        }
    }

    void setVibrationScale(float scale) {
        if (scale >= -10.0f && scale <= 10.0f) {
            this.vibrationScale = scale;
        }
    }

    void setSpinX(int value) {
        this.spinX = value;
    }

    void setSpinY(int value) {
        this.spinY = value;
    }

    void setSpinZ(int value) {
        this.spinZ = value;
    }

    void setSpinFps(int value) {
        if (value <= 0) {
            value = 1;
        } else if (value > 50) {
            value = 50;
        }
        this.spinFps = value;
    }

    void setSpinOn(boolean spinOn) {
        if (spinOn) {
            if (this.spinThread == null) {
                this.spinThread = new SpinThread();
                this.spinThread.start();
            }
        } else if (this.spinThread != null) {
            this.spinThread.interrupt();
            this.spinThread = null;
        }
        this.spinOn = spinOn;
    }

    void clearVibration() {
        this.setVibrationOn(false);
    }

    private void setVibrationOn(boolean vibrationOn) {
        if (!vibrationOn || !this.viewer.haveFrame()) {
            if (this.vibrationThread != null) {
                this.vibrationThread.interrupt();
                this.vibrationThread = null;
            }
            this.vibrationOn = false;
            return;
        }
        if (this.viewer.getModelCount() < 1) {
            this.vibrationOn = false;
            return;
        }
        if (this.vibrationThread == null) {
            this.vibrationThread = new VibrationThread();
            this.vibrationThread.start();
        }
        this.vibrationOn = true;
    }

    void setStereoMode(int stereoMode) {
        this.stereoMode = stereoMode;
        this.viewer.setGreyscaleRendering(stereoMode >= 2);
    }

    void setStereoDegrees(float stereoDegrees) {
        this.stereoDegrees = stereoDegrees;
        this.stereoRadians = stereoDegrees * ((float)Math.PI / 180);
    }

    synchronized Matrix3f getStereoRotationMatrix(boolean stereoFrame) {
        this.stereoFrame = stereoFrame;
        if (stereoFrame) {
            this.matrixTemp3.rotY(this.axesOrientationRasmol ? this.stereoRadians : -this.stereoRadians);
            this.matrixStereo.mul(this.matrixTemp3, this.matrixRotate);
        } else {
            this.matrixStereo.set(this.matrixRotate);
        }
        return this.matrixStereo;
    }

    class VibrationThread
    extends Thread
    implements Runnable {
        VibrationThread() {
        }

        public void run() {
            long startTime;
            long lastRepaintTime = startTime = System.currentTimeMillis();
            try {
                do {
                    long currentTime;
                    int elapsed;
                    int sleepTime;
                    if ((sleepTime = 33 - (elapsed = (int)((currentTime = System.currentTimeMillis()) - lastRepaintTime))) > 0) {
                        Thread.sleep(sleepTime);
                    }
                    lastRepaintTime = currentTime = System.currentTimeMillis();
                    elapsed = (int)(currentTime - startTime);
                    float t = (float)(elapsed % TransformManager.this.vibrationPeriodMs) / (float)TransformManager.this.vibrationPeriodMs;
                    TransformManager.this.setVibrationT(t);
                    TransformManager.this.viewer.refresh();
                } while (!this.isInterrupted());
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        }
    }

    class SpinThread
    extends Thread
    implements Runnable {
        SpinThread() {
        }

        public void run() {
            int myFps = TransformManager.this.spinFps;
            int i = 0;
            long timeBegin = System.currentTimeMillis();
            while (!this.isInterrupted()) {
                int currentTime;
                int targetTime;
                int sleepTime;
                if (myFps != TransformManager.this.spinFps) {
                    myFps = TransformManager.this.spinFps;
                    i = 0;
                    timeBegin = System.currentTimeMillis();
                }
                boolean refreshNeeded = false;
                if (TransformManager.this.spinX != 0) {
                    TransformManager.this.rotateXRadians((float)TransformManager.this.spinX * ((float)Math.PI / 180) / (float)myFps);
                    refreshNeeded = true;
                }
                if (TransformManager.this.spinY != 0) {
                    TransformManager.this.rotateYRadians((float)TransformManager.this.spinY * ((float)Math.PI / 180) / (float)myFps);
                    refreshNeeded = true;
                }
                if (TransformManager.this.spinZ != 0) {
                    TransformManager.this.rotateZRadians((float)TransformManager.this.spinZ * ((float)Math.PI / 180) / (float)myFps);
                    refreshNeeded = true;
                }
                if ((sleepTime = (targetTime = ++i * 1000 / myFps) - (currentTime = (int)(System.currentTimeMillis() - timeBegin))) <= 0) continue;
                if (refreshNeeded) {
                    TransformManager.this.viewer.refresh();
                }
                try {
                    Thread.sleep(sleepTime);
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }
    }
}

