/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3f;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.util.Bmp;
import org.jmol.viewer.Atom;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.SasCache;
import org.jmol.viewer.SasCavity;
import org.jmol.viewer.Sasurface;
import org.jmol.viewer.Sasurface1;
import org.jmol.viewer.ShapeRenderer;

class SasurfaceRenderer
extends ShapeRenderer {
    boolean perspectiveDepth;
    boolean hideSaddles;
    boolean hideConvex;
    boolean hideSeams;
    boolean showEdgeNumbers;
    int scalePixelsPerAngstrom;
    boolean bondSelectionModeOr;
    int geodesicVertexCount;
    int geodesicFaceCount;
    short[] geodesicFaceVertexes;
    short[] geodesicFaceNormixes;
    short[] geodesicNeighborVertexes;
    SasCache sasCache;
    float radiusP;
    Vector3f[] transformedProbeVertexes;
    Point3i[] probeScreens;
    int maxVertexCount;
    short formalChargeColixWhite;
    int[] bmpEdge;
    int[] atomsToRender;
    private static final boolean CONVEX_DOTS = false;
    private static final boolean CAVITY_DOTS = false;
    static final int OUTER_TORUS_STEP_COUNT = Sasurface.OUTER_TORUS_STEP_COUNT;
    final AxisAngle4f aaT = new AxisAngle4f();
    final AxisAngle4f aaT1 = new AxisAngle4f();
    final Matrix3f matrixT = new Matrix3f();
    final Matrix3f matrixT1 = new Matrix3f();
    final Point3f pointT = new Point3f();
    final Point3f pointT1 = new Point3f();
    final Point3i screenCavityBottom = new Point3i();
    final short[] torusColixes = new short[OUTER_TORUS_STEP_COUNT];

    SasurfaceRenderer() {
    }

    void initRenderer() {
        this.maxVertexCount = this.g3d.getGeodesicVertexCount(Sasurface.MAX_GEODESIC_RENDERING_LEVEL);
        this.sasCache = new SasCache(this.viewer, 6, this.maxVertexCount);
        this.formalChargeColixWhite = this.g3d.getChangableColix(JmolConstants.FORMAL_CHARGE_COLIX_WHITE, JmolConstants.argbsFormalCharge[4]);
        System.out.println(" formalChargeColixWhite=" + Integer.toHexString(this.formalChargeColixWhite));
        int i = JmolConstants.argbsFormalCharge.length;
        while (--i >= 0) {
            this.g3d.getChangableColix((short)(JmolConstants.FORMAL_CHARGE_COLIX_RED + i), JmolConstants.argbsFormalCharge[i]);
        }
    }

    void render() {
        this.perspectiveDepth = this.viewer.getPerspectiveDepth();
        this.scalePixelsPerAngstrom = (int)this.viewer.getScalePixelsPerAngstrom();
        this.bondSelectionModeOr = this.viewer.getBondSelectionModeOr();
        Sasurface sasurface = (Sasurface)this.shape;
        if (sasurface == null) {
            return;
        }
        int surfaceCount = sasurface.surfaceCount;
        if (surfaceCount == 0) {
            return;
        }
        Sasurface1[] surfaces = sasurface.surfaces;
        this.hideConvex = this.viewer.getTestFlag1();
        this.hideSaddles = this.viewer.getTestFlag2();
        this.hideSeams = this.viewer.getTestFlag3();
        this.showEdgeNumbers = this.viewer.getTestFlag4();
        if (this.showEdgeNumbers) {
            this.g3d.setFontOfSize(12);
        }
        this.sasCache.clear();
        int i = surfaceCount;
        while (--i >= 0) {
            this.renderSasurface1(surfaces[i]);
        }
    }

    void renderSasurface1(Sasurface1 surface) {
        if (surface.hide) {
            return;
        }
        int renderingLevel = surface.geodesicRenderingLevel;
        this.radiusP = surface.radiusP;
        this.geodesicVertexCount = surface.geodesicVertexCount;
        this.geodesicFaceCount = this.g3d.getGeodesicFaceCount(renderingLevel);
        this.geodesicFaceVertexes = this.g3d.getGeodesicFaceVertexes(renderingLevel);
        this.geodesicFaceNormixes = this.g3d.getGeodesicFaceNormixes(renderingLevel);
        this.geodesicNeighborVertexes = this.g3d.getGeodesicNeighborVertexes(renderingLevel);
        if (this.transformedProbeVertexes == null || this.transformedProbeVertexes.length < this.geodesicVertexCount) {
            this.allocTransformedProbeVertexes();
        }
        Atom[] atoms = this.frame.atoms;
        int[][] convexVertexMaps = surface.convexVertexMaps;
        int[][] convexFaceMaps = surface.convexFaceMaps;
        short[] colixesConvex = surface.colixesConvex;
        int displayModelIndex = this.displayModelIndex;
        int convexCount = surface.surfaceConvexMax;
        this.bmpEdge = this.bmpEdge == null ? Bmp.allocateBitmap((int)this.geodesicVertexCount) : Bmp.growBitmap((int[])this.bmpEdge, (int)this.geodesicVertexCount);
        this.atomsToRender = Bmp.growBitmap((int[])this.atomsToRender, (int)convexCount);
        int[] atomsToRender = this.atomsToRender;
        Bmp.setAllBits((int[])atomsToRender, (int)convexCount);
        Sasurface1.Torus[] toruses = surface.toruses;
        int i = surface.torusCount;
        while (--i >= 0) {
            int ixB;
            Sasurface1.Torus torus = toruses[i];
            this.renderTorus(torus, atoms, colixesConvex, convexVertexMaps);
            this.renderSeams(torus, atoms, colixesConvex, convexVertexMaps);
            int ixA = torus.ixA;
            if (Bmp.getBit((int[])atomsToRender, (int)ixA)) {
                Bmp.clearBit((int[])atomsToRender, (int)ixA);
                int[] vertexMap = convexVertexMaps[ixA];
                if (vertexMap != null) {
                    this.renderConvex(surface, atoms[ixA], colixesConvex[ixA], vertexMap, convexFaceMaps[ixA]);
                }
            }
            if (!Bmp.getBit((int[])atomsToRender, (int)(ixB = torus.ixB))) continue;
            Bmp.clearBit((int[])atomsToRender, (int)ixB);
            int[] vertexMap = convexVertexMaps[ixB];
            if (vertexMap == null) continue;
            this.renderConvex(surface, atoms[ixB], colixesConvex[ixB], vertexMap, convexFaceMaps[ixB]);
        }
        i = -1;
        while ((i = Bmp.nextSetBit((int[])atomsToRender, (int)(i + 1))) >= 0) {
            int[] vertexMap = convexVertexMaps[i];
            if (vertexMap == null) continue;
            int[] faceMap = convexFaceMaps[i];
            Atom atom = atoms[i];
            if (displayModelIndex >= 0 && displayModelIndex != atom.modelIndex) continue;
            this.renderConvex(surface, atom, colixesConvex[i], vertexMap, faceMap);
        }
    }

    void allocTransformedProbeVertexes() {
        this.transformedProbeVertexes = new Vector3f[this.geodesicVertexCount];
        this.probeScreens = new Point3i[this.geodesicVertexCount];
        Vector3f[] transformedGeodesicVertexes = this.viewer.g3d.getTransformedVertexVectors();
        int i = this.geodesicVertexCount;
        while (--i >= 0) {
            this.transformedProbeVertexes[i] = new Vector3f();
            this.transformedProbeVertexes[i].scale(this.radiusP, (Tuple3f)transformedGeodesicVertexes[i]);
            this.probeScreens[i] = new Point3i();
        }
    }

    void renderConvex(Sasurface1 surface, Atom atom, short colix, int[] vertexMap, int[] faceMap) {
        if (this.hideConvex) {
            return;
        }
        Point3i[] screens = this.sasCache.lookupAtomScreens(atom, vertexMap);
        colix = Graphics3D.inheritColix((short)colix, (short)atom.colixAtom);
        int i = -1;
        while ((i = Bmp.nextSetBit((int[])faceMap, (int)(i + 1))) >= 0) {
            int j = 3 * i;
            short vA = this.geodesicFaceVertexes[j];
            short vB = this.geodesicFaceVertexes[j + 1];
            short vC = this.geodesicFaceVertexes[j + 2];
            this.g3d.fillTriangle(colix, screens[vA], vA, screens[vB], vB, screens[vC], vC);
        }
        if (this.showEdgeNumbers) {
            this.renderGeodesicEdgeNumbers(atom, vertexMap);
        }
    }

    void renderGeodesicEdgeNumbers(Atom atom, int[] vertexMap) {
        Point3i[] screens = this.sasCache.lookupAtomScreens(atom, vertexMap);
        this.findActualEdge(vertexMap, this.bmpEdge);
        int v = -1;
        while ((v = Bmp.nextSetBit((int[])this.bmpEdge, (int)(v + 1))) >= 0) {
            this.g3d.drawString("" + v, (short)9, screens[v].x, screens[v].y, screens[v].z - 20);
        }
    }

    boolean findActualEdge(int[] visibleVertexMap, int[] actualEdgeMap) {
        int edgeVertexCount = 0;
        Bmp.clearBitmap((int[])actualEdgeMap);
        int v = -1;
        block0: while ((v = Bmp.nextSetBit((int[])visibleVertexMap, (int)(v + 1))) >= 0) {
            int j;
            int neighborsOffset = v * 6;
            int n = j = v < 12 ? 5 : 6;
            while (--j >= 0) {
                short neighbor = this.geodesicNeighborVertexes[neighborsOffset + j];
                if (Bmp.getBit((int[])visibleVertexMap, (int)neighbor)) continue;
                Bmp.setBit((int[])actualEdgeMap, (int)v);
                ++edgeVertexCount;
                continue block0;
            }
        }
        return edgeVertexCount > 0;
    }

    void renderVertexDots(Atom atom, int[] vertexMap) {
        Point3i[] screens = this.sasCache.lookupAtomScreens(atom, vertexMap);
        int v = -1;
        while ((v = Bmp.nextSetBit((int[])vertexMap, (int)(v + 1))) >= 0) {
            this.g3d.fillSphereCentered((short)14, 5, screens[v]);
        }
    }

    void renderTorus(Sasurface1.Torus torus, Atom[] atoms, short[] convexColixes, int[][] convexVertexMaps) {
        if (this.hideSaddles) {
            return;
        }
        this.prepareTorusColixes(torus, convexColixes, atoms);
        this.renderTorus(torus, this.torusColixes);
        if (this.showEdgeNumbers) {
            this.renderTorusEdgeNumbers(torus);
        }
    }

    void renderTorusEdgeNumbers(Sasurface1.Torus torus) {
        Point3i[] screens = this.sasCache.lookupTorusScreens(torus);
        byte outerPointCount = torus.outerPointCount;
        int totalPointCount = torus.totalPointCount;
        for (int i = 0; i < totalPointCount; i += outerPointCount) {
            this.g3d.drawString("" + i, (short)10, screens[i].x, screens[i].y, screens[i].z - 20);
            int j = i + outerPointCount - 1;
            this.g3d.drawString("" + j, (short)20, screens[j].x, screens[j].y, screens[j].z - 20);
        }
    }

    void renderSeams(Sasurface1.Torus torus, Atom[] atoms, short[] convexColixes, int[][] convexVertexMaps) {
    }

    void renderSeam(Point3i[] torusScreens, short[] torusNormixes, Point3i[] geodesicScreens, short colix, short[] seam) {
        if (seam == null) {
            return;
        }
        boolean breakSeam = true;
        short prevTorus = -1;
        short prevGeodesic = -1;
        for (int i = 0; i < seam.length; ++i) {
            if (breakSeam) {
                prevTorus = seam[i++];
                prevGeodesic = ~seam[i];
                breakSeam = false;
                continue;
            }
            short v = seam[i];
            if (v >= 0) {
                this.g3d.fillTriangle(colix, torusScreens[prevTorus], torusNormixes[prevTorus], torusScreens[v], torusNormixes[v], geodesicScreens[prevGeodesic], prevGeodesic);
                prevTorus = v;
                continue;
            }
            if (v == Short.MIN_VALUE) {
                breakSeam = true;
                continue;
            }
            v = ~v;
            this.g3d.fillTriangle(colix, torusScreens[prevTorus], torusNormixes[prevTorus], geodesicScreens[v], v, geodesicScreens[prevGeodesic], prevGeodesic);
            prevGeodesic = v;
        }
        if (this.showEdgeNumbers) {
            this.renderSeamEdgeNumbers(torusScreens, geodesicScreens, seam);
        }
    }

    void renderSeamEdgeNumbers(Point3i[] torusScreens, Point3i[] geodesicScreens, short[] seam) {
        if (seam == null) {
            return;
        }
        boolean breakSeam = true;
        int prevTorus = -1;
        int prevGeodesic = -1;
        for (int i = 0; i < seam.length; ++i) {
            if (breakSeam) {
                prevTorus = seam[i++];
                this.g3d.drawString("" + prevTorus, (short)8, torusScreens[prevTorus].x, torusScreens[prevTorus].y, torusScreens[prevTorus].z - 21);
                prevGeodesic = ~seam[i];
                this.g3d.drawString("" + prevGeodesic, (short)8, geodesicScreens[prevGeodesic].x, geodesicScreens[prevGeodesic].y, geodesicScreens[prevGeodesic].z - 21);
                breakSeam = false;
                continue;
            }
            int v = seam[i];
            if (v >= 0) {
                this.g3d.drawString("" + v, (short)8, torusScreens[v].x, torusScreens[v].y, torusScreens[v].z - 21);
                prevTorus = v;
                continue;
            }
            if (v == Short.MIN_VALUE) {
                breakSeam = true;
                continue;
            }
            v = (short)(~v);
            this.g3d.drawString("" + v, (short)8, geodesicScreens[v].x, geodesicScreens[v].y, geodesicScreens[v].z - 21);
            prevGeodesic = v;
        }
    }

    void dumpSeam(short[] seam) {
        System.out.println("dumpSeam:");
        for (int i = 0; i < seam.length; ++i) {
            short v = seam[i];
            System.out.print("  " + v + " ");
            if (v == Short.MIN_VALUE) {
                System.out.println(" -- break");
                continue;
            }
            if (v < 0) {
                System.out.println("(" + ~v + ")");
                continue;
            }
            System.out.println("");
        }
    }

    void renderEdgeBalls(Atom atom, int[] edgeVertexes) {
        Point3i[] screens = this.sasCache.lookupAtomScreens(atom, edgeVertexes);
        int v = -1;
        while ((v = Bmp.nextSetBit((int[])edgeVertexes, (int)(v + 1))) >= 0) {
            this.g3d.fillSphereCentered((short)7, 10, screens[v]);
            this.g3d.drawString("" + v, (short)7, screens[v].x + 10, screens[v].y + 10, screens[v].z - 10);
        }
    }

    short getColix(short colix, short[] colixes, Atom[] atoms, int index) {
        return Graphics3D.inheritColix((short)colix, (short)atoms[index].colixAtom);
    }

    int getTorusOuterDotCount() {
        return 32;
    }

    int getTorusIncrement() {
        return 1;
    }

    void renderTorus(Sasurface1.Torus torus, short[] colixes) {
        Point3i[] screens = this.sasCache.lookupTorusScreens(torus);
        short[] normixes = torus.normixes;
        int outerPointCount = torus.outerPointCount;
        Sasurface1.TorusCavity[] torusCavities = torus.torusCavities;
        int torusCavityIndex = 0;
        int ixP = 0;
        int torusSegmentCount = torus.torusSegmentCount;
        for (int i = 0; i < torusSegmentCount; ++i) {
            if (torusCavities != null) {
                this.renderTorusCavityTriangle(screens, normixes, ixP, outerPointCount, colixes, torusCavities[torusCavityIndex++]);
            }
            int stepCount = torus.torusSegments[i].stepCount;
            int ixQ = ixP + outerPointCount;
            int j = stepCount;
            while (--j > 0) {
                ++ixP;
                ++ixQ;
                for (int k = 1; k < outerPointCount; ++k) {
                    this.g3d.fillQuadrilateral(screens[ixP - 1], colixes[k - 1], normixes[ixP - 1], screens[ixP], colixes[k], normixes[ixP], screens[ixQ], colixes[k], normixes[ixQ], screens[ixQ - 1], colixes[k - 1], normixes[ixQ - 1]);
                    ++ixP;
                    ++ixQ;
                }
            }
            if (torusCavities != null) {
                this.renderTorusCavityTriangle(screens, normixes, ixP, outerPointCount, colixes, torusCavities[torusCavityIndex++]);
            }
            ixP = ixQ;
        }
    }

    void renderTorusCavityTriangle(Point3i[] torusScreens, short[] torusNormixes, int torusIndex, int torusPointCount, short[] colixes, Sasurface1.TorusCavity torusCavity) {
        SasCavity cavity = torusCavity.cavity;
        this.viewer.transformPoint(cavity.pointBottom, this.screenCavityBottom);
        short normixCavityBottom = cavity.normixBottom;
        Point3i torusScreenLast = torusScreens[torusIndex];
        short torusNormixLast = torusNormixes[torusIndex];
        short colixLast = colixes[0];
        ++torusIndex;
        for (int i = 1; i < torusPointCount; ++i) {
            short colix;
            Point3i torusScreen = torusScreens[torusIndex];
            short torusNormix = torusNormixes[torusIndex];
            ++torusIndex;
            short colixBottom = colix = colixes[i];
            if (colix != colixLast) {
                colixBottom = this.g3d.getColixMix(colix, colixLast);
            }
            this.g3d.fillTriangle(torusScreenLast, colixLast, torusNormixLast, torusScreen, colix, torusNormix, this.screenCavityBottom, colixBottom, normixCavityBottom);
            torusScreenLast = torusScreen;
            torusNormixLast = torusNormix;
            colixLast = colix;
        }
    }

    void prepareTorusColixes(Sasurface1.Torus torus, short[] convexColixes, Atom[] atoms) {
        short colixB;
        int ixA = torus.ixA;
        int ixB = torus.ixB;
        int outerPointCount = torus.outerPointCount;
        short colixA = Graphics3D.inheritColix((short)torus.colixA, (short)convexColixes[ixA], (short)atoms[ixA].colixAtom);
        if (colixA == (colixB = Graphics3D.inheritColix((short)torus.colixB, (short)convexColixes[ixB], (short)atoms[ixB].colixAtom))) {
            int i = outerPointCount;
            while (--i >= 0) {
                this.torusColixes[i] = colixA;
            }
            return;
        }
        if (colixA < 0 && colixB < 0) {
            short unmaskedA = Graphics3D.getChangableColixIndex((short)colixA);
            short unmaskedB = Graphics3D.getChangableColixIndex((short)colixB);
            if (unmaskedA >= JmolConstants.FORMAL_CHARGE_COLIX_RED && unmaskedA <= JmolConstants.FORMAL_CHARGE_COLIX_BLUE && unmaskedB >= JmolConstants.FORMAL_CHARGE_COLIX_RED && unmaskedB <= JmolConstants.FORMAL_CHARGE_COLIX_BLUE) {
                this.prepareFormalChargeTorusColixes(colixA, unmaskedA, colixB, unmaskedB, outerPointCount);
                return;
            }
        }
        int halfRoundedUp = (outerPointCount + 1) / 2;
        this.torusColixes[outerPointCount / 2] = colixA;
        int i = outerPointCount / 2;
        while (--i >= 0) {
            this.torusColixes[i] = colixA;
            this.torusColixes[i + halfRoundedUp] = colixB;
        }
    }

    void prepareFormalChargeTorusColixes(short colixA, short unmaskedA, short colixB, short unmaskedB, int outerPointCount) {
        boolean crossesZero;
        int delta = unmaskedB - unmaskedA;
        int denominator = outerPointCount - 1;
        boolean bl = crossesZero = unmaskedA > JmolConstants.FORMAL_CHARGE_COLIX_WHITE && unmaskedB < JmolConstants.FORMAL_CHARGE_COLIX_WHITE || unmaskedA < JmolConstants.FORMAL_CHARGE_COLIX_WHITE && unmaskedB > JmolConstants.FORMAL_CHARGE_COLIX_WHITE;
        if (!crossesZero) {
            int i = outerPointCount;
            while (--i >= 0) {
                this.torusColixes[i] = (short)(colixA + i * delta / denominator);
            }
            return;
        }
        short whiteColix = JmolConstants.FORMAL_CHARGE_COLIX_WHITE;
        int i = outerPointCount;
        while (--i >= 0) {
            this.torusColixes[i] = 11;
        }
        int deltaA = whiteColix - unmaskedA;
        int indexWhiteA = deltaA * outerPointCount / delta - 1;
        this.torusColixes[indexWhiteA] = (short)(whiteColix | colixA & 0xC000);
        int i2 = indexWhiteA;
        while (--i2 >= 0) {
            this.torusColixes[i2] = (short)(colixA + i2 * deltaA / indexWhiteA);
        }
        int indexWhiteB = indexWhiteA + 1;
        if (indexWhiteB < outerPointCount) {
            int deltaB = unmaskedB - whiteColix;
            int whiteB = whiteColix | colixB & 0xC000;
            int denomB = outerPointCount - indexWhiteB - 1;
            this.torusColixes[indexWhiteB] = (short)whiteB;
            int i3 = outerPointCount;
            while (--i3 > indexWhiteB) {
                this.torusColixes[i3] = (short)(whiteB + (i3 - indexWhiteB) * deltaB / denomB);
            }
        }
    }
}

