/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import javax.vecmath.Point3f;
import org.jmol.viewer.AlphaMonomer;
import org.jmol.viewer.Atom;
import org.jmol.viewer.Chain;
import org.jmol.viewer.Closest;
import org.jmol.viewer.Group;
import org.jmol.viewer.PhosphorusMonomer;
import org.jmol.viewer.Polymer;
import org.jmol.viewer.ProteinStructure;

abstract class Monomer
extends Group {
    Polymer polymer;
    final byte[] offsets;

    Monomer(Chain chain, String group3, int seqcode, int firstAtomIndex, int lastAtomIndex, byte[] interestingAtomOffsets) {
        super(chain, group3, seqcode, firstAtomIndex, lastAtomIndex);
        this.offsets = interestingAtomOffsets;
    }

    void setPolymer(Polymer polymer) {
        this.polymer = polymer;
    }

    int getPolymerLength() {
        return this.polymer == null ? 0 : this.polymer.monomerCount;
    }

    int getPolymerIndex() {
        return this.polymer == null ? -1 : this.polymer.getIndex(this);
    }

    static byte[] scanForOffsets(int firstAtomIndex, int[] specialAtomIndexes, byte[] interestingAtomIDs) {
        int interestingCount = interestingAtomIDs.length;
        byte[] offsets = new byte[interestingCount];
        int i = interestingCount;
        while (--i >= 0) {
            int offset;
            int atomIndex;
            byte atomID = interestingAtomIDs[i];
            if (atomID < 0) {
                atomIndex = specialAtomIndexes[~atomID];
            } else {
                atomIndex = specialAtomIndexes[atomID];
                if (atomIndex < 0) {
                    return null;
                }
            }
            if (atomIndex < 0) {
                offset = 255;
            } else {
                offset = atomIndex - firstAtomIndex;
                if (offset < 0 || offset > 254) {
                    throw new NullPointerException();
                }
            }
            offsets[i] = (byte)offset;
        }
        return offsets;
    }

    boolean isDna() {
        return false;
    }

    boolean isRna() {
        return false;
    }

    final boolean isProtein() {
        return this instanceof AlphaMonomer;
    }

    final boolean isNucleic() {
        return this instanceof PhosphorusMonomer;
    }

    void setStructure(ProteinStructure proteinstructure) {
    }

    ProteinStructure getProteinStructure() {
        return null;
    }

    byte getProteinStructureType() {
        return 0;
    }

    boolean isHelix() {
        return false;
    }

    boolean isHelixOrSheet() {
        return false;
    }

    final Atom getAtomFromOffset(byte offset) {
        if (offset == -1) {
            return null;
        }
        return this.chain.frame.atoms[this.firstAtomIndex + (offset & 0xFF)];
    }

    final Point3f getAtomPointFromOffset(byte offset) {
        if (offset == -1) {
            return null;
        }
        return this.chain.frame.atoms[this.firstAtomIndex + (offset & 0xFF)].point3f;
    }

    final Atom getAtomFromOffsetIndex(int offsetIndex) {
        if (offsetIndex > this.offsets.length) {
            return null;
        }
        int offset = this.offsets[offsetIndex] & 0xFF;
        if (offset == 255) {
            return null;
        }
        return this.chain.frame.atoms[this.firstAtomIndex + offset];
    }

    final Point3f getAtomPointFromOffsetIndex(int offsetIndex) {
        Atom atom = this.getAtomFromOffsetIndex(offsetIndex);
        return atom == null ? null : atom.point3f;
    }

    final Atom getSpecialAtom(byte[] interestingIDs, byte specialAtomID) {
        int i = interestingIDs.length;
        while (--i >= 0) {
            byte interestingID = interestingIDs[i];
            if (interestingID < 0) {
                interestingID = -interestingID;
            }
            if (specialAtomID != interestingID) continue;
            int offset = this.offsets[i] & 0xFF;
            if (offset == 255) {
                return null;
            }
            return this.chain.frame.atoms[this.firstAtomIndex + offset];
        }
        return null;
    }

    final Point3f getSpecialAtomPoint(byte[] interestingIDs, byte specialAtomID) {
        int i = interestingIDs.length;
        while (--i >= 0) {
            byte interestingID = interestingIDs[i];
            if (interestingID < 0) {
                interestingID = -interestingID;
            }
            if (specialAtomID != interestingID) continue;
            int offset = this.offsets[i] & 0xFF;
            if (offset == 255) {
                return null;
            }
            return this.chain.frame.atoms[this.firstAtomIndex + offset].point3f;
        }
        return null;
    }

    Atom getAtom(byte specialAtomID) {
        return null;
    }

    Point3f getAtomPoint(byte specialAtomID) {
        return null;
    }

    final int getLeadAtomIndex() {
        return this.firstAtomIndex + (this.offsets[0] & 0xFF);
    }

    final Atom getLeadAtom() {
        return this.getAtomFromOffsetIndex(0);
    }

    final Point3f getLeadAtomPoint() {
        return this.getAtomPointFromOffsetIndex(0);
    }

    final Atom getWingAtom() {
        return this.getAtomFromOffsetIndex(1);
    }

    final Point3f getWingAtomPoint() {
        return this.getAtomPointFromOffsetIndex(1);
    }

    Atom getInitiatorAtom() {
        return this.getLeadAtom();
    }

    Atom getTerminatorAtom() {
        return this.getLeadAtom();
    }

    abstract boolean isConnectedAfter(Monomer var1);

    void findNearestAtomIndex(int x, int y, Closest closest, short madBegin, short madEnd) {
    }
}

