/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import org.jmol.g3d.Font3D;
import org.jmol.g3d.Graphics3D;
import org.jmol.viewer.Measurement;
import org.jmol.viewer.PendingMeasurement;
import org.jmol.viewer.Shape;
import org.jmol.viewer.Util;

class Measures
extends Shape {
    static final int measurementGrowthIncrement = 16;
    int measurementCount = 0;
    Measurement[] measurements = new Measurement[16];
    PendingMeasurement pendingMeasurement;
    short mad = (short)-1;
    short colix;
    boolean showMeasurementNumbers = true;
    Font3D font3d;

    Measures() {
    }

    void initShape() {
        this.pendingMeasurement = new PendingMeasurement(this.frame);
        this.font3d = this.g3d.getFont3D(15);
    }

    void clear() {
        int countT = this.measurementCount;
        this.measurementCount = 0;
        int i = countT;
        while (--i >= 0) {
            this.measurements[i] = null;
        }
    }

    boolean isDefined(int[] atomCountPlusIndices) {
        int i = this.measurementCount;
        while (--i >= 0) {
            if (!this.measurements[i].sameAs(atomCountPlusIndices)) continue;
            return true;
        }
        return false;
    }

    void define(int[] atomCountPlusIndices) {
        if (this.isDefined(atomCountPlusIndices)) {
            return;
        }
        Measurement measureNew = new Measurement(this.frame, atomCountPlusIndices);
        if (this.measurementCount == this.measurements.length) {
            this.measurements = (Measurement[])Util.setLength(this.measurements, this.measurementCount + 16);
        }
        this.measurements[this.measurementCount++] = measureNew;
    }

    boolean delete(Object value) {
        if (value instanceof int[]) {
            return this.delete((int[])value);
        }
        if (value instanceof Integer) {
            return this.delete((Integer)value);
        }
        return false;
    }

    boolean delete(int[] atomCountPlusIndices) {
        int i = this.measurementCount;
        while (--i >= 0) {
            if (!this.measurements[i].sameAs(atomCountPlusIndices)) continue;
            return this.delete(i);
        }
        return false;
    }

    boolean delete(int i) {
        if (i < this.measurementCount) {
            System.arraycopy(this.measurements, i + 1, this.measurements, i, this.measurementCount - i - 1);
            --this.measurementCount;
            this.measurements[this.measurementCount] = null;
            return true;
        }
        return false;
    }

    void toggle(int[] atomCountPlusIndices) {
        if (this.isDefined(atomCountPlusIndices)) {
            this.delete(atomCountPlusIndices);
        } else {
            this.define(atomCountPlusIndices);
        }
    }

    void pending(int[] countPlusIndices) {
        this.pendingMeasurement.setCountPlusIndices(countPlusIndices);
    }

    void setSize(int size, BitSet bsSelected) {
        this.mad = (short)size;
        System.out.println("Measures.setSize(" + size + ")");
    }

    void setProperty(String propertyName, Object value, BitSet bsSelected) {
        if ("color".equals(propertyName)) {
            System.out.println("Measures.color set to:" + value);
            this.colix = value == null ? (short)0 : Graphics3D.getColix((Object)value);
            return;
        }
        if ("font".equals(propertyName)) {
            this.font3d = (Font3D)value;
            return;
        }
        if ("define".equals(propertyName)) {
            this.define((int[])value);
        } else if ("delete".equals(propertyName)) {
            this.delete(value);
        } else if ("toggle".equals(propertyName)) {
            this.toggle((int[])value);
        } else if ("pending".equals(propertyName)) {
            this.pending((int[])value);
        } else if ("clear".equals(propertyName)) {
            this.clear();
        } else if ("showMeasurementNumbers".equals(propertyName)) {
            this.showMeasurementNumbers = (Boolean)value;
        } else if ("reformatDistances".equals(propertyName)) {
            this.reformatDistances();
        } else {
            return;
        }
        this.viewer.notifyMeasurementsChanged();
    }

    Object getProperty(String property, int index) {
        if ("count".equals(property)) {
            return new Integer(this.measurementCount);
        }
        if ("countPlusIndices".equals(property)) {
            return index < this.measurementCount ? this.measurements[index].countPlusIndices : null;
        }
        if ("stringValue".equals(property)) {
            return index < this.measurementCount ? this.measurements[index].strMeasurement : null;
        }
        return null;
    }

    void reformatDistances() {
        int i = this.measurementCount;
        while (--i >= 0) {
            this.measurements[i].reformatDistanceIfSelected();
        }
    }
}

