/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.io.BufferedReader;
import java.io.IOException;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.SmarterJmolAdapter;

class GaussianReader
extends AtomSetCollectionReader {
    private static final int STD_ORIENTATION_ATOMIC_NUMBER_OFFSET = 1;
    private static final int FREQ_FIRST_VECTOR_OFFSET = 2;
    private int firstCoordinateOffset = 3;
    private String scfEnergy = "";
    private String scfKey = "";
    private int calculationNumber = 1;
    private int scanPoint = -1;
    private int equivalentAtomSets = 0;

    GaussianReader() {
    }

    AtomSetCollection readAtomSetCollection(BufferedReader reader) throws Exception {
        this.atomSetCollection = new AtomSetCollection("gaussian");
        try {
            String line;
            int lineNum = 0;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith(" Step number")) {
                    this.equivalentAtomSets = 0;
                    int scanPointIndex = line.indexOf("scan point");
                    this.scanPoint = scanPointIndex > 0 ? this.parseInt(line, scanPointIndex + 10) : -1;
                } else if (line.indexOf("-- Stationary point found") > 0) {
                    if (this.scanPoint >= 0) {
                        ++this.scanPoint;
                    }
                } else if (line.indexOf("Input orientation:") >= 0 || line.indexOf("Z-Matrix orientation:") >= 0) {
                    ++this.equivalentAtomSets;
                    this.readAtoms(reader, line);
                } else if (line.indexOf("Standard orientation:") >= 0) {
                    ++this.equivalentAtomSets;
                    this.readAtoms(reader, line);
                } else if (line.startsWith(" SCF Done:")) {
                    this.readSCFDone(reader, line);
                } else if (line.startsWith(" Harmonic frequencies")) {
                    this.readFrequencies(reader);
                } else if (line.startsWith(" Total atomic charges:") || line.startsWith(" Mulliken atomic charges:")) {
                    this.readPartialCharges(reader);
                } else if (line.startsWith(" Normal termination of Gaussian")) {
                    ++this.calculationNumber;
                } else if (lineNum < 20 && line.indexOf("This is part of the Gaussian 94(TM) system") >= 0) {
                    this.firstCoordinateOffset = 2;
                }
                ++lineNum;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.atomSetCollection.errorMessage = "Could not read file:" + ex;
            return this.atomSetCollection;
        }
        if (this.atomSetCollection.atomCount == 0) {
            this.atomSetCollection.errorMessage = "No atoms in file";
        }
        return this.atomSetCollection;
    }

    private void readSCFDone(BufferedReader reader, String line) throws Exception {
        String[] tokens = this.getTokens(line, 11);
        this.scfKey = tokens[0];
        this.scfEnergy = tokens[2] + " " + tokens[3];
        this.atomSetCollection.setAtomSetNames(this.scfKey + " = " + this.scfEnergy, this.equivalentAtomSets);
        this.atomSetCollection.setAtomSetProperties(this.scfKey, this.scfEnergy, this.equivalentAtomSets);
        tokens = this.getTokens(reader.readLine());
        this.atomSetCollection.setAtomSetProperties(tokens[0], tokens[2], this.equivalentAtomSets);
        this.atomSetCollection.setAtomSetProperties(tokens[3], tokens[5], this.equivalentAtomSets);
        tokens = this.getTokens(reader.readLine());
        this.atomSetCollection.setAtomSetProperties(tokens[0], tokens[2], this.equivalentAtomSets);
    }

    private void readAtoms(BufferedReader reader, String line) throws Exception {
        this.atomSetCollection.newAtomSet();
        this.atomSetCollection.setAtomSetName("");
        String path = this.getTokens(line)[0];
        this.discardLines(reader, 4);
        while ((line = reader.readLine()) != null && !line.startsWith(" --")) {
            String[] tokens = this.getTokens(line);
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.elementNumber = (byte)this.parseInt(tokens[1]);
            if (atom.elementNumber < 0) {
                atom.elementNumber = 0;
            }
            int offset = this.firstCoordinateOffset;
            atom.x = this.parseFloat(tokens[offset]);
            atom.y = this.parseFloat(tokens[++offset]);
            atom.z = this.parseFloat(tokens[++offset]);
        }
        this.atomSetCollection.setAtomSetProperty(".PATH", "Calculation " + this.calculationNumber + (this.scanPoint >= 0 ? SmarterJmolAdapter.PATH_SEPARATOR + "Scan Point " + this.scanPoint : "") + SmarterJmolAdapter.PATH_SEPARATOR + path);
        this.atomSetCollection.setAtomSetName("Last read atomset.");
    }

    private void readFrequencies(BufferedReader reader) throws Exception, IOException {
        String line;
        while ((line = reader.readLine()) != null && line.indexOf(":") < 0) {
        }
        if (line == null) {
            throw new Exception("No frequencies encountered");
        }
        while ((line = reader.readLine()) != null && line.length() > 15) {
            String[] symmetries = this.getTokens(reader.readLine());
            String[] frequencies = this.getTokens(this.discardLinesUntilStartsWith(reader, " Frequencies"), 15);
            String[] red_masses = this.getTokens(this.discardLinesUntilStartsWith(reader, " Red. masses"), 15);
            String[] frc_consts = this.getTokens(this.discardLinesUntilStartsWith(reader, " Frc consts"), 15);
            String[] intensities = this.getTokens(this.discardLinesUntilStartsWith(reader, " IR Inten"), 15);
            int frequencyCount = frequencies.length;
            for (int i = 0; i < frequencyCount; ++i) {
                this.atomSetCollection.cloneLastAtomSet();
                this.atomSetCollection.setAtomSetName(symmetries[i] + " " + frequencies[i] + " cm**-1");
                this.atomSetCollection.setAtomSetProperty(this.scfKey, this.scfEnergy);
                this.atomSetCollection.setAtomSetProperty("Frequency", frequencies[i] + " cm**-1");
                this.atomSetCollection.setAtomSetProperty("Reduced Mass", red_masses[i] + " AMU");
                this.atomSetCollection.setAtomSetProperty("Force Constant", frc_consts[i] + " mDyne/A");
                this.atomSetCollection.setAtomSetProperty("IR Intensity", intensities[i] + " KM/Mole");
                this.atomSetCollection.setAtomSetProperty(".PATH", "Calculation " + this.calculationNumber + SmarterJmolAdapter.PATH_SEPARATOR + "Frequencies");
            }
            int atomCount = this.atomSetCollection.getLastAtomSetAtomCount();
            int firstModelAtom = this.atomSetCollection.atomCount - frequencyCount * atomCount;
            this.discardLinesUntilStartsWith(reader, " Atom AN");
            for (int i = 0; i < atomCount; ++i) {
                String[] tokens = this.getTokens(reader.readLine());
                int atomCenterNumber = this.parseInt(tokens[0]);
                int offset = 2;
                for (int j = 0; j < frequencyCount; ++j) {
                    int atomOffset = firstModelAtom + j * atomCount + atomCenterNumber - 1;
                    Atom atom = this.atomSetCollection.atoms[atomOffset];
                    atom.vectorX = this.parseFloat(tokens[offset++]);
                    atom.vectorY = this.parseFloat(tokens[offset++]);
                    atom.vectorZ = this.parseFloat(tokens[offset++]);
                }
            }
        }
    }

    void readPartialCharges(BufferedReader reader) throws Exception {
        this.discardLines(reader, 1);
        for (int i = this.atomSetCollection.getLastAtomSetAtomIndex(); i < this.atomSetCollection.atomCount; ++i) {
            while (this.atomSetCollection.atoms[i].elementNumber == 0) {
                ++i;
            }
            this.atomSetCollection.atoms[i].partialCharge = this.parseFloat(this.getTokens(reader.readLine())[2]);
        }
    }
}

