/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import org.jmol.viewer.Sasurface1;
import org.jmol.viewer.Shape;
import org.jmol.viewer.Util;

class Sasurface
extends Shape {
    static int MAX_GEODESIC_RENDERING_LEVEL = 2;
    static int MAX_FULL_TORUS_STEP_COUNT = 15;
    static int OUTER_TORUS_STEP_COUNT = 9;
    static final int MAX_TORUS_POINTS = MAX_FULL_TORUS_STEP_COUNT * OUTER_TORUS_STEP_COUNT;
    int surfaceCount;
    Sasurface1[] surfaces = new Sasurface1[4];
    Sasurface1 currentSurface;

    Sasurface() {
    }

    void initShape() {
    }

    void setSize(int size, BitSet bsSelected) {
        this.dumpState("setSize:" + size);
        if (this.currentSurface != null) {
            this.currentSurface.setSize(size, bsSelected);
        } else {
            int i = this.surfaceCount;
            while (--i >= 0) {
                this.surfaces[i].setSize(size, bsSelected);
            }
        }
    }

    void setProperty(String propertyName, Object value, BitSet bs) {
        System.out.println("Sasurface.setProperty(" + propertyName + "," + value + ")");
        this.dumpState("setProperty:" + propertyName + ":" + value);
        if ("surfaceID" == propertyName) {
            String surfaceID = (String)value;
            System.out.println("surfaceID=" + surfaceID);
            if (surfaceID == null) {
                this.currentSurface = null;
                System.out.println("----> null surfaceID");
                return;
            }
            int i = this.surfaceCount;
            while (--i >= 0) {
                this.currentSurface = this.surfaces[i];
                if (!surfaceID.equals(this.currentSurface.surfaceID)) continue;
                System.out.println("surfaceID is set to" + surfaceID);
                return;
            }
            this.allocSurface(surfaceID, bs);
            this.dumpState("done");
            return;
        }
        if ("delete" == propertyName) {
            System.out.println("delete && surfaceCount=" + this.surfaceCount);
            if (this.currentSurface != null) {
                System.out.println("deleting currentSurface:" + this.currentSurface.surfaceID);
                int iCurrent = this.surfaceCount;
                while (this.surfaces[--iCurrent] != this.currentSurface) {
                }
                for (int j = iCurrent + 1; j < this.surfaceCount; ++j) {
                    this.surfaces[j - 1] = this.surfaces[j];
                }
                this.surfaces[--this.surfaceCount] = null;
                this.currentSurface = null;
            } else {
                System.out.println("deleting all surfaces");
                int i = this.surfaceCount;
                while (--i >= 0) {
                    this.surfaces[i] = null;
                }
                this.surfaceCount = 0;
            }
            return;
        }
        if (this.currentSurface != null) {
            this.currentSurface.setProperty(propertyName, value, bs);
        } else {
            int i = this.surfaceCount;
            while (--i >= 0) {
                this.surfaces[i].setProperty(propertyName, value, bs);
            }
        }
    }

    void allocSurface(String surfaceID, BitSet bs) {
        System.out.println("allocSurface(" + surfaceID + ")");
        this.surfaces = (Sasurface1[])Util.ensureLength(this.surfaces, this.surfaceCount + 1);
        Sasurface1 sasurface1 = new Sasurface1(surfaceID, this.viewer, this.g3d, 21, bs);
        this.surfaces[this.surfaceCount++] = sasurface1;
        this.currentSurface = sasurface1;
    }

    void dumpState(String msg) {
        System.out.println(">>>>>>>>>>>>>>>>>>>>> " + msg);
        System.out.println("surfaceCount=" + this.surfaceCount);
        System.out.println("currentSurface=" + (this.currentSurface == null ? "NULL" : this.currentSurface.surfaceID));
    }
}

