/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.viewer.Util;
import org.jmol.viewer.Viewer;

class Mesh {
    Viewer viewer;
    String meshID;
    boolean visible = true;
    short colix;
    short[] vertexColixes;
    Graphics3D g3d;
    int vertexCount;
    Point3f[] vertices;
    short[] normixes;
    int polygonCount;
    int[][] polygonIndexes;
    boolean showPoints = false;
    boolean drawTriangles = false;
    boolean fillTriangles = true;

    Mesh(Viewer viewer, String meshID, Graphics3D g3d, short colix) {
        this.viewer = viewer;
        this.meshID = meshID;
        this.g3d = g3d;
        this.colix = colix;
    }

    void clear() {
        this.polygonCount = 0;
        this.vertexCount = 0;
        this.vertices = null;
        this.polygonIndexes = null;
    }

    void initialize() {
        Vector3f[] vectorSums = new Vector3f[this.vertexCount];
        int i = this.vertexCount;
        while (--i >= 0) {
            vectorSums[i] = new Vector3f();
        }
        this.sumVertexNormals(vectorSums);
        this.normixes = new short[this.vertexCount];
        i = this.vertexCount;
        while (--i >= 0) {
            this.normixes[i] = this.g3d.get2SidedNormix(vectorSums[i]);
        }
    }

    void allocVertexColixes() {
        if (this.vertexColixes == null) {
            this.vertexColixes = new short[this.vertexCount];
            int i = this.vertexCount;
            while (--i >= 0) {
                this.vertexColixes[i] = this.colix;
            }
        }
    }

    void setTranslucent(boolean isTranslucent) {
        this.colix = Graphics3D.setTranslucent((short)this.colix, (boolean)isTranslucent);
        if (this.vertexColixes != null) {
            int i = this.vertexCount;
            while (--i >= 0) {
                this.vertexColixes[i] = Graphics3D.setTranslucent((short)this.vertexColixes[i], (boolean)isTranslucent);
            }
        }
    }

    void sumVertexNormals(Vector3f[] vectorSums) {
        Vector3f vNormalizedNormal = new Vector3f();
        int i = this.polygonCount;
        while (--i >= 0) {
            int[] pi = this.polygonIndexes[i];
            this.g3d.calcNormalizedNormal(this.vertices[pi[0]], this.vertices[pi[1]], this.vertices[pi[2]], vNormalizedNormal);
            int j = pi.length;
            while (--j >= 0) {
                int k = pi[j];
                vectorSums[k].add((Tuple3f)vNormalizedNormal);
            }
        }
    }

    void setVertexCount(int vertexCount) {
        this.vertexCount = vertexCount;
        this.vertices = new Point3f[vertexCount];
    }

    void setPolygonCount(int polygonCount) {
        this.polygonCount = polygonCount;
        this.polygonIndexes = new int[polygonCount][];
    }

    int addVertexCopy(Point3f vertex) {
        if (this.vertexCount == 0) {
            this.vertices = new Point3f[256];
        } else if (this.vertexCount == this.vertices.length) {
            this.vertices = (Point3f[])Util.doubleLength(this.vertices);
        }
        this.vertices[this.vertexCount] = new Point3f(vertex);
        return this.vertexCount++;
    }

    void addTriangle(int vertexA, int vertexB, int vertexC) {
        if (this.polygonCount == 0) {
            this.polygonIndexes = new int[256][];
        } else if (this.polygonCount == this.polygonIndexes.length) {
            this.polygonIndexes = (int[][])Util.doubleLength(this.polygonIndexes);
        }
        int[] polygon = new int[]{vertexA, vertexB, vertexC};
        this.polygonIndexes[this.polygonCount++] = polygon;
    }

    void setColix(short colix) {
        this.colix = colix;
    }

    void checkForDuplicatePoints(float cutoff) {
        float cutoff2 = cutoff * cutoff;
        int i = this.vertexCount;
        while (--i >= 0) {
            int j = i;
            while (--j >= 0) {
                float dist2 = this.vertices[i].distanceSquared(this.vertices[j]);
                if (!(dist2 < cutoff2)) continue;
                System.out.println("Mesh.checkForDuplicates " + this.vertices[i] + "<->" + this.vertices[j] + " : " + Math.sqrt(dist2));
            }
        }
    }
}

