/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.Vector;
import org.jmol.g3d.Graphics3D;
import org.jmol.viewer.Group;
import org.jmol.viewer.Token;

class Compiler {
    String filename;
    String script;
    short[] lineNumbers;
    short[] lineIndices;
    Token[][] aatokenCompiled;
    boolean error;
    String errorMessage;
    String errorLine;
    static final boolean logMessages = false;
    int cchScript;
    short lineCurrent;
    int ichToken;
    int cchToken;
    Token[] atokenCommand;
    int ichCurrentCommand;
    String[] loadFormats = new String[]{"alchemy ", "mol2 ", "mopac ", "nmrpdb ", "charmm ", "xyz ", "mdl ", "pdb "};
    Vector ltokenPostfix = null;
    Token[] atokenInfix;
    int itokenInfix;
    boolean residueSpecCodeGenerated;
    int seqcode;

    Compiler() {
    }

    private void log(String message) {
    }

    boolean compile(String filename, String script) {
        this.filename = filename;
        this.script = script;
        this.lineIndices = null;
        this.lineNumbers = null;
        this.aatokenCompiled = null;
        this.errorLine = null;
        this.errorMessage = null;
        if (this.compile0()) {
            return true;
        }
        int icharEnd = script.indexOf(13, this.ichCurrentCommand);
        if (icharEnd == -1 && (icharEnd = script.indexOf(10, this.ichCurrentCommand)) == -1) {
            icharEnd = script.length();
        }
        this.errorLine = script.substring(this.ichCurrentCommand, icharEnd);
        return false;
    }

    short[] getLineNumbers() {
        return this.lineNumbers;
    }

    short[] getLineIndices() {
        return this.lineIndices;
    }

    Token[][] getAatokenCompiled() {
        return this.aatokenCompiled;
    }

    String getErrorMessage() {
        String strError = this.errorMessage;
        strError = strError + " : " + this.errorLine + "\n";
        if (this.filename != null) {
            strError = strError + this.filename;
        }
        strError = strError + " line#" + this.lineCurrent;
        return strError;
    }

    /*
     * Unable to fully structure code
     */
    boolean compile0() {
        this.cchScript = this.script.length();
        this.ichToken = 0;
        this.lineCurrent = 1;
        lnLength = 8;
        this.lineNumbers = new short[lnLength];
        this.lineIndices = new short[lnLength];
        this.error = false;
        lltoken = new Vector<Token[]>();
        ltoken = new Vector<Token>();
        tokCommand = 0;
        while (true) {
            block32: {
                block33: {
                    if (this.lookingAtLeadingWhitespace() || this.lookingAtComment()) break block32;
                    endOfLine = this.lookingAtEndOfLine();
                    if (!endOfLine && !this.lookingAtEndOfStatement()) break block33;
                    if (tokCommand != 0) {
                        if (!this.compileCommand(ltoken)) {
                            return false;
                        }
                        lltoken.addElement(this.atokenCommand);
                        iCommand = lltoken.size();
                        if (iCommand == lnLength) {
                            lnT = new short[lnLength * 2];
                            System.arraycopy(this.lineNumbers, 0, lnT, 0, lnLength);
                            this.lineNumbers = lnT;
                            lnT = new short[lnLength * 2];
                            System.arraycopy(this.lineIndices, 0, lnT, 0, lnLength);
                            this.lineIndices = lnT;
                            lnLength *= 2;
                        }
                        this.lineNumbers[iCommand] = this.lineCurrent;
                        this.lineIndices[iCommand] = (short)this.ichCurrentCommand;
                        ltoken.setSize(0);
                        tokCommand = 0;
                    }
                    if (this.ichToken >= this.cchScript) break;
                    if (endOfLine) {
                        this.lineCurrent = (short)(this.lineCurrent + 1);
                    }
                    break block32;
                }
                if (tokCommand == 0) ** GOTO lbl-1000
                if (this.lookingAtString()) {
                    str = this.getUnescapedStringLiteral();
                    ltoken.addElement(new Token(4, str));
                } else if (tokCommand == 0x100110 && this.lookingAtLoadFormat()) {
                    strFormat = this.script.substring(this.ichToken, this.ichToken + this.cchToken);
                    strFormat = strFormat.toLowerCase();
                    ltoken.addElement(new Token(1, strFormat));
                } else if ((tokCommand & 0x100000) != 0 && this.lookingAtSpecialString()) {
                    str = this.script.substring(this.ichToken, this.ichToken + this.cchToken);
                    ltoken.addElement(new Token(4, str));
                } else if (this.lookingAtDecimal((tokCommand & 0x200000) != 0)) {
                    value = Float.valueOf(this.script.substring(this.ichToken, this.ichToken + this.cchToken)).floatValue();
                    ltoken.addElement(new Token(3, new Float(value)));
                } else if (this.lookingAtSeqcode()) {
                    seqNum = Integer.parseInt(this.script.substring(this.ichToken, this.ichToken + this.cchToken - 2));
                    insertionCode = this.script.charAt(this.ichToken + this.cchToken - 1);
                    seqcode = Group.getSeqcode(seqNum, insertionCode);
                    ltoken.addElement(new Token(5, seqcode, "seqcode"));
                } else if (this.lookingAtInteger((tokCommand & 0x200000) != 0)) {
                    intString = this.script.substring(this.ichToken, this.ichToken + this.cchToken);
                    val = Integer.parseInt(intString);
                    ltoken.addElement(new Token(2, val, intString));
                } else if (this.lookingAtLookupToken()) {
                    ident = this.script.substring(this.ichToken, this.ichToken + this.cchToken);
                    if (ident.length() == 1) {
                        token = (Token)Token.map.get(ident);
                        if (token == null && (token = (Token)Token.map.get(lowerCaseIdent = ident.toLowerCase())) != null) {
                            token = new Token(token.tok, token.intValue, ident);
                        }
                    } else {
                        ident = ident.toLowerCase();
                        token = (Token)Token.map.get(ident);
                    }
                    if (token == null) {
                        token = new Token(1, ident);
                    }
                    tok = token.tok;
                    switch (tokCommand) {
                        case 0: {
                            this.ichCurrentCommand = this.ichToken;
                            tokCommand = tok;
                            if ((tokCommand & 256) != 0) break;
                            return this.commandExpected();
                        }
                        case 2105631: {
                            if (ltoken.size() != 1) break;
                            if ((tok & 0x400000) != 0) {
                                tokCommand = tok;
                                ltoken.removeAllElements();
                                break;
                            }
                            if ((tok & 2048) != 0 || tok == 1) break;
                            return this.cannotSet(ident);
                        }
                        case 288: {
                            if ((tok & 4096) != 0) break;
                            return this.cannotShow(ident);
                        }
                        case 777: {
                            if (!(ltoken.size() == 1 ? tok != 1 && (tok & 294912) != 294912 : tok != 1 && tok != 2105631 && (tok & 294912) == 0)) break;
                            return this.invalidExpressionToken(ident);
                        }
                        case 793: 
                        case 798: 
                        case 4868: {
                            if (tok == 1 || (tok & 32768) != 0) break;
                            return this.invalidExpressionToken(ident);
                        }
                    }
                    ltoken.addElement(token);
                } else {
                    if (ltoken.size() == 0) {
                        return this.commandExpected();
                    }
                    return this.unrecognizedToken();
                }
            }
            this.ichToken += this.cchToken;
        }
        this.aatokenCompiled = new Token[lltoken.size()][];
        lltoken.copyInto((Object[])this.aatokenCompiled);
        return true;
    }

    private static final boolean isSpaceOrTab(char ch) {
        return ch == ' ' || ch == '\t';
    }

    boolean lookingAtLeadingWhitespace() {
        int ichT;
        this.log("lookingAtLeadingWhitespace");
        for (ichT = this.ichToken; ichT < this.cchScript && Compiler.isSpaceOrTab(this.script.charAt(ichT)); ++ichT) {
        }
        this.cchToken = ichT - this.ichToken;
        this.log("leadingWhitespace cchScript=" + this.cchScript + " cchToken=" + this.cchToken);
        return this.cchToken > 0;
    }

    boolean lookingAtComment() {
        char ch;
        int ichEnd;
        this.log("lookingAtComment ichToken=" + this.ichToken + " cchToken=" + this.cchToken);
        int ichFirstSharp = -1;
        for (ichEnd = this.ichToken; ichEnd < this.cchScript && (ch = this.script.charAt(ichEnd)) != ';' && ch != '\r' && ch != '\n'; ++ichEnd) {
            if (ch != '#' || ichFirstSharp != -1) continue;
            ichFirstSharp = ichEnd;
        }
        if (ichFirstSharp == -1) {
            return false;
        }
        if (this.cchScript - ichFirstSharp >= 3 && this.script.charAt(ichFirstSharp + 1) == 'j' && this.script.charAt(ichFirstSharp + 2) == 'c') {
            this.cchToken = ichEnd - this.ichToken;
            return true;
        }
        if (ichFirstSharp != this.ichToken) {
            return false;
        }
        if (this.cchScript > this.ichToken + 3 && this.script.charAt(this.ichToken + 1) == 'j' && this.script.charAt(this.ichToken + 2) == 'x' && Compiler.isSpaceOrTab(this.script.charAt(this.ichToken + 3))) {
            this.cchToken = 4;
            return true;
        }
        this.cchToken = ichEnd - this.ichToken;
        return true;
    }

    boolean lookingAtEndOfLine() {
        this.log("lookingAtEndOfLine");
        if (this.ichToken == this.cchScript) {
            return true;
        }
        int ichT = this.ichToken;
        char ch = this.script.charAt(ichT);
        if (ch == '\r') {
            if (++ichT < this.cchScript && this.script.charAt(ichT) == '\n') {
                ++ichT;
            }
        } else if (ch == '\n') {
            ++ichT;
        } else {
            return false;
        }
        this.cchToken = ichT - this.ichToken;
        return true;
    }

    boolean lookingAtEndOfStatement() {
        if (this.ichToken == this.cchScript || this.script.charAt(this.ichToken) != ';') {
            return false;
        }
        this.cchToken = 1;
        return true;
    }

    boolean lookingAtString() {
        char ch;
        if (this.ichToken == this.cchScript) {
            return false;
        }
        if (this.script.charAt(this.ichToken) != '\"') {
            return false;
        }
        int ichT = this.ichToken + 1;
        boolean previousCharBackslash = false;
        while (ichT < this.cchScript && ((ch = this.script.charAt(ichT++)) != '\"' || previousCharBackslash)) {
            previousCharBackslash = ch == '\\' ? !previousCharBackslash : false;
        }
        this.cchToken = ichT - this.ichToken;
        return true;
    }

    String getUnescapedStringLiteral() {
        StringBuffer sb = new StringBuffer(this.cchToken - 2);
        int ichMax = this.ichToken + this.cchToken - 1;
        int ich = this.ichToken + 1;
        while (ich < ichMax) {
            int ch;
            if ((ch = this.script.charAt(ich++)) == 92 && ich < ichMax) {
                ch = this.script.charAt(ich++);
                switch (ch) {
                    case 98: {
                        ch = 8;
                        break;
                    }
                    case 110: {
                        ch = 10;
                        break;
                    }
                    case 116: {
                        ch = 9;
                        break;
                    }
                    case 114: {
                        ch = 13;
                    }
                    case 34: 
                    case 39: 
                    case 92: {
                        break;
                    }
                    case 117: 
                    case 120: {
                        char chT;
                        int hexit;
                        int digitCount;
                        int n = digitCount = ch == 120 ? 2 : 4;
                        if (ich >= ichMax) break;
                        int unicode = 0;
                        int k = digitCount;
                        while (--k >= 0 && ich < ichMax && (hexit = Compiler.getHexitValue(chT = this.script.charAt(ich))) >= 0) {
                            unicode <<= 4;
                            unicode += hexit;
                            ++ich;
                        }
                        ch = (char)unicode;
                    }
                }
            }
            sb.append((char)ch);
        }
        return "" + sb;
    }

    static int getHexitValue(char ch) {
        if (ch >= '0' && ch <= '9') {
            return ch - 48;
        }
        if (ch >= 'a' && ch <= 'f') {
            return 10 + ch - 97;
        }
        if (ch >= 'A' && ch <= 'F') {
            return 10 + ch - 65;
        }
        return -1;
    }

    boolean lookingAtLoadFormat() {
        int i = this.loadFormats.length;
        while (--i >= 0) {
            String strFormat = this.loadFormats[i];
            int cchFormat = strFormat.length();
            if (!this.script.regionMatches(true, this.ichToken, strFormat, 0, cchFormat)) continue;
            this.cchToken = cchFormat - 1;
            return true;
        }
        return false;
    }

    boolean lookingAtSpecialString() {
        char ch;
        int ichT;
        for (ichT = this.ichToken; ichT < this.cchScript && (ch = this.script.charAt(ichT)) != ';' && ch != '\r' && ch != '\n'; ++ichT) {
        }
        this.cchToken = ichT - this.ichToken;
        this.log("lookingAtSpecialString cchToken=" + this.cchToken);
        return this.cchToken > 0;
    }

    boolean lookingAtDecimal(boolean allowNegative) {
        if (this.ichToken == this.cchScript) {
            return false;
        }
        int ichT = this.ichToken;
        if (this.script.charAt(ichT) == '-') {
            ++ichT;
        }
        boolean digitSeen = false;
        int ch = 88;
        while (ichT < this.cchScript) {
            char c = this.script.charAt(ichT);
            ch = c;
            if (!Compiler.isDigit(c)) break;
            ++ichT;
            digitSeen = true;
        }
        if (ichT == this.cchScript || ch != 46) {
            return false;
        }
        if (ch == 46 && ichT + 1 < this.cchScript && Compiler.isAlphabetic(this.script.charAt(ichT + 1))) {
            return false;
        }
        ++ichT;
        while (ichT < this.cchScript && Compiler.isDigit(this.script.charAt(ichT))) {
            ++ichT;
            digitSeen = true;
        }
        this.cchToken = ichT - this.ichToken;
        return digitSeen;
    }

    static boolean isAlphabetic(char ch) {
        return ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z';
    }

    static boolean isDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    boolean lookingAtSeqcode() {
        int ichT;
        char ch = ' ';
        for (ichT = this.ichToken; ichT < this.cchScript; ++ichT) {
            char c = this.script.charAt(ichT);
            ch = c;
            if (!Compiler.isDigit(c)) break;
        }
        if (ichT == this.ichToken || ichT + 2 > this.cchScript || ch != '^') {
            return false;
        }
        if (!Compiler.isAlphabetic(ch = (char)this.script.charAt(++ichT))) {
            return false;
        }
        this.cchToken = ++ichT - this.ichToken;
        return true;
    }

    boolean lookingAtInteger(boolean allowNegative) {
        if (this.ichToken == this.cchScript) {
            return false;
        }
        int ichT = this.ichToken;
        if (allowNegative && this.script.charAt(this.ichToken) == '-') {
            ++ichT;
        }
        int ichBeginDigits = ichT;
        while (ichT < this.cchScript && Compiler.isDigit(this.script.charAt(ichT))) {
            ++ichT;
        }
        if (ichBeginDigits == ichT) {
            return false;
        }
        this.cchToken = ichT - this.ichToken;
        return true;
    }

    boolean lookingAtLookupToken() {
        if (this.ichToken == this.cchScript) {
            return false;
        }
        int ichT = this.ichToken;
        char ch = this.script.charAt(ichT++);
        switch (ch) {
            case '%': 
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case ',': 
            case '-': 
            case '.': 
            case ':': 
            case '@': 
            case '[': 
            case ']': {
                break;
            }
            case '&': 
            case '|': {
                if (ichT >= this.cchScript || this.script.charAt(ichT) != ch) break;
                ++ichT;
                break;
            }
            case '<': 
            case '=': 
            case '>': {
                if (ichT >= this.cchScript || (ch = this.script.charAt(ichT)) != '<' && ch != '=' && ch != '>') break;
                ++ichT;
                break;
            }
            case '!': 
            case '/': {
                if (ichT >= this.cchScript || this.script.charAt(ichT) != '=') break;
                ++ichT;
                break;
            }
            default: {
                if ((ch < 'a' || ch > 'z') && ch < 'A' && ch > 'Z' && ch != '_') {
                    return false;
                }
            }
            case '?': {
                while (ichT < this.cchScript && (Compiler.isAlphabetic(ch = this.script.charAt(ichT)) || Compiler.isDigit(ch) || ch == '_' || ch == '?') || ch == '^' && ichT > this.ichToken && Compiler.isDigit(this.script.charAt(ichT - 1))) {
                    ++ichT;
                }
                break block0;
            }
        }
        this.cchToken = ichT - this.ichToken;
        return true;
    }

    private boolean commandExpected() {
        return this.compileError("command expected");
    }

    private boolean cannotSet(String ident) {
        return this.compileError("cannot SET:" + ident);
    }

    private boolean cannotShow(String ident) {
        return this.compileError("cannot SHOW:" + ident);
    }

    private boolean invalidExpressionToken(String ident) {
        return this.compileError("invalid expression token:" + ident);
    }

    private boolean unrecognizedToken() {
        return this.compileError("unrecognized token");
    }

    private boolean badArgumentCount() {
        return this.compileError("bad argument count");
    }

    private boolean endOfExpressionExpected() {
        return this.compileError("end of expression expected");
    }

    private boolean leftParenthesisExpected() {
        return this.compileError("left parenthesis expected");
    }

    private boolean rightParenthesisExpected() {
        return this.compileError("right parenthesis expected");
    }

    private boolean commaExpected() {
        return this.compileError("comma expected");
    }

    private boolean stringExpected() {
        return this.compileError("string expected");
    }

    private boolean unrecognizedExpressionToken() {
        return this.compileError("unrecognized expression token:" + this.valuePeek());
    }

    private boolean comparisonOperatorExpected() {
        return this.compileError("comparison operator expected");
    }

    private boolean integerExpected() {
        return this.compileError("integer expected");
    }

    private boolean numberOrKeywordExpected() {
        return this.compileError("number or keyword expected");
    }

    private boolean badRGBColor() {
        return this.compileError("bad [R,G,B] color");
    }

    private boolean identifierOrResidueSpecificationExpected() {
        return this.compileError("identifier or residue specification expected");
    }

    private boolean residueSpecificationExpected() {
        return this.compileError("3 letter residue specification expected");
    }

    private boolean invalidChainSpecification() {
        return this.compileError("invalid chain specification");
    }

    private boolean invalidModelSpecification() {
        return this.compileError("invalid model specification");
    }

    private boolean invalidAtomSpecification() {
        return this.compileError("invalid atom specification");
    }

    private boolean compileError(String errorMessage) {
        System.out.println("compileError(" + errorMessage + ")");
        this.error = true;
        this.errorMessage = errorMessage;
        return false;
    }

    private boolean compileCommand(Vector ltoken) {
        int size;
        Token tokenCommand = (Token)ltoken.firstElement();
        int tokCommand = tokenCommand.tok;
        if ((tokenCommand.intValue & 0x21) == 33 && ltoken.size() == 1) {
            ltoken.addElement(Token.tokenOn);
        }
        if (tokCommand == 2105631 && (size = ltoken.size()) < 2) {
            return this.badArgumentCount();
        }
        this.atokenCommand = new Token[ltoken.size()];
        ltoken.copyInto(this.atokenCommand);
        if ((tokCommand & 0x600) != 0 && !this.compileExpression()) {
            return false;
        }
        if ((tokCommand & 0x80000) != 0 && !this.compileColorParam()) {
            return false;
        }
        if ((tokenCommand.intValue & 0x10) == 0 && (tokenCommand.intValue & 0xF) + 1 != this.atokenCommand.length) {
            return this.badArgumentCount();
        }
        return true;
    }

    private boolean compileExpression() {
        int i;
        int tokCommand = this.atokenCommand[0].tok;
        if (tokCommand == 777) {
            i = 2;
        } else if ((tokCommand & 0x400) != 0) {
            for (i = 1; i < this.atokenCommand.length && this.atokenCommand[i].tok != 32768; ++i) {
            }
        }
        if (i >= this.atokenCommand.length) {
            return true;
        }
        return this.compileExpression(i);
    }

    boolean addTokenToPostfix(Token token) {
        this.ltokenPostfix.addElement(token);
        return true;
    }

    boolean compileExpression(int itoken) {
        this.ltokenPostfix = new Vector();
        for (int i = 0; i < itoken; ++i) {
            this.addTokenToPostfix(this.atokenCommand[i]);
        }
        this.atokenInfix = this.atokenCommand;
        this.itokenInfix = itoken;
        this.addTokenToPostfix(Token.tokenExpressionBegin);
        if (!this.clauseOr()) {
            return false;
        }
        this.addTokenToPostfix(Token.tokenExpressionEnd);
        if (this.itokenInfix != this.atokenInfix.length) {
            return this.endOfExpressionExpected();
        }
        this.atokenCommand = new Token[this.ltokenPostfix.size()];
        this.ltokenPostfix.copyInto(this.atokenCommand);
        return true;
    }

    Token tokenNext() {
        if (this.itokenInfix == this.atokenInfix.length) {
            return null;
        }
        return this.atokenInfix[this.itokenInfix++];
    }

    Object valuePeek() {
        if (this.itokenInfix == this.atokenInfix.length) {
            return null;
        }
        return this.atokenInfix[this.itokenInfix].value;
    }

    int tokPeek() {
        if (this.itokenInfix == this.atokenInfix.length) {
            return 0;
        }
        return this.atokenInfix[this.itokenInfix].tok;
    }

    boolean clauseOr() {
        if (!this.clauseAnd()) {
            return false;
        }
        while (this.tokPeek() == 32772) {
            Token tokenOr = this.tokenNext();
            if (!this.clauseAnd()) {
                return false;
            }
            this.addTokenToPostfix(tokenOr);
        }
        return true;
    }

    boolean clauseAnd() {
        if (!this.clauseNot()) {
            return false;
        }
        while (this.tokPeek() == 32771) {
            Token tokenAnd = this.tokenNext();
            if (!this.clauseNot()) {
                return false;
            }
            this.addTokenToPostfix(tokenAnd);
        }
        return true;
    }

    boolean clauseNot() {
        if (this.tokPeek() == 32773) {
            Token tokenNot = this.tokenNext();
            if (!this.clauseNot()) {
                return false;
            }
            return this.addTokenToPostfix(tokenNot);
        }
        return this.clausePrimitive();
    }

    boolean clausePrimitive() {
        int tok = this.tokPeek();
        switch (tok) {
            case 32774: {
                return this.clauseWithin();
            }
            case 32784: {
                return this.clauseSubstructure();
            }
            case 1: 
            case 2: 
            case 5: 
            case 32770: 
            case 32777: 
            case 32780: 
            case 32782: 
            case 49154: 
            case 49156: 
            case 311299: {
                return this.clauseResidueSpec();
            }
            default: {
                if ((tok & 0x18000) == 98304) {
                    return this.clauseComparator();
                }
                if ((tok & 0x48000) != 294912) break;
            }
            case 36875: 
            case 49157: {
                return this.addTokenToPostfix(this.tokenNext());
            }
            case 32768: {
                this.tokenNext();
                if (!this.clauseOr()) {
                    return false;
                }
                if (this.tokenNext().tok != 32769) {
                    return this.rightParenthesisExpected();
                }
                return true;
            }
        }
        return this.unrecognizedExpressionToken();
    }

    boolean clauseComparator() {
        Token tokenAtomProperty = this.tokenNext();
        Token tokenComparator = this.tokenNext();
        if ((tokenComparator.tok & 0x28000) == 0) {
            return this.comparisonOperatorExpected();
        }
        Token tokenValue = this.tokenNext();
        if (tokenValue.tok != 2) {
            return this.integerExpected();
        }
        int val = tokenValue.intValue;
        return this.addTokenToPostfix(new Token(tokenComparator.tok, tokenAtomProperty.tok, new Integer(val)));
    }

    /*
     * WARNING - void declaration
     */
    boolean clauseWithin() {
        void var1_2;
        this.tokenNext();
        if (this.tokenNext().tok != 32768) {
            return this.leftParenthesisExpected();
        }
        Token tokenDistance = this.tokenNext();
        switch (tokenDistance.tok) {
            case 2: {
                Object distance = new Float((float)(tokenDistance.intValue * 4) / 1000.0f);
                break;
            }
            case 3: 
            case 36868: 
            case 36869: 
            case 102661: {
                Object distance = tokenDistance.value;
                break;
            }
            default: {
                return this.numberOrKeywordExpected();
            }
        }
        if (this.tokenNext().tok != 32772) {
            return this.commaExpected();
        }
        if (!this.clauseOr()) {
            return false;
        }
        if (this.tokenNext().tok != 32769) {
            return this.rightParenthesisExpected();
        }
        return this.addTokenToPostfix(new Token(32774, var1_2));
    }

    boolean clauseSubstructure() {
        this.tokenNext();
        if (this.tokenNext().tok != 32768) {
            return this.leftParenthesisExpected();
        }
        Token tokenSmiles = this.tokenNext();
        if (tokenSmiles.tok != 4) {
            return this.stringExpected();
        }
        if (this.tokenNext().tok != 32769) {
            return this.rightParenthesisExpected();
        }
        return this.addTokenToPostfix(new Token(32784, tokenSmiles.value));
    }

    boolean generateResidueSpecCode(Token token) {
        this.addTokenToPostfix(token);
        if (this.residueSpecCodeGenerated) {
            this.addTokenToPostfix(Token.tokenAnd);
        }
        this.residueSpecCodeGenerated = true;
        return true;
    }

    boolean clauseResidueSpec() {
        boolean specSeen = false;
        this.residueSpecCodeGenerated = false;
        int tok = this.tokPeek();
        if (tok == 32777 || tok == 32780 || tok == 1 || tok == 2105631 || tok == 49154 || tok == 311299 || tok == 49156) {
            this.log("I see a residue name");
            if (!this.clauseResNameSpec()) {
                return false;
            }
            specSeen = true;
            tok = this.tokPeek();
        }
        if (tok == 32777 || tok == 32770 || tok == 2 || tok == 5) {
            this.log("I see a residue number");
            if (!this.clauseResNumSpec()) {
                return false;
            }
            specSeen = true;
            tok = this.tokPeek();
        }
        if (tok == 32782 || tok == 32777 || tok == 1 || tok == 49154 || tok == 311299 || tok == 49156 || tok == 2) {
            if (!this.clauseChainSpec()) {
                return false;
            }
            specSeen = true;
            tok = this.tokPeek();
        }
        if (tok == 32779) {
            if (!this.clauseAtomSpec()) {
                return false;
            }
            specSeen = true;
            tok = this.tokPeek();
        }
        if (tok == 49181) {
            if (!this.clauseAlternateSpec()) {
                return false;
            }
            specSeen = true;
            tok = this.tokPeek();
        }
        if (tok == 32782 || tok == 32783) {
            if (!this.clauseModelSpec()) {
                return false;
            }
            specSeen = true;
            tok = this.tokPeek();
        }
        if (!specSeen) {
            return this.residueSpecificationExpected();
        }
        if (!this.residueSpecCodeGenerated) {
            this.addTokenToPostfix(Token.tokenAll);
        }
        return true;
    }

    boolean clauseResNameSpec() {
        int tokPeek = this.tokPeek();
        if (tokPeek == 32777) {
            this.tokenNext();
            return true;
        }
        Token tokenT = this.tokenNext();
        if (tokenT.tok == 32780) {
            int tok;
            this.log("I see a left square bracket");
            tokenT = this.tokenNext();
            if (tokenT == null) {
                return false;
            }
            String strSpec = "";
            if (tokenT.tok == 32775) {
                strSpec = "+";
                tokenT = this.tokenNext();
            }
            if ((tok = tokenT.tok) == 2) {
                strSpec = strSpec + tokenT.value;
                tokenT = this.tokenNext();
                if (tokenT == null) {
                    return false;
                }
                tok = tokenT.tok;
            }
            if (tok == 1 || tok == 2105631 || tok == 49154 || tok == 311299 || tok == 49156) {
                strSpec = strSpec + tokenT.value;
                tokenT = this.tokenNext();
                if (tokenT == null) {
                    return false;
                }
                tok = tokenT.tok;
            }
            if (strSpec == "") {
                return this.residueSpecificationExpected();
            }
            short groupID = Group.lookupGroupID(strSpec = strSpec.toUpperCase());
            if (groupID != -1) {
                this.generateResidueSpecCode(new Token(16405, groupID, strSpec));
            } else {
                this.generateResidueSpecCode(new Token(16406, strSpec));
            }
            return tok == 32781;
        }
        return this.processIdentifier(tokenT);
    }

    boolean processIdentifier(Token tokenIdent) {
        String strUpper3;
        if (tokenIdent.tok != 1) {
            return this.identifierOrResidueSpecificationExpected();
        }
        String strToken = (String)tokenIdent.value;
        this.log("processing identifier:" + strToken);
        int cchToken = strToken.length();
        if (cchToken < 3) {
            return this.generateResidueSpecCode(tokenIdent);
        }
        for (int i = 3; i < cchToken - 1; ++i) {
            if (Character.isDigit(strToken.charAt(i))) continue;
            return this.generateResidueSpecCode(tokenIdent);
        }
        this.log("still here looking at:" + strToken);
        int seqcode = -1;
        char chain = '?';
        if (cchToken > 3) {
            String strResno;
            char chLast = strToken.charAt(cchToken - 1);
            this.log("the last character is:" + chLast);
            if (Character.isDigit(chLast)) {
                strResno = strToken.substring(3);
                this.log("strResNo=" + strResno);
            } else {
                chain = chLast;
                strResno = strToken.substring(3, cchToken - 1);
            }
            try {
                int sequenceNum = Integer.parseInt(strResno);
                this.log("I parsed sequenceNum=" + sequenceNum);
                seqcode = Group.getSeqcode(sequenceNum, ' ');
            }
            catch (NumberFormatException e) {
                return this.generateResidueSpecCode(tokenIdent);
            }
        }
        if ((strUpper3 = strToken.substring(0, 3).toUpperCase()).charAt(0) == '?' || strUpper3.charAt(1) == '?' || strUpper3.charAt(2) == '?') {
            this.generateResidueSpecCode(new Token(16406, strUpper3));
        } else {
            short groupID = Group.lookupGroupID(strUpper3);
            if (groupID != -1) {
                this.generateResidueSpecCode(new Token(16405, groupID, strUpper3));
            } else {
                return this.generateResidueSpecCode(tokenIdent);
            }
        }
        this.log(" I see a residue name:" + strUpper3 + " seqcode=" + seqcode + " chain=" + chain);
        if (seqcode != -1) {
            this.generateResidueSpecCode(new Token(16407, seqcode, "spec_seqcode"));
        }
        if (chain != '?') {
            this.generateResidueSpecCode(new Token(16409, chain, "spec_chain"));
        }
        return true;
    }

    boolean clauseResNumSpec() {
        this.log("clauseResNumSpec()");
        if (this.tokPeek() == 32777) {
            this.tokenNext();
            return true;
        }
        return this.clauseSequenceRange();
    }

    boolean clauseSequenceRange() {
        if (!this.clauseSequenceCode()) {
            return false;
        }
        if (this.tokPeek() == 32770) {
            this.tokenNext();
            int seqcodeA = this.seqcode;
            if (!this.clauseSequenceCode()) {
                return false;
            }
            return this.generateResidueSpecCode(new Token(16408, seqcodeA, new Integer(this.seqcode)));
        }
        return this.generateResidueSpecCode(new Token(16407, this.seqcode, "seqcode"));
    }

    boolean clauseSequenceCode() {
        boolean negative = false;
        int tokPeek = this.tokPeek();
        if (tokPeek == 32770) {
            this.tokenNext();
            negative = true;
            tokPeek = this.tokPeek();
        }
        if (tokPeek == 5) {
            this.seqcode = this.tokenNext().intValue;
        } else if (tokPeek == 2) {
            this.seqcode = Group.getSeqcode(this.tokenNext().intValue, ' ');
        } else {
            return false;
        }
        if (negative) {
            this.seqcode = -this.seqcode;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    boolean clauseChainSpec() {
        void var2_1;
        if (this.tokPeek() == 32782) {
            this.tokenNext();
        }
        if (this.tokPeek() == 32777) {
            this.tokenNext();
            return true;
        }
        if (this.tokPeek() == 32782) {
            return true;
        }
        switch (this.tokPeek()) {
            case 0: 
            case 32779: 
            case 32782: {
                char chain = '\u0000';
                break;
            }
            case 2: {
                Token tokenChain = this.tokenNext();
                if (tokenChain.intValue < 0 || tokenChain.intValue > 9) {
                    return this.invalidChainSpecification();
                }
                char chain = (char)(48 + tokenChain.intValue);
                break;
            }
            case 1: 
            case 49154: 
            case 49156: 
            case 311299: {
                Token tokenChain = this.tokenNext();
                String strChain = (String)tokenChain.value;
                if (strChain.length() != 1) {
                    return this.invalidChainSpecification();
                }
                char chain = strChain.charAt(0);
                if (chain != '?') break;
                return true;
            }
            default: {
                return this.invalidChainSpecification();
            }
        }
        return this.generateResidueSpecCode(new Token(16409, (int)var2_1, "spec_chain"));
    }

    boolean clauseAlternateSpec() {
        int tok = this.tokPeek();
        if (tok == 49181) {
            this.tokenNext();
        }
        if (this.tokPeek() == 32777) {
            this.tokenNext();
            return true;
        }
        Token tokenAlternate = this.tokenNext();
        switch (tokenAlternate.tok) {
            case 1: 
            case 2: 
            case 4: 
            case 49154: 
            case 49156: 
            case 311299: {
                break;
            }
            default: {
                return this.invalidModelSpecification();
            }
        }
        String alternate = (String)tokenAlternate.value;
        System.out.println("alternate specification seen:" + alternate);
        return this.generateResidueSpecCode(new Token(16410, alternate));
    }

    boolean clauseModelSpec() {
        int tok = this.tokPeek();
        if (tok == 32782 || tok == 32783) {
            this.tokenNext();
        }
        if (this.tokPeek() == 32777) {
            this.tokenNext();
            return true;
        }
        Token tokenModel = this.tokenNext();
        switch (tokenModel.tok) {
            case 1: 
            case 2: 
            case 4: 
            case 49154: 
            case 49156: 
            case 311299: {
                break;
            }
            default: {
                return this.invalidModelSpecification();
            }
        }
        return this.generateResidueSpecCode(new Token(16411, (String)tokenModel.value));
    }

    boolean clauseAtomSpec() {
        if (this.tokenNext().tok != 32779) {
            return this.invalidAtomSpecification();
        }
        Token tokenAtomSpec = this.tokenNext();
        if (tokenAtomSpec == null) {
            return true;
        }
        switch (tokenAtomSpec.tok) {
            case 32777: {
                return true;
            }
            case 1: 
            case 49154: 
            case 49156: 
            case 311299: {
                break;
            }
            default: {
                return this.invalidAtomSpecification();
            }
        }
        String atomSpec = (String)tokenAtomSpec.value;
        if (this.tokPeek() == 32777) {
            this.tokenNext();
            atomSpec = atomSpec + "*";
        }
        return this.generateResidueSpecCode(new Token(16412, atomSpec));
    }

    boolean compileColorParam() {
        for (int i = 1; i < this.atokenCommand.length; ++i) {
            String id;
            int argb;
            Token token = this.atokenCommand[i];
            if (token.tok == 32780) {
                Token[] atokenNew = new Token[i + 1];
                System.arraycopy(this.atokenCommand, 0, atokenNew, 0, i);
                if (!this.compileRGB(this.atokenCommand, i, atokenNew)) {
                    return false;
                }
                this.atokenCommand = atokenNew;
                break;
            }
            if (token.tok != 1 || (argb = Graphics3D.getArgbFromString((String)(id = (String)token.value))) == 0) continue;
            token.tok = 540692;
            token.intValue = argb;
        }
        return true;
    }

    boolean compileRGB(Token[] atoken, int i, Token[] atokenNew) {
        String hex;
        if (atoken.length == i + 7 && atoken[i].tok == 32780 && atoken[i + 1].tok == 2 && atoken[i + 2].tok == 32772 && atoken[i + 3].tok == 2 && atoken[i + 4].tok == 32772 && atoken[i + 5].tok == 2 && atoken[i + 6].tok == 32781) {
            int rgb = atoken[i + 1].intValue << 16 | atoken[i + 3].intValue << 8 | atoken[i + 5].intValue;
            atokenNew[i] = new Token(540692, rgb, "[R,G,B]");
            return true;
        }
        if (atoken.length == i + 3 && atoken[i].tok == 32780 && atoken[i + 1].tok == 1 && atoken[i + 2].tok == 32781 && (hex = (String)atoken[i + 1].value).length() == 7 && hex.charAt(0) == 'x') {
            try {
                int rgb = Integer.parseInt(hex.substring(1), 16);
                atokenNew[i] = new Token(540692, rgb, "[xRRGGBB]");
                return true;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return this.badRGBColor();
    }
}

