/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.awt.Color;
import org.jmol.g3d.Graphics3D;
import org.jmol.viewer.Atom;
import org.jmol.viewer.Frame;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.Viewer;

class ColorManager {
    Viewer viewer;
    Graphics3D g3d;
    int[] argbsCpk;
    String paletteDefault = "cpk";
    static final Color colorSelectionDefault = Graphics3D.COLOR_GOLD;
    static final short colixSelectionDefault = 23;
    Color colorSelection = colorSelectionDefault;
    short colixSelection = (short)23;
    Color colorRubberband = Color.pink;
    short colixRubberband = (short)22;
    boolean isBondAtomColor = true;
    Color colorBond = null;
    short colixBond = 0;
    Color colorHbond = null;
    short colixHbond = 0;
    Color colorSsbond = null;
    short colixSsbond = 0;
    Color colorLabel = Color.black;
    short colixLabel = (short)4;
    short colixDotsConvex = 0;
    short colixDotsConcave = 0;
    short colixDotsSaddle = 0;
    Color colorDistance = Color.white;
    short colixDistance = (short)8;
    Color colorAngle = Color.white;
    short colixAngle = (short)8;
    Color colorTorsion = Color.white;
    short colixTorsion = (short)8;
    Color colorBackground = Color.white;
    short colixBackground = (short)8;
    Color colorAxes = new Color(128, 128, 0);
    short colixAxes = (short)17;
    Color colorAxesText = this.colorAxes;
    short colixAxesText = (short)17;
    Color colorVector = Color.black;
    short colixVector = (short)4;

    ColorManager(Viewer viewer, Graphics3D g3d) {
        this.viewer = viewer;
        this.g3d = g3d;
        this.argbsCpk = JmolConstants.argbsCpk;
    }

    void setDefaultColors(String colorScheme) {
        System.out.println("setting color scheme to:" + colorScheme);
        if (colorScheme.equals("jmol")) {
            this.argbsCpk = JmolConstants.argbsCpk;
            this.viewer.setColorBackground(Color.black);
            this.viewer.setColorMeasurement(null);
            this.viewer.setColorLabel(Color.white);
            this.viewer.setShapeColorProperty(7, null);
        } else if (colorScheme.equals("rasmol")) {
            this.copyArgbsCpk();
            int argb = JmolConstants.argbsCpkRasmol[0] | 0xFF000000;
            int i = this.argbsCpk.length;
            while (--i >= 0) {
                this.argbsCpk[i] = argb;
            }
            i = JmolConstants.argbsCpkRasmol.length;
            while (--i >= 0) {
                argb = JmolConstants.argbsCpkRasmol[i];
                int atomNo = argb >> 24;
                this.argbsCpk[atomNo] = argb |= 0xFF000000;
            }
            this.viewer.setColorBackground(Color.black);
            this.viewer.setColorMeasurement(Color.white);
            this.viewer.setColorLabel(null);
            this.viewer.setShapeColorProperty(7, null);
        } else {
            System.out.println("unrecognized color scheme");
            return;
        }
        int i = JmolConstants.argbsCpk.length;
        while (--i >= 0) {
            this.g3d.changeColixArgb((short)i, this.argbsCpk[i]);
        }
    }

    void copyArgbsCpk() {
        this.argbsCpk = new int[JmolConstants.argbsCpk.length];
        int i = JmolConstants.argbsCpk.length;
        while (--i >= 0) {
            this.argbsCpk[i] = JmolConstants.argbsCpk[i];
        }
    }

    void setPaletteDefault(String palette) {
        this.paletteDefault = palette.intern();
    }

    void setColorSelection(Color c) {
        if (c == null) {
            c = colorSelectionDefault;
        }
        this.colorSelection = c;
        this.colixSelection = Graphics3D.getColix((Color)c);
    }

    Color getColorSelection() {
        return this.colorSelection;
    }

    short getColixSelection() {
        return this.colixSelection;
    }

    Color getColorRubberband() {
        return this.colorRubberband;
    }

    short getColixRubberband() {
        return this.colixRubberband;
    }

    void setColorRubberband(Color color) {
        if (color == null) {
            color = Color.pink;
        }
        this.colorRubberband = color;
        this.colixRubberband = Graphics3D.getColix((Color)color);
    }

    void setIsBondAtomColor(boolean isBondAtomColor) {
        this.isBondAtomColor = isBondAtomColor;
    }

    void setColorBond(Color c) {
        this.colorBond = c;
        this.colixBond = Graphics3D.getColix((Color)c);
    }

    void setColorHbond(Color c) {
        this.colorHbond = c;
        this.colixHbond = Graphics3D.getColix((Color)c);
    }

    void setColorSsbond(Color c) {
        this.colorSsbond = c;
        this.colixSsbond = Graphics3D.getColix((Color)c);
    }

    void setColorLabel(Color color) {
        this.colorLabel = color;
        this.colixLabel = Graphics3D.getColix((Color)color);
    }

    void setColorDotsConvex(Color color) {
        this.colixDotsConvex = Graphics3D.getColix((Color)color);
    }

    void setColorDotsConcave(Color color) {
        this.colixDotsConcave = Graphics3D.getColix((Color)color);
    }

    void setColorDotsSaddle(Color color) {
        this.colixDotsSaddle = Graphics3D.getColix((Color)color);
    }

    void setColorDistance(Color c) {
        this.colorDistance = c;
        this.colixDistance = Graphics3D.getColix((Color)c);
    }

    void setColorAngle(Color c) {
        this.colorAngle = c;
        this.colixAngle = Graphics3D.getColix((Color)c);
    }

    void setColorTorsion(Color c) {
        this.colorTorsion = c;
        this.colixTorsion = Graphics3D.getColix((Color)c);
    }

    void setColorMeasurement(Color c) {
        this.colorAngle = this.colorTorsion = c;
        this.colorDistance = this.colorTorsion;
        this.colixAngle = this.colixTorsion = Graphics3D.getColix((Color)c);
        this.colixDistance = this.colixTorsion;
    }

    void setColorBackground(Color bg) {
        this.colorBackground = bg == null ? Color.getColor("colorBackground") : bg;
        this.colixBackground = Graphics3D.getColix((Color)this.colorBackground);
        this.g3d.setBackground(this.colixBackground);
    }

    void setColorAxes(Color color) {
        this.colorAxes = color;
        this.colixAxes = Graphics3D.getColix((Color)color);
    }

    void setColorAxesText(Color color) {
        this.colorAxesText = color;
        this.colixAxesText = Graphics3D.getColix((Color)color);
    }

    void setColorVector(Color c) {
        this.colorVector = c;
        this.colixVector = Graphics3D.getColix((Color)c);
    }

    Color getColorVector() {
        return this.colorVector;
    }

    void setColorBackground(String colorName) {
        if (colorName != null && colorName.length() > 0) {
            this.setColorBackground(this.viewer.getColorFromString(colorName));
        }
    }

    short getColixAtom(Atom atom) {
        return this.getColixAtomPalette(atom, this.paletteDefault);
    }

    short getColixAtomPalette(Atom atom, String palette) {
        int argb = 0;
        if ("cpk" == palette) {
            short id = atom.getElementNumber();
            return this.g3d.getChangableColix(id, this.argbsCpk[id]);
        }
        if ("partialcharge" == palette) {
            int index = this.quantize(atom.getPartialCharge(), -1.0f, 1.0f, 31);
            return this.g3d.getChangableColix((short)(JmolConstants.PARTIAL_CHARGE_COLIX_RED + index), JmolConstants.argbsRwbScale[index]);
        }
        if ("formalcharge" == palette) {
            int index = atom.getFormalCharge() - -4;
            return this.g3d.getChangableColix((short)(JmolConstants.FORMAL_CHARGE_COLIX_RED + index), JmolConstants.argbsFormalCharge[index]);
        }
        if ("temperature" == palette || "fixedtemperature" == palette) {
            float hi;
            float lo;
            if ("temperature" == palette) {
                Frame frame = this.viewer.getFrame();
                lo = frame.getBfactor100Lo();
                hi = frame.getBfactor100Hi();
            } else {
                lo = 0.0f;
                hi = 10000.0f;
            }
            int index = this.quantize(atom.getBfactor100(), lo, hi, JmolConstants.argbsRwbScale.length);
            index = JmolConstants.argbsRwbScale.length - 1 - index;
            argb = JmolConstants.argbsRwbScale[index];
        } else if ("structure" == palette) {
            argb = JmolConstants.argbsStructure[atom.getProteinStructureType()];
        } else if ("amino" == palette) {
            short index = atom.getGroupID();
            if (index >= 23) {
                index = 0;
            }
            argb = JmolConstants.argbsAmino[index];
        } else if ("shapely" == palette) {
            short index = atom.getGroupID();
            if (index >= 36) {
                index = 0;
            }
            argb = JmolConstants.argbsShapely[index];
        } else if ("chain" == palette) {
            int chain = atom.getChainID() & 0x1F;
            if (chain >= JmolConstants.argbsChainAtom.length) {
                chain %= JmolConstants.argbsChainAtom.length;
            }
            argb = (atom.isHetero() ? JmolConstants.argbsChainHetero : JmolConstants.argbsChainAtom)[chain];
        } else if ("group" == palette) {
            int index = this.quantize(atom.getSelectedGroupIndexWithinChain(), 0.0f, atom.getSelectedGroupCountWithinChain() - 1, JmolConstants.argbsRoygbScale.length);
            index = JmolConstants.argbsRoygbScale.length - 1 - index;
            argb = JmolConstants.argbsRoygbScale[index];
        } else if ("monomer" == palette) {
            int index = this.quantize(atom.getSelectedMonomerIndexWithinPolymer(), 0.0f, atom.getSelectedMonomerCountWithinPolymer() - 1, JmolConstants.argbsRoygbScale.length);
            index = JmolConstants.argbsRoygbScale.length - 1 - index;
            argb = JmolConstants.argbsRoygbScale[index];
        } else {
            System.out.println("ColorManager.getColixAtomPalette: unrecognized color palette:" + palette);
            return 22;
        }
        if (argb == 0) {
            return 22;
        }
        return Graphics3D.getColix((int)argb);
    }

    int quantize(float val, float lo, float hi, int segmentCount) {
        float range = hi - lo;
        if (range <= 0.0f || Float.isNaN(val)) {
            return segmentCount / 2;
        }
        float t = val - lo;
        if (t <= 0.0f) {
            return 0;
        }
        float quanta = range / (float)segmentCount;
        int q = (int)(t / quanta + 0.5f);
        if (q >= segmentCount) {
            q = segmentCount - 1;
        }
        return q;
    }

    short getColixFromPalette(float val, float lo, float hi, String palette) {
        if (palette == "rwb") {
            int index = this.quantize(val, lo, hi, JmolConstants.argbsRwbScale.length);
            return Graphics3D.getColix((int)JmolConstants.argbsRwbScale[index]);
        }
        if (palette == "roygb") {
            int index = this.quantize(val, lo, hi, JmolConstants.argbsRoygbScale.length);
            return Graphics3D.getColix((int)JmolConstants.argbsRoygbScale[index]);
        }
        return 22;
    }

    short getColixHbondType(short order) {
        int argbIndex = (order & 0x3C0) >> 6;
        return Graphics3D.getColix((int)JmolConstants.argbsHbondType[argbIndex]);
    }

    void flushCachedColors() {
    }

    private void flushCaches() {
        this.g3d.flushShadesAndImageCaches();
        this.viewer.refresh();
    }

    void setSpecular(boolean specular) {
        this.g3d.setSpecular(specular);
        this.flushCaches();
    }

    boolean getSpecular() {
        return this.g3d.getSpecular();
    }

    void setSpecularPower(int specularPower) {
        this.g3d.setSpecularPower(specularPower);
        this.flushCaches();
    }

    void setAmbientPercent(int ambientPercent) {
        this.g3d.setAmbientPercent(ambientPercent);
        this.flushCaches();
    }

    void setDiffusePercent(int diffusePercent) {
        this.g3d.setDiffusePercent(diffusePercent);
        this.flushCaches();
    }

    void setSpecularPercent(int specularPercent) {
        this.g3d.setSpecularPercent(specularPercent);
        this.flushCaches();
    }

    void setLightsourceZ(float dist) {
        this.g3d.setLightsourceZ(dist);
        this.flushCaches();
    }

    void setElementColor(int elementNumber, Color color) {
        int argb;
        if (color == null) {
            if (this.argbsCpk == JmolConstants.argbsCpk) {
                return;
            }
            argb = JmolConstants.argbsCpk[elementNumber];
        } else {
            argb = color.getRGB() | 0xFF000000;
        }
        if (this.argbsCpk == JmolConstants.argbsCpk) {
            this.copyArgbsCpk();
        }
        this.argbsCpk[elementNumber] = argb;
        this.g3d.changeColixArgb((short)elementNumber, argb);
    }
}

