/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.Hashtable;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.jmol.bspt.Tuple;
import org.jmol.g3d.Graphics3D;
import org.jmol.g3d.Xyzd;
import org.jmol.viewer.Bond;
import org.jmol.viewer.Chain;
import org.jmol.viewer.Frame;
import org.jmol.viewer.Group;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.Model;
import org.jmol.viewer.Monomer;
import org.jmol.viewer.Viewer;

final class Atom
implements Tuple {
    static final byte VISIBLE_FLAG = 1;
    static final byte VIBRATION_VECTOR_FLAG = 2;
    static final byte IS_HETERO_FLAG = 4;
    Group group;
    int atomIndex;
    Point3f point3f;
    long xyzd;
    short modelIndex;
    byte elementNumber;
    byte formalChargeAndFlags;
    byte alternateLocationID;
    short madAtom;
    short colixAtom;
    Bond[] bonds;
    static final int MIN_Z = 100;
    static final int MAX_Z = 14383;
    private static Hashtable htAtom = new Hashtable();

    Atom(Viewer viewer, Frame frame, int modelIndex, int atomIndex, byte elementNumber, String atomName, int formalCharge, float partialCharge, int occupancy, float bfactor, float x, float y, float z, boolean isHetero, int atomSerial, char chainID, float vibrationX, float vibrationY, float vibrationZ, char alternateLocationID, Object clientAtomReference) {
        byte specialAtomID;
        this.modelIndex = (short)modelIndex;
        this.atomIndex = atomIndex;
        this.elementNumber = elementNumber;
        if (!JmolConstants.isValidFormalCharge(elementNumber, formalCharge)) {
            formalCharge = 0;
        }
        this.formalChargeAndFlags = (byte)(formalCharge << 4);
        this.colixAtom = viewer.getColixAtom(this);
        this.alternateLocationID = (byte)alternateLocationID;
        this.setMadAtom(viewer.getMadAtom());
        this.point3f = new Point3f(x, y, z);
        if (isHetero) {
            this.formalChargeAndFlags = (byte)(this.formalChargeAndFlags | 4);
        }
        if (atomName != null) {
            if (frame.atomNames == null) {
                frame.atomNames = new String[frame.atoms.length];
            }
            frame.atomNames[atomIndex] = atomName.intern();
        }
        if ((specialAtomID = this.lookupSpecialAtomID(atomName)) != 0) {
            if (frame.specialAtomIDs == null) {
                frame.specialAtomIDs = new byte[frame.atoms.length];
            }
            frame.specialAtomIDs[atomIndex] = specialAtomID;
        }
        if (occupancy < 0) {
            occupancy = 0;
        } else if (occupancy > 100) {
            occupancy = 100;
        }
        if (occupancy != 100) {
            if (frame.occupancies == null) {
                frame.occupancies = new byte[frame.atoms.length];
            }
            frame.occupancies[atomIndex] = (byte)occupancy;
        }
        if (atomSerial != Integer.MIN_VALUE) {
            if (frame.atomSerials == null) {
                frame.atomSerials = new int[frame.atoms.length];
            }
            frame.atomSerials[atomIndex] = atomSerial;
        }
        if (!Float.isNaN(partialCharge)) {
            if (frame.partialCharges == null) {
                frame.partialCharges = new float[frame.atoms.length];
            }
            frame.partialCharges[atomIndex] = partialCharge;
        }
        if (!Float.isNaN(bfactor) && bfactor != 0.0f) {
            if (frame.bfactor100s == null) {
                frame.bfactor100s = new short[frame.atoms.length];
            }
            frame.bfactor100s[atomIndex] = (short)(bfactor * 100.0f);
        }
        if (!(Float.isNaN(vibrationX) || Float.isNaN(vibrationY) || Float.isNaN(vibrationZ))) {
            if (frame.vibrationVectors == null) {
                frame.vibrationVectors = new Vector3f[frame.atoms.length];
            }
            frame.vibrationVectors[atomIndex] = new Vector3f(vibrationX, vibrationY, vibrationZ);
            this.formalChargeAndFlags = (byte)(this.formalChargeAndFlags | 2);
        }
        if (clientAtomReference != null) {
            if (frame.clientAtomReferences == null) {
                frame.clientAtomReferences = new Object[frame.atoms.length];
            }
            frame.clientAtomReferences[atomIndex] = clientAtomReference;
        }
    }

    void setGroup(Group group) {
        this.group = group;
    }

    boolean isBonded(Atom atomOther) {
        if (this.bonds != null) {
            int i = this.bonds.length;
            while (--i >= 0) {
                Bond bond = this.bonds[i];
                if (bond.atom1 != atomOther && bond.atom2 != atomOther) continue;
                return true;
            }
        }
        return false;
    }

    Bond bondMutually(Atom atomOther, int order, Frame frame) {
        if (this.isBonded(atomOther)) {
            return null;
        }
        Bond bond = new Bond(this, atomOther, order, frame);
        this.addBond(bond, frame);
        atomOther.addBond(bond, frame);
        return bond;
    }

    private void addBond(Bond bond, Frame frame) {
        if (this.bonds == null) {
            this.bonds = new Bond[1];
            this.bonds[0] = bond;
        } else {
            this.bonds = frame.addToBonds(bond, this.bonds);
        }
    }

    void deleteBondedAtom(Atom atomToDelete) {
        if (this.bonds == null) {
            return;
        }
        int i = this.bonds.length;
        while (--i >= 0) {
            Bond bond = this.bonds[i];
            Atom atomBonded = bond.atom1 != this ? bond.atom1 : bond.atom2;
            if (atomBonded != atomToDelete) continue;
            this.deleteBond(i);
            return;
        }
    }

    void deleteAllBonds() {
        if (this.bonds == null) {
            return;
        }
        int i = this.bonds.length;
        while (--i >= 0) {
            this.group.chain.frame.deleteBond(this.bonds[i]);
        }
        if (this.bonds != null) {
            System.out.println("bond delete error");
            throw new NullPointerException();
        }
    }

    void deleteBond(Bond bond) {
        int i = this.bonds.length;
        while (--i >= 0) {
            if (this.bonds[i] != bond) continue;
            this.deleteBond(i);
            return;
        }
    }

    void deleteBond(int i) {
        int j;
        int newLength = this.bonds.length - 1;
        if (newLength == 0) {
            this.bonds = null;
            return;
        }
        Bond[] bondsNew = new Bond[newLength];
        for (j = 0; j < i; ++j) {
            bondsNew[j] = this.bonds[j];
        }
        while (j < newLength) {
            bondsNew[j] = this.bonds[j + 1];
            ++j;
        }
        this.bonds = bondsNew;
    }

    void clearBonds() {
        this.bonds = null;
    }

    int getBondedAtomIndex(int bondIndex) {
        Bond bond = this.bonds[bondIndex];
        return (bond.atom1 == this ? bond.atom2 : bond.atom1).atomIndex & 0xFFFF;
    }

    void setMadAtom(short madAtom) {
        if (this.madAtom == Short.MIN_VALUE) {
            return;
        }
        this.madAtom = this.convertEncodedMad(madAtom);
    }

    short convertEncodedMad(int size) {
        if (size == -1000) {
            int diameter = this.getBfactor100() * 10 * 2;
            if (diameter > 4000) {
                diameter = 4000;
            }
            size = diameter;
        } else if (size == -1001) {
            size = this.getBondingMar() * 2;
        } else if (size < 0) {
            if ((size = -size) > 200) {
                size = 200;
            }
            size = size * this.getVanderwaalsMar() / 50;
        }
        return (short)size;
    }

    int getRasMolRadius() {
        if (this.madAtom == Short.MIN_VALUE) {
            return 0;
        }
        return this.madAtom / 8;
    }

    int getCovalentBondCount() {
        if (this.bonds == null) {
            return 0;
        }
        int n = 0;
        int i = this.bonds.length;
        while (--i >= 0) {
            if ((this.bonds[i].order & 3) == 0) continue;
            ++n;
        }
        return n;
    }

    Bond[] getBonds() {
        return this.bonds;
    }

    void setColixAtom(short colixAtom) {
        if (colixAtom == 0) {
            colixAtom = this.group.chain.frame.viewer.getColixAtomPalette(this, "cpk");
        }
        this.colixAtom = colixAtom;
    }

    void setTranslucent(boolean isTranslucent) {
        this.colixAtom = Graphics3D.setTranslucent((short)this.colixAtom, (boolean)isTranslucent);
    }

    Vector3f getVibrationVector() {
        Vector3f[] vibrationVectors = this.group.chain.frame.vibrationVectors;
        return vibrationVectors == null ? null : vibrationVectors[this.atomIndex];
    }

    void setLabel(String strLabel) {
        this.group.chain.frame.setLabel(strLabel, this.atomIndex);
    }

    /*
     * Unable to fully structure code
     */
    void transform(Viewer viewer) {
        if (this.madAtom == -32768) {
            return;
        }
        if ((this.formalChargeAndFlags & 2) == 0) ** GOTO lbl-1000
        vibrationVectors = this.group.chain.frame.vibrationVectors;
        if (this.group.chain.frame.vibrationVectors == null) lbl-1000:
        // 2 sources

        {
            screen = viewer.transformPoint(this.point3f);
        } else {
            screen = viewer.transformPoint(this.point3f, vibrationVectors[this.atomIndex]);
        }
        z = screen.z;
        z = z < 100 ? 100 : (z > 14383 ? 14383 : z);
        diameter = viewer.scaleToScreen(z, this.madAtom);
        this.xyzd = Xyzd.getXyzd((int)screen.x, (int)screen.y, (int)z, (int)diameter);
    }

    byte getElementNumber() {
        return this.elementNumber;
    }

    String getElementSymbol() {
        return JmolConstants.elementSymbols[this.elementNumber];
    }

    String getAtomNameOrNull() {
        String[] atomNames = this.group.chain.frame.atomNames;
        return atomNames == null ? null : atomNames[this.atomIndex];
    }

    String getAtomName() {
        String atomName = this.getAtomNameOrNull();
        return atomName != null ? atomName : JmolConstants.elementSymbols[this.elementNumber];
    }

    String getPdbAtomName4() {
        String atomName = this.getAtomNameOrNull();
        return atomName != null ? atomName : "";
    }

    String getGroup3() {
        return this.group.getGroup3();
    }

    boolean isGroup3(String group3) {
        return this.group.isGroup3(group3);
    }

    boolean isGroup3Match(String strWildcard) {
        return this.group.isGroup3Match(strWildcard);
    }

    int getSeqcode() {
        return this.group.seqcode;
    }

    boolean isAtomNameMatch(String strPattern) {
        int ich;
        String atomName = this.getAtomNameOrNull();
        int cchAtomName = atomName == null ? 0 : atomName.length();
        int cchPattern = strPattern.length();
        for (ich = 0; ich < cchPattern; ++ich) {
            char charWild = Character.toUpperCase(strPattern.charAt(ich));
            if (charWild == '?' || ich < cchAtomName && charWild == Character.toUpperCase(atomName.charAt(ich))) continue;
            return false;
        }
        return ich >= cchAtomName;
    }

    boolean isAlternateLocationMatch(String strPattern) {
        if (strPattern == null) {
            return true;
        }
        if (strPattern.length() != 1) {
            return false;
        }
        return this.alternateLocationID == strPattern.charAt(0);
    }

    int getAtomNumber() {
        int[] atomSerials = this.group.chain.frame.atomSerials;
        if (atomSerials != null) {
            return atomSerials[this.atomIndex];
        }
        if (this.group.chain.frame.modelSetTypeName == "xyz" && this.group.chain.frame.viewer.getZeroBasedXyzRasmol()) {
            return this.atomIndex;
        }
        return this.atomIndex + 1;
    }

    boolean isHetero() {
        return (this.formalChargeAndFlags & 4) != 0;
    }

    int getFormalCharge() {
        return this.formalChargeAndFlags >> 4;
    }

    boolean isVisible() {
        return (this.formalChargeAndFlags & 1) != 0;
    }

    float getPartialCharge() {
        float[] partialCharges = this.group.chain.frame.partialCharges;
        return partialCharges == null ? 0.0f : partialCharges[this.atomIndex];
    }

    Point3f getPoint3f() {
        return this.point3f;
    }

    float getAtomX() {
        return this.point3f.x;
    }

    float getAtomY() {
        return this.point3f.y;
    }

    float getAtomZ() {
        return this.point3f.z;
    }

    public float getDimensionValue(int dimension) {
        return dimension == 0 ? this.point3f.x : (dimension == 1 ? this.point3f.y : this.point3f.z);
    }

    short getVanderwaalsMar() {
        return JmolConstants.vanderwaalsMars[this.elementNumber];
    }

    float getVanderwaalsRadiusFloat() {
        return (float)JmolConstants.vanderwaalsMars[this.elementNumber] / 1000.0f;
    }

    short getBondingMar() {
        return JmolConstants.getBondingMar(this.elementNumber, this.formalChargeAndFlags >> 4);
    }

    float getBondingRadiusFloat() {
        return (float)this.getBondingMar() / 1000.0f;
    }

    int getCurrentBondCount() {
        return this.bonds == null ? 0 : this.bonds.length;
    }

    Bond getLongestBondToDiscard(Atom atomChallenger) {
        float dist2Longest = this.point3f.distanceSquared(atomChallenger.point3f);
        Bond bondLongest = null;
        int i = this.bonds.length;
        while (--i >= 0) {
            Atom atomOther;
            Bond bond = this.bonds[i];
            Atom atom = atomOther = bond.atom1 != this ? bond.atom1 : bond.atom2;
            float dist2 = this.point3f.distanceSquared(atomOther.point3f);
            if (!(dist2 > dist2Longest)) continue;
            bondLongest = bond;
            dist2Longest = dist2;
        }
        return bondLongest;
    }

    short getColix() {
        return this.colixAtom;
    }

    float getRadius() {
        if (this.madAtom == Short.MIN_VALUE) {
            return 0.0f;
        }
        return (float)this.madAtom / 2000.0f;
    }

    char getChainID() {
        return this.group.chain.chainID;
    }

    int getOccupancy() {
        byte[] occupancies = this.group.chain.frame.occupancies;
        return occupancies == null ? 100 : occupancies[this.atomIndex];
    }

    int getBfactor100() {
        short[] bfactor100s = this.group.chain.frame.bfactor100s;
        if (bfactor100s == null) {
            return 0;
        }
        return bfactor100s[this.atomIndex];
    }

    Group getGroup() {
        return this.group;
    }

    int getPolymerLength() {
        return this.group.getPolymerLength();
    }

    int getPolymerIndex() {
        return this.group.getPolymerIndex();
    }

    int getSelectedGroupCountWithinChain() {
        return this.group.chain.getSelectedGroupCount();
    }

    int getSelectedGroupIndexWithinChain() {
        return this.group.chain.getSelectedGroupIndex(this.group);
    }

    int getSelectedMonomerCountWithinPolymer() {
        if (this.group instanceof Monomer) {
            return ((Monomer)this.group).polymer.selectedMonomerCount;
        }
        return 0;
    }

    int getSelectedMonomerIndexWithinPolymer() {
        if (this.group instanceof Monomer) {
            Monomer monomer = (Monomer)this.group;
            return monomer.polymer.getSelectedMonomerIndex(monomer);
        }
        return -1;
    }

    int getAtomIndex() {
        return this.atomIndex;
    }

    Chain getChain() {
        return this.group.chain;
    }

    Model getModel() {
        return this.group.chain.model;
    }

    int getModelIndex() {
        return this.modelIndex;
    }

    String getClientAtomStringProperty(String propertyName) {
        Object[] clientAtomReferences = this.group.chain.frame.clientAtomReferences;
        return clientAtomReferences == null || clientAtomReferences.length <= this.atomIndex ? null : this.group.chain.frame.viewer.getClientAtomStringProperty(clientAtomReferences[this.atomIndex], propertyName);
    }

    boolean isDeleted() {
        return this.madAtom == Short.MIN_VALUE;
    }

    void markDeleted() {
        this.deleteAllBonds();
        this.madAtom = Short.MIN_VALUE;
        this.xyzd = Long.MIN_VALUE;
    }

    byte getProteinStructureType() {
        return this.group.getProteinStructureType();
    }

    short getGroupID() {
        return this.group.groupID;
    }

    String getSeqcodeString() {
        return this.group.getSeqcodeString();
    }

    String getModelTag() {
        return this.group.chain.model.modelTag;
    }

    int getModelTagNumber() {
        try {
            return Integer.parseInt(this.group.chain.model.modelTag);
        }
        catch (NumberFormatException nfe) {
            return 0;
        }
    }

    byte getSpecialAtomID() {
        byte[] specialAtomIDs = this.group.chain.frame.specialAtomIDs;
        return specialAtomIDs == null ? (byte)0 : specialAtomIDs[this.atomIndex];
    }

    void demoteSpecialAtomImposter() {
        this.group.chain.frame.specialAtomIDs[this.atomIndex] = 0;
    }

    static String generateStarredAtomName(String primedAtomName) {
        int primeIndex = primedAtomName.indexOf(39);
        if (primeIndex < 0) {
            return null;
        }
        return primedAtomName.replace('\'', '*');
    }

    static String generatePrimeAtomName(String starredAtomName) {
        int starIndex = starredAtomName.indexOf(42);
        if (starIndex < 0) {
            return starredAtomName;
        }
        return starredAtomName.replace('*', '\'');
    }

    byte lookupSpecialAtomID(String atomName) {
        Integer boxedAtomID;
        if (atomName != null && (boxedAtomID = (Integer)htAtom.get(atomName = Atom.generatePrimeAtomName(atomName))) != null) {
            return (byte)boxedAtomID.intValue();
        }
        return 0;
    }

    String formatLabel(String strFormat) {
        int ichPercent;
        if (strFormat == null || strFormat.equals("")) {
            return null;
        }
        String strLabel = "";
        int cch = strFormat.length();
        int ich = 0;
        while ((ichPercent = strFormat.indexOf(37, ich)) != -1) {
            if (ich != ichPercent) {
                strLabel = strLabel + strFormat.substring(ich, ichPercent);
            }
            ich = ichPercent + 1;
            try {
                char ch;
                String strT = "";
                float floatT = 0.0f;
                boolean floatIsSet = false;
                boolean alignLeft = false;
                if (strFormat.charAt(ich) == '-') {
                    alignLeft = true;
                    ++ich;
                }
                boolean zeroPad = false;
                if (strFormat.charAt(ich) == '0') {
                    zeroPad = true;
                    ++ich;
                }
                int width = 0;
                while ((ch = strFormat.charAt(ich)) >= '0' && ch <= '9') {
                    width = 10 * width + (ch - 48);
                    ++ich;
                }
                int precision = -1;
                if (strFormat.charAt(ich) == '.' && (ch = strFormat.charAt(++ich)) >= '0' && ch <= '9') {
                    precision = ch - 48;
                }
                int n = ++ich;
                ++ich;
                ch = strFormat.charAt(n);
                switch (ch) {
                    case 'i': {
                        strT = "" + this.getAtomNumber();
                        break;
                    }
                    case 'a': {
                        strT = this.getAtomName();
                        break;
                    }
                    case 'e': {
                        strT = JmolConstants.elementSymbols[this.elementNumber];
                        break;
                    }
                    case 'x': {
                        floatT = this.point3f.x;
                        floatIsSet = true;
                        break;
                    }
                    case 'y': {
                        floatT = this.point3f.y;
                        floatIsSet = true;
                        break;
                    }
                    case 'z': {
                        floatT = this.point3f.z;
                        floatIsSet = true;
                        break;
                    }
                    case 'X': {
                        strT = "" + this.atomIndex;
                        break;
                    }
                    case 'C': {
                        int formalCharge = this.getFormalCharge();
                        if (formalCharge > 0) {
                            strT = "" + formalCharge + "+";
                            break;
                        }
                        if (formalCharge < 0) {
                            strT = "" + -formalCharge + "-";
                            break;
                        }
                        strT = "0";
                        break;
                    }
                    case 'P': {
                        floatT = this.getPartialCharge();
                        floatIsSet = true;
                        break;
                    }
                    case 'V': {
                        floatT = this.getVanderwaalsRadiusFloat();
                        floatIsSet = true;
                        break;
                    }
                    case 'I': {
                        floatT = this.getBondingRadiusFloat();
                        floatIsSet = true;
                        break;
                    }
                    case 'b': 
                    case 't': {
                        floatT = (float)this.getBfactor100() / 100.0f;
                        floatIsSet = true;
                        break;
                    }
                    case 'q': {
                        strT = "" + this.getOccupancy();
                        break;
                    }
                    case 'c': 
                    case 's': {
                        strT = "" + this.getChainID();
                        break;
                    }
                    case 'L': {
                        strT = "" + this.getPolymerLength();
                        break;
                    }
                    case 'M': {
                        strT = "/" + this.getModelTag();
                        break;
                    }
                    case 'm': {
                        strT = "<X>";
                        break;
                    }
                    case 'n': {
                        strT = this.getGroup3();
                        break;
                    }
                    case 'r': {
                        strT = this.getSeqcodeString();
                        break;
                    }
                    case 'U': {
                        strT = this.getIdentity();
                        break;
                    }
                    case '%': {
                        strT = "%";
                        break;
                    }
                    case '{': {
                        int ichCloseBracket = strFormat.indexOf(125, ich);
                        if (ichCloseBracket > ich) {
                            String propertyName = strFormat.substring(ich, ichCloseBracket);
                            String value = this.getClientAtomStringProperty(propertyName);
                            if (value != null) {
                                strT = value;
                            }
                            ich = ichCloseBracket + 1;
                            break;
                        }
                    }
                    default: {
                        strT = "%" + ch;
                    }
                }
                if (floatIsSet) {
                    strLabel = strLabel + this.format(floatT, width, precision, alignLeft);
                    continue;
                }
                strLabel = strLabel + Atom.format(strT, width, precision, alignLeft);
            }
            catch (IndexOutOfBoundsException ioobe) {
                ich = ichPercent;
                break;
            }
        }
        if ((strLabel = strLabel + strFormat.substring(ich)).length() == 0) {
            return null;
        }
        return strLabel.intern();
    }

    String format(float value, int width, int precision, boolean alignLeft) {
        return Atom.format(this.group.chain.frame.viewer.formatDecimal(value, precision), width, 0, alignLeft);
    }

    static String format(String value, int width, int precision, boolean alignLeft) {
        int padLength;
        if (precision > value.length()) {
            value = value.substring(0, precision);
        }
        if ((padLength = width - value.length()) <= 0) {
            return value;
        }
        StringBuffer sb = new StringBuffer();
        if (alignLeft) {
            sb.append(value);
        }
        int i = padLength;
        while (--i >= 0) {
            sb.append(' ');
        }
        if (!alignLeft) {
            sb.append(value);
        }
        return "" + sb;
    }

    String getInfo() {
        return this.getIdentity();
    }

    String getIdentity() {
        String atomName;
        StringBuffer info = new StringBuffer();
        String group3 = this.getGroup3();
        String seqcodeString = this.getSeqcodeString();
        char chainID = this.getChainID();
        if (group3 != null && group3.length() > 0) {
            info.append("[");
            info.append(group3);
            info.append("]");
        }
        if (seqcodeString != null) {
            info.append(seqcodeString);
        }
        if (chainID != '\u0000' && chainID != ' ') {
            info.append(":");
            info.append(chainID);
        }
        if ((atomName = this.getAtomNameOrNull()) != null) {
            if (info.length() > 0) {
                info.append(".");
            }
            info.append(atomName);
        }
        if (info.length() == 0) {
            info.append(this.getElementSymbol());
            info.append(" ");
            info.append(this.getAtomNumber());
        }
        if (this.group.chain.frame.getModelCount() > 1) {
            info.append("/");
            info.append(this.getModelTag());
        }
        info.append(" #");
        info.append(this.getAtomNumber());
        return "" + info;
    }

    boolean isCursorOnTopOfVisibleAtom(int xCursor, int yCursor, int minRadius, Atom competitor) {
        return (this.formalChargeAndFlags & 1) != 0 && this.isCursorOnTop(xCursor, yCursor, minRadius, competitor);
    }

    boolean isCursorOnTop(int xCursor, int yCursor, int minRadius, Atom competitor) {
        int rCompetitor;
        int zCompetitor;
        int r = Xyzd.getD((long)this.xyzd) / 2;
        if (r < minRadius) {
            r = minRadius;
        }
        int r2 = r * r;
        int dx = Xyzd.getX((long)this.xyzd) - xCursor;
        int dx2 = dx * dx;
        if (dx2 > r2) {
            return false;
        }
        int dy = Xyzd.getY((long)this.xyzd) - yCursor;
        int dy2 = dy * dy;
        int dz2 = r2 - (dx2 + dy2);
        if (dz2 < 0) {
            return false;
        }
        if (competitor == null) {
            return true;
        }
        int z = Xyzd.getZ((long)this.xyzd);
        if (z < (zCompetitor = Xyzd.getZ((long)competitor.xyzd)) - (rCompetitor = Xyzd.getD((long)competitor.xyzd) / 2)) {
            return true;
        }
        int dxCompetitor = Xyzd.getX((long)competitor.xyzd) - xCursor;
        int dx2Competitor = dxCompetitor * dxCompetitor;
        int dyCompetitor = Xyzd.getY((long)competitor.xyzd) - yCursor;
        int dy2Competitor = dyCompetitor * dyCompetitor;
        int r2Competitor = rCompetitor * rCompetitor;
        int dz2Competitor = r2Competitor - (dx2Competitor + dy2Competitor);
        return (double)z - Math.sqrt(dz2) < (double)zCompetitor - Math.sqrt(dz2Competitor);
    }

    int getScreenX() {
        return Xyzd.getX((long)this.xyzd);
    }

    int getScreenY() {
        return Xyzd.getY((long)this.xyzd);
    }

    int getScreenZ() {
        return Xyzd.getZ((long)this.xyzd);
    }

    int getScreenD() {
        return Xyzd.getD((long)this.xyzd);
    }

    boolean isProtein() {
        return this.group.isProtein();
    }

    boolean isNucleic() {
        return this.group.isNucleic();
    }

    boolean isDna() {
        return this.group.isDna();
    }

    boolean isRna() {
        return this.group.isRna();
    }

    boolean isPurine() {
        return this.group.isPurine();
    }

    boolean isPyrimidine() {
        return this.group.isPyrimidine();
    }

    static {
        int i = JmolConstants.specialAtomNames.length;
        while (--i >= 0) {
            String specialAtomName = JmolConstants.specialAtomNames[i];
            if (specialAtomName == null) continue;
            Integer boxedI = new Integer(i);
            htAtom.put(specialAtomName, boxedI);
        }
    }
}

