/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.io.BufferedReader;
import java.util.Properties;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.Bond;
import org.jmol.adapter.smarter.Resolver;
import org.jmol.adapter.smarter.Structure;
import org.jmol.api.JmolAdapter;

public class SmarterJmolAdapter
extends JmolAdapter {
    public static final String PATH_KEY = ".PATH";
    public static final String PATH_SEPARATOR = System.getProperty("path.separator");

    public SmarterJmolAdapter(JmolAdapter.Logger logger) {
        super("SmarterJmolAdapter", logger);
    }

    public void finish(Object clientFile) {
        ((AtomSetCollection)clientFile).finish();
    }

    public Object openBufferedReader(String name, BufferedReader bufferedReader) {
        try {
            Object atomSetCollectionOrErrorMessage = Resolver.resolve(name, bufferedReader, this.logger);
            if (atomSetCollectionOrErrorMessage instanceof String) {
                return atomSetCollectionOrErrorMessage;
            }
            if (atomSetCollectionOrErrorMessage instanceof AtomSetCollection) {
                AtomSetCollection atomSetCollection = (AtomSetCollection)atomSetCollectionOrErrorMessage;
                if (atomSetCollection.errorMessage != null) {
                    return atomSetCollection.errorMessage;
                }
                return atomSetCollection;
            }
            return "unknown reader error";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "" + e;
        }
    }

    public String getFileTypeName(Object clientFile) {
        return ((AtomSetCollection)clientFile).fileTypeName;
    }

    public String getAtomSetCollectionName(Object clientFile) {
        return ((AtomSetCollection)clientFile).collectionName;
    }

    public Properties getAtomSetCollectionProperties(Object clientFile) {
        return ((AtomSetCollection)clientFile).atomSetCollectionProperties;
    }

    public int getAtomSetCount(Object clientFile) {
        return ((AtomSetCollection)clientFile).atomSetCount;
    }

    public int getAtomSetNumber(Object clientFile, int atomSetIndex) {
        return ((AtomSetCollection)clientFile).getAtomSetNumber(atomSetIndex);
    }

    public String getAtomSetName(Object clientFile, int atomSetIndex) {
        return ((AtomSetCollection)clientFile).getAtomSetName(atomSetIndex);
    }

    public Properties getAtomSetProperties(Object clientFile, int atomSetIndex) {
        return ((AtomSetCollection)clientFile).getAtomSetProperties(atomSetIndex);
    }

    public int getEstimatedAtomCount(Object clientFile) {
        return ((AtomSetCollection)clientFile).atomCount;
    }

    public boolean coordinatesAreFractional(Object clientFile) {
        return ((AtomSetCollection)clientFile).coordinatesAreFractional;
    }

    public float[] getNotionalUnitcell(Object clientFile) {
        return ((AtomSetCollection)clientFile).notionalUnitcell;
    }

    public float[] getPdbScaleMatrix(Object clientFile) {
        return ((AtomSetCollection)clientFile).pdbScaleMatrix;
    }

    public float[] getPdbScaleTranslate(Object clientFile) {
        return ((AtomSetCollection)clientFile).pdbScaleTranslate;
    }

    public JmolAdapter.AtomIterator getAtomIterator(Object clientFile) {
        return new AtomIterator((AtomSetCollection)clientFile);
    }

    public JmolAdapter.BondIterator getBondIterator(Object clientFile) {
        return new BondIterator((AtomSetCollection)clientFile);
    }

    public JmolAdapter.StructureIterator getStructureIterator(Object clientFile) {
        AtomSetCollection atomSetCollection = (AtomSetCollection)clientFile;
        return atomSetCollection.structureCount == 0 ? null : new StructureIterator(atomSetCollection);
    }

    public class StructureIterator
    extends JmolAdapter.StructureIterator {
        int structureCount;
        Structure[] structures;
        Structure structure;
        int istructure;

        StructureIterator(AtomSetCollection atomSetCollection) {
            super((JmolAdapter)SmarterJmolAdapter.this);
            this.structureCount = atomSetCollection.structureCount;
            this.structures = atomSetCollection.structures;
            this.istructure = 0;
        }

        public boolean hasNext() {
            if (this.istructure == this.structureCount) {
                return false;
            }
            this.structure = this.structures[this.istructure++];
            return true;
        }

        public String getStructureType() {
            return this.structure.structureType;
        }

        public char getStartChainID() {
            return JmolAdapter.canonizeChainID((char)this.structure.startChainID);
        }

        public int getStartSequenceNumber() {
            return this.structure.startSequenceNumber;
        }

        public char getStartInsertionCode() {
            return JmolAdapter.canonizeInsertionCode((char)this.structure.startInsertionCode);
        }

        public char getEndChainID() {
            return JmolAdapter.canonizeChainID((char)this.structure.endChainID);
        }

        public int getEndSequenceNumber() {
            return this.structure.endSequenceNumber;
        }

        public char getEndInsertionCode() {
            return this.structure.endInsertionCode;
        }
    }

    class BondIterator
    extends JmolAdapter.BondIterator {
        AtomSetCollection atomSetCollection;
        Atom[] atoms;
        Bond[] bonds;
        int ibond;
        Bond bond;

        BondIterator(AtomSetCollection atomSetCollection) {
            super((JmolAdapter)SmarterJmolAdapter.this);
            this.atomSetCollection = atomSetCollection;
            this.atoms = atomSetCollection.atoms;
            this.bonds = atomSetCollection.bonds;
            this.ibond = 0;
        }

        public boolean hasNext() {
            if (this.ibond == this.atomSetCollection.bondCount) {
                return false;
            }
            this.bond = this.bonds[this.ibond++];
            return true;
        }

        public Object getAtomUniqueID1() {
            return this.atoms[this.bond.atomIndex1];
        }

        public Object getAtomUniqueID2() {
            return this.atoms[this.bond.atomIndex2];
        }

        public int getEncodedOrder() {
            return this.bond.order;
        }
    }

    class AtomIterator
    extends JmolAdapter.AtomIterator {
        AtomSetCollection atomSetCollection;
        int iatom;
        Atom atom;

        AtomIterator(AtomSetCollection atomSetCollection) {
            super((JmolAdapter)SmarterJmolAdapter.this);
            this.atomSetCollection = atomSetCollection;
            this.iatom = 0;
        }

        public boolean hasNext() {
            if (this.iatom == this.atomSetCollection.atomCount) {
                return false;
            }
            this.atom = this.atomSetCollection.atoms[this.iatom++];
            return true;
        }

        public int getAtomSetIndex() {
            return this.atom.atomSetIndex;
        }

        public Object getUniqueID() {
            return this.atom;
        }

        public String getElementSymbol() {
            if (this.atom.elementSymbol != null) {
                return this.atom.elementSymbol;
            }
            return this.atom.getElementSymbol();
        }

        public int getElementNumber() {
            return this.atom.elementNumber;
        }

        public String getAtomName() {
            return this.atom.atomName;
        }

        public int getFormalCharge() {
            return this.atom.formalCharge;
        }

        public float getPartialCharge() {
            return this.atom.partialCharge;
        }

        public float getX() {
            return this.atom.x;
        }

        public float getY() {
            return this.atom.y;
        }

        public float getZ() {
            return this.atom.z;
        }

        public float getVectorX() {
            return this.atom.vectorX;
        }

        public float getVectorY() {
            return this.atom.vectorY;
        }

        public float getVectorZ() {
            return this.atom.vectorZ;
        }

        public float getBfactor() {
            return this.atom.bfactor;
        }

        public int getOccupancy() {
            return this.atom.occupancy;
        }

        public boolean getIsHetero() {
            return this.atom.isHetero;
        }

        public int getAtomSerial() {
            return this.atom.atomSerial;
        }

        public char getChainID() {
            return JmolAdapter.canonizeChainID((char)this.atom.chainID);
        }

        public char getAlternateLocationID() {
            return JmolAdapter.canonizeAlternateLocationID((char)this.atom.alternateLocationID);
        }

        public String getGroup3() {
            return this.atom.group3;
        }

        public int getSequenceNumber() {
            return this.atom.sequenceNumber;
        }

        public char getInsertionCode() {
            return JmolAdapter.canonizeInsertionCode((char)this.atom.insertionCode);
        }
    }
}

