/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.vecmath.Point3f;
import org.jmol.constant.EnumStructure;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.Group;
import org.jmol.modelset.HBond;
import org.jmol.modelset.LabelToken;
import org.jmol.modelset.Model;
import org.jmol.modelset.ModelSet;
import org.jmol.modelsetbio.BioPolymer;
import org.jmol.modelsetbio.Monomer;
import org.jmol.util.ArrayUtil;
import org.jmol.util.BitSetUtil;
import org.jmol.util.Escape;
import org.jmol.util.OutputStringBuffer;
import org.jmol.util.TextFormat;
import org.jmol.viewer.Viewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BioModel
extends Model {
    private int bioPolymerCount = 0;
    private BioPolymer[] bioPolymers;
    private static final String[] pdbRecords = new String[]{"ATOM  ", "MODEL ", "HETATM"};

    BioModel(ModelSet modelSet, int n, int n2, String string, Properties properties, Map<String, Object> map) {
        super(modelSet, n, n2, string, properties, map);
        this.isBioModel = true;
        this.clearBioPolymers();
    }

    public void freeze() {
        super.freeze();
        this.bioPolymers = (BioPolymer[])ArrayUtil.setLength((Object)this.bioPolymers, (int)this.bioPolymerCount);
    }

    public void addSecondaryStructure(EnumStructure enumStructure, String string, int n, int n2, char c, int n3, char c2, int n4) {
        int n5 = this.bioPolymerCount;
        while (--n5 >= 0) {
            this.bioPolymers[n5].addSecondaryStructure(enumStructure, string, n, n2, c, n3, c2, n4);
        }
    }

    public String calculateStructures(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        int n;
        if (this.bioPolymerCount == 0 || !bl4 && !bl) {
            return "";
        }
        this.structureTainted = true;
        this.modelSet.proteinStructureTainted = true;
        if (bl4) {
            n = this.bioPolymerCount;
            while (--n >= 0) {
                if (bl && this.bioPolymers[n].getGroups()[0].getNitrogenAtom() == null) continue;
                this.bioPolymers[n].clearStructures();
            }
        }
        if (!bl || bl5) {
            n = this.bioPolymerCount;
            while (--n >= 0) {
                this.bioPolymers[n].calculateStructures(bl5);
            }
        }
        return bl ? this.bioPolymers[0].calculateStructures(this.bioPolymers, this.bioPolymerCount, null, bl2, bl3, bl4) : "";
    }

    public void setConformation(BitSet bitSet) {
        if (this.nAltLocs > 0) {
            int n = this.bioPolymerCount;
            while (--n >= 0) {
                this.bioPolymers[n].setConformation(bitSet);
            }
        }
    }

    public boolean getPdbConformation(BitSet bitSet, int n) {
        if (this.nAltLocs > 0) {
            int n2 = this.bioPolymerCount;
            while (--n2 >= 0) {
                this.bioPolymers[n2].getConformation(bitSet, n);
            }
        }
        return true;
    }

    public int getBioPolymerCount() {
        return this.bioPolymerCount;
    }

    public void calcSelectedMonomersCount(BitSet bitSet) {
        int n = this.bioPolymerCount;
        while (--n >= 0) {
            this.bioPolymers[n].calcSelectedMonomersCount(bitSet);
        }
    }

    public BioPolymer getBioPolymer(int n) {
        return this.bioPolymers[n];
    }

    public void getDefaultLargePDBRendering(StringBuffer stringBuffer, int n) {
        BitSet bitSet = new BitSet();
        if (this.getBondCount() == 0) {
            bitSet = this.bsAtoms;
        }
        if (bitSet != this.bsAtoms) {
            for (int i = 0; i < this.bioPolymerCount; ++i) {
                this.bioPolymers[i].getRange(bitSet);
            }
        }
        if (bitSet.nextSetBit(0) < 0) {
            return;
        }
        BitSet bitSet2 = new BitSet();
        if (bitSet == this.bsAtoms) {
            bitSet2 = bitSet;
        } else {
            for (int i = 0; i < this.bioPolymerCount; ++i) {
                if (this.bioPolymers[i].getType() != 0) continue;
                this.bioPolymers[i].getRange(bitSet2);
            }
        }
        if (bitSet2.nextSetBit(0) >= 0) {
            stringBuffer.append("select ").append(Escape.escape((Object)bitSet2)).append(";backbone only;");
        }
        if (this.atomCount <= n) {
            return;
        }
        stringBuffer.append("select ").append(Escape.escape((Object)bitSet)).append(" & connected; wireframe only;");
        if (bitSet != this.bsAtoms) {
            bitSet2.clear();
            bitSet2.or(this.bsAtoms);
            bitSet2.andNot(bitSet);
            if (bitSet2.nextSetBit(0) >= 0) {
                stringBuffer.append("select " + Escape.escape((Object)bitSet2) + " & !connected;stars 0.5;");
            }
        }
    }

    public void fixIndices(int n, int n2, BitSet bitSet) {
        super.fixIndices(n, n2, bitSet);
        for (int i = 0; i < this.bioPolymerCount; ++i) {
            this.bioPolymers[i].recalculateLeadMidpointsAndWingVectors();
        }
    }

    public int calculateStruts(ModelSet modelSet, BitSet bitSet, BitSet bitSet2) {
        BitSet bitSet3;
        ArrayList<Atom> arrayList = new ArrayList<Atom>();
        Atom atom = null;
        if (bitSet.equals(bitSet2)) {
            bitSet3 = bitSet;
        } else {
            bitSet3 = BitSetUtil.copy((BitSet)bitSet);
            bitSet3.or(bitSet2);
        }
        Atom[] atomArray = modelSet.atoms;
        Viewer viewer = modelSet.viewer;
        bitSet3.and(viewer.getModelUndeletedAtomsBitSet(this.modelIndex));
        int n = bitSet3.nextSetBit(0);
        while (n >= 0) {
            if (atomArray[n].isVisible(0) && atomArray[n].atomID == 2 && atomArray[n].getGroupID() != 5) {
                atom = atomArray[n];
                arrayList.add(atom);
            }
            n = bitSet3.nextSetBit(n + 1);
        }
        if (arrayList.size() == 0) {
            return 0;
        }
        float f = viewer.getStrutLengthMaximum();
        short s = (short)(viewer.getStrutDefaultRadius() * 2000.0f);
        int n2 = viewer.getStrutSpacingMinimum();
        boolean bl = viewer.getStrutsMultiple();
        List<Atom[]> list = this.getBioPolymer(atom.getPolymerIndexInModel()).calculateStruts(modelSet, bitSet, bitSet2, arrayList, f, n2, bl);
        for (int i = 0; i < list.size(); ++i) {
            Atom[] atomArray2 = list.get(i);
            modelSet.bondAtoms(atomArray2[0], atomArray2[1], 32768, s, null, 0.0f, false, true);
        }
        return list.size();
    }

    public void setStructureList(Map<EnumStructure, float[]> map) {
        this.bioPolymers = (BioPolymer[])ArrayUtil.setLength((Object)this.bioPolymers, (int)this.bioPolymerCount);
        int n = this.bioPolymerCount;
        while (--n >= 0) {
            this.bioPolymers[n].setStructureList(map);
        }
    }

    public void calculateStraightness(Viewer viewer, char c, char c2, int n) {
        for (int i = 0; i < this.bioPolymerCount; ++i) {
            this.bioPolymers[i].getPdbData(viewer, c, c2, n, 2, null, null, false, false, false, null, null, null, new BitSet());
        }
    }

    public void getPolymerPointsAndVectors(BitSet bitSet, List<Point3f[]> list, boolean bl, float f) {
        int n = 0x7FFFFFFE;
        for (int i = 0; i < this.bioPolymerCount; ++i) {
            n = this.bioPolymers[i].getPolymerPointsAndVectors(n, bitSet, list, bl, f);
        }
    }

    public Point3f[] getPolymerLeadMidPoints(int n) {
        return this.bioPolymers[n].getLeadMidpoints();
    }

    public void recalculateLeadMidpointsAndWingVectors() {
        for (int i = 0; i < this.bioPolymerCount; ++i) {
            this.bioPolymers[i].recalculateLeadMidpointsAndWingVectors();
        }
    }

    public List<BitSet> getBioBranches(List<BitSet> list) {
        for (int i = 0; i < this.bioPolymerCount; ++i) {
            BitSet bitSet = new BitSet();
            this.bioPolymers[i].getRange(bitSet);
            int n = bitSet.nextSetBit(0);
            if (n < 0) continue;
            if (list == null) {
                list = new ArrayList<BitSet>();
            }
            list.add(bitSet);
        }
        return list;
    }

    public void getGroupsWithin(int n, BitSet bitSet, BitSet bitSet2) {
        int n2 = this.bioPolymerCount;
        while (--n2 >= 0) {
            this.bioPolymers[n2].getRangeGroups(n, bitSet, bitSet2);
        }
    }

    public void getSequenceBits(String string, BitSet bitSet, BitSet bitSet2) {
        int n = string.length();
        block0: for (int i = 0; i < this.bioPolymerCount; ++i) {
            String string2 = this.bioPolymers[i].getSequence();
            int n2 = -1;
            while (true) {
                ++n2;
                if ((n2 = string2.indexOf(string, n2)) < 0) continue block0;
                this.bioPolymers[i].getPolymerSequenceAtoms(n2, n, bitSet, bitSet2);
            }
        }
    }

    public void selectSeqcodeRange(int n, int n2, char c, BitSet bitSet, boolean bl) {
        int n3 = this.chainCount;
        while (--n3 >= 0) {
            char c2 = this.chains[n3].chainID;
            if (c != c2 && c != '\t' && (bl || c != Character.toUpperCase(c2))) continue;
            int n4 = 0;
            while (n4 >= 0) {
                n4 = this.chains[n3].selectSeqcodeRange(n4, n, n2, bitSet);
            }
        }
    }

    public void getRasmolHydrogenBonds(BitSet bitSet, BitSet bitSet2, List<Bond> list, boolean bl, int n, boolean bl2, BitSet bitSet3) {
        int n2;
        int n3;
        boolean bl3;
        boolean bl4;
        boolean bl5 = bl4 = list == null;
        if (bl4) {
            list = new ArrayList<Bond>();
        }
        if (n < 0) {
            n = Integer.MAX_VALUE;
        }
        boolean bl6 = bl3 = bitSet2 == null;
        if (bl3 && this.bioPolymerCount > 0) {
            this.bioPolymers[0].calculateStructures(this.bioPolymers, this.bioPolymerCount, list, false, bl2, false);
        } else {
            n3 = this.bioPolymerCount;
            while (--n3 >= 0) {
                boolean bl7;
                BioPolymer bioPolymer = this.bioPolymers[n3];
                int n4 = bioPolymer.getType();
                if ((bl || n4 != 1) && n4 != 2) continue;
                boolean bl8 = bioPolymer.isRna();
                boolean bl9 = bl7 = n4 == 1;
                if (bl7) {
                    bioPolymer.calcRasmolHydrogenBonds(null, bitSet, bitSet2, list, n, null, true, false);
                }
                n2 = this.bioPolymerCount;
                while (--n2 >= 0) {
                    BioPolymer bioPolymer2 = this.bioPolymers[n2];
                    if (bioPolymer2 == null || !bl8 && n3 == n2 || n4 != bioPolymer2.getType()) continue;
                    bioPolymer2.calcRasmolHydrogenBonds(bioPolymer, bitSet, bitSet2, list, n, null, true, false);
                }
            }
        }
        if (list.size() == 0 || !bl4) {
            return;
        }
        this.hasRasmolHBonds = true;
        for (n3 = 0; n3 < list.size(); ++n3) {
            Atom atom;
            HBond hBond = (HBond)list.get(n3);
            Atom atom2 = hBond.getAtom1();
            if (atom2.isBonded(atom = hBond.getAtom2())) continue;
            n2 = this.modelSet.addHBond(atom2, atom, hBond.order, hBond.getEnergy());
            if (bitSet3 == null) continue;
            bitSet3.set(n2);
        }
    }

    public void clearRasmolHydrogenBonds(BitSet bitSet) {
        BitSet bitSet2 = new BitSet();
        this.hasRasmolHBonds = false;
        Model[] modelArray = this.modelSet.getModels();
        Bond[] bondArray = this.modelSet.getBonds();
        int n = this.modelSet.getBondCount();
        while (--n >= 0) {
            Bond bond = bondArray[n];
            Atom atom = bond.getAtom1();
            Model model = modelArray[atom.modelIndex];
            if (!model.isBioModel || model.trajectoryBaseIndex != this.modelIndex || (bond.order & 0x7000) == 0) continue;
            if (bitSet != null && !bitSet.get(atom.index)) {
                this.hasRasmolHBonds = true;
                continue;
            }
            bitSet2.set(n);
        }
        if (bitSet2.nextSetBit(0) >= 0) {
            this.modelSet.deleteBonds(bitSet2, false);
        }
    }

    public void calculatePolymers(Group[] groupArray, int n, int n2, BitSet bitSet) {
        Monomer monomer;
        int n3;
        if (groupArray == null) {
            groupArray = this.modelSet.getGroups();
            n = groupArray.length;
        }
        if (bitSet != null) {
            for (n3 = 0; n3 < n; ++n3) {
                Group group = groupArray[n3];
                if (!(group instanceof Monomer) || (monomer = (Monomer)group).getBioPolymer() == null || bitSet != null && bitSet.get(monomer.getModelIndex())) continue;
                monomer.setBioPolymer(null, -1);
            }
        }
        n3 = !this.modelSet.viewer.isPdbSequential() ? 1 : 0;
        for (int i = n2; i < n; ++i) {
            BioPolymer bioPolymer;
            monomer = groupArray[i];
            Model model = monomer.getModel();
            if (!model.isBioModel || !(monomer instanceof Monomer)) continue;
            boolean bl = n3 != 0 && !this.modelSet.isJmolDataFrame((int)this.modelSet.atoms[monomer.firstAtomIndex].modelIndex);
            BioPolymer bioPolymer2 = bioPolymer = monomer.getBioPolymer() == null ? BioPolymer.allocateBioPolymer(groupArray, i, bl) : null;
            if (bioPolymer == null || bioPolymer.monomerCount == 0) continue;
            ((BioModel)model).addBioPolymer(bioPolymer);
            i += bioPolymer.monomerCount - 1;
        }
    }

    private void addBioPolymer(BioPolymer bioPolymer) {
        if (this.bioPolymers.length == 0) {
            this.clearBioPolymers();
        }
        if (this.bioPolymerCount == this.bioPolymers.length) {
            this.bioPolymers = (BioPolymer[])ArrayUtil.doubleLength((Object)this.bioPolymers);
        }
        bioPolymer.bioPolymerIndexInModel = this.bioPolymerCount;
        this.bioPolymers[this.bioPolymerCount++] = bioPolymer;
    }

    public void clearBioPolymers() {
        this.bioPolymers = new BioPolymer[8];
        this.bioPolymerCount = 0;
    }

    public void getAllPolymerInfo(BitSet bitSet, Map<String, List<Map<String, Object>>> map, List<Map<String, Object>> list) {
        Hashtable<String, Serializable> hashtable = new Hashtable<String, Serializable>();
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        for (int i = 0; i < this.bioPolymerCount; ++i) {
            Map<String, Object> map2 = this.bioPolymers[i].getPolymerInfo(bitSet);
            if (map2.isEmpty()) continue;
            arrayList.add(map2);
        }
        if (arrayList.size() > 0) {
            hashtable.put("modelIndex", Integer.valueOf(this.modelIndex));
            hashtable.put("polymers", arrayList);
            list.add(hashtable);
        }
    }

    public void getChimeInfo(StringBuffer stringBuffer, int n) {
        int n2 = 0;
        Model[] modelArray = this.modelSet.getModels();
        int n3 = this.modelSet.getModelCount();
        int n4 = this.modelSet.getAtomCount();
        Atom[] atomArray = this.modelSet.atoms;
        stringBuffer.append("\nMolecule name ....... " + this.modelSet.getModelSetAuxiliaryInfo("COMPND"));
        stringBuffer.append("\nSecondary Structure . PDB Data Records");
        stringBuffer.append("\nBrookhaven Code ..... " + this.modelSet.modelSetName);
        int n5 = n3;
        while (--n5 >= 0) {
            n2 += modelArray[n5].getChainCount(false);
        }
        stringBuffer.append("\nNumber of Chains .... " + n2);
        n2 = 0;
        n5 = n3;
        while (--n5 >= 0) {
            n2 += modelArray[n5].getGroupCount(false);
        }
        n = 0;
        n5 = n3;
        while (--n5 >= 0) {
            n += modelArray[n5].getGroupCount(true);
        }
        stringBuffer.append("\nNumber of Groups .... " + n2);
        if (n > 0) {
            stringBuffer.append(" (" + n + ")");
        }
        n5 = n4;
        while (--n5 >= 0) {
            if (!atomArray[n5].isHetero()) continue;
            ++n;
        }
        super.getChimeInfo(stringBuffer, n);
        n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = -1;
        block9: for (int i = 0; i < n4 && atomArray[i].modelIndex == 0; ++i) {
            int n9 = atomArray[i].getStrucNo();
            if (n9 == n8 || n9 == 0) continue;
            n8 = n9;
            switch (atomArray[i].getProteinStructureType()) {
                case HELIX: {
                    ++n5;
                    continue block9;
                }
                case SHEET: {
                    ++n6;
                    continue block9;
                }
                case TURN: {
                    ++n7;
                }
            }
        }
        stringBuffer.append("\nNumber of Helices ... " + n5);
        stringBuffer.append("\nNumber of Strands ... " + n6);
        stringBuffer.append("\nNumber of Turns ..... " + n7);
    }

    public String getProteinStructureState(BitSet bitSet, boolean bl, boolean bl2, int n) {
        int n2;
        boolean bl3 = n == 3;
        boolean bl4 = n == 1;
        boolean bl5 = n == 0;
        BitSet bitSet2 = null;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        StringBuffer stringBuffer4 = new StringBuffer();
        EnumStructure enumStructure = EnumStructure.NONE;
        EnumStructure enumStructure2 = EnumStructure.NONE;
        int n3 = 0;
        int n4 = 0;
        int c = -1;
        int n5 = -1;
        int n6 = 0;
        int n7 = 0;
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        BitSet bitSet3 = null;
        Model[] modelArray = this.modelSet.getModels();
        Atom[] atomArray = this.modelSet.atoms;
        int n12 = this.modelSet.getAtomCount();
        if (bl) {
            if (!this.modelSet.proteinStructureTainted) {
                return "";
            }
            bitSet3 = new BitSet();
            for (n2 = this.firstAtomIndex; n2 < n12; ++n2) {
                if (!modelArray[atomArray[n2].modelIndex].isStructureTainted()) continue;
                bitSet3.set(n2);
            }
            bitSet3.set(n12);
        }
        for (n2 = 0; n2 <= n12; ++n2) {
            char string6;
            if (n2 != n12 && bitSet != null && !bitSet.get(n2) || bl && !bitSet3.get(n2)) continue;
            n3 = 0;
            if (n2 == n12 || (n3 = atomArray[n2].getStrucNo()) != n5) {
                if (bitSet2 != null) {
                    switch (enumStructure) {
                        case HELIX: 
                        case SHEET: 
                        case TURN: {
                            String string7;
                            CharSequence charSequence;
                            ++n8;
                            if (bl5) {
                                char c2;
                                string6 = atomArray[n4].modelIndex;
                                String n13 = "    \t# model=" + this.modelSet.getModelNumberDotted((int)string6);
                                if (c2 != string6) {
                                    c2 = string6;
                                    stringBuffer.append("  structure none ").append(Escape.escape((Object)this.modelSet.getModelAtomBitSetIncludingDeleted((int)string6, false))).append(n13).append(";\n");
                                }
                                n13 = n13 + " & (" + n6 + " - " + n7 + ")";
                                charSequence = enumStructure2.getBioStructureTypeName(false);
                                stringBuffer.append("  structure ").append((String)charSequence).append(" ").append(Escape.escape((Object)bitSet2)).append(n13).append(";\n");
                                break;
                            }
                            switch (enumStructure) {
                                case HELIX: {
                                    int n13 = ++n9;
                                    if (string == null || bl4) {
                                        string = TextFormat.formatString((String)"%3N %3N", (String)"N", (int)n13);
                                    }
                                    string7 = "HELIX  %ID %3GROUPA %1CA %4RESA  %3GROUPB %1CB %4RESB";
                                    charSequence = stringBuffer3;
                                    String string8 = null;
                                    switch (enumStructure2) {
                                        case HELIX: 
                                        case HELIXALPHA: {
                                            string8 = "  1";
                                            break;
                                        }
                                        case HELIX310: {
                                            string8 = "  5";
                                            break;
                                        }
                                        case HELIXPI: {
                                            string8 = "  3";
                                        }
                                    }
                                    if (string8 == null) break;
                                    string7 = string7 + string8;
                                    break;
                                }
                                case SHEET: {
                                    int n13 = ++n11;
                                    if (string == null || bl4) {
                                        string = TextFormat.formatString((String)"%3N %3A 0", (String)"N", (int)n13);
                                        string = TextFormat.formatString((String)string, (String)"A", (String)("S" + n13));
                                    }
                                    string7 = "SHEET  %ID %3GROUPA %1CA%4RESA  %3GROUPB %1CB%4RESB";
                                    charSequence = stringBuffer4;
                                    break;
                                }
                                default: {
                                    int n13 = ++n10;
                                    if (string == null || bl4) {
                                        string = TextFormat.formatString((String)"%3N %3N", (String)"N", (int)n13);
                                    }
                                    string7 = "TURN   %ID %3GROUPA %1CA%4RESA  %3GROUPB %1CB%4RESB";
                                    charSequence = stringBuffer2;
                                }
                            }
                            string7 = TextFormat.formatString((String)string7, (String)"ID", (String)string);
                            string7 = TextFormat.formatString((String)string7, (String)"GROUPA", (String)string2);
                            string7 = TextFormat.formatString((String)string7, (String)"CA", (String)string4);
                            string7 = TextFormat.formatString((String)string7, (String)"RESA", (int)n6);
                            string7 = TextFormat.formatString((String)string7, (String)"GROUPB", (String)string3);
                            string7 = TextFormat.formatString((String)string7, (String)"CB", (String)string5);
                            string7 = TextFormat.formatString((String)string7, (String)"RESB", (int)n7);
                            ((StringBuffer)charSequence).append(string7);
                            if (bl3) {
                                ((StringBuffer)charSequence).append(" strucno= ").append(n5);
                            }
                            ((StringBuffer)charSequence).append("\n");
                        }
                    }
                    bitSet2 = null;
                }
                if (n3 == 0 || bitSet != null && bl2 && (Float.isNaN(atomArray[n2].getGroupParameter(1112539143)) || Float.isNaN(atomArray[n2].getGroupParameter(1112539144)))) continue;
            }
            if ((string6 = atomArray[n2].getChainID()) == '\u0000') {
                string6 = ' ';
            }
            if (bitSet2 == null) {
                bitSet2 = new BitSet();
                n6 = atomArray[n2].getResno();
                string2 = atomArray[n2].getGroup3(false);
                string4 = "" + string6;
            }
            enumStructure = atomArray[n2].getProteinStructureType();
            enumStructure2 = atomArray[n2].getProteinStructureSubType();
            string = atomArray[n2].getProteinStructureTag();
            bitSet2.set(n2);
            n5 = n3;
            n7 = atomArray[n2].getResno();
            string3 = atomArray[n2].getGroup3(false);
            string5 = "" + string6;
            n4 = n2;
        }
        if (n8 > 0) {
            stringBuffer.append("\n");
        }
        return bl5 ? stringBuffer.toString() : stringBuffer3.append(stringBuffer4).append(stringBuffer2).append(stringBuffer).toString();
    }

    public String getFullPDBHeader() {
        if (this.modelIndex < 0) {
            return "";
        }
        String string = (String)this.auxiliaryInfo.get("fileHeader");
        if (string != null) {
            return string;
        }
        string = this.modelSet.viewer.getCurrentFileAsString();
        int n = string.length();
        int n2 = pdbRecords.length;
        block4: while (--n2 >= 0) {
            String string2 = pdbRecords[n2];
            int n3 = string.startsWith(string2) ? 0 : string.indexOf("\n" + string2);
            switch (n3) {
                case -1: {
                    continue block4;
                }
                case 0: {
                    this.auxiliaryInfo.put("fileHeader", "");
                    return "";
                }
            }
            if (n3 >= n) continue;
            n = ++n3;
        }
        string = string.substring(0, n);
        this.auxiliaryInfo.put("fileHeader", string);
        return string;
    }

    public void getPdbData(Viewer viewer, String string, char c, boolean bl, BitSet bitSet, OutputStringBuffer outputStringBuffer, LabelToken[] labelTokenArray, StringBuffer stringBuffer, BitSet bitSet2) {
        int n;
        char c2;
        boolean bl2 = false;
        char c3 = c != 'R' ? (char)'r' : (c2 = string.length() > 13 && string.indexOf("ramachandran ") >= 0 ? (char)string.charAt(13) : (char)'R');
        if (c2 == 'r') {
            c2 = viewer.getQuaternionFrame();
        }
        int n2 = viewer.getHelixStep();
        int n3 = string.indexOf("diff") < 0 ? 0 : (n = string.indexOf("2") < 0 ? 1 : 2);
        if (!bl) {
            outputStringBuffer.append("REMARK   6 Jmol PDB-encoded data: " + string + ";");
            if (c != 'R') {
                outputStringBuffer.append("  quaternionFrame = \"" + c2 + "\"");
                bl2 = true;
            }
            outputStringBuffer.append("\nREMARK   6 Jmol Version ").append(Viewer.getJmolVersion()).append('\n');
            if (c == 'R') {
                outputStringBuffer.append("REMARK   6 Jmol data min = {-180 -180 -180} max = {180 180 180} unScaledXyz = xyz * {1 1 1} + {0 0 0} plotScale = {100 100 100}\n");
            } else {
                outputStringBuffer.append("REMARK   6 Jmol data min = {-1 -1 -1} max = {1 1 1} unScaledXyz = xyz * {0.1 0.1 0.1} + {0 0 0} plotScale = {100 100 100}\n");
            }
        }
        for (int i = 0; i < this.bioPolymerCount; ++i) {
            this.bioPolymers[i].getPdbData(viewer, c, c2, n2, n, this.bsAtoms, bitSet, bl2, bl, i == 0, labelTokenArray, outputStringBuffer, stringBuffer, bitSet2);
        }
    }
}

