/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.simple;

import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import org.jmol.adapter.readers.simple.ZMatrixReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.api.JmolAdapter;

public class MopacArchiveReader
extends ZMatrixReader {
    String energyWithUnits;

    protected void initializeReader() {
        this.atomSetCollection.newAtomSet();
        if (!this.checkFilter("NOCENTER")) {
            this.doCentralize = true;
        }
    }

    protected boolean checkLine() throws Exception {
        if (this.line.indexOf("=") == 34) {
            return this.getValue();
        }
        if (this.line.indexOf("FINAL GEOMETRY OBTAINED") >= 0) {
            return this.readCoordinates();
        }
        return true;
    }

    private boolean getValue() {
        if (this.line.substring(0, 10).trim().length() != 0) {
            return true;
        }
        String string = this.line.substring(0, 34).trim().replace(' ', '_');
        String string2 = this.line.substring(35).trim();
        this.atomSetCollection.setAtomSetAuxiliaryInfo(string, (Object)string2);
        if (this.line.indexOf("TOTAL ENERGY") >= 0) {
            String[] stringArray = this.getTokens();
            this.energyWithUnits = " (" + stringArray[3] + " " + stringArray[4] + ")";
            this.atomSetCollection.setAtomSetEnergy(stringArray[3], this.parseFloat(stringArray[3]));
        }
        return true;
    }

    private boolean readCoordinates() throws Exception {
        this.readLine();
        this.line = this.readLine().trim();
        this.atomSetCollection.setAtomSetName(this.line + (this.energyWithUnits == null ? "" : this.energyWithUnits));
        this.readLine();
        Atom atom = null;
        String string = null;
        this.setFractionalCoordinates(false);
        while (this.readLine() != null && this.line.length() >= 50) {
            atom = new Atom();
            this.vAtoms.add(atom);
            atom.x = this.parseFloat(this.line.substring(5, 18));
            atom.y = this.parseFloat(this.line.substring(21, 34));
            atom.z = this.parseFloat(this.line.substring(37, 50));
            if (this.line.length() > 58 && this.line.charAt(58) != ' ') {
                switch (this.atomCount) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        atom.sub((Tuple3f)this.vAtoms.get(0));
                        break;
                    }
                    case 2: {
                        this.setAtom(atom, 0, 1, 0, atom.x, atom.y, Float.MAX_VALUE);
                        break;
                    }
                    default: {
                        this.setAtom(atom, this.parseInt(this.line.substring(54, 59)) - 1, this.parseInt(this.line.substring(60, 65)) - 1, this.parseInt(this.line.substring(66, 71)) - 1, atom.x, atom.y, atom.z);
                    }
                }
            }
            atom.elementSymbol = string = this.line.substring(1, 3).trim();
            if (string.equals("Tv")) continue;
            ++this.atomCount;
            if (this.line.length() >= 84) {
                atom.partialCharge = this.parseFloat(this.line.substring(76, 84));
            }
            if (JmolAdapter.getElementNumber((String)string) != 0) {
                this.atomSetCollection.addAtom(atom);
            }
            this.setAtomCoord(atom);
        }
        if (string.equals("Tv")) {
            int n;
            int n2;
            this.setSpaceGroupName("P1");
            for (int i = n2 = this.vAtoms.size() - this.atomCount; i < 3; ++i) {
                this.vAtoms.add(new Atom());
            }
            float[] fArray = new float[9];
            for (n = 0; n < 3; ++n) {
                int n3 = n * 3;
                atom = (Atom)this.vAtoms.get(this.atomCount + n);
                if (!Float.isNaN(atom.x)) {
                    fArray[n3] = atom.x;
                    fArray[n3 + 1] = atom.y;
                    fArray[n3 + 2] = atom.z;
                }
                this.addPrimitiveLatticeVector(n, fArray, n3);
            }
            n = this.atomCount;
            while (--n >= 0) {
                this.setAtomCoord((Atom)this.vAtoms.get(n));
            }
            Point3f point3f = new Point3f(-3.4028235E38f, -3.4028235E38f, -3.4028235E38f);
            Point3f point3f2 = new Point3f(Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE);
            if (this.doCentralize) {
                int n4 = this.atomCount;
                while (--n4 >= 0) {
                    atom = (Atom)this.vAtoms.get(n4);
                    point3f.x = Math.max(point3f.x, atom.x);
                    point3f.y = Math.max(point3f.y, atom.y);
                    point3f.z = Math.max(point3f.z, atom.z);
                    point3f2.x = Math.min(point3f2.x, atom.x);
                    point3f2.y = Math.min(point3f2.y, atom.y);
                    point3f2.z = Math.min(point3f2.z, atom.z);
                }
                Point3f point3f3 = new Point3f();
                switch (n2) {
                    case 3: {
                        point3f3.x = 0.5f;
                    }
                    case 2: {
                        point3f3.y = 0.5f;
                    }
                    case 1: {
                        point3f3.z = 0.5f;
                    }
                }
                point3f3.scaleAdd(-0.5f, (Tuple3f)point3f2, (Tuple3f)point3f3);
                point3f3.scaleAdd(-0.5f, (Tuple3f)point3f, (Tuple3f)point3f3);
                int n5 = this.atomCount;
                while (--n5 >= 0) {
                    ((Atom)this.vAtoms.get(n5)).add((Tuple3f)point3f3);
                }
            }
            this.doCentralize = false;
        }
        return true;
    }
}

