/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapesurface;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.vecmath.Point4f;
import org.jmol.constant.EnumQuantumShell;
import org.jmol.jvxl.data.JvxlCoder;
import org.jmol.jvxl.readers.Parameters;
import org.jmol.shape.Shape;
import org.jmol.shapesurface.Isosurface;
import org.jmol.shapesurface.IsosurfaceMesh;
import org.jmol.util.ArrayUtil;
import org.jmol.util.Escape;

public class MolecularOrbital
extends Isosurface {
    private String moTranslucency;
    private Float moTranslucentLevel;
    private Point4f moPlane;
    private Float moCutoff;
    private Float moResolution;
    private Float moScale;
    private Integer moColorPos;
    private Integer moColorNeg;
    private Integer moMonteCarloCount;
    private boolean moIsPositiveOnly;
    private Integer moRandomSeed;
    private int moFill = 1073742046;
    private int moMesh = 1073742018;
    private int moDots = 1073742042;
    private int moFrontOnly = 0x40000088;
    private String moTitleFormat;
    private boolean moDebug;
    private int myColorPt;
    private String strID;
    private int moNumber;
    private float[] moLinearCombination;
    private Map<String, Map<String, Object>> htModels;
    private Map<String, Object> thisModel;
    private List<Object> moSlab;
    private Integer moSlabValue;

    public void initShape() {
        super.initShape();
        this.myType = "mo";
        super.setProperty("thisID", "mo", null);
    }

    public void setProperty(String string, Object object, BitSet bitSet) {
        int n;
        if ("init" == string) {
            this.myColorPt = 0;
            this.moDebug = false;
            int n2 = (Integer)object;
            this.strID = this.getId(n2);
            super.setProperty("init", null, null);
            super.setProperty("modelIndex", n2, null);
            if (this.htModels == null) {
                this.htModels = new Hashtable<String, Map<String, Object>>();
            }
            if (!this.htModels.containsKey(this.strID)) {
                this.htModels.put(this.strID, new Hashtable());
            }
            this.thisModel = this.htModels.get(this.strID);
            this.moNumber = !this.thisModel.containsKey("moNumber") ? 0 : (Integer)this.thisModel.get("moNumber");
            this.moLinearCombination = (float[])this.thisModel.get("moLinearCombination");
            return;
        }
        if ("slab" == string) {
            if (object instanceof Integer) {
                this.thisModel.put("slabValue", object);
            } else {
                Object[] objectArray = (Object[])object;
                int n3 = (Integer)objectArray[0];
                this.moSlab = (List)this.thisModel.get("slab");
                if (this.moSlab == null) {
                    this.moSlab = new ArrayList<Object>();
                    this.thisModel.put("slab", this.moSlab);
                }
                if (n3 == 0x10000B) {
                    this.moSlab = null;
                    this.thisModel.remove("slab");
                    return;
                }
                this.moSlab.add(object);
            }
            return;
        }
        if ("cutoff" == string) {
            this.thisModel.put("moCutoff", object);
            this.thisModel.put("moIsPositiveOnly", Boolean.FALSE);
            return;
        }
        if ("scale" == string) {
            this.thisModel.put("moScale", object);
            return;
        }
        if ("cutoffPositive" == string) {
            this.thisModel.put("moCutoff", object);
            this.thisModel.put("moIsPositiveOnly", Boolean.TRUE);
            return;
        }
        if ("resolution" == string) {
            this.thisModel.put("moResolution", object);
            return;
        }
        if ("titleFormat" == string) {
            this.moTitleFormat = (String)object;
            return;
        }
        if ("color" == string) {
            if (!(object instanceof Integer)) {
                return;
            }
            this.thisModel.remove("moTranslucency");
            super.setProperty("color", object, bitSet);
            string = "colorRGB";
            this.myColorPt = 0;
        }
        if ("colorRGB" == string) {
            this.moColorPos = (Integer)object;
            if (this.myColorPt++ == 0) {
                this.moColorNeg = this.moColorPos;
            }
            this.thisModel.put("moColorNeg", this.moColorNeg);
            this.thisModel.put("moColorPos", this.moColorPos);
            return;
        }
        if ("plane" == string) {
            if (object == null) {
                this.thisModel.remove("moPlane");
            } else {
                this.thisModel.put("moPlane", object);
            }
            return;
        }
        if ("monteCarloCount" == string) {
            this.thisModel.put("monteCarloCount", object);
            return;
        }
        if ("randomSeed" == string) {
            if (object == null) {
                this.thisModel.remove("randomSeed");
            } else {
                this.thisModel.put("randomSeed", object);
            }
            return;
        }
        if ("molecularOrbital" == string) {
            if (object instanceof Integer) {
                this.moNumber = (Integer)object;
                this.thisModel.put("moNumber", object);
                this.thisModel.remove("moLinearCombination");
                this.moLinearCombination = null;
            } else {
                this.moNumber = 0;
                this.moLinearCombination = (float[])object;
                this.thisModel.put("moNumber", 0);
                this.thisModel.put("moLinearCombination", this.moLinearCombination);
            }
            this.setOrbital(this.moNumber, this.moLinearCombination);
            return;
        }
        if ("translucentLevel" == string) {
            if (this.thisModel == null) {
                if (this.currentMesh == null) {
                    return;
                }
                this.thisModel = this.htModels.get(this.currentMesh.thisID);
            }
            this.thisModel.put("moTranslucentLevel", object);
        }
        if ("delete" == string) {
            this.htModels.remove(this.strID);
            this.moNumber = 0;
            this.moLinearCombination = null;
        }
        if ("token" == string) {
            n = (Integer)object;
            switch (n) {
                case 1073742042: 
                case 1113198595: {
                    this.moDots = n;
                    break;
                }
                case 1073741938: 
                case 1073742046: {
                    this.moFill = n;
                    break;
                }
                case 1073742018: 
                case 0x400000E4: {
                    this.moMesh = n;
                    break;
                }
                case 0x40000088: 
                case 1073742058: {
                    this.moFrontOnly = n;
                }
            }
        }
        if ("translucency" == string) {
            if (this.thisModel == null) {
                if (this.currentMesh == null) {
                    return;
                }
                this.thisModel = this.htModels.get(this.currentMesh.thisID);
            }
            this.thisModel.put("moTranslucency", object);
        }
        if (string == "deleteModelAtoms") {
            n = ((int[])((Object[])object)[2])[0];
            Hashtable<String, Map<String, Object>> hashtable = new Hashtable<String, Map<String, Object>>();
            int n4 = this.meshCount;
            while (--n4 >= 0) {
                if (this.meshes[n4] == null) continue;
                if (this.meshes[n4].modelIndex == n) {
                    --this.meshCount;
                    if (this.meshes[n4] == this.currentMesh) {
                        this.currentMesh = null;
                        this.thisModel = null;
                    }
                    this.meshes = (IsosurfaceMesh[])ArrayUtil.deleteElements((Object)this.meshes, (int)n4, (int)1);
                    continue;
                }
                Map<String, Object> map = this.htModels.get(this.meshes[n4].thisID);
                if (this.meshes[n4].modelIndex > n) {
                    --this.meshes[n4].modelIndex;
                    this.meshes[n4].thisID = this.getId(this.meshes[n4].modelIndex);
                }
                hashtable.put(this.meshes[n4].thisID, map);
            }
            this.htModels = hashtable;
            return;
        }
        super.setProperty(string, object, bitSet);
    }

    private String getId(int n) {
        return "mo_model" + this.viewer.getModelNumberDotted(n);
    }

    public Object getProperty(String string, int n) {
        if (string.equals("list")) {
            String string2 = (String)super.getProperty("list", n);
            if (string2.length() > 1) {
                string2 = string2 + "cutoff = " + super.getProperty("cutoff", 0) + "\n";
            }
            return this.viewer.getMoInfo(-1) + "\n" + string2;
        }
        if (string == "moNumber") {
            return this.moNumber;
        }
        if (string == "moLinearCombination") {
            return this.moLinearCombination;
        }
        if (string == "showMO") {
            int n2;
            boolean bl;
            boolean bl2;
            StringBuffer stringBuffer = new StringBuffer();
            List list = (List)this.sg.getMoData().get("mos");
            int n3 = list == null ? 0 : list.size();
            int n4 = n;
            int n5 = this.moNumber;
            boolean bl3 = bl2 = n4 == Integer.MIN_VALUE;
            if (n4 == Integer.MAX_VALUE) {
                n4 = n5;
            }
            if (n3 == 0 || bl2 && n5 == 0) {
                return "";
            }
            boolean bl4 = bl = n4 != 0;
            if (n5 == 0) {
                n4 = 0;
            }
            boolean bl5 = false;
            int n6 = n4 > 0 ? 1 : n3;
            for (int i = n2 = n6 == 1 && n5 > 0 ? n5 : 1; i <= n3; ++i) {
                if (n4 != 0 && n4 != i && (bl || i != n5)) continue;
                if (!bl) {
                    Parameters parameters = this.sg.getParams();
                    super.setProperty("init", parameters, null);
                    this.setOrbital(i, null);
                }
                this.jvxlData.moleculeXml = this.viewer.getModelCml(this.viewer.getModelUndeletedAtomsBitSet(this.thisMesh.modelIndex), 100, true);
                if (!bl5) {
                    stringBuffer.append(JvxlCoder.jvxlGetFile(this.jvxlData, null, null, "HEADERONLY", true, n6, null, null));
                    bl5 = true;
                }
                stringBuffer.append(JvxlCoder.jvxlGetFile(this.jvxlData, null, this.jvxlData.title, null, false, 1, this.thisMesh.getState("mo"), this.thisMesh.scriptCommand == null ? "" : this.thisMesh.scriptCommand));
                if (!bl) {
                    super.setProperty("delete", "mo_show", null);
                }
                if (n6 == 1) break;
            }
            stringBuffer.append(JvxlCoder.jvxlGetFile(this.jvxlData, null, null, "TRAILERONLY", true, 0, null, null));
            return stringBuffer.toString();
        }
        return super.getProperty(string, n);
    }

    protected void clearSg() {
    }

    private boolean getSettings(String string) {
        this.thisModel = this.htModels.get(string);
        if (this.thisModel == null || this.thisModel.get("moNumber") == null) {
            return false;
        }
        this.moTranslucency = (String)this.thisModel.get("moTranslucency");
        this.moTranslucentLevel = (Float)this.thisModel.get("moTranslucentLevel");
        this.moPlane = (Point4f)this.thisModel.get("moPlane");
        this.moCutoff = (Float)this.thisModel.get("moCutoff");
        if (this.moCutoff == null) {
            this.moCutoff = (Float)this.sg.getMoData().get("defaultCutoff");
        }
        if (this.moCutoff == null) {
            this.moCutoff = new Float(0.05f);
        }
        this.thisModel.put("moCutoff", new Float(this.moCutoff.floatValue()));
        this.moResolution = (Float)this.thisModel.get("moResolution");
        this.moScale = (Float)this.thisModel.get("moScale");
        this.moColorPos = (Integer)this.thisModel.get("moColorPos");
        this.moColorNeg = (Integer)this.thisModel.get("moColorNeg");
        this.moMonteCarloCount = (Integer)this.thisModel.get("monteCarloCount");
        this.moRandomSeed = (Integer)this.thisModel.get("randomSeed");
        this.moSlabValue = (Integer)this.thisModel.get("slabValue");
        this.moSlab = (List)this.thisModel.get("slab");
        if (this.moRandomSeed == null) {
            this.moRandomSeed = (int)(-System.currentTimeMillis()) % 10000;
            this.thisModel.put("randomSeed", this.moRandomSeed);
        }
        this.moNumber = (Integer)this.thisModel.get("moNumber");
        this.moLinearCombination = (float[])this.thisModel.get("moLinearCombination");
        Object object = this.thisModel.get("moIsPositiveOnly");
        this.moIsPositiveOnly = object != null && (Boolean)object != false;
        return true;
    }

    private void setOrbital(int n, float[] fArray) {
        super.setProperty("reset", this.strID, null);
        if (this.moDebug) {
            super.setProperty("debug", Boolean.TRUE, null);
        }
        this.getSettings(this.strID);
        if (this.moScale != null) {
            super.setProperty("scale", this.moScale, null);
        }
        if (this.moResolution != null) {
            super.setProperty("resolution", this.moResolution, null);
        }
        if (this.moPlane != null) {
            super.setProperty("plane", this.moPlane, null);
            if (this.moCutoff != null) {
                super.setProperty("red", new Float(-this.moCutoff.floatValue()), null);
                super.setProperty("blue", this.moCutoff, null);
            }
        } else {
            if (this.moCutoff != null) {
                super.setProperty(this.moIsPositiveOnly ? "cutoffPositive" : "cutoff", this.moCutoff, null);
            }
            if (this.moColorNeg != null) {
                super.setProperty("colorRGB", this.moColorNeg, null);
            }
            if (this.moColorPos != null) {
                super.setProperty("colorRGB", this.moColorPos, null);
            }
            if (this.moMonteCarloCount != null) {
                super.setProperty("randomSeed", this.moRandomSeed, null);
                super.setProperty("monteCarloCount", this.moMonteCarloCount, null);
            }
        }
        super.setProperty("title", this.moTitleFormat, null);
        super.setProperty("fileName", this.viewer.getFileName(), null);
        super.setProperty("molecularOrbital", fArray == null ? (Object)n : fArray, null);
        if (this.moPlane != null && this.moColorNeg != null) {
            super.setProperty("colorRGB", this.moColorNeg, null);
        }
        if (this.moPlane != null && this.moColorPos != null) {
            super.setProperty("colorRGB", this.moColorPos, null);
        }
        this.currentMesh.isColorSolid = false;
        if (this.moSlabValue != null) {
            super.setProperty("slab", this.moSlabValue, null);
        }
        if (this.moSlab != null) {
            for (int i = 0; i < this.moSlab.size(); ++i) {
                super.setProperty("slab", this.moSlab.get(i), null);
            }
        }
        if (this.moTranslucentLevel != null) {
            super.setProperty("translucenctLevel", this.moTranslucentLevel, null);
        }
        if (this.moTranslucency != null) {
            super.setProperty("translucency", this.moTranslucency, null);
        }
        super.setProperty("token", this.moFill, null);
        super.setProperty("token", this.moMesh, null);
        super.setProperty("token", this.moDots, null);
        super.setProperty("token", this.moFrontOnly, null);
        this.thisModel.put("mesh", this.currentMesh);
    }

    public String getShapeState() {
        if (this.htModels == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.viewer.getModelCount();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(this.getMoState(i));
        }
        return stringBuffer.toString();
    }

    private String getMoState(int n) {
        this.strID = this.getId(n);
        if (!this.getSettings(this.strID)) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = this.viewer.getModelCount();
        if (n2 > 1) {
            MolecularOrbital.appendCmd((StringBuffer)stringBuffer, (String)("frame " + this.viewer.getModelNumberDotted(n)));
        }
        if (this.moCutoff != null) {
            MolecularOrbital.appendCmd((StringBuffer)stringBuffer, (String)("mo cutoff " + (this.sg.getIsPositiveOnly() ? "+" : "") + this.moCutoff));
        }
        if (this.moScale != null) {
            MolecularOrbital.appendCmd((StringBuffer)stringBuffer, (String)("mo scale " + this.moScale));
        }
        if (this.moMonteCarloCount != null) {
            MolecularOrbital.appendCmd((StringBuffer)stringBuffer, (String)("mo points " + this.moMonteCarloCount + " " + this.moRandomSeed));
        }
        if (this.moResolution != null) {
            MolecularOrbital.appendCmd((StringBuffer)stringBuffer, (String)("mo resolution " + this.moResolution));
        }
        if (this.moPlane != null) {
            MolecularOrbital.appendCmd((StringBuffer)stringBuffer, (String)("mo plane {" + this.moPlane.x + " " + this.moPlane.y + " " + this.moPlane.z + " " + this.moPlane.w + "}"));
        }
        if (this.moTitleFormat != null) {
            MolecularOrbital.appendCmd((StringBuffer)stringBuffer, (String)("mo titleFormat " + Escape.escape((String)this.moTitleFormat)));
        }
        if (this.moColorNeg != null) {
            MolecularOrbital.appendCmd((StringBuffer)stringBuffer, (String)("mo color " + Escape.escapeColor((int)this.moColorNeg) + (this.moColorNeg.equals(this.moColorPos) ? "" : " " + Escape.escapeColor((int)this.moColorPos))));
        }
        if (this.moSlab != null) {
            if (this.thisMesh.slabOptions != null) {
                MolecularOrbital.appendCmd((StringBuffer)stringBuffer, (String)this.thisMesh.slabOptions.toString());
            }
            if (this.thisMesh.jvxlData.slabValue != Integer.MIN_VALUE) {
                MolecularOrbital.appendCmd((StringBuffer)stringBuffer, (String)("mo slab " + this.thisMesh.jvxlData.slabValue));
            }
        }
        if (this.moLinearCombination == null) {
            MolecularOrbital.appendCmd((StringBuffer)stringBuffer, (String)("mo " + this.moNumber));
        } else {
            MolecularOrbital.appendCmd((StringBuffer)stringBuffer, (String)("mo " + EnumQuantumShell.getMOString((float[])this.moLinearCombination)));
        }
        if (this.moTranslucency != null) {
            MolecularOrbital.appendCmd((StringBuffer)stringBuffer, (String)("mo translucent " + this.moTranslucentLevel));
        }
        MolecularOrbital.appendCmd((StringBuffer)stringBuffer, (String)((IsosurfaceMesh)((Object)this.thisModel.get("mesh"))).getState("mo"));
        return stringBuffer.toString();
    }

    public void merge(Shape shape) {
        Map<String, Map<String, Object>> map;
        MolecularOrbital molecularOrbital = (MolecularOrbital)shape;
        this.moColorNeg = molecularOrbital.moColorNeg;
        this.moColorPos = molecularOrbital.moColorPos;
        this.moCutoff = molecularOrbital.moCutoff;
        this.moPlane = molecularOrbital.moPlane;
        this.moResolution = molecularOrbital.moResolution;
        this.moScale = molecularOrbital.moScale;
        this.moSlab = molecularOrbital.moSlab;
        this.moSlabValue = molecularOrbital.moSlabValue;
        this.moTitleFormat = molecularOrbital.moTitleFormat;
        this.moTranslucency = molecularOrbital.moTranslucency;
        if (this.htModels == null) {
            this.htModels = new Hashtable<String, Map<String, Object>>();
        }
        if ((map = molecularOrbital.htModels) != null) {
            for (Map.Entry<String, Map<String, Object>> entry : map.entrySet()) {
                String string = entry.getKey();
                this.htModels.put(string, entry.getValue());
            }
        }
        super.merge(shape);
    }
}

