/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import javax.vecmath.Vector3f;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.jvxl.readers.VolumeFileReader;
import org.jmol.util.Logger;

class XsfReader
extends VolumeFileReader {
    private boolean isBXSF = false;

    XsfReader(SurfaceGenerator surfaceGenerator, BufferedReader bufferedReader) {
        super(surfaceGenerator, bufferedReader);
    }

    protected void readParameters() throws Exception {
        this.isAngstroms = false;
        this.params.blockCubeData = true;
        this.jvxlFileHeaderBuffer = new StringBuffer();
        this.jvxlFileHeaderBuffer.append("XsfReader file\n");
        boolean bl = this.params.cutoffAutomatic;
        this.isAngstroms = true;
        String string = "BEGIN_DATAGRID_3D";
        this.nSurfaces = 1;
        while (this.readLine() != null && this.line.indexOf(string) < 0) {
            Logger.info((String)this.line);
            if (this.line.indexOf("Fermi Energy:") < 0) continue;
            this.isBXSF = true;
            string = "BEGIN_BANDGRID_3D";
            if (!bl) continue;
            this.params.cutoff = this.parseFloat(this.getTokens()[2]);
            bl = false;
        }
        if (bl) {
            this.params.cutoff = 0.05f;
        }
        if (this.isBXSF) {
            this.nSurfaces = this.parseInt(this.readLine());
        }
        this.voxelCounts[0] = this.parseInt(this.readLine());
        this.voxelCounts[1] = this.parseInt();
        this.voxelCounts[2] = this.parseInt();
        this.volumetricOrigin.set(this.parseFloat(this.readLine()), this.parseFloat(), this.parseFloat());
        for (int i = 0; i < 3; ++i) {
            this.volumetricVectors[i].set(this.parseFloat(this.readLine()), this.parseFloat(), this.parseFloat());
            this.volumetricVectors[i].scale(1.0f / (float)(this.voxelCounts[i] - 1));
        }
        if (!this.isBXSF) {
            Vector3f vector3f = this.volumetricVectors[0];
            this.volumetricVectors[0] = this.volumetricVectors[2];
            this.volumetricVectors[2] = vector3f;
            int n = this.voxelCounts[0];
            this.voxelCounts[0] = this.voxelCounts[2];
            this.voxelCounts[2] = n;
            this.params.insideOut = !this.params.insideOut;
        }
    }

    protected void gotoData(int n, int n2) throws Exception {
        if (!this.params.blockCubeData) {
            return;
        }
        if (n > 0) {
            Logger.info((String)("skipping " + n + " data sets, " + n2 + " points each"));
        }
        if (this.isBXSF) {
            Logger.info((String)this.readLine());
        }
        for (int i = 0; i < n; ++i) {
            this.skipData(n2);
        }
    }

    protected void skipData(int n) throws Exception {
        super.skipData(n);
        if (this.isBXSF) {
            Logger.info((String)this.readLine());
        }
    }
}

