/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import javax.vecmath.Point3f;
import javax.vecmath.Point4f;
import javax.vecmath.Tuple3f;
import org.jmol.jvxl.data.JvxlCoder;
import org.jmol.jvxl.readers.AtomDataReader;
import org.jmol.jvxl.readers.SurfaceGenerator;

class IsoFxyReader
extends AtomDataReader {
    private float[][] data;
    private boolean isPlanarMapping;
    private Object[] func;
    private final float[] values = new float[3];

    IsoFxyReader(SurfaceGenerator surfaceGenerator) {
        super(surfaceGenerator);
        this.isXLowToHigh = true;
        this.precalculateVoxelData = false;
        this.atomDataServer = surfaceGenerator.getAtomDataServer();
        this.params.fullyLit = true;
        boolean bl = this.isPlanarMapping = this.params.thePlane != null || this.params.state == 3;
        if (this.params.func != null) {
            this.volumeData.sr = this;
        }
    }

    protected void setup(boolean bl) {
        if (this.params.functionInfo.size() > 5) {
            this.data = (float[][])this.params.functionInfo.get(5);
        }
        this.setup("functionXY");
    }

    protected void setup(String string) {
        this.func = (Object[])this.params.func;
        String string2 = (String)this.params.functionInfo.get(0);
        this.jvxlFileHeaderBuffer = new StringBuffer();
        this.jvxlFileHeaderBuffer.append(string).append("\n").append(string2).append("\n");
        if (this.params.thePlane != null || this.data == null && !this.useOriginStepsPoints) {
            this.setVolumeForPlane();
        } else if (this.data == null) {
            this.setVolumeDataParams();
        } else {
            this.setVolumeData();
        }
        JvxlCoder.jvxlCreateHeaderWithoutTitleOrAtoms(this.volumeData, this.jvxlFileHeaderBuffer);
    }

    protected void setVolumeData() {
        if (this.data == null) {
            super.setVolumeData();
            return;
        }
        this.volumetricOrigin.set((Tuple3f)((Point3f)this.params.functionInfo.get(1)));
        for (int i = 0; i < 3; ++i) {
            Point4f point4f = (Point4f)this.params.functionInfo.get(i + 2);
            this.voxelCounts[i] = Math.abs((int)point4f.x);
            this.volumetricVectors[i].set(point4f.y, point4f.z, point4f.w);
        }
        if (this.isAnisotropic) {
            this.setVolumetricAnisotropy();
        }
    }

    protected void readSurfaceData(boolean bl) throws Exception {
        if (this.volumeData.sr != null) {
            return;
        }
        super.readSurfaceData(bl);
    }

    public float[] getPlane(int n) {
        float[] fArray = super.getPlane(n);
        this.getPlane(n, fArray);
        return fArray;
    }

    private void getPlane(int n, float[] fArray) {
        int n2 = 0;
        for (int i = 0; i < this.nPointsY; ++i) {
            for (int j = 0; j < this.nPointsZ; ++j) {
                fArray[n2++] = this.getValue(n, i, j);
            }
        }
    }

    protected float getValue(int n, int n2, int n3) {
        float f;
        if (this.data == null) {
            f = this.evaluateValue(n, n2, n3);
        } else {
            this.volumeData.voxelPtToXYZ(n, n2, n3, this.ptTemp);
            f = this.data[n][n2];
        }
        return this.isPlanarMapping ? f : f - this.ptTemp.z;
    }

    public float getValueAtPoint(Point3f point3f) {
        if (this.params.func == null) {
            return 0.0f;
        }
        this.values[0] = point3f.x;
        this.values[1] = point3f.y;
        this.values[2] = point3f.z;
        return this.atomDataServer.evalFunctionFloat(this.func[0], this.func[1], this.values);
    }

    protected float evaluateValue(int n, int n2, int n3) {
        this.volumeData.voxelPtToXYZ(n, n2, n3, this.ptTemp);
        return this.getValueAtPoint(this.ptTemp);
    }
}

