/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.cif;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.List;
import javajs.util.M3;
import javajs.util.Matrix;
import javajs.util.P3;
import javajs.util.SB;
import javajs.util.T3;
import org.jmol.adapter.readers.cif.Subsystem;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.MSInterface;
import org.jmol.api.SymmetryInterface;
import org.jmol.java.BS;
import org.jmol.util.BSUtil;
import org.jmol.util.BoxInfo;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Modulation;
import org.jmol.util.ModulationSet;
import org.jmol.util.Tensor;

public class MSReader
implements MSInterface {
    protected AtomSetCollectionReader cr;
    protected int modDim;
    protected String modAxes;
    protected boolean modAverage;
    private boolean modPack;
    private boolean modVib;
    private String modType;
    private String modCell;
    private boolean modDebug;
    private int modSelected = -1;
    private boolean modLast;
    private Matrix sigma;
    private double[] q1;
    private P3 q1Norm;
    private Map<String, double[]> htModulation;
    private Map<String, List<Modulation>> htAtomMods;
    private int iopLast = -1;
    private M3 gammaE;
    private int nOps;
    private boolean haveOccupancy;
    private Atom[] atoms;
    private int atomCount;
    private boolean haveAtomMods;
    private String atModel = "@0";
    private Matrix[] modMatrices;
    private P3[] qs;
    private int modCount;
    private static final String U_LIST = "U11U22U33U12U13U23UISO";
    private Map<String, Subsystem> htSubsystems;
    private P3 minXYZ0;
    private P3 maxXYZ0;

    Matrix getSigma() {
        return this.sigma;
    }

    public int initialize(AtomSetCollectionReader atomSetCollectionReader, String string) throws Exception {
        this.cr = atomSetCollectionReader;
        this.modDebug = atomSetCollectionReader.checkFilterKey("MODDEBUG");
        this.modPack = !atomSetCollectionReader.checkFilterKey("MODNOPACK");
        this.modLast = atomSetCollectionReader.checkFilterKey("MODLAST");
        this.modAxes = atomSetCollectionReader.getFilter("MODAXES=");
        this.modType = atomSetCollectionReader.getFilter("MODTYPE=");
        this.modCell = atomSetCollectionReader.getFilter("MODCELL=");
        this.modSelected = atomSetCollectionReader.parseIntStr("" + atomSetCollectionReader.getFilter("MOD="));
        this.modVib = atomSetCollectionReader.checkFilterKey("MODVIB");
        this.modAverage = atomSetCollectionReader.checkFilterKey("MODAVE");
        this.setModDim(atomSetCollectionReader.parseIntStr(string));
        return this.modDim;
    }

    private void setSubsystemOptions() {
        this.cr.doPackUnitCell = this.modPack;
        if (!this.cr.doApplySymmetry) {
            this.cr.doApplySymmetry = true;
            this.cr.latticeCells[0] = 1;
            this.cr.latticeCells[1] = 1;
            this.cr.latticeCells[2] = 1;
        }
        if (this.modCell != null) {
            this.cr.addJmolScript("unitcell {%" + this.modCell + "}");
        }
    }

    protected void setModDim(int n) {
        if (this.modAverage) {
            return;
        }
        this.modDim = n;
        if (this.modDim > 3) {
            this.cr.appendLoadNote("Too high modulation dimension (" + this.modDim + ") -- reading average structure");
            this.modDim = 0;
            this.modAverage = true;
        } else {
            this.cr.appendLoadNote("Modulation dimension = " + this.modDim);
            this.htModulation = new Hashtable<String, double[]>();
        }
    }

    public void addModulation(Map<String, double[]> map, String string, double[] dArray, int n) {
        char c = string.charAt(0);
        switch (c) {
            case 'D': 
            case 'O': 
            case 'U': {
                if ((this.modType == null || this.modType.indexOf(c) >= 0) && (this.modSelected <= 0 || this.modSelected == 1)) break;
                return;
            }
        }
        boolean bl = false;
        int n2 = dArray.length;
        while (--n2 >= 0) {
            if (this.modSelected > 0 && n2 + 1 != this.modSelected && string.contains("_coefs_")) {
                dArray[n2] = 0.0;
                continue;
            }
            if (dArray[n2] == 0.0) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return;
        }
        if (map == null) {
            map = this.htModulation;
        }
        string = string + "@" + (n >= 0 ? n : this.cr.atomSetCollection.getCurrentAtomSetIndex());
        Logger.info((String)("Adding " + string + " " + Escape.e((Object)dArray)));
        map.put(string, dArray);
    }

    public void setModulation(boolean bl) {
        if (this.modDim == 0 || this.htModulation == null) {
            return;
        }
        if (this.modDebug) {
            Logger.debuggingHigh = true;
            Logger.debugging = true;
        }
        this.cr.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("someModelsAreModulated", (Object)Boolean.TRUE);
        this.setModulationForStructure(this.cr.atomSetCollection.getCurrentAtomSetIndex(), bl);
        if (this.modDebug) {
            Logger.debuggingHigh = false;
            Logger.debugging = false;
        }
    }

    public void finalizeModulation() {
        if (this.modDim > 0 && !this.modVib) {
            this.cr.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("modulationOn", (Object)Boolean.TRUE);
            this.cr.addJmolScript(this.haveOccupancy ? ";display occupancy >= 0.5" : "");
        }
    }

    private String checkKey(String string, boolean bl) {
        int n = string.indexOf(this.atModel);
        return n < 0 || string.indexOf("*;*") >= 0 || bl && string.indexOf("?") >= 0 ? null : string.substring(0, n);
    }

    public double[] getMod(String string) {
        return this.htModulation.get(string + this.atModel);
    }

    private void setModulationForStructure(int n, boolean bl) {
        this.atModel = "@" + n;
        if (this.htModulation.containsKey("X_" + this.atModel)) {
            return;
        }
        if (!bl) {
            this.initModForStructure(n);
            return;
        }
        this.htModulation.put("X_" + this.atModel, new double[0]);
        if (!this.haveAtomMods) {
            return;
        }
        int n2 = this.cr.atomSetCollection.getAtomCount();
        this.atoms = this.cr.atomSetCollection.getAtoms();
        this.cr.symmetry = this.cr.atomSetCollection.getSymmetry();
        if (this.cr.symmetry != null) {
            this.nOps = this.cr.symmetry.getSpaceGroupOperationCount();
        }
        this.iopLast = -1;
        SB sB = new SB();
        for (int i = this.cr.atomSetCollection.getLastAtomSetAtomIndex(); i < n2; ++i) {
            this.modulateAtom(this.atoms[i], sB);
        }
        this.cr.atomSetCollection.setAtomSetAtomProperty("modt", sB.toString(), -1);
        this.cr.appendLoadNote(this.modCount + " modulations for " + this.atomCount + " atoms");
        this.htAtomMods = null;
        if (this.minXYZ0 != null) {
            this.trimAtomSet();
        }
        this.htSubsystems = null;
    }

    private void initModForStructure(int n) {
        String string;
        String string2;
        double[] dArray;
        this.sigma = new Matrix((double[][])null, this.modDim, 3);
        this.qs = null;
        this.modMatrices = new Matrix[]{this.sigma, null};
        for (int i = 0; i < this.modDim; ++i) {
            dArray = this.getMod("W_" + (i + 1));
            if (dArray == null) {
                Logger.info((String)("Not enough cell wave vectors for d=" + this.modDim));
                return;
            }
            this.cr.appendLoadNote("W_" + (i + 1) + " = " + Escape.e((Object)dArray));
            this.sigma.getArray()[i] = new double[]{dArray[0], dArray[1], dArray[2]};
        }
        this.q1 = this.sigma.getArray()[0];
        this.q1Norm = P3.new3((float)(this.q1[0] == 0.0 ? 0.0f : 1.0f), (float)(this.q1[1] == 0.0 ? 0.0f : 1.0f), (float)(this.q1[2] == 0.0 ? 0.0f : 1.0f));
        double[] dArray2 = new double[this.modDim];
        dArray2[0] = 1.0;
        Hashtable<String, double[]> hashtable = new Hashtable<String, double[]>();
        for (Map.Entry<String, double[]> entry : this.htModulation.entrySet()) {
            string2 = this.checkKey(entry.getKey(), false);
            if (string2 == null) continue;
            dArray = entry.getValue();
            switch (string2.charAt(0)) {
                case 'O': {
                    this.haveOccupancy = true;
                }
                case 'D': 
                case 'U': {
                    if (dArray[2] != 1.0 || string2.charAt(2) == 'S') break;
                    int n2 = string2.indexOf("?");
                    if (n2 >= 0) {
                        string = string2.substring(n2 + 1);
                        dArray = this.getMod(string2.substring(0, 2) + string + "#*;*");
                        if (dArray == null) break;
                        string2 = string2.substring(0, n2);
                        this.addModulation(hashtable, string2, dArray, n);
                        break;
                    }
                    double d = dArray[0];
                    double d2 = Math.PI * 2 * dArray[1];
                    dArray[0] = (float)(d * Math.cos(d2));
                    dArray[1] = (float)(d * Math.sin(-d2));
                    dArray[2] = 0.0;
                    Logger.info((String)("msCIF setting " + string2 + " " + Escape.e((Object)dArray)));
                    break;
                }
                case 'W': {
                    if (this.modDim > 1) break;
                }
                case 'F': {
                    if (string2.indexOf("_coefs_") >= 0) {
                        this.cr.appendLoadNote("Wave vector " + string2 + "=" + Escape.e((Object)dArray));
                        break;
                    }
                    double[] dArray3 = this.getQCoefs(dArray);
                    if (dArray3 == null) {
                        this.cr.appendLoadNote("Cannot match atom wave vector " + string2 + " " + dArray + " to a cell wave vector or its harmonic");
                        break;
                    }
                    string = string2 + "_coefs_";
                    if (this.htModulation.containsKey(string + this.atModel)) break;
                    this.addModulation(hashtable, string, dArray3, n);
                    if (!string2.startsWith("F_")) break;
                    this.cr.appendLoadNote("atom wave vector " + string2 + " = " + Escape.e((Object)dArray) + " fn = " + Escape.e((Object)dArray3));
                }
            }
        }
        if (!hashtable.isEmpty()) {
            this.htModulation.putAll(hashtable);
        }
        if (this.htSubsystems == null) {
            this.haveAtomMods = false;
        } else {
            this.haveAtomMods = true;
            this.htAtomMods = new Hashtable<String, List<Modulation>>();
        }
        for (Map.Entry<String, double[]> entry : this.htModulation.entrySet()) {
            string2 = this.checkKey(entry.getKey(), true);
            if (string2 == null) continue;
            double[] dArray4 = entry.getValue();
            string = string2.substring(string2.indexOf(";") + 1);
            int n3 = string.indexOf("#=");
            if (n3 >= 0) {
                dArray4 = this.getMod(string.substring(n3 + 2));
                string = string.substring(0, n3);
            }
            if (Logger.debuggingHigh) {
                Logger.debug((String)("SetModulation: " + string2 + " " + Escape.e((Object)dArray4)));
            }
            char c = string2.charAt(0);
            n3 = string2.indexOf("#") + 1;
            String string3 = null;
            switch (c) {
                case 'U': {
                    string3 = string2.substring(4, string2.indexOf(";"));
                }
                case 'D': 
                case 'O': {
                    char c2 = string2.charAt(2);
                    char c3 = string2.charAt(n3);
                    char c4 = c2 == 'S' ? (char)'s' : (c2 == '0' ? (char)'c' : (c == 'O' ? (char)'o' : (c = c == 'U' ? (char)'u' : 'f')));
                    if (this.htAtomMods == null) {
                        this.htAtomMods = new Hashtable<String, List<Modulation>>();
                    }
                    int n4 = c2 == 'S' ? 0 : this.cr.parseIntStr(string2.substring(2));
                    double[] dArray5 = new double[]{dArray4[0], dArray4[1], dArray4[2]};
                    if (n4 == 0) {
                        this.addAtomModulation(string, c3, c, dArray5, string3, dArray2);
                    } else {
                        double[] dArray6 = this.getMod("F_" + n4 + "_coefs_");
                        if (dArray6 == null) {
                            Logger.error((String)("Missing qlist for F_" + n4));
                            this.cr.appendLoadNote("Missing cell wave vector for atom wave vector " + n4 + " for " + string2 + " " + Escape.e((Object)dArray4));
                            dArray6 = this.getMod("F_1_coefs_");
                        }
                        if (dArray6 != null) {
                            this.addAtomModulation(string, c3, c, dArray5, string3, dArray6);
                        }
                    }
                    this.haveAtomMods = true;
                }
            }
        }
    }

    private double[] getQCoefs(double[] dArray) {
        int n;
        if (this.qs == null) {
            this.qs = new P3[this.modDim];
            for (int i = 0; i < this.modDim; ++i) {
                this.qs[i] = this.toP3(this.getMod("W_" + (i + 1)));
            }
        }
        P3 p3 = this.toP3(dArray);
        for (int i = 0; i < this.modDim; ++i) {
            float f;
            if (this.qs[i] == null || !(Math.abs((f = p3.dot((T3)this.qs[i]) / this.qs[i].dot((T3)this.qs[i])) - (float)(n = Math.round(f))) < 0.001f)) continue;
            dArray = new double[this.modDim];
            dArray[i] = n;
            return dArray;
        }
        P3 p32 = this.toP3(dArray);
        int n2 = this.modDim < 2 ? 0 : -3;
        n = this.modDim < 2 ? 0 : 3;
        int n3 = this.modDim < 3 ? 0 : -3;
        int n4 = this.modDim < 3 ? 0 : 3;
        for (int i = -3; i <= 3; ++i) {
            for (int j = n2; j <= n; ++j) {
                for (int k = n3; k <= n4; ++k) {
                    p3.setT((T3)this.qs[0]);
                    p3.scale((float)i);
                    if (this.qs[1] != null) {
                        p3.scaleAdd2((float)j, (T3)this.qs[1], (T3)p3);
                    }
                    if (this.qs[2] != null) {
                        p3.scaleAdd2((float)k, (T3)this.qs[2], (T3)p3);
                    }
                    if (!(p3.distanceSquared((T3)p32) < 1.0E-4f)) continue;
                    dArray = new double[this.modDim];
                    switch (this.modDim) {
                        default: {
                            dArray[2] = k;
                        }
                        case 2: {
                            dArray[1] = j;
                        }
                        case 1: 
                    }
                    dArray[0] = i;
                    return dArray;
                }
            }
        }
        return null;
    }

    private P3 toP3(double[] dArray) {
        return P3.new3((float)((float)dArray[0]), (float)((float)dArray[1]), (float)((float)dArray[2]));
    }

    private void addAtomModulation(String string, char c, char c2, double[] dArray, String string2, double[] dArray2) {
        List list = this.htAtomMods.get(string);
        if (list == null) {
            ++this.atomCount;
            list = new List();
            this.htAtomMods.put(string, (List<Modulation>)list);
        }
        list.addLast((Object)new Modulation(c, c2, dArray, string2, dArray2));
        ++this.modCount;
    }

    public void addSubsystem(String string, Matrix matrix) {
        if (string == null) {
            return;
        }
        Subsystem subsystem = new Subsystem(this, string, matrix);
        this.cr.appendLoadNote("subsystem " + string + "\n" + matrix);
        this.setSubsystem(string, subsystem);
    }

    private void addUStr(Atom atom, String string, float f) {
        int n = U_LIST.indexOf(string) / 3;
        if (Logger.debuggingHigh) {
            Logger.debug((String)("MOD RDR adding " + string + " " + n + " " + f + " to " + atom.anisoBorU[n]));
        }
        if (atom.anisoBorU == null) {
            Logger.error((String)("MOD RDR cannot modulate nonexistent atom anisoBorU for atom " + atom.atomName));
        } else {
            this.cr.setU(atom, n, f + atom.anisoBorU[n]);
        }
    }

    private void modulateAtom(Atom atom, SB sB) {
        Object object;
        List list = this.htAtomMods.get(atom.atomName);
        if (list == null && atom.altLoc != '\u0000' && this.htSubsystems != null) {
            list = new List();
        }
        if (list == null || this.cr.symmetry == null || atom.bsSymmetry == null) {
            return;
        }
        int n = Math.max(atom.bsSymmetry.nextSetBit(0), 0);
        if (this.modLast) {
            n = Math.max((atom.bsSymmetry.length() - 1) % this.nOps, n);
        }
        if (Logger.debuggingHigh) {
            Logger.debug((String)("\nsetModulation: i=" + atom.index + " " + atom.atomName + " xyz=" + atom + " occ=" + atom.foccupancy));
        }
        if (n != this.iopLast) {
            this.iopLast = n;
            this.gammaE = new M3();
            this.cr.symmetry.getSpaceGroupOperation(n).getRotationScale(this.gammaE);
        }
        if (Logger.debugging) {
            Logger.debug((String)("setModulation iop = " + n + " " + this.cr.symmetry.getSpaceGroupXyz(n, false) + " " + atom.bsSymmetry));
        }
        ModulationSet modulationSet = new ModulationSet().set(atom.index + " " + atom.atomName, P3.newP((T3)atom), this.modDim, list, this.gammaE, this.getMatrices(atom), n, this.getSymmetry(atom));
        modulationSet.calculate(null, false);
        if (!Float.isNaN(modulationSet.vOcc)) {
            double d;
            object = this.getMod("J_O#0;" + atom.atomName);
            float f = modulationSet.vOcc0;
            if (Float.isNaN(f)) {
                d = modulationSet.vOcc;
            } else if (object == null) {
                d = atom.foccupancy + modulationSet.vOcc;
            } else if (atom.vib != null) {
                double d2 = atom.vib.x;
                double d3 = (double)atom.foccupancy * d2 / (double)this.nOps / object[1];
                d = d3 * (object[1] + (double)modulationSet.vOcc);
            } else {
                d = (double)(object[0] * (object[1] + (double)modulationSet.vOcc));
            }
            atom.foccupancy = (float)Math.min(1.0, Math.max(0.0, d));
        }
        if (modulationSet.htUij != null) {
            if (Logger.debuggingHigh) {
                Logger.debug((String)("setModulation Uij(initial)=" + Escape.eAF((float[])atom.anisoBorU)));
                Logger.debug((String)("setModulation tensor=" + Escape.e((Object)((Tensor)atom.tensors.get(0)).getInfo("all"))));
            }
            for (Map.Entry entry : modulationSet.htUij.entrySet()) {
                this.addUStr(atom, (String)entry.getKey(), ((Float)entry.getValue()).floatValue());
            }
            if (atom.tensors != null) {
                ((Tensor)atom.tensors.get((int)0)).isUnmodulated = true;
            }
            object = this.getAtomSymmetry(atom, this.cr.symmetry);
            Tensor tensor = this.cr.atomSetCollection.addRotatedTensor(atom, object.getTensor(atom.anisoBorU), n, false, (SymmetryInterface)object);
            tensor.isModulated = true;
            if (Logger.debuggingHigh) {
                Logger.debug((String)("setModulation Uij(final)=" + Escape.eAF((float[])atom.anisoBorU) + "\n"));
                Logger.debug((String)("setModulation tensor=" + ((Tensor)atom.tensors.get(0)).getInfo("all")));
            }
        }
        if (Float.isNaN(modulationSet.x)) {
            modulationSet.set(0.0f, 0.0f, 0.0f);
        }
        atom.vib = modulationSet;
        if (this.modVib || atom.foccupancy != 0.0f) {
            float f = this.q1Norm.dot((T3)atom);
            if (Math.abs(f - (float)((int)f)) > 0.001f) {
                f = (int)Math.floor(f);
            }
            sB.append((int)f + "\n");
        }
    }

    public SymmetryInterface getAtomSymmetry(Atom atom, SymmetryInterface symmetryInterface) {
        Subsystem subsystem;
        return this.htSubsystems == null || (subsystem = this.getSubsystem(atom)) == null ? symmetryInterface : subsystem.getSymmetry();
    }

    private void setSubsystem(String string, Subsystem subsystem) {
        if (this.htSubsystems == null) {
            this.htSubsystems = new Hashtable<String, Subsystem>();
        }
        this.htSubsystems.put(string, subsystem);
        this.setSubsystemOptions();
    }

    private Matrix[] getMatrices(Atom atom) {
        Subsystem subsystem = this.getSubsystem(atom);
        return subsystem == null ? this.modMatrices : subsystem.getModMatrices();
    }

    private SymmetryInterface getSymmetry(Atom atom) {
        Subsystem subsystem = this.getSubsystem(atom);
        return subsystem == null ? this.cr.symmetry : subsystem.getSymmetry();
    }

    private Subsystem getSubsystem(Atom atom) {
        return this.htSubsystems == null ? null : this.htSubsystems.get("" + atom.altLoc);
    }

    public void setMinMax0(P3 p3, P3 p32) {
        if (this.htSubsystems == null) {
            return;
        }
        SymmetryInterface symmetryInterface = this.getDefaultUnitCell();
        this.minXYZ0 = P3.newP((T3)p3);
        this.maxXYZ0 = P3.newP((T3)p32);
        P3 p33 = P3.newP((T3)p3);
        P3 p34 = P3.newP((T3)p32);
        P3 p35 = new P3();
        symmetryInterface.toCartesian((T3)p33, true);
        symmetryInterface.toCartesian((T3)p34, true);
        P3[] p3Array = BoxInfo.unitCubePoints;
        for (Map.Entry<String, Subsystem> entry : this.htSubsystems.entrySet()) {
            SymmetryInterface symmetryInterface2 = entry.getValue().getSymmetry();
            int n = 8;
            while (--n >= 0) {
                p35.x = p3Array[n].x == 0.0f ? p33.x : p34.x;
                p35.y = p3Array[n].y == 0.0f ? p33.y : p34.y;
                p35.z = p3Array[n].z == 0.0f ? p33.z : p34.z;
                this.expandMinMax(p35, symmetryInterface2, p3, p32);
            }
        }
    }

    private void expandMinMax(P3 p3, SymmetryInterface symmetryInterface, P3 p32, P3 p33) {
        P3 p34 = P3.newP((T3)p3);
        float f = 1.0E-4f;
        symmetryInterface.toFractional((T3)p34, false);
        if (p32.x > p34.x + f) {
            p32.x = (int)Math.floor(p34.x) - 1;
        }
        if (p32.y > p34.y + f) {
            p32.y = (int)Math.floor(p34.y) - 1;
        }
        if (p32.z > p34.z + f) {
            p32.z = (int)Math.floor(p34.z) - 1;
        }
        if (p33.x < p34.x - f) {
            p33.x = (int)Math.ceil(p34.x) + 1;
        }
        if (p33.y < p34.y - f) {
            p33.y = (int)Math.ceil(p34.y) + 1;
        }
        if (p33.z < p34.z - f) {
            p33.z = (int)Math.ceil(p34.z) + 1;
        }
    }

    private void trimAtomSet() {
        if (!this.cr.doApplySymmetry) {
            return;
        }
        AtomSetCollection atomSetCollection = this.cr.atomSetCollection;
        BS bS = atomSetCollection.bsAtoms;
        SymmetryInterface symmetryInterface = this.getDefaultUnitCell();
        Atom[] atomArray = atomSetCollection.getAtoms();
        P3 p3 = new P3();
        if (bS == null) {
            bS = atomSetCollection.bsAtoms = BSUtil.newBitSet2((int)0, (int)atomSetCollection.getAtomCount());
        }
        int n = bS.nextSetBit(0);
        while (n >= 0) {
            Atom atom = atomArray[n];
            p3.setT((T3)atom);
            p3.add((T3)atom.vib);
            this.getSymmetry(atom).toCartesian((T3)p3, false);
            symmetryInterface.toFractional((T3)p3, false);
            if (!atomSetCollection.isWithinCell(3, p3, this.minXYZ0.x, this.maxXYZ0.x, this.minXYZ0.y, this.maxXYZ0.y, this.minXYZ0.z, this.maxXYZ0.z, 0.001f)) {
                bS.clear(n);
            }
            n = bS.nextSetBit(n + 1);
        }
    }

    private SymmetryInterface getDefaultUnitCell() {
        return this.modCell != null && this.htSubsystems.containsKey(this.modCell) ? this.htSubsystems.get(this.modCell).getSymmetry() : this.cr.atomSetCollection.symmetry;
    }
}

