/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.gui;

import com.l2fprod.gui.plaf.skin.CompoundSkin;
import com.l2fprod.gui.plaf.skin.Skin;
import com.l2fprod.gui.plaf.skin.SkinLookAndFeel;
import com.l2fprod.gui.plaf.skin.SkinPreviewWindow;
import com.l2fprod.util.OS;
import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class SkinChooser
extends JPanel {
    private JList skinList;
    private String[] directories;
    private JCheckBox backgroundCheckBox;
    private JCheckBox scrollBarCheckBox;
    private ResourceBundle bundle;
    private boolean themePackMode = false;
    static final String REFRESH_CMD = "refresh";
    static final String PREVIEW_CMD = "preview";
    static final String GETSKINS_CMD = "getskins";

    public SkinChooser() {
        this.loadResourceBundle();
        this.setLayout(new BorderLayout(3, 3));
        JPanel listPane = new JPanel(new BorderLayout(3, 3));
        JPanel buttonPane = new JPanel(new GridLayout(1, 3, 3, 3));
        JButton button = new JButton(this.bundle.getString("SkinChooser.getskins"));
        buttonPane.add(button);
        button.addActionListener(new GetSkinsAction());
        button.setToolTipText(this.bundle.getString("SkinChooser.getskins.tip"));
        button = new JButton(this.bundle.getString("SkinChooser.preview"));
        buttonPane.add(button);
        button.addActionListener(new PreviewAction());
        button = new JButton(this.bundle.getString("SkinChooser.refresh"));
        buttonPane.add(button);
        button.addActionListener(new RefreshAction());
        this.skinList = new JList();
        listPane.add("Center", new JScrollPane(this.skinList));
        listPane.add("South", buttonPane);
        this.add("Center", listPane);
        Box optionPane = Box.createVerticalBox();
        this.backgroundCheckBox = new JCheckBox(this.bundle.getString("SkinChooser.enableBackground"));
        optionPane.add(this.backgroundCheckBox);
        this.scrollBarCheckBox = new JCheckBox(this.bundle.getString("SkinChooser.enableScrollBar"));
        optionPane.add(this.scrollBarCheckBox);
        this.add("East", optionPane);
    }

    public void setSkinLocations(String[] directories) {
        this.directories = directories;
        Vector skins = new Vector();
        int c = directories.length;
        for (int i = 0; i < c; ++i) {
            this.buildSkinList(skins, new File(directories[i]));
        }
        this.skinList.setListData(skins);
    }

    public void setThemePackMode(boolean b) {
        this.themePackMode = b;
    }

    public String[] getSkinLocations() {
        return this.directories;
    }

    public boolean getThemePackMode() {
        return this.themePackMode;
    }

    public String[] getSelectedSkins() {
        return (String[])this.skinList.getSelectedValues();
    }

    public void refreshList() {
        if (this.directories != null && this.directories.length > 0) {
            this.setSkinLocations(this.directories);
        }
    }

    public void apply() throws Exception {
        Object[] values = this.skinList.getSelectedValues();
        if (values == null || this.themePackMode && values.length != 1 || !this.themePackMode && values.length != 2) {
            return;
        }
        UIManager.put("JDesktopPane.backgroundEnabled", this.backgroundCheckBox.isSelected() ? Boolean.TRUE : null);
        UIManager.put("ScrollBar.alternateLayout", this.scrollBarCheckBox.isSelected() ? Boolean.TRUE : null);
        Skin skin = null;
        skin = this.themePackMode ? SkinLookAndFeel.loadThemePack((String)values[0]) : new CompoundSkin(SkinLookAndFeel.loadSkin((String)values[0]), SkinLookAndFeel.loadSkin((String)values[1]));
        SkinLookAndFeel.setSkin(skin);
        UIManager.setLookAndFeel("com.l2fprod.gui.plaf.skin.SkinLookAndFeel");
    }

    protected void buildSkinList(Vector v, File directory) {
        if (!directory.isDirectory() || !directory.exists()) {
            return;
        }
        String[] files = directory.list();
        int c = files.length;
        for (int i = 0; i < c; ++i) {
            File f = new File(directory, files[i]);
            if (f.isDirectory()) {
                this.buildSkinList(v, f);
                continue;
            }
            if (!this.accept(f)) continue;
            try {
                v.addElement(f.getCanonicalPath());
                continue;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    protected boolean accept(File f) {
        return !f.isDirectory() && (this.themePackMode && f.getName().endsWith(".zip") || f.getName().endsWith("gtkrc") || f.getName().endsWith("themerc"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void showPreviewWindow() {
        Skin oldSkin = SkinLookAndFeel.getSkin();
        LookAndFeel oldLAF = UIManager.getLookAndFeel();
        try {
            Object[] values = this.skinList.getSelectedValues();
            if (values == null || values.length != 2) {
                return;
            }
            CompoundSkin skin = new CompoundSkin(SkinLookAndFeel.loadSkin((String)values[0]), SkinLookAndFeel.loadSkin((String)values[1]));
            SkinLookAndFeel.setSkin(skin);
            UIManager.setLookAndFeel("com.l2fprod.gui.plaf.skin.SkinLookAndFeel");
            SkinPreviewWindow window = new SkinPreviewWindow();
            window.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            SkinLookAndFeel.setSkin(oldSkin);
            try {
                UIManager.setLookAndFeel(oldLAF);
            }
            catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {}
        }
    }

    private void loadResourceBundle() {
        this.bundle = ResourceBundle.getBundle("com.l2fprod.gui.plaf.skin.resources.skin");
    }

    private class PreviewAction
    extends AbstractAction {
        public PreviewAction() {
            super(SkinChooser.PREVIEW_CMD);
        }

        public void actionPerformed(ActionEvent event) {
            SkinChooser.this.showPreviewWindow();
        }
    }

    private class GetSkinsAction
    extends AbstractAction {
        public GetSkinsAction() {
            super(SkinChooser.GETSKINS_CMD);
        }

        public void actionPerformed(ActionEvent event) {
            try {
                OS.openDocument(SkinChooser.this.bundle.getString("SkinChooser.getskins.url"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private class RefreshAction
    extends AbstractAction {
        public RefreshAction() {
            super(SkinChooser.REFRESH_CMD);
        }

        public void actionPerformed(ActionEvent event) {
            SkinChooser.this.refreshList();
        }
    }
}

