/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import javajs.util.AU;
import org.jmol.api.JmolSelectionListener;
import org.jmol.i18n.GT;
import org.jmol.java.BS;
import org.jmol.modelset.ModelSet;
import org.jmol.util.BSUtil;
import org.jmol.viewer.Viewer;

public class SelectionManager {
    private Viewer viewer;
    private JmolSelectionListener[] listeners = new JmolSelectionListener[0];
    final BS bsHidden = new BS();
    final BS bsSelection = new BS();
    final BS bsFixed = new BS();
    BS bsSubset;
    BS bsDeleted;
    private static final int TRUE = 1;
    private static final int FALSE = 0;
    private static final int UNKNOWN = -1;
    private int empty = 1;
    boolean hideNotSelected;
    private final BS bsTemp = new BS();

    SelectionManager(Viewer viewer) {
        this.viewer = viewer;
    }

    void deleteModelAtoms(BS bS) {
        BSUtil.deleteBits(this.bsHidden, bS);
        BSUtil.deleteBits(this.bsSelection, bS);
        BSUtil.deleteBits(this.bsSubset, bS);
        BSUtil.deleteBits(this.bsFixed, bS);
        BSUtil.deleteBits(this.bsDeleted, bS);
    }

    void clear() {
        this.clearSelection(true);
        this.hide(null, null, 0, true);
        this.setSelectionSubset(null);
        this.bsDeleted = null;
        this.setMotionFixedAtoms(null);
    }

    void display(ModelSet modelSet, BS bS, int n, boolean bl) {
        switch (n) {
            default: {
                BS bS2 = modelSet.getModelAtomBitSetIncludingDeleted(-1, false);
                this.bsHidden.or(bS2);
            }
            case 1276118017: {
                if (bS == null) break;
                this.bsHidden.andNot(bS);
                break;
            }
            case 1073742119: {
                if (bS == null) break;
                this.bsHidden.or(bS);
            }
        }
        BSUtil.andNot(this.bsHidden, this.bsDeleted);
        modelSet.setBsHidden(this.bsHidden);
        if (!bl) {
            this.viewer.reportSelection(GT.i(GT._("{0} atoms hidden"), this.bsHidden.cardinality()));
        }
    }

    void hide(ModelSet modelSet, BS bS, int n, boolean bl) {
        SelectionManager.setBitSet(this.bsHidden, bS, n);
        if (modelSet != null) {
            modelSet.setBsHidden(this.bsHidden);
        }
        if (!bl) {
            this.viewer.reportSelection(GT.i(GT._("{0} atoms hidden"), this.bsHidden.cardinality()));
        }
    }

    void setSelectionSet(BS bS, int n) {
        SelectionManager.setBitSet(this.bsSelection, bS, n);
        this.empty = -1;
        this.selectionChanged(false);
    }

    private static void setBitSet(BS bS, BS bS2, int n) {
        switch (n) {
            default: {
                bS.clearAll();
            }
            case 1276118017: {
                if (bS2 == null) break;
                bS.or(bS2);
                break;
            }
            case 1073742119: {
                if (bS2 == null) break;
                bS.andNot(bS2);
            }
        }
    }

    BS getHiddenSet() {
        return this.bsHidden;
    }

    boolean getHideNotSelected() {
        return this.hideNotSelected;
    }

    void setHideNotSelected(boolean bl) {
        this.hideNotSelected = bl;
        if (bl) {
            this.selectionChanged(false);
        }
    }

    boolean isSelected(int n) {
        return n >= 0 && this.bsSelection.get(n);
    }

    void select(BS bS, int n, boolean bl) {
        if (bS == null) {
            this.selectAll(true);
            if (!this.viewer.getBoolean(1613758476)) {
                this.excludeSelectionSet(this.viewer.getAtomBits(1613758476, null));
            }
            if (!this.viewer.getBoolean(0x60300006)) {
                this.excludeSelectionSet(this.viewer.getAtomBits(0x60300006, null));
            }
            this.selectionChanged(false);
        } else {
            this.setSelectionSet(bS, n);
        }
        boolean bl2 = this.viewer.getBoolean(603979880);
        if (!bl2 && bl) {
            return;
        }
        int n2 = this.getSelectionCount();
        if (bl2) {
            this.viewer.reportSelection((n2 == 0 ? "No atoms" : (n2 == 1 ? "1 atom" : n2 + " atoms")) + " selected!");
        } else if (!bl) {
            this.viewer.reportSelection(GT.i(GT._("{0} atoms selected"), n2));
        }
    }

    void selectAll(boolean bl) {
        int n = this.viewer.getAtomCount();
        this.empty = n == 0 ? 1 : 0;
        int n2 = n;
        while (--n2 >= 0) {
            this.bsSelection.set(n2);
        }
        BSUtil.andNot(this.bsSelection, this.bsDeleted);
        this.selectionChanged(bl);
    }

    void clearSelection(boolean bl) {
        this.setHideNotSelected(false);
        this.bsSelection.clearAll();
        this.empty = 1;
        this.selectionChanged(bl);
    }

    public boolean isAtomSelected(int n) {
        return ((this.bsSubset == null || this.bsSubset.get(n)) && this.bsDeleted == null || !this.bsDeleted.get(n)) && this.bsSelection.get(n);
    }

    public void setSelectedAtom(int n, boolean bl) {
        if (n < 0) {
            this.selectionChanged(true);
            return;
        }
        if (this.bsSubset != null && !this.bsSubset.get(n) || this.bsDeleted != null && this.bsDeleted.get(n)) {
            return;
        }
        this.bsSelection.setBitTo(n, bl);
        this.empty = bl ? 0 : -1;
    }

    void setSelectionSubset(BS bS) {
        this.bsSubset = bS;
    }

    boolean isInSelectionSubset(int n) {
        return n < 0 || this.bsSubset == null || this.bsSubset.get(n);
    }

    void invertSelection() {
        BSUtil.invertInPlace(this.bsSelection, this.viewer.getAtomCount());
        this.empty = this.bsSelection.length() > 0 ? 0 : 1;
        this.selectionChanged(false);
    }

    private void excludeSelectionSet(BS bS) {
        if (bS == null || this.empty == 1) {
            return;
        }
        this.bsSelection.andNot(bS);
        this.empty = -1;
    }

    int getSelectionCount() {
        BS bS;
        if (this.empty == 1) {
            return 0;
        }
        this.empty = 1;
        if (this.bsSubset != null) {
            this.bsTemp.clearAll();
            this.bsTemp.or(this.bsSubset);
            this.bsTemp.and(this.bsSelection);
            bS = this.bsTemp;
        } else {
            bS = this.bsSelection;
        }
        int n = bS.cardinality();
        if (n > 0) {
            this.empty = 0;
        }
        return n;
    }

    void addListener(JmolSelectionListener jmolSelectionListener) {
        int n = this.listeners.length;
        while (--n >= 0) {
            if (this.listeners[n] != jmolSelectionListener) continue;
            this.listeners[n] = null;
            break;
        }
        int n2 = n = this.listeners.length;
        while (--n2 >= 0) {
            if (this.listeners[n2] != null) continue;
            this.listeners[n2] = jmolSelectionListener;
            return;
        }
        this.listeners = this.listeners.length == 0 ? new JmolSelectionListener[1] : (JmolSelectionListener[])AU.doubleLength(this.listeners);
        this.listeners[n] = jmolSelectionListener;
    }

    private void selectionChanged(boolean bl) {
        if (this.hideNotSelected) {
            this.hide(this.viewer.getModelSet(), BSUtil.copyInvert(this.bsSelection, this.viewer.getAtomCount()), 0, bl);
        }
        if (bl || this.listeners.length == 0) {
            return;
        }
        int n = this.listeners.length;
        while (--n >= 0) {
            if (this.listeners[n] == null) continue;
            this.listeners[n].selectionChanged(this.bsSelection);
        }
    }

    int deleteAtoms(BS bS) {
        BS bS2 = BSUtil.copy(bS);
        if (this.bsDeleted == null) {
            this.bsDeleted = bS2;
        } else {
            bS2.andNot(this.bsDeleted);
            this.bsDeleted.or(bS);
        }
        this.bsHidden.andNot(this.bsDeleted);
        this.bsSelection.andNot(this.bsDeleted);
        return bS2.cardinality();
    }

    BS getDeletedAtoms() {
        return this.bsDeleted;
    }

    BS getSelectionSet(boolean bl) {
        if (bl || this.bsDeleted == null && this.bsSubset == null) {
            return this.bsSelection;
        }
        BS bS = new BS();
        bS.or(this.bsSelection);
        this.excludeAtoms(bS, false);
        return bS;
    }

    BS getSelectionSubset() {
        return this.bsSubset;
    }

    void excludeAtoms(BS bS, boolean bl) {
        if (this.bsDeleted != null) {
            bS.andNot(this.bsDeleted);
        }
        if (!bl && this.bsSubset != null) {
            bS.and(this.bsSubset);
        }
    }

    void processDeletedModelAtoms(BS bS) {
        if (this.bsDeleted != null) {
            BSUtil.deleteBits(this.bsDeleted, bS);
        }
        if (this.bsSubset != null) {
            BSUtil.deleteBits(this.bsSubset, bS);
        }
        BSUtil.deleteBits(this.bsFixed, bS);
        BSUtil.deleteBits(this.bsHidden, bS);
        BS bS2 = BSUtil.copy(this.bsSelection);
        BSUtil.deleteBits(bS2, bS);
        this.setSelectionSet(bS2, 0);
    }

    void setMotionFixedAtoms(BS bS) {
        this.bsFixed.clearAll();
        if (bS != null) {
            this.bsFixed.or(bS);
        }
    }

    BS getMotionFixedAtoms() {
        return this.bsFixed;
    }
}

