/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.List;
import javajs.util.OC;
import javajs.util.PT;
import javajs.util.SB;
import org.jmol.api.Interface;
import org.jmol.api.JmolImageEncoder;
import org.jmol.i18n.GT;
import org.jmol.io.JmolBinary;
import org.jmol.java.BS;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Txt;
import org.jmol.viewer.FileManager;
import org.jmol.viewer.JC;
import org.jmol.viewer.Viewer;

abstract class OutputManager {
    protected Viewer viewer;
    protected double privateKey;
    protected static final String SCENE_TAG = "###scene.spt###";

    OutputManager() {
    }

    protected abstract String getLogPath(String var1);

    abstract String clipImageOrPasteText(String var1);

    abstract String getClipboardText();

    abstract OC openOutputChannel(double var1, String var3, boolean var4, boolean var5) throws IOException;

    protected abstract String createSceneSet(String var1, String var2, int var3, int var4);

    OutputManager setViewer(Viewer viewer, double d) {
        this.viewer = viewer;
        this.privateKey = d;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String writeToOutputChannel(Map<String, Object> map) {
        String string = (String)map.get("type");
        String string2 = (String)map.get("fileName");
        String string3 = (String)map.get("text");
        byte[] byArray = (byte[])map.get("bytes");
        int n = OutputManager.getInt(map, "quality", Integer.MIN_VALUE);
        OC oC = (OC)map.get("outputChannel");
        boolean bl = oC == null;
        int n2 = -1;
        try {
            if (!this.viewer.checkPrivateKey(this.privateKey)) {
                String string4 = "ERROR: SECURITY";
                return string4;
            }
            if (byArray != null) {
                if (oC == null) {
                    oC = this.openOutputChannel(this.privateKey, string2, false, false);
                }
                oC.write(byArray, 0, byArray.length);
            } else if (string3 != null) {
                if (oC == null) {
                    oC = this.openOutputChannel(this.privateKey, string2, true, false);
                }
                oC.append(string3);
            } else {
                String string5 = (String)this.getOrSaveImage(map);
                if (string5 != null) {
                    String string6 = string5;
                    return string6;
                }
                n2 = (Integer)map.get("byteCount");
            }
        }
        catch (Exception exception) {
            Logger.errorEx("IO Exception", exception);
            String string7 = exception.toString();
            return string7;
        }
        finally {
            if (oC != null) {
                if (bl) {
                    oC.closeChannel();
                }
                n2 = oC.getByteCount();
            }
        }
        return n2 < 0 ? "Creation of " + string2 + " failed: " + this.viewer.getErrorMessageUn() : "OK " + string + " " + (n2 > 0 ? n2 + " " : "") + string2 + (n == Integer.MIN_VALUE ? "" : "; quality=" + n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getOrSaveImage(Map<String, Object> map) throws Exception {
        boolean bl;
        Object object;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        OC oC;
        Object object2;
        String[] stringArray;
        String string;
        String string2;
        String string3;
        byte[] byArray;
        block33: {
            block32: {
                String string4;
                byArray = null;
                string3 = null;
                string2 = ((String)map.get("type")).toUpperCase();
                string = (String)map.get("fileName");
                stringArray = (String[])map.get("scripts");
                object2 = map.get("image");
                oC = (OC)map.get("outputChannel");
                bl4 = oC == null && string == null;
                bl3 = oC == null && string != null;
                bl2 = object2 == null;
                object = object2 == null ? this.viewer.getScreenImageBuffer(null, true) : object2;
                bl = false;
                try {
                    if (object != null) break block32;
                    string4 = string3 = this.viewer.getErrorMessage();
                    if (bl2) {
                        this.viewer.releaseScreenImage();
                    }
                    map.put("byteCount", byArray != null ? byArray.length : (bl ? oC.getByteCount() : -1));
                }
                catch (Throwable throwable) {
                    if (bl2) {
                        this.viewer.releaseScreenImage();
                    }
                    map.put("byteCount", byArray != null ? byArray.length : (bl ? oC.getByteCount() : -1));
                    if (object2 != null) {
                        return string;
                    }
                    throw throwable;
                }
                if (object2 != null) {
                    return string;
                }
                return string4;
            }
            if (oC == null) {
                oC = this.openOutputChannel(this.privateKey, string, false, false);
            }
            if (oC != null) break block33;
            string3 = "ERROR: canceled";
            String string5 = "ERROR: canceled";
            if (bl2) {
                this.viewer.releaseScreenImage();
            }
            map.put("byteCount", byArray != null ? byArray.length : (bl ? oC.getByteCount() : -1));
            if (object2 != null) {
                return string;
            }
            return string5;
        }
        string = oC.getFileName();
        String string6 = null;
        byte[] byArray2 = null;
        map.put("date", this.viewer.apiPlatform.getDateFormat(false));
        if (string2.startsWith("JP")) {
            if ((string2 = PT.simpleReplace(string2, "E", "")).equals("JPG64")) {
                map.put("outputChannelTemp", this.getOutputChannel(null, null));
                string6 = "";
            } else {
                string6 = !bl4 ? (String)this.getWrappedState(null, null, object, null) : "";
            }
        } else if (string2.equals("PDF")) {
            string6 = "";
        } else if (string2.startsWith("PNG")) {
            string6 = "";
            boolean bl5 = string2.equals("PNGJ");
            if (bl5) {
                OC oC2 = this.getOutputChannel(null, null);
                this.getWrappedState(string, stringArray, object, oC2);
                byArray2 = oC2.toByteArray();
            } else if (!bl4) {
                byArray2 = ((String)this.getWrappedState(null, stringArray, object, null)).getBytes();
            }
            if (byArray2 != null) {
                map.put("applicationData", byArray2);
                map.put("applicationPrefix", "Jmol Type");
            }
            if (string2.equals("PNGT")) {
                map.put("transparentColor", this.viewer.getBackgroundArgb());
            }
            string2 = "PNG";
        }
        if (string6 != null) {
            map.put("comment", string6.length() == 0 ? Viewer.getJmolVersion() : string6);
        }
        String[] stringArray2 = new String[1];
        bl = this.createTheImage(object, string2, oC, map, stringArray2);
        if (bl3) {
            oC.closeChannel();
        }
        if (bl) {
            if (bl4) {
                byArray = oC.toByteArray();
            } else if (map.containsKey("captureByteCount")) {
                string3 = "OK: " + map.get("captureByteCount").toString() + " bytes";
            }
        } else {
            string3 = stringArray2[0];
        }
        if (bl2) {
            this.viewer.releaseScreenImage();
        }
        map.put("byteCount", byArray != null ? byArray.length : (bl ? oC.getByteCount() : -1));
        if (object2 != null) {
            return string;
        }
        return string3 == null ? byArray : (byte[])string3;
    }

    Object getWrappedState(String string, String[] stringArray, Object object, OC oC) {
        int n = this.viewer.apiPlatform.getImageWidth(object);
        int n2 = this.viewer.apiPlatform.getImageHeight(object);
        if (n > 0 && !this.viewer.global.imageState && oC == null || !this.viewer.global.preserveState) {
            return "";
        }
        String string2 = this.viewer.getStateInfo3(null, n, n2);
        if (oC != null) {
            if (string != null) {
                this.viewer.fileManager.clearPngjCache(string);
            }
            return this.createZipSet(string2, stringArray, true, oC);
        }
        try {
            string2 = JC.embedScript(FileManager.setScriptFileReferences(string2, ".", null, null));
        }
        catch (Throwable throwable) {
            Logger.error("state could not be saved: " + throwable.toString());
            string2 = "Jmol " + Viewer.getJmolVersion();
        }
        return string2;
    }

    private boolean createTheImage(Object object, String string, OC oC, Map<String, Object> map, String[] stringArray) throws IOException {
        string = string.substring(0, 1) + string.substring(1).toLowerCase();
        JmolImageEncoder jmolImageEncoder = (JmolImageEncoder)Interface.getInterface("org.jmol.image." + string + "Encoder");
        if (jmolImageEncoder == null) {
            stringArray[0] = "Image encoder type " + string + " not available";
            return false;
        }
        return jmolImageEncoder.createImage(this.viewer.apiPlatform, string, object, oC, map, stringArray);
    }

    String outputToFile(Map<String, Object> map) {
        return this.handleOutputToFile(map, true);
    }

    OC getOutputChannel(String string, String[] stringArray) {
        if (!this.viewer.haveAccess(Viewer.ACCESS.ALL)) {
            return null;
        }
        if (string != null && (string = this.getOutputFileNameFromDialog(string, Integer.MIN_VALUE)) == null) {
            return null;
        }
        if (stringArray != null) {
            stringArray[0] = string;
        }
        String string2 = FileManager.isLocal(string) ? string : null;
        try {
            return this.openOutputChannel(this.privateKey, string2, false, false);
        }
        catch (IOException iOException) {
            Logger.info(iOException.toString());
            return null;
        }
    }

    String processWriteOrCapture(Map<String, Object> map) {
        String string = (String)map.get("fileName");
        if (string == null) {
            return this.viewer.clipImageOrPasteText((String)map.get("text"));
        }
        BS bS = (BS)map.get("bsFrames");
        int n = OutputManager.getInt(map, "nVibes", 0);
        return bS != null || n != 0 ? this.processMultiFrameOutput(string, bS, n, map) : this.handleOutputToFile(map, true);
    }

    private static int getInt(Map<String, Object> map, String string, int n) {
        Integer n2 = (Integer)map.get(string);
        return n2 == null ? n : n2;
    }

    private String processMultiFrameOutput(String string, BS bS, int n, Map<String, Object> map) {
        String string2 = "";
        int n2 = 0;
        int n3 = OutputManager.getInt(map, "quality", -1);
        if ((string = this.setFullPath(map, this.getOutputFileNameFromDialog(string, n3))) == null) {
            return null;
        }
        int n4 = string.indexOf(".");
        if (n4 < 0) {
            n4 = string.length();
        }
        String string3 = string.substring(0, n4);
        String string4 = string.substring(n4);
        SB sB = new SB();
        if (bS == null) {
            this.viewer.transformManager.vibrationOn = true;
            sB = new SB();
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < 20; ++j) {
                    this.viewer.transformManager.setVibrationT((float)j / 20.0f + 0.2501f);
                    if (this.writeFrame(++n2, string3, string4, map, sB)) continue;
                    return "ERROR WRITING FILE SET: \n" + string2;
                }
            }
            this.viewer.setVibrationOff();
        } else {
            int n5 = bS.nextSetBit(0);
            while (n5 >= 0) {
                this.viewer.setCurrentModelIndex(n5);
                if (!this.writeFrame(++n2, string3, string4, map, sB)) {
                    return "ERROR WRITING FILE SET: \n" + string2;
                }
                n5 = bS.nextSetBit(n5 + 1);
            }
        }
        if (string2.length() == 0) {
            string2 = "OK\n";
        }
        return string2 + "\n" + n2 + " files created";
    }

    private String setFullPath(Map<String, Object> map, String string) {
        String[] stringArray = (String[])map.get("fullPath");
        if (stringArray != null) {
            stringArray[0] = string;
        }
        if (string == null) {
            return null;
        }
        map.put("fileName", string);
        return string;
    }

    String getOutputFromExport(Map<String, Object> map) {
        int n = OutputManager.getInt(map, "width", 0);
        int n2 = OutputManager.getInt(map, "height", 0);
        String string = (String)map.get("fileName");
        if (string != null && (string = this.setFullPath(map, this.getOutputFileNameFromDialog(string, Integer.MIN_VALUE))) == null) {
            return null;
        }
        this.viewer.mustRender = true;
        int n3 = this.viewer.dimScreen.width;
        int n4 = this.viewer.dimScreen.height;
        this.viewer.resizeImage(n, n2, true, true, false);
        this.viewer.setModelVisibility();
        String string2 = this.viewer.repaintManager.renderExport(this.viewer.gdata, this.viewer.modelSet, map);
        this.viewer.resizeImage(n3, n4, true, true, true);
        return string2;
    }

    byte[] getImageAsBytes(String string, int n, int n2, int n3, String[] stringArray) {
        int n4 = this.viewer.dimScreen.width;
        int n5 = this.viewer.dimScreen.height;
        this.viewer.mustRender = true;
        this.viewer.resizeImage(n, n2, true, false, false);
        this.viewer.setModelVisibility();
        this.viewer.creatingImage = true;
        byte[] byArray = null;
        try {
            Object object;
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            hashtable.put("type", string);
            if (n3 > 0) {
                hashtable.put("quality", n3);
            }
            if ((object = this.getOrSaveImage(hashtable)) instanceof String) {
                stringArray[0] = (String)object;
            } else {
                byArray = (byte[])object;
            }
        }
        catch (Exception exception) {
            stringArray[0] = exception.toString();
            this.viewer.setErrorMessage("Error creating image: " + exception, null);
        }
        catch (Error error) {
            this.viewer.handleError(error, false);
            this.viewer.setErrorMessage("Error creating image: " + error, null);
            stringArray[0] = this.viewer.getErrorMessage();
        }
        this.viewer.creatingImage = false;
        this.viewer.resizeImage(n4, n5, true, false, true);
        return byArray;
    }

    String writeFileData(String string, String string2, int n, Object[] objectArray) {
        boolean bl;
        String[] stringArray = new String[1];
        OC oC = this.getOutputChannel(string, stringArray);
        if (oC == null) {
            return "";
        }
        string = stringArray[0];
        String string3 = string2.equals("FILE") ? this.viewer.getFullPathName(false) : null;
        boolean bl2 = string3 != null && (string3.equals("string") || string3.indexOf("[]") >= 0 || string3.equals("JSNode"));
        boolean bl3 = bl = string3 != null && !bl2;
        if (bl && (string3 = this.viewer.getModelSetPathName()) == null) {
            return null;
        }
        oC.setType(string2);
        String string4 = string2.equals("PDB") || string2.equals("PQR") ? this.viewer.getPdbAtomData(null, oC) : (string2.startsWith("PLOT") ? this.viewer.modelSet.getPdbData(n, string2.substring(5), this.viewer.getSelectionSet(false), objectArray, oC) : (bl2 ? oC.append(this.viewer.getCurrentFileAsString()).toString() : (String)this.viewer.getFileAsBytes(string3, oC)));
        oC.closeChannel();
        if (string4 != null) {
            string4 = "OK " + string4 + " " + string;
        }
        return string4;
    }

    private boolean writeFrame(int n, String string, String string2, Map<String, Object> map, SB sB) {
        String string3 = "0000" + n;
        string3 = this.setFullPath(map, string + string3.substring(string3.length() - 4) + string2);
        String string4 = this.handleOutputToFile(map, false);
        this.viewer.scriptEcho(string4);
        sB.append(string4).append("\n");
        return string4.startsWith("OK");
    }

    private String getOutputFileNameFromDialog(String string, int n) {
        boolean bl;
        if (string == null || this.viewer.isKiosk) {
            return null;
        }
        boolean bl2 = bl = string.indexOf("?") == 0;
        if (bl) {
            string = string.substring(1);
        }
        boolean bl3 = this.viewer.isApplet() && string.indexOf("http:") < 0;
        string = FileManager.getLocalPathForWritingFile(this.viewer, string);
        if (bl |= bl3) {
            string = this.viewer.dialogAsk(n == Integer.MIN_VALUE ? "Save" : "Save Image", string);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String handleOutputToFile(Map<String, Object> map, boolean bl) {
        String string = null;
        String string2 = (String)map.get("fileName");
        if (string2 == null) {
            return null;
        }
        String string3 = (String)map.get("type");
        String string4 = (String)map.get("text");
        int n = OutputManager.getInt(map, "width", 0);
        int n2 = OutputManager.getInt(map, "height", 0);
        int n3 = OutputManager.getInt(map, "quality", Integer.MIN_VALUE);
        int n4 = OutputManager.getInt(map, "captureMode", Integer.MIN_VALUE);
        if (n4 != Integer.MIN_VALUE && !this.viewer.allowCapture()) {
            return "ERROR: Cannot capture on this platform.";
        }
        boolean bl2 = n3 != Integer.MIN_VALUE;
        String string5 = null;
        if (n4 != Integer.MIN_VALUE) {
            bl = false;
            bl2 = false;
            string3 = "GIF";
        }
        if (bl) {
            string2 = this.getOutputFileNameFromDialog(string2, n3);
        }
        if ((string2 = this.setFullPath(map, string2)) == null) {
            return null;
        }
        map.put("fileName", string2);
        if (FileManager.isLocal(string2)) {
            string5 = string2;
        }
        int n5 = this.viewer.dimScreen.width;
        int n6 = this.viewer.dimScreen.height;
        this.viewer.creatingImage = true;
        if (bl2) {
            this.viewer.mustRender = true;
            this.viewer.resizeImage(n, n2, true, false, false);
            this.viewer.setModelVisibility();
        }
        try {
            if (string3.equals("JMOL")) {
                string3 = "ZIPALL";
            }
            if (string3.equals("ZIP") || string3.equals("ZIPALL")) {
                String[] stringArray = (String[])map.get("scripts");
                if (stringArray != null && string3.equals("ZIP")) {
                    string3 = "ZIPALL";
                }
                OC oC = this.getOutputChannel(string2, null);
                string = this.createZipSet(string4, stringArray, string3.equals("ZIPALL"), oC);
            } else if (string3.equals("SCENE")) {
                string = this.createSceneSet(string2, string4, n, n2);
            } else {
                byte[] byArray = (byte[])map.get("bytes");
                string = this.viewer.statusManager.createImage(string2, string3, string4, byArray, n3);
                if (string == null) {
                    String string6 = null;
                    if (n4 != Integer.MIN_VALUE) {
                        OC oC = null;
                        Map<String, Object> map2 = this.viewer.captureParams;
                        block2 : switch (n4) {
                            case 0x400000D0: {
                                if (map2 != null) {
                                    ((OC)map2.get("outputChannel")).closeChannel();
                                }
                                if ((oC = this.getOutputChannel(string5, null)) == null) {
                                    string6 = "ERROR: capture canceled";
                                    string = "ERROR: capture canceled";
                                    this.viewer.captureParams = null;
                                    break;
                                }
                                string5 = oC.getFileName();
                                string6 = string3 + "_STREAM_OPEN " + string5;
                                this.viewer.captureParams = map;
                                map.put("captureFileName", string5);
                                map.put("captureCount", 1);
                                map.put("captureMode", 0x400000D0);
                                break;
                            }
                            default: {
                                if (map2 == null) {
                                    string6 = "ERROR: capture not active";
                                    string = "ERROR: capture not active";
                                    break;
                                }
                                map = map2;
                                switch (n4) {
                                    default: {
                                        string = string6 = "ERROR: CAPTURE MODE=" + n4 + "?";
                                        break block2;
                                    }
                                    case 1276118017: {
                                        if (Boolean.FALSE == map.get("captureEnabled")) {
                                            string6 = "capturing OFF; use CAPTURE ON/END/CANCEL to continue";
                                            string = "capturing OFF; use CAPTURE ON/END/CANCEL to continue";
                                            break block2;
                                        }
                                        int n7 = OutputManager.getInt(map, "captureCount", 1);
                                        map.put("captureCount", ++n7);
                                        string6 = string3 + "_STREAM_ADD " + n7;
                                        break block2;
                                    }
                                    case 0x10000C: 
                                    case 0x10000D: {
                                        map = map2;
                                        map.put("captureEnabled", n4 == 0x10000D ? Boolean.TRUE : Boolean.FALSE);
                                        string = string3 + "_STREAM_" + (n4 == 0x10000D ? "ON" : "OFF");
                                        map.put("captureMode", 1276118017);
                                        break block2;
                                    }
                                    case 0x119009: 
                                    case 1073741874: 
                                }
                                map = map2;
                                map.put("captureMode", n4);
                                string2 = (String)map.get("captureFileName");
                                string6 = string3 + "_STREAM_" + (n4 == 0x119009 ? "CLOSE " : "CANCEL ") + map.get("captureFileName");
                                this.viewer.captureParams = null;
                                this.viewer.prompt(GT._("Capture") + ": " + (n4 == 1073741874 ? GT._("canceled") : GT.o(GT._("{0} saved"), string2)), "OK", null, true);
                            }
                        }
                        if (oC != null) {
                            map.put("outputChannel", oC);
                        }
                    }
                    map.put("fileName", string5);
                    if (string == null) {
                        string = this.writeToOutputChannel(map);
                    }
                    this.viewer.statusManager.createImage(string, string3, null, null, n3);
                    if (string6 != null) {
                        this.viewer.showString(string6 + " (" + map.get("captureByteCount") + " bytes)", false);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            string = "ERROR creating image??: " + throwable;
            Logger.error(this.viewer.setErrorMessage(string, null));
        }
        finally {
            this.viewer.creatingImage = false;
            if (n3 != Integer.MIN_VALUE) {
                this.viewer.resizeImage(n5, n6, true, false, true);
            }
        }
        return string;
    }

    String setLogFile(String string) {
        String string2 = null;
        String string3 = this.viewer.getLogFilePath();
        if (string3 == null || string.indexOf("\\") >= 0) {
            string = null;
        } else if (string.startsWith("http://") || string.startsWith("https://")) {
            string2 = string;
        } else if (string.indexOf("/") >= 0) {
            string = null;
        } else if (string.length() > 0) {
            if (!string.startsWith("JmolLog_")) {
                string = "JmolLog_" + string;
            }
            string2 = this.getLogPath(string3 + string);
        }
        if (string2 == null) {
            string = null;
        } else {
            Logger.info(GT.o(GT._("Setting log file to {0}"), string2));
        }
        if (string == null || !this.viewer.haveAccess(Viewer.ACCESS.ALL)) {
            Logger.info(GT._("Cannot set log file path."));
            string = null;
        } else {
            this.viewer.logFileName = string2;
            this.viewer.global.setS("_logFile", this.viewer.isApplet() ? string : string2);
        }
        return string;
    }

    void logToFile(String string) {
        block7: {
            try {
                OC oC;
                boolean bl = string.equals("$CLEAR$");
                if (string.indexOf("$NOW$") >= 0) {
                    string = PT.simpleReplace(string, "$NOW$", this.viewer.apiPlatform.getDateFormat(false));
                }
                if (this.viewer.logFileName == null) {
                    Logger.info(string);
                    return;
                }
                OC oC2 = this.viewer.haveAccess(Viewer.ACCESS.ALL) ? this.openOutputChannel(this.privateKey, this.viewer.logFileName, true, !bl) : (oC = null);
                if (!bl) {
                    int n = string.indexOf(0);
                    if (n >= 0) {
                        string = string.substring(0, n);
                    }
                    oC.append(string);
                    if (n < 0) {
                        oC.append("\n");
                    }
                }
                String string2 = oC.closeChannel();
                Logger.info(string2);
            }
            catch (Exception exception) {
                if (!Logger.debugging) break block7;
                Logger.debug("cannot log " + string);
            }
        }
    }

    private String createZipSet(String string, String[] stringArray, boolean bl, OC oC) {
        byte[] byArray;
        String string2;
        int n;
        boolean bl2;
        boolean bl3;
        List<Object> list = new List<Object>();
        FileManager fileManager = this.viewer.fileManager;
        List<String> list2 = new List<String>();
        Hashtable<Object, String> hashtable = new Hashtable<Object, String>();
        boolean bl4 = stringArray != null && stringArray.length == 3 && stringArray[1].startsWith(SCENE_TAG);
        boolean bl5 = bl3 = bl4 && stringArray[2].equals("min");
        if (!bl3) {
            JmolBinary.getFileReferences(string, list2);
            if (bl4) {
                JmolBinary.getFileReferences(stringArray[1], list2);
            }
        }
        boolean bl6 = bl2 = !bl4 && stringArray != null && stringArray.length > 0;
        if (bl2) {
            string = this.wrapPathForAllFiles("script " + Escape.eS(stringArray[0]), "");
            for (n = 0; n < stringArray.length; ++n) {
                list2.addLast(stringArray[n]);
            }
        }
        n = list2.size();
        List<String> list3 = new List<String>();
        for (int i = 0; i < n; ++i) {
            string2 = (String)list2.get(i);
            boolean bl7 = !this.viewer.isJS && FileManager.isLocal(string2);
            String string3 = string2;
            if (bl7 || bl) {
                boolean bl8;
                int n2 = string2.lastIndexOf("/");
                string3 = string2.indexOf("?") > 0 && string2.indexOf("|") < 0 ? PT.replaceAllCharacters(string2, "/:?\"'=&", "_") : FileManager.stripPath(string2);
                string3 = PT.replaceAllCharacters(string3, "[]", "_");
                boolean bl9 = bl8 = fileManager.spardirCache != null && fileManager.spardirCache.containsKey(string2);
                if (bl7 && string2.indexOf("|") < 0 && !bl8) {
                    list.addLast(string2);
                    list.addLast(string3);
                    list.addLast((Object)null);
                } else {
                    Object object;
                    Object object2 = object = bl8 ? fileManager.spardirCache.get(string2) : (Object)fileManager.getFileAsBytes(string2, null, true);
                    if (!PT.isAB(object)) {
                        return (String)object;
                    }
                    string3 = this.addPngFileBytes(string2, (byte[])object, i, hashtable, bl8, string3, n2, list);
                }
                string2 = "$SCRIPT_PATH$" + string3;
            }
            hashtable.put(string3, string3);
            list3.addLast(string2);
        }
        if (!bl3) {
            string = Txt.replaceQuotedStrings(string, list2, list3);
            list.addLast("state.spt");
            list.addLast((Object)null);
            list.addLast(string.getBytes());
        }
        if (bl4) {
            if (stringArray[0] != null) {
                list.addLast("animate.spt");
                list.addLast((Object)null);
                list.addLast(stringArray[0].getBytes());
            }
            list.addLast("scene.spt");
            list.addLast((Object)null);
            string = Txt.replaceQuotedStrings(stringArray[1], list2, list3);
            list.addLast(string.getBytes());
        }
        String string4 = bl4 ? "scene.spt" : "state.spt";
        list.addLast("JmolManifest.txt");
        list.addLast((Object)null);
        string2 = "# Jmol Manifest Zip Format 1.1\n# Created " + new Date() + "\n" + "# JmolVersion " + Viewer.getJmolVersion() + "\n" + string4;
        list.addLast(string2.getBytes());
        list.addLast("Jmol_version_" + Viewer.getJmolVersion().replace(' ', '_').replace(':', '.'));
        list.addLast((Object)null);
        list.addLast(new byte[0]);
        if (oC.getFileName() != null && (byArray = this.viewer.getImageAsBytes("PNG", 0, 0, -1, null)) != null) {
            list.addLast("preview.png");
            list.addLast((Object)null);
            list.addLast(byArray);
        }
        return this.writeZipFile(this.privateKey, fileManager, this.viewer, oC, list, "OK JMOL");
    }

    private String addPngFileBytes(String string, byte[] byArray, int n, Hashtable<Object, String> hashtable, boolean bl, String string2, int n2, List<Object> list) {
        Integer n3 = JmolBinary.getCrcValue(byArray);
        if (hashtable.containsKey(n3)) {
            string2 = hashtable.get(n3);
        } else {
            if (bl) {
                string2 = string2.replace('.', '_');
            }
            if (hashtable.containsKey(string2)) {
                int n4 = string2.lastIndexOf(".");
                string2 = n4 > n2 ? string2.substring(0, n4) + "[" + n + "]" + string2.substring(n4) : string2 + "[" + n + "]";
            }
            list.addLast(string);
            list.addLast(string2);
            list.addLast(byArray);
            hashtable.put(n3, string2);
        }
        return string2;
    }

    private String writeZipFile(double d, FileManager fileManager, Viewer viewer, OC oC, List<Object> list, String string) {
        Object object;
        byte[] byArray = new byte[1024];
        long l = 0L;
        long l2 = 0L;
        String string2 = oC.getFileName();
        Logger.info("creating zip file " + (string2 == null ? "" : string2) + "...");
        String string3 = "";
        try {
            object = new BufferedOutputStream(oC);
            OutputStream outputStream = (OutputStream)JmolBinary.getZipOutputStream(object);
            for (int i = 0; i < list.size(); i += 3) {
                String string4;
                String string5;
                String string6 = (String)list.get(i);
                byte[] byArray2 = null;
                Object object2 = fileManager.cacheGet(string6, false);
                if (object2 instanceof Map) continue;
                if (string6.indexOf("file:/") == 0) {
                    if ((string6 = string6.substring(5)).length() > 2 && string6.charAt(2) == ':') {
                        string6 = string6.substring(1);
                    }
                } else if (string6.indexOf("cache://") == 0) {
                    string6 = string6.substring(8);
                }
                if ((string5 = (String)list.get(i + 1)) == null) {
                    string5 = string6;
                }
                if (object2 != null) {
                    byte[] byArray3 = byArray2 = PT.isAB(object2) ? (byte[])object2 : ((String)object2).getBytes();
                }
                if (byArray2 == null) {
                    byArray2 = (byte[])list.get(i + 2);
                }
                if (string3.indexOf(string4 = ";" + string5 + ";") >= 0) {
                    Logger.info("duplicate entry");
                    continue;
                }
                string3 = string3 + string4;
                JmolBinary.addZipEntry(outputStream, string5);
                int n = 0;
                if (byArray2 == null) {
                    int n2;
                    BufferedInputStream bufferedInputStream = viewer.getBufferedInputStream(string6);
                    while ((n2 = bufferedInputStream.read(byArray, 0, 1024)) > 0) {
                        outputStream.write(byArray, 0, n2);
                        n += n2;
                    }
                    bufferedInputStream.close();
                } else {
                    outputStream.write(byArray2, 0, byArray2.length);
                    n += byArray2.length;
                }
                l += (long)n;
                JmolBinary.closeZipEntry(outputStream);
                Logger.info("...added " + string6 + " (" + n + " bytes)");
            }
            outputStream.flush();
            outputStream.close();
            Logger.info(l + " bytes prior to compression");
            String string7 = oC.closeChannel();
            if (string7 != null) {
                if (string7.indexOf("Exception") >= 0) {
                    return string7;
                }
                string = string + " " + string7;
            }
            l2 = oC.getByteCount();
        }
        catch (IOException iOException) {
            Logger.info(iOException.toString());
            return iOException.toString();
        }
        object = oC.getFileName();
        return object == null ? null : string + " " + l2 + " " + (String)object;
    }

    protected String wrapPathForAllFiles(String string, String string2) {
        String string3 = "v__" + ("" + Math.random()).substring(3);
        return "# Jmol script\n{\n\tVar " + string3 + " = pathForAllFiles\n\tpathForAllFiles=\"$SCRIPT_PATH$\"\n\ttry{\n\t\t" + string + "\n\t}catch(e){" + string2 + "}\n\tpathForAllFiles = " + string3 + "\n}\n";
    }
}

